/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.params;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.params.AbstractHttpParams;
import org.apache.http.params.HttpParams;

public class BasicHttpParams
extends AbstractHttpParams
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -7086398485908701455L;
    private HashMap parameters;

    public Object getParameter(String name) {
        Object param = null;
        if (this.parameters != null) {
            param = this.parameters.get(name);
        }
        return param;
    }

    public HttpParams setParameter(String name, Object value) {
        if (this.parameters == null) {
            this.parameters = new HashMap();
        }
        this.parameters.put(name, value);
        return this;
    }

    public boolean removeParameter(String name) {
        if (this.parameters == null) {
            return false;
        }
        if (this.parameters.containsKey(name)) {
            this.parameters.remove(name);
            return true;
        }
        return false;
    }

    public void setParameters(String[] names, Object value) {
        for (int i = 0; i < names.length; ++i) {
            this.setParameter(names[i], value);
        }
    }

    public boolean isParameterSet(String name) {
        return this.getParameter(name) != null;
    }

    public boolean isParameterSetLocally(String name) {
        return this.parameters != null && this.parameters.get(name) != null;
    }

    public void clear() {
        this.parameters = null;
    }

    public HttpParams copy() {
        BasicHttpParams clone = new BasicHttpParams();
        this.copyParams(clone);
        return clone;
    }

    public Object clone() throws CloneNotSupportedException {
        BasicHttpParams clone = (BasicHttpParams)super.clone();
        this.copyParams(clone);
        return clone;
    }

    protected void copyParams(HttpParams target) {
        if (this.parameters == null) {
            return;
        }
        for (Map.Entry me : this.parameters.entrySet()) {
            if (!(me.getKey() instanceof String)) continue;
            target.setParameter((String)me.getKey(), me.getValue());
        }
    }
}

