/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.conn.routing;

import java.net.InetAddress;
import org.apache.http.HttpHost;
import org.apache.http.conn.routing.RouteInfo;

public class HttpRoute
implements RouteInfo,
Cloneable {
    private final HttpHost targetHost;
    private final InetAddress localAddress;
    private final HttpHost[] proxyChain;
    private final RouteInfo.TunnelType tunnelled;
    private final RouteInfo.LayerType layered;
    private final boolean secure;

    private HttpRoute(InetAddress local, HttpHost target, HttpHost[] proxies, boolean secure, RouteInfo.TunnelType tunnelled, RouteInfo.LayerType layered) {
        if (target == null) {
            throw new IllegalArgumentException("Target host may not be null.");
        }
        if (tunnelled == RouteInfo.TunnelType.TUNNELLED && proxies == null) {
            throw new IllegalArgumentException("Proxy required if tunnelled.");
        }
        if (tunnelled == null) {
            tunnelled = RouteInfo.TunnelType.PLAIN;
        }
        if (layered == null) {
            layered = RouteInfo.LayerType.PLAIN;
        }
        this.targetHost = target;
        this.localAddress = local;
        this.proxyChain = proxies;
        this.secure = secure;
        this.tunnelled = tunnelled;
        this.layered = layered;
    }

    public HttpRoute(HttpHost target, InetAddress local, HttpHost[] proxies, boolean secure, RouteInfo.TunnelType tunnelled, RouteInfo.LayerType layered) {
        this(local, target, HttpRoute.toChain(proxies), secure, tunnelled, layered);
    }

    public HttpRoute(HttpHost target, InetAddress local, HttpHost proxy, boolean secure, RouteInfo.TunnelType tunnelled, RouteInfo.LayerType layered) {
        this(local, target, HttpRoute.toChain(proxy), secure, tunnelled, layered);
    }

    public HttpRoute(HttpHost target, InetAddress local, boolean secure) {
        this(local, target, null, secure, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
    }

    public HttpRoute(HttpHost target) {
        this(null, target, null, false, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
    }

    public HttpRoute(HttpHost target, InetAddress local, HttpHost proxy, boolean secure) {
        this(local, target, HttpRoute.toChain(proxy), secure, secure ? RouteInfo.TunnelType.TUNNELLED : RouteInfo.TunnelType.PLAIN, secure ? RouteInfo.LayerType.LAYERED : RouteInfo.LayerType.PLAIN);
        if (proxy == null) {
            throw new IllegalArgumentException("Proxy host may not be null.");
        }
    }

    private static HttpHost[] toChain(HttpHost proxy) {
        if (proxy == null) {
            return null;
        }
        return new HttpHost[]{proxy};
    }

    private static HttpHost[] toChain(HttpHost[] proxies) {
        if (proxies == null || proxies.length < 1) {
            return null;
        }
        for (HttpHost proxy : proxies) {
            if (proxy != null) continue;
            throw new IllegalArgumentException("Proxy chain may not contain null elements.");
        }
        HttpHost[] result = new HttpHost[proxies.length];
        System.arraycopy(proxies, 0, result, 0, proxies.length);
        return result;
    }

    public HttpHost getTargetHost() {
        return this.targetHost;
    }

    public InetAddress getLocalAddress() {
        return this.localAddress;
    }

    public int getHopCount() {
        return this.proxyChain == null ? 1 : this.proxyChain.length + 1;
    }

    public HttpHost getHopTarget(int hop) {
        if (hop < 0) {
            throw new IllegalArgumentException("Hop index must not be negative: " + hop);
        }
        int hopcount = this.getHopCount();
        if (hop >= hopcount) {
            throw new IllegalArgumentException("Hop index " + hop + " exceeds route length " + hopcount);
        }
        HttpHost result = null;
        result = hop < hopcount - 1 ? this.proxyChain[hop] : this.targetHost;
        return result;
    }

    public HttpHost getProxyHost() {
        return this.proxyChain == null ? null : this.proxyChain[0];
    }

    public RouteInfo.TunnelType getTunnelType() {
        return this.tunnelled;
    }

    public boolean isTunnelled() {
        return this.tunnelled == RouteInfo.TunnelType.TUNNELLED;
    }

    public RouteInfo.LayerType getLayerType() {
        return this.layered;
    }

    public boolean isLayered() {
        return this.layered == RouteInfo.LayerType.LAYERED;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpRoute)) {
            return false;
        }
        HttpRoute that = (HttpRoute)o;
        boolean equal = this.targetHost.equals(that.targetHost);
        equal &= this.localAddress == that.localAddress || this.localAddress != null && this.localAddress.equals(that.localAddress);
        equal &= this.proxyChain == that.proxyChain || this.proxyChain != null && that.proxyChain != null && this.proxyChain.length == that.proxyChain.length;
        if ((equal &= this.secure == that.secure && this.tunnelled == that.tunnelled && this.layered == that.layered) && this.proxyChain != null) {
            for (int i = 0; equal && i < this.proxyChain.length; ++i) {
                equal = this.proxyChain[i].equals(that.proxyChain[i]);
            }
        }
        return equal;
    }

    public int hashCode() {
        int hc = this.targetHost.hashCode();
        if (this.localAddress != null) {
            hc ^= this.localAddress.hashCode();
        }
        if (this.proxyChain != null) {
            hc ^= this.proxyChain.length;
            for (HttpHost aProxyChain : this.proxyChain) {
                hc ^= aProxyChain.hashCode();
            }
        }
        if (this.secure) {
            hc ^= 0x11111111;
        }
        hc ^= this.tunnelled.hashCode();
        return hc ^= this.layered.hashCode();
    }

    public String toString() {
        StringBuilder cab = new StringBuilder(50 + this.getHopCount() * 30);
        cab.append("HttpRoute[");
        if (this.localAddress != null) {
            cab.append(this.localAddress);
            cab.append("->");
        }
        cab.append('{');
        if (this.tunnelled == RouteInfo.TunnelType.TUNNELLED) {
            cab.append('t');
        }
        if (this.layered == RouteInfo.LayerType.LAYERED) {
            cab.append('l');
        }
        if (this.secure) {
            cab.append('s');
        }
        cab.append("}->");
        if (this.proxyChain != null) {
            for (HttpHost aProxyChain : this.proxyChain) {
                cab.append(aProxyChain);
                cab.append("->");
            }
        }
        cab.append(this.targetHost);
        cab.append(']');
        return cab.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

