/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.fortress;

import com.android.tools.layoutlib.java.Objects;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.harmony.security.fortress.SecurityAccess;
import org.apache.harmony.security.fortress.Services;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Engine {
    public static SecurityAccess door;
    private final String serviceName;
    private volatile ServiceCacheEntry serviceCache;

    public Engine(String serviceName) {
        this.serviceName = serviceName;
    }

    public SpiAndProvider getInstance(String algorithm, Object param) throws NoSuchAlgorithmException {
        if (algorithm == null) {
            throw new NoSuchAlgorithmException("Null algorithm name");
        }
        ArrayList<Provider.Service> services = this.getServices(algorithm, null);
        if (services == null) {
            throw this.notFound(this.serviceName, algorithm);
        }
        return new SpiAndProvider(services.get(0).newInstance(param), services.get(0).getProvider());
    }

    public SpiAndProvider getInstance(Provider.Service service, String param) throws NoSuchAlgorithmException {
        return new SpiAndProvider(service.newInstance(param), service.getProvider());
    }

    public ArrayList<Provider.Service> getServices(String algorithm, Provider provider) {
        int newCacheVersion = Services.getCacheVersion();
        ServiceCacheEntry cacheEntry = this.serviceCache;
        String algoUC = algorithm.toUpperCase(Locale.US);
        if (cacheEntry != null && cacheEntry.algorithm.equalsIgnoreCase(algoUC) && Objects.equals(cacheEntry.provider, provider) && newCacheVersion == cacheEntry.cacheVersion) {
            return cacheEntry.services;
        }
        String name = this.serviceName + "." + algoUC;
        ArrayList<Provider.Service> services = Services.getServices(name);
        if (provider == null || services == null) {
            this.serviceCache = new ServiceCacheEntry(algoUC, provider, newCacheVersion, services);
            return services;
        }
        ArrayList<Provider.Service> filteredServices = new ArrayList<Provider.Service>(services.size());
        for (Provider.Service service : services) {
            if (!provider.equals(service.getProvider())) continue;
            filteredServices.add(service);
        }
        this.serviceCache = new ServiceCacheEntry(algoUC, provider, newCacheVersion, filteredServices);
        return filteredServices;
    }

    public Object getInstance(String algorithm, Provider provider, Object param) throws NoSuchAlgorithmException {
        if (algorithm == null) {
            throw new NoSuchAlgorithmException("algorithm == null");
        }
        Provider.Service service = provider.getService(this.serviceName, algorithm);
        if (service == null) {
            throw this.notFound(this.serviceName, algorithm);
        }
        return service.newInstance(param);
    }

    private NoSuchAlgorithmException notFound(String serviceName, String algorithm) throws NoSuchAlgorithmException {
        throw new NoSuchAlgorithmException(serviceName + " " + algorithm + " implementation not found");
    }

    public static class SpiAndProvider {
        public final Object spi;
        public final Provider provider;

        private SpiAndProvider(Object spi, Provider provider) {
            this.spi = spi;
            this.provider = provider;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ServiceCacheEntry {
        private final String algorithm;
        private final Provider provider;
        private final int cacheVersion;
        private final ArrayList<Provider.Service> services;

        private ServiceCacheEntry(String algorithm, Provider provider, int cacheVersion, ArrayList<Provider.Service> services) {
            this.algorithm = algorithm;
            this.provider = provider;
            this.cacheVersion = cacheVersion;
            this.services = services;
        }
    }
}

