/*
 * Decompiled with CFR 0.152.
 */
package libcore.io;

import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.FileDescriptor;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.NioUtils;
import libcore.io.ErrnoException;
import libcore.io.GaiException;
import libcore.io.Os;
import libcore.io.StructAddrinfo;
import libcore.io.StructFlock;
import libcore.io.StructGroupReq;
import libcore.io.StructLinger;
import libcore.io.StructPasswd;
import libcore.io.StructPollfd;
import libcore.io.StructStat;
import libcore.io.StructStatVfs;
import libcore.io.StructTimeval;
import libcore.io.StructUcred;
import libcore.io.StructUtsname;
import libcore.util.MutableInt;
import libcore.util.MutableLong;

public class Posix
implements Os {
    Posix() {
    }

    public FileDescriptor accept(FileDescriptor fileDescriptor, InetSocketAddress inetSocketAddress) throws ErrnoException, SocketException {
        return (FileDescriptor)OverrideMethod.invokeA("libcore.io.Posix#accept(Ljava/io/FileDescriptor;Ljava/net/InetSocketAddress;)Ljava/io/FileDescriptor;", true, this);
    }

    public boolean access(String string2, int n) throws ErrnoException {
        return OverrideMethod.invokeI("libcore.io.Posix#access(Ljava/lang/String;I)Z", true, this) != 0;
    }

    public void bind(FileDescriptor fileDescriptor, InetAddress inetAddress, int n) throws ErrnoException, SocketException {
        OverrideMethod.invokeV("libcore.io.Posix#bind(Ljava/io/FileDescriptor;Ljava/net/InetAddress;I)V", true, this);
    }

    public void chmod(String string2, int n) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#chmod(Ljava/lang/String;I)V", true, this);
    }

    public void chown(String string2, int n, int n2) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#chown(Ljava/lang/String;II)V", true, this);
    }

    public void close(FileDescriptor fileDescriptor) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#close(Ljava/io/FileDescriptor;)V", true, this);
    }

    public void connect(FileDescriptor fileDescriptor, InetAddress inetAddress, int n) throws ErrnoException, SocketException {
        OverrideMethod.invokeV("libcore.io.Posix#connect(Ljava/io/FileDescriptor;Ljava/net/InetAddress;I)V", true, this);
    }

    public FileDescriptor dup(FileDescriptor fileDescriptor) throws ErrnoException {
        return (FileDescriptor)OverrideMethod.invokeA("libcore.io.Posix#dup(Ljava/io/FileDescriptor;)Ljava/io/FileDescriptor;", true, this);
    }

    public FileDescriptor dup2(FileDescriptor fileDescriptor, int n) throws ErrnoException {
        return (FileDescriptor)OverrideMethod.invokeA("libcore.io.Posix#dup2(Ljava/io/FileDescriptor;I)Ljava/io/FileDescriptor;", true, this);
    }

    public String[] environ() {
        return (String[])OverrideMethod.invokeA("libcore.io.Posix#environ()[Ljava/lang/String;", true, this);
    }

    public void execv(String string2, String[] stringArray) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#execv(Ljava/lang/String;[Ljava/lang/String;)V", true, this);
    }

    public void execve(String string2, String[] stringArray, String[] stringArray2) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#execve(Ljava/lang/String;[Ljava/lang/String;[Ljava/lang/String;)V", true, this);
    }

    public void fchmod(FileDescriptor fileDescriptor, int n) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#fchmod(Ljava/io/FileDescriptor;I)V", true, this);
    }

    public void fchown(FileDescriptor fileDescriptor, int n, int n2) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#fchown(Ljava/io/FileDescriptor;II)V", true, this);
    }

    public int fcntlVoid(FileDescriptor fileDescriptor, int n) throws ErrnoException {
        return OverrideMethod.invokeI("libcore.io.Posix#fcntlVoid(Ljava/io/FileDescriptor;I)I", true, this);
    }

    public int fcntlLong(FileDescriptor fileDescriptor, int n, long l) throws ErrnoException {
        return OverrideMethod.invokeI("libcore.io.Posix#fcntlLong(Ljava/io/FileDescriptor;IJ)I", true, this);
    }

    public int fcntlFlock(FileDescriptor fileDescriptor, int n, StructFlock structFlock) throws ErrnoException {
        return OverrideMethod.invokeI("libcore.io.Posix#fcntlFlock(Ljava/io/FileDescriptor;ILlibcore/io/StructFlock;)I", true, this);
    }

    public void fdatasync(FileDescriptor fileDescriptor) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#fdatasync(Ljava/io/FileDescriptor;)V", true, this);
    }

    public StructStat fstat(FileDescriptor fileDescriptor) throws ErrnoException {
        return (StructStat)OverrideMethod.invokeA("libcore.io.Posix#fstat(Ljava/io/FileDescriptor;)Llibcore/io/StructStat;", true, this);
    }

    public StructStatVfs fstatvfs(FileDescriptor fileDescriptor) throws ErrnoException {
        return (StructStatVfs)OverrideMethod.invokeA("libcore.io.Posix#fstatvfs(Ljava/io/FileDescriptor;)Llibcore/io/StructStatVfs;", true, this);
    }

    public void fsync(FileDescriptor fileDescriptor) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#fsync(Ljava/io/FileDescriptor;)V", true, this);
    }

    public void ftruncate(FileDescriptor fileDescriptor, long l) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#ftruncate(Ljava/io/FileDescriptor;J)V", true, this);
    }

    public String gai_strerror(int n) {
        return (String)OverrideMethod.invokeA("libcore.io.Posix#gai_strerror(I)Ljava/lang/String;", true, this);
    }

    public InetAddress[] getaddrinfo(String string2, StructAddrinfo structAddrinfo) throws GaiException {
        return (InetAddress[])OverrideMethod.invokeA("libcore.io.Posix#getaddrinfo(Ljava/lang/String;Llibcore/io/StructAddrinfo;)[Ljava/net/InetAddress;", true, this);
    }

    public int getegid() {
        return OverrideMethod.invokeI("libcore.io.Posix#getegid()I", true, this);
    }

    public int geteuid() {
        return OverrideMethod.invokeI("libcore.io.Posix#geteuid()I", true, this);
    }

    public int getgid() {
        return OverrideMethod.invokeI("libcore.io.Posix#getgid()I", true, this);
    }

    public String getenv(String string2) {
        return (String)OverrideMethod.invokeA("libcore.io.Posix#getenv(Ljava/lang/String;)Ljava/lang/String;", true, this);
    }

    public String getnameinfo(InetAddress inetAddress, int n) throws GaiException {
        return (String)OverrideMethod.invokeA("libcore.io.Posix#getnameinfo(Ljava/net/InetAddress;I)Ljava/lang/String;", true, this);
    }

    public SocketAddress getpeername(FileDescriptor fileDescriptor) throws ErrnoException {
        return (SocketAddress)OverrideMethod.invokeA("libcore.io.Posix#getpeername(Ljava/io/FileDescriptor;)Ljava/net/SocketAddress;", true, this);
    }

    public int getpid() {
        return OverrideMethod.invokeI("libcore.io.Posix#getpid()I", true, this);
    }

    public int getppid() {
        return OverrideMethod.invokeI("libcore.io.Posix#getppid()I", true, this);
    }

    public StructPasswd getpwnam(String string2) throws ErrnoException {
        return (StructPasswd)OverrideMethod.invokeA("libcore.io.Posix#getpwnam(Ljava/lang/String;)Llibcore/io/StructPasswd;", true, this);
    }

    public StructPasswd getpwuid(int n) throws ErrnoException {
        return (StructPasswd)OverrideMethod.invokeA("libcore.io.Posix#getpwuid(I)Llibcore/io/StructPasswd;", true, this);
    }

    public SocketAddress getsockname(FileDescriptor fileDescriptor) throws ErrnoException {
        return (SocketAddress)OverrideMethod.invokeA("libcore.io.Posix#getsockname(Ljava/io/FileDescriptor;)Ljava/net/SocketAddress;", true, this);
    }

    public int getsockoptByte(FileDescriptor fileDescriptor, int n, int n2) throws ErrnoException {
        return OverrideMethod.invokeI("libcore.io.Posix#getsockoptByte(Ljava/io/FileDescriptor;II)I", true, this);
    }

    public InetAddress getsockoptInAddr(FileDescriptor fileDescriptor, int n, int n2) throws ErrnoException {
        return (InetAddress)OverrideMethod.invokeA("libcore.io.Posix#getsockoptInAddr(Ljava/io/FileDescriptor;II)Ljava/net/InetAddress;", true, this);
    }

    public int getsockoptInt(FileDescriptor fileDescriptor, int n, int n2) throws ErrnoException {
        return OverrideMethod.invokeI("libcore.io.Posix#getsockoptInt(Ljava/io/FileDescriptor;II)I", true, this);
    }

    public StructLinger getsockoptLinger(FileDescriptor fileDescriptor, int n, int n2) throws ErrnoException {
        return (StructLinger)OverrideMethod.invokeA("libcore.io.Posix#getsockoptLinger(Ljava/io/FileDescriptor;II)Llibcore/io/StructLinger;", true, this);
    }

    public StructTimeval getsockoptTimeval(FileDescriptor fileDescriptor, int n, int n2) throws ErrnoException {
        return (StructTimeval)OverrideMethod.invokeA("libcore.io.Posix#getsockoptTimeval(Ljava/io/FileDescriptor;II)Llibcore/io/StructTimeval;", true, this);
    }

    public StructUcred getsockoptUcred(FileDescriptor fileDescriptor, int n, int n2) throws ErrnoException {
        return (StructUcred)OverrideMethod.invokeA("libcore.io.Posix#getsockoptUcred(Ljava/io/FileDescriptor;II)Llibcore/io/StructUcred;", true, this);
    }

    public int gettid() {
        return OverrideMethod.invokeI("libcore.io.Posix#gettid()I", true, this);
    }

    public int getuid() {
        return OverrideMethod.invokeI("libcore.io.Posix#getuid()I", true, this);
    }

    public String if_indextoname(int n) {
        return (String)OverrideMethod.invokeA("libcore.io.Posix#if_indextoname(I)Ljava/lang/String;", true, this);
    }

    public InetAddress inet_pton(int n, String string2) {
        return (InetAddress)OverrideMethod.invokeA("libcore.io.Posix#inet_pton(ILjava/lang/String;)Ljava/net/InetAddress;", true, this);
    }

    public InetAddress ioctlInetAddress(FileDescriptor fileDescriptor, int n, String string2) throws ErrnoException {
        return (InetAddress)OverrideMethod.invokeA("libcore.io.Posix#ioctlInetAddress(Ljava/io/FileDescriptor;ILjava/lang/String;)Ljava/net/InetAddress;", true, this);
    }

    public int ioctlInt(FileDescriptor fileDescriptor, int n, MutableInt mutableInt) throws ErrnoException {
        return OverrideMethod.invokeI("libcore.io.Posix#ioctlInt(Ljava/io/FileDescriptor;ILlibcore/util/MutableInt;)I", true, this);
    }

    public boolean isatty(FileDescriptor fileDescriptor) {
        return OverrideMethod.invokeI("libcore.io.Posix#isatty(Ljava/io/FileDescriptor;)Z", true, this) != 0;
    }

    public void kill(int n, int n2) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#kill(II)V", true, this);
    }

    public void lchown(String string2, int n, int n2) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#lchown(Ljava/lang/String;II)V", true, this);
    }

    public void listen(FileDescriptor fileDescriptor, int n) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#listen(Ljava/io/FileDescriptor;I)V", true, this);
    }

    public long lseek(FileDescriptor fileDescriptor, long l, int n) throws ErrnoException {
        return OverrideMethod.invokeL("libcore.io.Posix#lseek(Ljava/io/FileDescriptor;JI)J", true, this);
    }

    public StructStat lstat(String string2) throws ErrnoException {
        return (StructStat)OverrideMethod.invokeA("libcore.io.Posix#lstat(Ljava/lang/String;)Llibcore/io/StructStat;", true, this);
    }

    public void mincore(long l, long l2, byte[] byArray) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#mincore(JJ[B)V", true, this);
    }

    public void mkdir(String string2, int n) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#mkdir(Ljava/lang/String;I)V", true, this);
    }

    public void mlock(long l, long l2) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#mlock(JJ)V", true, this);
    }

    public long mmap(long l, long l2, int n, int n2, FileDescriptor fileDescriptor, long l3) throws ErrnoException {
        return OverrideMethod.invokeL("libcore.io.Posix#mmap(JJIILjava/io/FileDescriptor;J)J", true, this);
    }

    public void msync(long l, long l2, int n) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#msync(JJI)V", true, this);
    }

    public void munlock(long l, long l2) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#munlock(JJ)V", true, this);
    }

    public void munmap(long l, long l2) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#munmap(JJ)V", true, this);
    }

    public FileDescriptor open(String string2, int n, int n2) throws ErrnoException {
        return (FileDescriptor)OverrideMethod.invokeA("libcore.io.Posix#open(Ljava/lang/String;II)Ljava/io/FileDescriptor;", true, this);
    }

    public FileDescriptor[] pipe() throws ErrnoException {
        return (FileDescriptor[])OverrideMethod.invokeA("libcore.io.Posix#pipe()[Ljava/io/FileDescriptor;", true, this);
    }

    public int poll(StructPollfd[] structPollfdArray, int n) throws ErrnoException {
        return OverrideMethod.invokeI("libcore.io.Posix#poll([Llibcore/io/StructPollfd;I)I", true, this);
    }

    public int pread(FileDescriptor fd, ByteBuffer buffer, long offset) throws ErrnoException {
        if (buffer.isDirect()) {
            return this.preadBytes(fd, buffer, buffer.position(), buffer.remaining(), offset);
        }
        return this.preadBytes(fd, NioUtils.unsafeArray(buffer), NioUtils.unsafeArrayOffset(buffer) + buffer.position(), buffer.remaining(), offset);
    }

    public int pread(FileDescriptor fd, byte[] bytes, int byteOffset, int byteCount, long offset) throws ErrnoException {
        return this.preadBytes(fd, bytes, byteOffset, byteCount, offset);
    }

    private int preadBytes(FileDescriptor fileDescriptor, Object object, int n, int n2, long l) throws ErrnoException {
        return OverrideMethod.invokeI("libcore.io.Posix#preadBytes(Ljava/io/FileDescriptor;Ljava/lang/Object;IIJ)I", true, this);
    }

    public int pwrite(FileDescriptor fd, ByteBuffer buffer, long offset) throws ErrnoException {
        if (buffer.isDirect()) {
            return this.pwriteBytes(fd, buffer, buffer.position(), buffer.remaining(), offset);
        }
        return this.pwriteBytes(fd, NioUtils.unsafeArray(buffer), NioUtils.unsafeArrayOffset(buffer) + buffer.position(), buffer.remaining(), offset);
    }

    public int pwrite(FileDescriptor fd, byte[] bytes, int byteOffset, int byteCount, long offset) throws ErrnoException {
        return this.pwriteBytes(fd, bytes, byteOffset, byteCount, offset);
    }

    private int pwriteBytes(FileDescriptor fileDescriptor, Object object, int n, int n2, long l) throws ErrnoException {
        return OverrideMethod.invokeI("libcore.io.Posix#pwriteBytes(Ljava/io/FileDescriptor;Ljava/lang/Object;IIJ)I", true, this);
    }

    public int read(FileDescriptor fd, ByteBuffer buffer) throws ErrnoException {
        if (buffer.isDirect()) {
            return this.readBytes(fd, buffer, buffer.position(), buffer.remaining());
        }
        return this.readBytes(fd, NioUtils.unsafeArray(buffer), NioUtils.unsafeArrayOffset(buffer) + buffer.position(), buffer.remaining());
    }

    public int read(FileDescriptor fd, byte[] bytes, int byteOffset, int byteCount) throws ErrnoException {
        return this.readBytes(fd, bytes, byteOffset, byteCount);
    }

    private int readBytes(FileDescriptor fileDescriptor, Object object, int n, int n2) throws ErrnoException {
        return OverrideMethod.invokeI("libcore.io.Posix#readBytes(Ljava/io/FileDescriptor;Ljava/lang/Object;II)I", true, this);
    }

    public int readv(FileDescriptor fileDescriptor, Object[] objectArray, int[] nArray, int[] nArray2) throws ErrnoException {
        return OverrideMethod.invokeI("libcore.io.Posix#readv(Ljava/io/FileDescriptor;[Ljava/lang/Object;[I[I)I", true, this);
    }

    public int recvfrom(FileDescriptor fd, ByteBuffer buffer, int flags, InetSocketAddress srcAddress) throws ErrnoException, SocketException {
        if (buffer.isDirect()) {
            return this.recvfromBytes(fd, buffer, buffer.position(), buffer.remaining(), flags, srcAddress);
        }
        return this.recvfromBytes(fd, NioUtils.unsafeArray(buffer), NioUtils.unsafeArrayOffset(buffer) + buffer.position(), buffer.remaining(), flags, srcAddress);
    }

    public int recvfrom(FileDescriptor fd, byte[] bytes, int byteOffset, int byteCount, int flags, InetSocketAddress srcAddress) throws ErrnoException, SocketException {
        return this.recvfromBytes(fd, bytes, byteOffset, byteCount, flags, srcAddress);
    }

    private int recvfromBytes(FileDescriptor fileDescriptor, Object object, int n, int n2, int n3, InetSocketAddress inetSocketAddress) throws ErrnoException, SocketException {
        return OverrideMethod.invokeI("libcore.io.Posix#recvfromBytes(Ljava/io/FileDescriptor;Ljava/lang/Object;IIILjava/net/InetSocketAddress;)I", true, this);
    }

    public void remove(String string2) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#remove(Ljava/lang/String;)V", true, this);
    }

    public void rename(String string2, String string3) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#rename(Ljava/lang/String;Ljava/lang/String;)V", true, this);
    }

    public long sendfile(FileDescriptor fileDescriptor, FileDescriptor fileDescriptor2, MutableLong mutableLong, long l) throws ErrnoException {
        return OverrideMethod.invokeL("libcore.io.Posix#sendfile(Ljava/io/FileDescriptor;Ljava/io/FileDescriptor;Llibcore/util/MutableLong;J)J", true, this);
    }

    public int sendto(FileDescriptor fd, ByteBuffer buffer, int flags, InetAddress inetAddress, int port) throws ErrnoException, SocketException {
        if (buffer.isDirect()) {
            return this.sendtoBytes(fd, buffer, buffer.position(), buffer.remaining(), flags, inetAddress, port);
        }
        return this.sendtoBytes(fd, NioUtils.unsafeArray(buffer), NioUtils.unsafeArrayOffset(buffer) + buffer.position(), buffer.remaining(), flags, inetAddress, port);
    }

    public int sendto(FileDescriptor fd, byte[] bytes, int byteOffset, int byteCount, int flags, InetAddress inetAddress, int port) throws ErrnoException, SocketException {
        return this.sendtoBytes(fd, bytes, byteOffset, byteCount, flags, inetAddress, port);
    }

    private int sendtoBytes(FileDescriptor fileDescriptor, Object object, int n, int n2, int n3, InetAddress inetAddress, int n4) throws ErrnoException, SocketException {
        return OverrideMethod.invokeI("libcore.io.Posix#sendtoBytes(Ljava/io/FileDescriptor;Ljava/lang/Object;IIILjava/net/InetAddress;I)I", true, this);
    }

    public void setegid(int n) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#setegid(I)V", true, this);
    }

    public void setenv(String string2, String string3, boolean bl) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#setenv(Ljava/lang/String;Ljava/lang/String;Z)V", true, this);
    }

    public void seteuid(int n) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#seteuid(I)V", true, this);
    }

    public void setgid(int n) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#setgid(I)V", true, this);
    }

    public int setsid() throws ErrnoException {
        return OverrideMethod.invokeI("libcore.io.Posix#setsid()I", true, this);
    }

    public void setsockoptByte(FileDescriptor fileDescriptor, int n, int n2, int n3) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#setsockoptByte(Ljava/io/FileDescriptor;III)V", true, this);
    }

    public void setsockoptIfreq(FileDescriptor fileDescriptor, int n, int n2, String string2) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#setsockoptIfreq(Ljava/io/FileDescriptor;IILjava/lang/String;)V", true, this);
    }

    public void setsockoptInt(FileDescriptor fileDescriptor, int n, int n2, int n3) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#setsockoptInt(Ljava/io/FileDescriptor;III)V", true, this);
    }

    public void setsockoptIpMreqn(FileDescriptor fileDescriptor, int n, int n2, int n3) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#setsockoptIpMreqn(Ljava/io/FileDescriptor;III)V", true, this);
    }

    public void setsockoptGroupReq(FileDescriptor fileDescriptor, int n, int n2, StructGroupReq structGroupReq) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#setsockoptGroupReq(Ljava/io/FileDescriptor;IILlibcore/io/StructGroupReq;)V", true, this);
    }

    public void setsockoptLinger(FileDescriptor fileDescriptor, int n, int n2, StructLinger structLinger) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#setsockoptLinger(Ljava/io/FileDescriptor;IILlibcore/io/StructLinger;)V", true, this);
    }

    public void setsockoptTimeval(FileDescriptor fileDescriptor, int n, int n2, StructTimeval structTimeval) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#setsockoptTimeval(Ljava/io/FileDescriptor;IILlibcore/io/StructTimeval;)V", true, this);
    }

    public void setuid(int n) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#setuid(I)V", true, this);
    }

    public void shutdown(FileDescriptor fileDescriptor, int n) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#shutdown(Ljava/io/FileDescriptor;I)V", true, this);
    }

    public FileDescriptor socket(int n, int n2, int n3) throws ErrnoException {
        return (FileDescriptor)OverrideMethod.invokeA("libcore.io.Posix#socket(III)Ljava/io/FileDescriptor;", true, this);
    }

    public void socketpair(int n, int n2, int n3, FileDescriptor fileDescriptor, FileDescriptor fileDescriptor2) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#socketpair(IIILjava/io/FileDescriptor;Ljava/io/FileDescriptor;)V", true, this);
    }

    public StructStat stat(String string2) throws ErrnoException {
        return (StructStat)OverrideMethod.invokeA("libcore.io.Posix#stat(Ljava/lang/String;)Llibcore/io/StructStat;", true, this);
    }

    public StructStatVfs statvfs(String string2) throws ErrnoException {
        return (StructStatVfs)OverrideMethod.invokeA("libcore.io.Posix#statvfs(Ljava/lang/String;)Llibcore/io/StructStatVfs;", true, this);
    }

    public String strerror(int n) {
        return (String)OverrideMethod.invokeA("libcore.io.Posix#strerror(I)Ljava/lang/String;", true, this);
    }

    public String strsignal(int n) {
        return (String)OverrideMethod.invokeA("libcore.io.Posix#strsignal(I)Ljava/lang/String;", true, this);
    }

    public void symlink(String string2, String string3) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#symlink(Ljava/lang/String;Ljava/lang/String;)V", true, this);
    }

    public long sysconf(int n) {
        return OverrideMethod.invokeL("libcore.io.Posix#sysconf(I)J", true, this);
    }

    public void tcdrain(FileDescriptor fileDescriptor) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#tcdrain(Ljava/io/FileDescriptor;)V", true, this);
    }

    public void tcsendbreak(FileDescriptor fileDescriptor, int n) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#tcsendbreak(Ljava/io/FileDescriptor;I)V", true, this);
    }

    public int umask(int mask) {
        if ((mask & 0x1FF) != mask) {
            throw new IllegalArgumentException("Invalid umask: " + mask);
        }
        return this.umaskImpl(mask);
    }

    private int umaskImpl(int n) {
        return OverrideMethod.invokeI("libcore.io.Posix#umaskImpl(I)I", true, this);
    }

    public StructUtsname uname() {
        return (StructUtsname)OverrideMethod.invokeA("libcore.io.Posix#uname()Llibcore/io/StructUtsname;", true, this);
    }

    public void unsetenv(String string2) throws ErrnoException {
        OverrideMethod.invokeV("libcore.io.Posix#unsetenv(Ljava/lang/String;)V", true, this);
    }

    public int waitpid(int n, MutableInt mutableInt, int n2) throws ErrnoException {
        return OverrideMethod.invokeI("libcore.io.Posix#waitpid(ILlibcore/util/MutableInt;I)I", true, this);
    }

    public int write(FileDescriptor fd, ByteBuffer buffer) throws ErrnoException {
        if (buffer.isDirect()) {
            return this.writeBytes(fd, buffer, buffer.position(), buffer.remaining());
        }
        return this.writeBytes(fd, NioUtils.unsafeArray(buffer), NioUtils.unsafeArrayOffset(buffer) + buffer.position(), buffer.remaining());
    }

    public int write(FileDescriptor fd, byte[] bytes, int byteOffset, int byteCount) throws ErrnoException {
        return this.writeBytes(fd, bytes, byteOffset, byteCount);
    }

    private int writeBytes(FileDescriptor fileDescriptor, Object object, int n, int n2) throws ErrnoException {
        return OverrideMethod.invokeI("libcore.io.Posix#writeBytes(Ljava/io/FileDescriptor;Ljava/lang/Object;II)I", true, this);
    }

    public int writev(FileDescriptor fileDescriptor, Object[] objectArray, int[] nArray, int[] nArray2) throws ErrnoException {
        return OverrideMethod.invokeI("libcore.io.Posix#writev(Ljava/io/FileDescriptor;[Ljava/lang/Object;[I[I)I", true, this);
    }
}

