/*
 * Decompiled with CFR 0.152.
 */
package libcore.io;

import com.android.tools.layoutlib.java.AutoCloseable;
import java.io.FileDescriptor;
import java.nio.ByteOrder;
import libcore.io.BufferIterator;
import libcore.io.ErrnoException;
import libcore.io.Libcore;
import libcore.io.NioBufferIterator;
import libcore.io.OsConstants;

public class MemoryMappedFile
implements AutoCloseable {
    private long address;
    private final long size;

    public MemoryMappedFile(long address, long size) {
        this.address = address;
        this.size = size;
    }

    public static MemoryMappedFile mmapRO(String path) throws ErrnoException {
        FileDescriptor fd = Libcore.os.open(path, OsConstants.O_RDONLY, 0);
        long size = Libcore.os.fstat((FileDescriptor)fd).st_size;
        long address = Libcore.os.mmap(0L, size, OsConstants.PROT_READ, OsConstants.MAP_SHARED, fd, 0L);
        Libcore.os.close(fd);
        return new MemoryMappedFile(address, size);
    }

    public synchronized void close() throws ErrnoException {
        if (this.address != 0L) {
            Libcore.os.munmap(this.address, this.size);
            this.address = 0L;
        }
    }

    public BufferIterator bigEndianIterator() {
        return new NioBufferIterator(this.address, (int)this.size, ByteOrder.nativeOrder() != ByteOrder.BIG_ENDIAN);
    }

    public BufferIterator littleEndianIterator() {
        return new NioBufferIterator(this.address, (int)this.size, ByteOrder.nativeOrder() != ByteOrder.LITTLE_ENDIAN);
    }

    public long size() {
        return this.size;
    }
}

