/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl;

import java.net.InetAddress;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.net.ssl.DistinguishedNameParser;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.security.auth.x500.X500Principal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultHostnameVerifier
implements HostnameVerifier {
    private static final int ALT_DNS_NAME = 2;
    private static final int ALT_IPA_NAME = 7;

    @Override
    public boolean verify(String host, SSLSession session) {
        try {
            Certificate[] certificates = session.getPeerCertificates();
            return this.verify(host, (X509Certificate)certificates[0]);
        }
        catch (SSLException e) {
            return false;
        }
    }

    public boolean verify(String host, X509Certificate certificate) {
        return InetAddress.isNumeric((String)host) ? this.verifyIpAddress(host, certificate) : this.verifyHostName(host, certificate);
    }

    private boolean verifyIpAddress(String ipAddress, X509Certificate certificate) {
        for (String altName : this.getSubjectAltNames(certificate, 7)) {
            if (!ipAddress.equalsIgnoreCase(altName)) continue;
            return true;
        }
        return false;
    }

    private boolean verifyHostName(String hostName, X509Certificate certificate) {
        X500Principal principal;
        String cn;
        hostName = hostName.toLowerCase(Locale.US);
        boolean hasDns = false;
        for (String altName : this.getSubjectAltNames(certificate, 2)) {
            hasDns = true;
            if (!this.verifyHostName(hostName, altName)) continue;
            return true;
        }
        if (!hasDns && (cn = new DistinguishedNameParser(principal = certificate.getSubjectX500Principal()).findMostSpecific("cn")) != null) {
            return this.verifyHostName(hostName, cn);
        }
        return false;
    }

    private List<String> getSubjectAltNames(X509Certificate certificate, int type) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            Collection<List<?>> subjectAltNames = certificate.getSubjectAlternativeNames();
            if (subjectAltNames == null) {
                return Collections.emptyList();
            }
            for (List<?> subjectAltName : subjectAltNames) {
                String altName;
                Integer altNameType;
                List<?> entry = subjectAltName;
                if (entry == null || entry.size() < 2 || (altNameType = (Integer)entry.get(0)) == null || altNameType != type || (altName = (String)entry.get(1)) == null) continue;
                result.add(altName);
            }
            return result;
        }
        catch (CertificateParsingException e) {
            return Collections.emptyList();
        }
    }

    public boolean verifyHostName(String hostName, String cn) {
        int dot;
        if (hostName == null || hostName.isEmpty() || cn == null || cn.isEmpty()) {
            return false;
        }
        if (!(cn = cn.toLowerCase(Locale.US)).contains("*")) {
            return hostName.equals(cn);
        }
        if (cn.startsWith("*.") && hostName.regionMatches(0, cn, 2, cn.length() - 2)) {
            return true;
        }
        int asterisk = cn.indexOf(42);
        if (asterisk > (dot = cn.indexOf(46))) {
            return false;
        }
        if (!hostName.regionMatches(0, cn, 0, asterisk)) {
            return false;
        }
        int suffixLength = cn.length() - (asterisk + 1);
        int suffixStart = hostName.length() - suffixLength;
        if (hostName.indexOf(46, asterisk) < suffixStart && !hostName.endsWith(".clients.google.com")) {
            return false;
        }
        return hostName.regionMatches(suffixStart, cn, asterisk + 1, suffixLength);
    }
}

