/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import dalvik.system.VMRuntime;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import libcore.io.ErrnoException;
import libcore.io.Libcore;
import libcore.io.Memory;
import libcore.io.OsConstants;

class MemoryBlock {
    protected long address;
    protected final long size;

    public static MemoryBlock mmap(FileDescriptor fd, long offset, long size, FileChannel.MapMode mapMode) throws IOException {
        int flags;
        int prot;
        if (size == 0L) {
            return new MemoryBlock(0L, 0L);
        }
        if (offset < 0L || size < 0L || offset > Integer.MAX_VALUE || size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("offset=" + offset + " size=" + size);
        }
        if (mapMode == FileChannel.MapMode.PRIVATE) {
            prot = OsConstants.PROT_READ | OsConstants.PROT_WRITE;
            flags = OsConstants.MAP_PRIVATE;
        } else if (mapMode == FileChannel.MapMode.READ_ONLY) {
            prot = OsConstants.PROT_READ;
            flags = OsConstants.MAP_SHARED;
        } else {
            prot = OsConstants.PROT_READ | OsConstants.PROT_WRITE;
            flags = OsConstants.MAP_SHARED;
        }
        try {
            long address = Libcore.os.mmap(0L, size, prot, flags, fd, offset);
            return new MemoryMappedBlock(address, size);
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsIOException();
        }
    }

    public static MemoryBlock allocate(int byteCount) {
        VMRuntime runtime = VMRuntime.getRuntime();
        byte[] array2 = (byte[])runtime.newNonMovableArray(Byte.TYPE, byteCount);
        long address = runtime.addressOf(array2);
        return new NonMovableHeapBlock(array2, address, byteCount);
    }

    public static MemoryBlock wrapFromJni(long address, long byteCount) {
        return new UnmanagedBlock(address, byteCount);
    }

    private MemoryBlock(long address, long size) {
        this.address = address;
        this.size = size;
    }

    public byte[] array() {
        return null;
    }

    public void free() {
    }

    public void pokeByte(int offset, byte value) {
        Memory.pokeByte(this.address + (long)offset, value);
    }

    public void pokeByteArray(int offset, byte[] src, int srcOffset, int byteCount) {
        Memory.pokeByteArray(this.address + (long)offset, src, srcOffset, byteCount);
    }

    public void pokeCharArray(int offset, char[] src, int srcOffset, int charCount, boolean swap) {
        Memory.pokeCharArray(this.address + (long)offset, src, srcOffset, charCount, swap);
    }

    public void pokeDoubleArray(int offset, double[] src, int srcOffset, int doubleCount, boolean swap) {
        Memory.pokeDoubleArray(this.address + (long)offset, src, srcOffset, doubleCount, swap);
    }

    public void pokeFloatArray(int offset, float[] src, int srcOffset, int floatCount, boolean swap) {
        Memory.pokeFloatArray(this.address + (long)offset, src, srcOffset, floatCount, swap);
    }

    public void pokeIntArray(int offset, int[] src, int srcOffset, int intCount, boolean swap) {
        Memory.pokeIntArray(this.address + (long)offset, src, srcOffset, intCount, swap);
    }

    public void pokeLongArray(int offset, long[] src, int srcOffset, int longCount, boolean swap) {
        Memory.pokeLongArray(this.address + (long)offset, src, srcOffset, longCount, swap);
    }

    public void pokeShortArray(int offset, short[] src, int srcOffset, int shortCount, boolean swap) {
        Memory.pokeShortArray(this.address + (long)offset, src, srcOffset, shortCount, swap);
    }

    public byte peekByte(int offset) {
        return Memory.peekByte(this.address + (long)offset);
    }

    public void peekByteArray(int offset, byte[] dst, int dstOffset, int byteCount) {
        Memory.peekByteArray(this.address + (long)offset, dst, dstOffset, byteCount);
    }

    public void peekCharArray(int offset, char[] dst, int dstOffset, int charCount, boolean swap) {
        Memory.peekCharArray(this.address + (long)offset, dst, dstOffset, charCount, swap);
    }

    public void peekDoubleArray(int offset, double[] dst, int dstOffset, int doubleCount, boolean swap) {
        Memory.peekDoubleArray(this.address + (long)offset, dst, dstOffset, doubleCount, swap);
    }

    public void peekFloatArray(int offset, float[] dst, int dstOffset, int floatCount, boolean swap) {
        Memory.peekFloatArray(this.address + (long)offset, dst, dstOffset, floatCount, swap);
    }

    public void peekIntArray(int offset, int[] dst, int dstOffset, int intCount, boolean swap) {
        Memory.peekIntArray(this.address + (long)offset, dst, dstOffset, intCount, swap);
    }

    public void peekLongArray(int offset, long[] dst, int dstOffset, int longCount, boolean swap) {
        Memory.peekLongArray(this.address + (long)offset, dst, dstOffset, longCount, swap);
    }

    public void peekShortArray(int offset, short[] dst, int dstOffset, int shortCount, boolean swap) {
        Memory.peekShortArray(this.address + (long)offset, dst, dstOffset, shortCount, swap);
    }

    public void pokeShort(int offset, short value, ByteOrder order) {
        Memory.pokeShort(this.address + (long)offset, value, order.needsSwap);
    }

    public short peekShort(int offset, ByteOrder order) {
        return Memory.peekShort(this.address + (long)offset, order.needsSwap);
    }

    public void pokeInt(int offset, int value, ByteOrder order) {
        Memory.pokeInt(this.address + (long)offset, value, order.needsSwap);
    }

    public int peekInt(int offset, ByteOrder order) {
        return Memory.peekInt(this.address + (long)offset, order.needsSwap);
    }

    public void pokeLong(int offset, long value, ByteOrder order) {
        Memory.pokeLong(this.address + (long)offset, value, order.needsSwap);
    }

    public long peekLong(int offset, ByteOrder order) {
        return Memory.peekLong(this.address + (long)offset, order.needsSwap);
    }

    public long toLong() {
        return this.address;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.address + "]";
    }

    public long getSize() {
        return this.size;
    }

    private static class UnmanagedBlock
    extends MemoryBlock {
        private UnmanagedBlock(long address, long byteCount) {
            super(address, byteCount);
        }

        public void free() {
            this.address = 0L;
        }
    }

    private static class NonMovableHeapBlock
    extends MemoryBlock {
        private byte[] array;

        private NonMovableHeapBlock(byte[] array2, long address, long byteCount) {
            super(address, byteCount);
            this.array = array2;
        }

        public byte[] array() {
            return this.array;
        }

        public void free() {
            this.array = null;
            this.address = 0L;
        }
    }

    private static class MemoryMappedBlock
    extends MemoryBlock {
        private MemoryMappedBlock(long address, long byteCount) {
            super(address, byteCount);
        }

        public void free() {
            if (this.address != 0L) {
                try {
                    Libcore.os.munmap(this.address, this.size);
                }
                catch (ErrnoException errnoException) {
                    throw new AssertionError((Object)errnoException);
                }
                this.address = 0L;
            }
        }

        protected void finalize() throws Throwable {
            this.free();
        }
    }
}

