/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.io.Closeable;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.DirectByteBuffer;
import java.nio.IoVec;
import java.nio.MappedByteBuffer;
import java.nio.MemoryBlock;
import java.nio.NioUtils;
import java.nio.SocketChannelImpl;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.NonReadableChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.OverlappingFileLockException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import libcore.io.ErrnoException;
import libcore.io.Libcore;
import libcore.io.OsConstants;
import libcore.io.StructFlock;
import libcore.util.MutableLong;

class FileChannelImpl
extends FileChannel {
    private static final Comparator<FileLock> LOCK_COMPARATOR = new Comparator<FileLock>(){

        @Override
        public int compare(FileLock lock1, FileLock lock2) {
            long position2;
            long position1 = lock1.position();
            return position1 > (position2 = lock2.position()) ? 1 : (position1 < position2 ? -1 : 0);
        }
    };
    private final Object stream;
    private final FileDescriptor fd;
    private final int mode;
    private final SortedSet<FileLock> locks = new TreeSet<FileLock>(LOCK_COMPARATOR);

    public FileChannelImpl(Object stream, FileDescriptor fd, int mode) {
        this.fd = fd;
        this.stream = stream;
        this.mode = mode;
    }

    private void checkOpen() throws ClosedChannelException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }

    private void checkReadable() {
        if ((this.mode & OsConstants.O_ACCMODE) == OsConstants.O_WRONLY) {
            throw new NonReadableChannelException();
        }
    }

    private void checkWritable() {
        if ((this.mode & OsConstants.O_ACCMODE) == OsConstants.O_RDONLY) {
            throw new NonWritableChannelException();
        }
    }

    protected void implCloseChannel() throws IOException {
        if (this.stream instanceof Closeable) {
            ((Closeable)this.stream).close();
        }
    }

    private FileLock basicLock(long position, long size, boolean shared, boolean wait) throws IOException {
        int accessMode = this.mode & OsConstants.O_ACCMODE;
        if (accessMode == OsConstants.O_RDONLY) {
            if (!shared) {
                throw new NonWritableChannelException();
            }
        } else if (accessMode == OsConstants.O_WRONLY && shared) {
            throw new NonReadableChannelException();
        }
        if (position < 0L || size < 0L) {
            throw new IllegalArgumentException("position=" + position + " size=" + size);
        }
        FileLockImpl pendingLock = new FileLockImpl(this, position, size, shared);
        this.addLock(pendingLock);
        StructFlock flock = new StructFlock();
        flock.l_type = (short)(shared ? OsConstants.F_RDLCK : OsConstants.F_WRLCK);
        flock.l_whence = (short)OsConstants.SEEK_SET;
        flock.l_start = position;
        flock.l_len = FileChannelImpl.translateLockLength(size);
        boolean success = false;
        try {
            try {
                success = Libcore.os.fcntlFlock(this.fd, wait ? OsConstants.F_SETLKW64 : OsConstants.F_SETLK64, flock) != -1;
            }
            catch (ErrnoException errnoException) {
                throw errnoException.rethrowAsIOException();
            }
            Object var13_9 = null;
            if (!success) {
                this.removeLock(pendingLock);
            }
        }
        catch (Throwable throwable) {
            Object var13_10 = null;
            if (!success) {
                this.removeLock(pendingLock);
            }
            throw throwable;
        }
        return success ? pendingLock : null;
    }

    private static long translateLockLength(long byteCount) {
        return byteCount == Long.MAX_VALUE ? 0L : byteCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileLock lock(long position, long size, boolean shared) throws IOException {
        this.checkOpen();
        FileLock resultLock = null;
        boolean completed = false;
        try {
            this.begin();
            resultLock = this.basicLock(position, size, shared, true);
            completed = true;
            Object var9_6 = null;
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            this.end(completed);
            throw throwable;
        }
        this.end(completed);
        return resultLock;
    }

    public FileLock tryLock(long position, long size, boolean shared) throws IOException {
        this.checkOpen();
        return this.basicLock(position, size, shared, false);
    }

    public void release(FileLock lock) throws IOException {
        this.checkOpen();
        StructFlock flock = new StructFlock();
        flock.l_type = (short)OsConstants.F_UNLCK;
        flock.l_whence = (short)OsConstants.SEEK_SET;
        flock.l_start = lock.position();
        flock.l_len = FileChannelImpl.translateLockLength(lock.size());
        try {
            Libcore.os.fcntlFlock(this.fd, OsConstants.F_SETLKW64, flock);
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsIOException();
        }
        this.removeLock(lock);
    }

    public void force(boolean metadata) throws IOException {
        this.checkOpen();
        if ((this.mode & OsConstants.O_ACCMODE) != OsConstants.O_RDONLY) {
            try {
                if (metadata) {
                    Libcore.os.fsync(this.fd);
                } else {
                    Libcore.os.fdatasync(this.fd);
                }
            }
            catch (ErrnoException errnoException) {
                throw errnoException.rethrowAsIOException();
            }
        }
    }

    public MappedByteBuffer map(FileChannel.MapMode mapMode, long position, long size) throws IOException {
        this.checkOpen();
        if (mapMode == null) {
            throw new NullPointerException("mapMode == null");
        }
        if (position < 0L || size < 0L || size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("position=" + position + " size=" + size);
        }
        int accessMode = this.mode & OsConstants.O_ACCMODE;
        if (accessMode == OsConstants.O_RDONLY) {
            if (mapMode != FileChannel.MapMode.READ_ONLY) {
                throw new NonWritableChannelException();
            }
        } else if (accessMode == OsConstants.O_WRONLY) {
            throw new NonReadableChannelException();
        }
        if (position + size > this.size()) {
            try {
                Libcore.os.ftruncate(this.fd, position + size);
            }
            catch (ErrnoException ftruncateException) {
                try {
                    if (OsConstants.S_ISREG(Libcore.os.fstat((FileDescriptor)this.fd).st_mode) || ftruncateException.errno != OsConstants.EINVAL) {
                        throw ftruncateException.rethrowAsIOException();
                    }
                }
                catch (ErrnoException fstatException) {
                    throw fstatException.rethrowAsIOException();
                }
            }
        }
        long alignment = position - position % Libcore.os.sysconf(OsConstants._SC_PAGE_SIZE);
        int offset = (int)(position - alignment);
        MemoryBlock block = MemoryBlock.mmap(this.fd, alignment, size + (long)offset, mapMode);
        return new DirectByteBuffer(block, (int)size, offset, mapMode == FileChannel.MapMode.READ_ONLY, mapMode);
    }

    public long position() throws IOException {
        this.checkOpen();
        try {
            return Libcore.os.lseek(this.fd, 0L, OsConstants.SEEK_CUR);
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsIOException();
        }
    }

    public FileChannel position(long newPosition) throws IOException {
        this.checkOpen();
        if (newPosition < 0L) {
            throw new IllegalArgumentException("position: " + newPosition);
        }
        try {
            Libcore.os.lseek(this.fd, newPosition, OsConstants.SEEK_SET);
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsIOException();
        }
        return this;
    }

    public int read(ByteBuffer buffer, long position) throws IOException {
        if (position < 0L) {
            throw new IllegalArgumentException("position: " + position);
        }
        return this.readImpl(buffer, position);
    }

    public int read(ByteBuffer buffer) throws IOException {
        return this.readImpl(buffer, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readImpl(ByteBuffer buffer, long position) throws IOException {
        buffer.checkWritable();
        this.checkOpen();
        this.checkReadable();
        if (!buffer.hasRemaining()) {
            return 0;
        }
        int bytesRead = 0;
        boolean completed = false;
        try {
            this.begin();
            try {
                bytesRead = position == -1L ? Libcore.os.read(this.fd, buffer) : Libcore.os.pread(this.fd, buffer, position);
                if (bytesRead == 0) {
                    bytesRead = -1;
                }
            }
            catch (ErrnoException errnoException) {
                if (errnoException.errno == OsConstants.EAGAIN) {
                    bytesRead = 0;
                }
                throw errnoException.rethrowAsIOException();
            }
            completed = true;
            Object var8_6 = null;
            this.end(completed && bytesRead >= 0);
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.end(completed && bytesRead >= 0);
            throw throwable;
        }
        if (bytesRead > 0) {
            buffer.position(buffer.position() + bytesRead);
        }
        return bytesRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int transferIoVec(IoVec ioVec) throws IOException {
        if (ioVec.init() == 0) {
            return 0;
        }
        int bytesTransferred = 0;
        boolean completed = false;
        try {
            this.begin();
            bytesTransferred = ioVec.doTransfer(this.fd);
            completed = true;
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.end(completed);
            throw throwable;
        }
        this.end(completed);
        ioVec.didTransfer(bytesTransferred);
        return bytesTransferred;
    }

    public long read(ByteBuffer[] buffers, int offset, int length) throws IOException {
        Arrays.checkOffsetAndCount((int)buffers.length, (int)offset, (int)length);
        this.checkOpen();
        this.checkReadable();
        return this.transferIoVec(new IoVec(buffers, offset, length, IoVec.Direction.READV));
    }

    public long size() throws IOException {
        this.checkOpen();
        try {
            return Libcore.os.fstat((FileDescriptor)this.fd).st_size;
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsIOException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
        this.checkOpen();
        if (!src.isOpen()) {
            throw new ClosedChannelException();
        }
        this.checkWritable();
        if (position < 0L || count < 0L || count > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("position=" + position + " count=" + count);
        }
        if (position > this.size()) {
            return 0L;
        }
        if (src instanceof FileChannel) {
            long l;
            FileChannel fileSrc = (FileChannel)src;
            long size = fileSrc.size();
            long filePosition = fileSrc.position();
            count = Math.min(count, size - filePosition);
            MappedByteBuffer buffer = fileSrc.map(FileChannel.MapMode.READ_ONLY, filePosition, count);
            try {
                fileSrc.position(filePosition + count);
                l = this.write(buffer, position);
                Object var15_10 = null;
            }
            catch (Throwable throwable) {
                Object var15_11 = null;
                NioUtils.freeDirectBuffer(buffer);
                throw throwable;
            }
            NioUtils.freeDirectBuffer(buffer);
            return l;
        }
        ByteBuffer buffer = ByteBuffer.allocate((int)count);
        src.read(buffer);
        buffer.flip();
        return this.write(buffer, position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
        long l;
        block13: {
            this.checkOpen();
            if (!target.isOpen()) {
                throw new ClosedChannelException();
            }
            this.checkReadable();
            if (target instanceof FileChannelImpl) {
                ((FileChannelImpl)target).checkWritable();
            }
            if (position < 0L) throw new IllegalArgumentException("position=" + position + " count=" + count);
            if (count < 0L) {
                throw new IllegalArgumentException("position=" + position + " count=" + count);
            }
            if (count == 0L) return 0L;
            if (position >= this.size()) {
                return 0L;
            }
            count = Math.min(count, this.size() - position);
            boolean completed = false;
            if (target instanceof SocketChannelImpl) {
                long l2;
                FileDescriptor outFd = ((SocketChannelImpl)target).getFD();
                try {
                    this.begin();
                    try {
                        MutableLong offset = new MutableLong(position);
                        long rc = Libcore.os.sendfile(outFd, this.fd, offset, count);
                        completed = true;
                        l2 = rc;
                    }
                    catch (ErrnoException errnoException) {
                        if (errnoException.errno != OsConstants.ENOSYS && errnoException.errno != OsConstants.EINVAL) {
                            throw errnoException.rethrowAsIOException();
                        }
                        Object var14_12 = null;
                        this.end(completed);
                        break block13;
                    }
                    Object var14_11 = null;
                }
                catch (Throwable throwable) {
                    Object var14_13 = null;
                    this.end(completed);
                    throw throwable;
                }
                this.end(completed);
                return l2;
            }
        }
        MappedByteBuffer buffer = null;
        try {
            buffer = this.map(FileChannel.MapMode.READ_ONLY, position, count);
            l = target.write(buffer);
            Object var16_15 = null;
        }
        catch (Throwable throwable) {
            Object var16_16 = null;
            NioUtils.freeDirectBuffer(buffer);
            throw throwable;
        }
        NioUtils.freeDirectBuffer(buffer);
        return l;
    }

    public FileChannel truncate(long size) throws IOException {
        this.checkOpen();
        if (size < 0L) {
            throw new IllegalArgumentException("size < 0: " + size);
        }
        this.checkWritable();
        if (size < this.size()) {
            try {
                Libcore.os.ftruncate(this.fd, size);
            }
            catch (ErrnoException errnoException) {
                throw errnoException.rethrowAsIOException();
            }
        }
        if (this.position() > size) {
            this.position(size);
        }
        return this;
    }

    public int write(ByteBuffer buffer, long position) throws IOException {
        if (position < 0L) {
            throw new IllegalArgumentException("position < 0: " + position);
        }
        return this.writeImpl(buffer, position);
    }

    public int write(ByteBuffer buffer) throws IOException {
        return this.writeImpl(buffer, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeImpl(ByteBuffer buffer, long position) throws IOException {
        this.checkOpen();
        this.checkWritable();
        if (buffer == null) {
            throw new NullPointerException("buffer == null");
        }
        if (!buffer.hasRemaining()) {
            return 0;
        }
        int bytesWritten = 0;
        boolean completed = false;
        try {
            this.begin();
            try {
                bytesWritten = position == -1L ? Libcore.os.write(this.fd, buffer) : Libcore.os.pwrite(this.fd, buffer, position);
            }
            catch (ErrnoException errnoException) {
                throw errnoException.rethrowAsIOException();
            }
            completed = true;
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.end(completed);
            throw throwable;
        }
        this.end(completed);
        if (bytesWritten > 0) {
            buffer.position(buffer.position() + bytesWritten);
        }
        return bytesWritten;
    }

    public long write(ByteBuffer[] buffers, int offset, int length) throws IOException {
        Arrays.checkOffsetAndCount((int)buffers.length, (int)offset, (int)length);
        this.checkOpen();
        this.checkWritable();
        return this.transferIoVec(new IoVec(buffers, offset, length, IoVec.Direction.WRITEV));
    }

    static int calculateTotalRemaining(ByteBuffer[] buffers, int offset, int length, boolean copyingIn) {
        int count = 0;
        for (int i = offset; i < offset + length; ++i) {
            count += buffers[i].remaining();
            if (!copyingIn) continue;
            buffers[i].checkWritable();
        }
        return count;
    }

    public FileDescriptor getFD() {
        return this.fd;
    }

    private synchronized void addLock(FileLock lock) throws OverlappingFileLockException {
        FileLock existingLock;
        long lockEnd = lock.position() + lock.size();
        Iterator i$ = this.locks.iterator();
        while (i$.hasNext() && (existingLock = (FileLock)i$.next()).position() <= lockEnd) {
            if (!existingLock.overlaps(lock.position(), lock.size())) continue;
            throw new OverlappingFileLockException();
        }
        this.locks.add(lock);
    }

    private synchronized void removeLock(FileLock lock) {
        this.locks.remove(lock);
    }

    private static class FileLockImpl
    extends FileLock {
        private boolean isReleased = false;

        public FileLockImpl(FileChannel channel, long position, long size, boolean shared) {
            super(channel, position, size, shared);
        }

        public boolean isValid() {
            return !this.isReleased && this.channel().isOpen();
        }

        public void release() throws IOException {
            if (!this.channel().isOpen()) {
                throw new ClosedChannelException();
            }
            if (!this.isReleased) {
                ((FileChannelImpl)this.channel()).release(this);
                this.isReleased = true;
            }
        }
    }
}

