/*
 * Decompiled with CFR 0.152.
 */
package dalvik.system.profiler;

import dalvik.system.profiler.BinaryHprof;
import dalvik.system.profiler.HprofData;
import dalvik.system.profiler.PortableThreadSampler;
import dalvik.system.profiler.ThreadSampler;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class SamplingProfiler {
    private final Map<HprofData.StackTrace, int[]> stackTraces = new HashMap<HprofData.StackTrace, int[]>();
    private final HprofData hprofData = new HprofData(this.stackTraces);
    private final Timer timer = new Timer("SamplingProfiler", true);
    private Sampler sampler;
    private final int depth;
    private final ThreadSet threadSet;
    private int nextThreadId = 200001;
    private int nextStackTraceId = 300001;
    private int nextObjectId = 1;
    private Thread[] currentThreads = new Thread[0];
    private final Map<Thread, Integer> threadIds = new HashMap<Thread, Integer>();
    private final HprofData.StackTrace mutableStackTrace = new HprofData.StackTrace();
    private final ThreadSampler threadSampler;

    public SamplingProfiler(int depth, ThreadSet threadSet) {
        this.depth = depth;
        this.threadSet = threadSet;
        this.threadSampler = SamplingProfiler.findDefaultThreadSampler();
        this.threadSampler.setDepth(depth);
        this.hprofData.setFlags(BinaryHprof.ControlSettings.CPU_SAMPLING.bitmask);
        this.hprofData.setDepth(depth);
    }

    private static ThreadSampler findDefaultThreadSampler() {
        if ("Dalvik Core Library".equals(System.getProperty("java.specification.name"))) {
            String className = "dalvik.system.profiler.DalvikThreadSampler";
            try {
                return (ThreadSampler)Class.forName(className).newInstance();
            }
            catch (Exception e) {
                System.out.println("Problem creating " + className + ": " + e);
            }
        }
        return new PortableThreadSampler();
    }

    public static ThreadSet newArrayThreadSet(Thread ... threads) {
        return new ArrayThreadSet(threads);
    }

    public static ThreadSet newThreadGroupThreadSet(ThreadGroup threadGroup) {
        return new ThreadGroupThreadSet(threadGroup);
    }

    public void start(int interval) {
        if (interval < 1) {
            throw new IllegalArgumentException("interval < 1");
        }
        if (this.sampler != null) {
            throw new IllegalStateException("profiling already started");
        }
        this.sampler = new Sampler();
        this.hprofData.setStartMillis(System.currentTimeMillis());
        this.timer.scheduleAtFixedRate((TimerTask)this.sampler, 0L, (long)interval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.sampler == null) {
            return;
        }
        Sampler sampler = this.sampler;
        synchronized (sampler) {
            this.sampler.stop = true;
            while (!this.sampler.stopped) {
                try {
                    this.sampler.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.sampler = null;
    }

    public void shutdown() {
        this.stop();
        this.timer.cancel();
    }

    public HprofData getHprofData() {
        if (this.sampler != null) {
            throw new IllegalStateException("cannot access hprof data while sampling");
        }
        return this.hprofData;
    }

    static /* synthetic */ Thread[] access$402(SamplingProfiler x0, Thread[] x1) {
        x0.currentThreads = x1;
        return x1;
    }

    private class Sampler
    extends TimerTask {
        private boolean stop;
        private boolean stopped;
        private Thread timerThread;

        private Sampler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Sampler sampler = this;
            synchronized (sampler) {
                if (this.stop) {
                    this.cancel();
                    this.stopped = true;
                    this.notifyAll();
                    return;
                }
            }
            if (this.timerThread == null) {
                this.timerThread = Thread.currentThread();
            }
            Object[] newThreads = SamplingProfiler.this.threadSet.threads();
            if (!Arrays.equals(SamplingProfiler.this.currentThreads, newThreads)) {
                this.updateThreadHistory(SamplingProfiler.this.currentThreads, (Thread[])newThreads);
                SamplingProfiler.access$402(SamplingProfiler.this, (Thread[])newThreads.clone());
            }
            for (Thread thread : SamplingProfiler.this.currentThreads) {
                StackTraceElement[] stackFrames;
                if (thread == null) break;
                if (thread == this.timerThread || (stackFrames = SamplingProfiler.this.threadSampler.getStackTrace(thread)) == null) continue;
                this.recordStackTrace(thread, stackFrames);
            }
        }

        private void recordStackTrace(Thread thread, StackTraceElement[] stackFrames) {
            Integer threadId = (Integer)SamplingProfiler.this.threadIds.get(thread);
            if (threadId == null) {
                throw new IllegalArgumentException("Unknown thread " + thread);
            }
            ((SamplingProfiler)SamplingProfiler.this).mutableStackTrace.threadId = threadId;
            ((SamplingProfiler)SamplingProfiler.this).mutableStackTrace.stackFrames = stackFrames;
            int[] countCell = (int[])SamplingProfiler.this.stackTraces.get(SamplingProfiler.this.mutableStackTrace);
            if (countCell == null) {
                countCell = new int[1];
                StackTraceElement[] stackFramesCopy = (StackTraceElement[])stackFrames.clone();
                HprofData.StackTrace stackTrace = new HprofData.StackTrace(SamplingProfiler.this.nextStackTraceId++, threadId, stackFramesCopy);
                SamplingProfiler.this.hprofData.addStackTrace(stackTrace, countCell);
            }
            countCell[0] = countCell[0] + 1;
        }

        private void updateThreadHistory(Thread[] oldThreads, Thread[] newThreads) {
            HashSet<Thread> n = new HashSet<Thread>(Arrays.asList(newThreads));
            HashSet<Thread> o = new HashSet<Thread>(Arrays.asList(oldThreads));
            HashSet<Thread> added = new HashSet<Thread>(n);
            added.removeAll(o);
            HashSet<Thread> removed = new HashSet<Thread>(o);
            removed.removeAll(n);
            for (Thread thread : added) {
                if (thread == null || thread == this.timerThread) continue;
                this.addStartThread(thread);
            }
            for (Thread thread : removed) {
                if (thread == null || thread == this.timerThread) continue;
                this.addEndThread(thread);
            }
        }

        private void addStartThread(Thread thread) {
            if (thread == null) {
                throw new NullPointerException("thread == null");
            }
            int threadId = SamplingProfiler.this.nextThreadId++;
            Integer old = SamplingProfiler.this.threadIds.put(thread, threadId);
            if (old != null) {
                throw new IllegalArgumentException("Thread already registered as " + old);
            }
            String threadName = thread.getName();
            ThreadGroup group = thread.getThreadGroup();
            String groupName = group == null ? null : group.getName();
            ThreadGroup parentGroup = group == null ? null : group.getParent();
            String parentGroupName = parentGroup == null ? null : parentGroup.getName();
            HprofData.ThreadEvent event = HprofData.ThreadEvent.start(SamplingProfiler.this.nextObjectId++, threadId, threadName, groupName, parentGroupName);
            SamplingProfiler.this.hprofData.addThreadEvent(event);
        }

        private void addEndThread(Thread thread) {
            if (thread == null) {
                throw new NullPointerException("thread == null");
            }
            Integer threadId = (Integer)SamplingProfiler.this.threadIds.remove(thread);
            if (threadId == null) {
                throw new IllegalArgumentException("Unknown thread " + thread);
            }
            HprofData.ThreadEvent event = HprofData.ThreadEvent.end(threadId);
            SamplingProfiler.this.hprofData.addThreadEvent(event);
        }
    }

    private static class ThreadGroupThreadSet
    implements ThreadSet {
        private final ThreadGroup threadGroup;
        private Thread[] threads;
        private int lastThread;

        public ThreadGroupThreadSet(ThreadGroup threadGroup) {
            if (threadGroup == null) {
                throw new NullPointerException("threadGroup == null");
            }
            this.threadGroup = threadGroup;
            this.resize();
        }

        private void resize() {
            int count = this.threadGroup.activeCount();
            this.threads = new Thread[count * 2];
            this.lastThread = 0;
        }

        public Thread[] threads() {
            int threadCount;
            while ((threadCount = this.threadGroup.enumerate(this.threads)) == this.threads.length) {
                this.resize();
            }
            if (threadCount < this.lastThread) {
                Arrays.fill(this.threads, threadCount, this.lastThread, null);
            }
            this.lastThread = threadCount;
            return this.threads;
        }
    }

    private static class ArrayThreadSet
    implements ThreadSet {
        private final Thread[] threads;

        public ArrayThreadSet(Thread ... threads) {
            if (threads == null) {
                throw new NullPointerException("threads == null");
            }
            this.threads = threads;
        }

        public Thread[] threads() {
            return this.threads;
        }
    }

    public static interface ThreadSet {
        public Thread[] threads();
    }
}

