/*
 * Decompiled with CFR 0.152.
 */
package dalvik.system;

import com.android.tools.layoutlib.create.OverrideMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VMRuntime {
    private static final VMRuntime THE_ONE = new VMRuntime();
    private int targetSdkVersion;

    private VMRuntime() {
    }

    public static VMRuntime getRuntime() {
        return THE_ONE;
    }

    public String[] properties() {
        return (String[])OverrideMethod.invokeA("dalvik.system.VMRuntime#properties()[Ljava/lang/String;", true, this);
    }

    public String bootClassPath() {
        return (String)OverrideMethod.invokeA("dalvik.system.VMRuntime#bootClassPath()Ljava/lang/String;", true, this);
    }

    public String classPath() {
        return (String)OverrideMethod.invokeA("dalvik.system.VMRuntime#classPath()Ljava/lang/String;", true, this);
    }

    public String vmVersion() {
        return (String)OverrideMethod.invokeA("dalvik.system.VMRuntime#vmVersion()Ljava/lang/String;", true, this);
    }

    public String vmLibrary() {
        return (String)OverrideMethod.invokeA("dalvik.system.VMRuntime#vmLibrary()Ljava/lang/String;", true, this);
    }

    public float getTargetHeapUtilization() {
        return OverrideMethod.invokeF("dalvik.system.VMRuntime#getTargetHeapUtilization()F", true, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float setTargetHeapUtilization(float newTarget) {
        if (newTarget <= 0.0f || newTarget >= 1.0f) {
            throw new IllegalArgumentException(newTarget + " out of range (0,1)");
        }
        VMRuntime vMRuntime = this;
        synchronized (vMRuntime) {
            float oldTarget = this.getTargetHeapUtilization();
            this.nativeSetTargetHeapUtilization(newTarget);
            return oldTarget;
        }
    }

    public synchronized void setTargetSdkVersion(int targetSdkVersion) {
        this.targetSdkVersion = targetSdkVersion;
        this.setTargetSdkVersionNative(this.targetSdkVersion);
    }

    public synchronized int getTargetSdkVersion() {
        return this.targetSdkVersion;
    }

    private void setTargetSdkVersionNative(int n) {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#setTargetSdkVersionNative(I)V", true, this);
    }

    @Deprecated
    public long getMinimumHeapSize() {
        return 0L;
    }

    @Deprecated
    public long setMinimumHeapSize(long size) {
        return 0L;
    }

    @Deprecated
    public void gcSoftReferences() {
    }

    @Deprecated
    public void runFinalizationSync() {
        System.runFinalization();
    }

    private void nativeSetTargetHeapUtilization(float f) {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#nativeSetTargetHeapUtilization(F)V", true, this);
    }

    @Deprecated
    public boolean trackExternalAllocation(long size) {
        return true;
    }

    @Deprecated
    public void trackExternalFree(long size) {
    }

    @Deprecated
    public long getExternalBytesAllocated() {
        return 0L;
    }

    public void startJitCompilation() {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#startJitCompilation()V", true, this);
    }

    public void disableJitCompilation() {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#disableJitCompilation()V", true, this);
    }

    public Object newNonMovableArray(Class<?> clazz, int n) {
        return OverrideMethod.invokeA("dalvik.system.VMRuntime#newNonMovableArray(Ljava/lang/Class;I)Ljava/lang/Object;", true, this);
    }

    public long addressOf(Object object) {
        return OverrideMethod.invokeL("dalvik.system.VMRuntime#addressOf(Ljava/lang/Object;)J", true, this);
    }

    public void clearGrowthLimit() {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#clearGrowthLimit()V", true, this);
    }

    public boolean isDebuggerActive() {
        return OverrideMethod.invokeI("dalvik.system.VMRuntime#isDebuggerActive()Z", true, this) != 0;
    }

    public void registerNativeAllocation(int n) {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#registerNativeAllocation(I)V", true, this);
    }

    public void registerNativeFree(int n) {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#registerNativeFree(I)V", true, this);
    }

    public void updateProcessState(int n) {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#updateProcessState(I)V", true, this);
    }

    public void preloadDexCaches() {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#preloadDexCaches()V", true, this);
    }

    public static void registerAppInfo(String appDir, String processName) {
    }
}

