/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.layoutlib.java;

import java.nio.charset.Charset;

public class UnsafeByteSequence {
    private byte[] bytes;
    private int count;

    public UnsafeByteSequence(int n) {
        this.bytes = new byte[n];
    }

    public int size() {
        return this.count;
    }

    public void rewind() {
        this.count = 0;
    }

    public void write(byte[] byArray, int n, int n2) {
        if (this.count + n2 >= this.bytes.length) {
            byte[] byArray2 = new byte[(this.count + n2) * 2];
            System.arraycopy(this.bytes, 0, byArray2, 0, this.count);
            this.bytes = byArray2;
        }
        System.arraycopy(byArray, n, this.bytes, this.count, n2);
        this.count += n2;
    }

    public void write(int n) {
        if (this.count == this.bytes.length) {
            byte[] byArray = new byte[this.count * 2];
            System.arraycopy(this.bytes, 0, byArray, 0, this.count);
            this.bytes = byArray;
        }
        this.bytes[this.count++] = (byte)n;
    }

    public byte[] toByteArray() {
        if (this.count == this.bytes.length) {
            return this.bytes;
        }
        byte[] byArray = new byte[this.count];
        System.arraycopy(this.bytes, 0, byArray, 0, this.count);
        return byArray;
    }

    public String toString(Charset charset) {
        return new String(this.bytes, 0, this.count, charset);
    }
}

