/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.layoutlib.java;

public class IntegralToString {
    private static final ThreadLocal<char[]> BUFFER = new /* Unavailable Anonymous Inner Class!! */;
    private static final String[] SMALL_NONNEGATIVE_VALUES = new String[100];
    private static final String[] SMALL_NEGATIVE_VALUES = new String[100];
    private static final char[] TENS = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
    private static final char[] ONES = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static final char[] MOD_10_TABLE = new char[]{'\u0000', '\u0001', '\u0002', '\u0002', '\u0003', '\u0003', '\u0004', '\u0005', '\u0005', '\u0006', '\u0007', '\u0007', '\b', '\b', '\t', '\u0000'};
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static final char[] UPPER_CASE_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};

    private IntegralToString() {
    }

    public static String intToString(int n, int n2) {
        int n3;
        if (n2 < 2 || n2 > 36) {
            n2 = 10;
        }
        if (n2 == 10) {
            return IntegralToString.intToString(n);
        }
        boolean bl = false;
        if (n < 0) {
            bl = true;
        } else {
            n = -n;
        }
        int n4 = n2 < 8 ? 33 : 12;
        char[] cArray = new char[n4];
        int n5 = n4;
        do {
            n3 = n / n2;
            cArray[--n5] = DIGITS[n2 * n3 - n];
        } while ((n = n3) != 0);
        if (bl) {
            cArray[--n5] = 45;
        }
        return new String(cArray, n5, n4 - n5);
    }

    public static String intToString(int n) {
        return IntegralToString.convertInt(null, n);
    }

    public static void appendInt(StringBuilder stringBuilder, int n) {
        IntegralToString.convertInt(stringBuilder, n);
    }

    private static String convertInt(StringBuilder stringBuilder, int n) {
        int n2;
        int n3;
        boolean bl = false;
        String string2 = null;
        if (n < 0) {
            bl = true;
            if ((n = -n) < 100) {
                if (n < 0) {
                    string2 = "-2147483648";
                } else {
                    string2 = SMALL_NEGATIVE_VALUES[n];
                    if (string2 == null) {
                        string2 = n < 10 ? IntegralToString.stringOf('-', ONES[n]) : IntegralToString.stringOf('-', TENS[n], ONES[n]);
                        IntegralToString.SMALL_NEGATIVE_VALUES[n] = string2;
                    }
                }
            }
        } else if (n < 100 && (string2 = SMALL_NONNEGATIVE_VALUES[n]) == null) {
            string2 = n < 10 ? IntegralToString.stringOf(ONES[n]) : IntegralToString.stringOf(TENS[n], ONES[n]);
            IntegralToString.SMALL_NONNEGATIVE_VALUES[n] = string2;
        }
        if (string2 != null) {
            if (stringBuilder != null) {
                stringBuilder.append(string2);
                return null;
            }
            return string2;
        }
        int n4 = 11;
        char[] cArray = stringBuilder != null ? BUFFER.get() : new char[n4];
        int n5 = n4;
        while (n >= 65536) {
            n3 = (int)(1374389535L * (long)n >>> 37);
            n2 = n - 100 * n3;
            cArray[--n5] = ONES[n2];
            cArray[--n5] = TENS[n2];
            n = n3;
        }
        while (n != 0) {
            n3 = 52429 * n >>> 19;
            n2 = n - 10 * n3;
            cArray[--n5] = DIGITS[n2];
            n = n3;
        }
        if (bl) {
            cArray[--n5] = 45;
        }
        if (stringBuilder != null) {
            stringBuilder.append(cArray, n5, n4 - n5);
            return null;
        }
        return new String(cArray, n5, n4 - n5);
    }

    public static String longToString(long l, int n) {
        long l2;
        int n2 = (int)l;
        if ((long)n2 == l) {
            return IntegralToString.intToString(n2, n);
        }
        if (n < 2 || n > 36) {
            n = 10;
        }
        if (n == 10) {
            return IntegralToString.longToString(l);
        }
        boolean bl = false;
        if (l < 0L) {
            bl = true;
        } else {
            l = -l;
        }
        int n3 = n < 8 ? 65 : 23;
        char[] cArray = new char[n3];
        int n4 = n3;
        do {
            l2 = l / (long)n;
            cArray[--n4] = DIGITS[(int)((long)n * l2 - l)];
        } while ((l = l2) != 0L);
        if (bl) {
            cArray[--n4] = 45;
        }
        return new String(cArray, n4, n3 - n4);
    }

    public static String longToString(long l) {
        return IntegralToString.convertLong(null, l);
    }

    public static void appendLong(StringBuilder stringBuilder, long l) {
        IntegralToString.convertLong(stringBuilder, l);
    }

    private static String convertLong(StringBuilder stringBuilder, long l) {
        boolean bl;
        int n = (int)l;
        if ((long)n == l) {
            return IntegralToString.convertInt(stringBuilder, n);
        }
        boolean bl2 = bl = l < 0L;
        if (bl && (l = -l) < 0L) {
            String string2 = "-9223372036854775808";
            if (stringBuilder != null) {
                stringBuilder.append(string2);
                return null;
            }
            return string2;
        }
        int n2 = 20;
        char[] cArray = stringBuilder != null ? BUFFER.get() : new char[n2];
        int n3 = (int)(l % 1000000000L);
        int n4 = IntegralToString.intIntoCharArray(cArray, n2, n3);
        while (n4 != n2 - 9) {
            cArray[--n4] = 48;
        }
        if (((l = (l - (long)n3 >>> 9) * -8194354213138031507L) & 0xFFFFFFFF00000000L) == 0L) {
            n4 = IntegralToString.intIntoCharArray(cArray, n4, (int)l);
        } else {
            int n5 = (int)l;
            int n6 = (int)(l >>> 32);
            int n7 = MOD_10_TABLE[0x19999999 * n5 + (n5 >>> 1) + (n5 >>> 3) >>> 28];
            if ((n7 -= n6 << 2) < 0) {
                n7 += 10;
            }
            cArray[--n4] = DIGITS[n7];
            int n8 = (int)(l - (long)n7 >>> 1) * -858993459;
            n4 = IntegralToString.intIntoCharArray(cArray, n4, n8);
        }
        if (bl) {
            cArray[--n4] = 45;
        }
        if (stringBuilder != null) {
            stringBuilder.append(cArray, n4, n2 - n4);
            return null;
        }
        return new String(cArray, n4, n2 - n4);
    }

    private static int intIntoCharArray(char[] cArray, int n, int n2) {
        int n3;
        int n4;
        while ((n2 & 0xFFFF0000) != 0) {
            n4 = (int)(1374389535L * (long)(n2 >>> 2) >>> 35);
            n3 = n2 - 100 * n4;
            cArray[--n] = ONES[n3];
            cArray[--n] = TENS[n3];
            n2 = n4;
        }
        while (n2 != 0) {
            n4 = 52429 * n2 >>> 19;
            n3 = n2 - 10 * n4;
            cArray[--n] = DIGITS[n3];
            n2 = n4;
        }
        return n;
    }

    public static String intToBinaryString(int n) {
        int n2 = 32;
        char[] cArray = new char[n2];
        int n3 = n2;
        do {
            cArray[--n3] = DIGITS[n & 1];
        } while ((n >>>= 1) != 0);
        return new String(cArray, n3, n2 - n3);
    }

    public static String longToBinaryString(long l) {
        int n = (int)l;
        if (l >= 0L && (long)n == l) {
            return IntegralToString.intToBinaryString(n);
        }
        int n2 = 64;
        char[] cArray = new char[n2];
        int n3 = n2;
        do {
            cArray[--n3] = DIGITS[(int)l & 1];
        } while ((l >>>= 1) != 0L);
        return new String(cArray, n3, n2 - n3);
    }

    public static StringBuilder appendByteAsHex(StringBuilder stringBuilder, byte by, boolean bl) {
        char[] cArray = bl ? UPPER_CASE_DIGITS : DIGITS;
        stringBuilder.append(cArray[by >> 4 & 0xF]);
        stringBuilder.append(cArray[by & 0xF]);
        return stringBuilder;
    }

    public static String byteToHexString(byte by, boolean bl) {
        char[] cArray = bl ? UPPER_CASE_DIGITS : DIGITS;
        char[] cArray2 = new char[]{cArray[by >> 4 & 0xF], cArray[by & 0xF]};
        return new String(cArray2, 0, 2);
    }

    public static String bytesToHexString(byte[] byArray, boolean bl) {
        char[] cArray = bl ? UPPER_CASE_DIGITS : DIGITS;
        char[] cArray2 = new char[byArray.length * 2];
        int n = 0;
        for (byte by : byArray) {
            cArray2[n++] = cArray[by >> 4 & 0xF];
            cArray2[n++] = cArray[by & 0xF];
        }
        return new String(cArray2);
    }

    public static String intToHexString(int n, boolean bl, int n2) {
        int n3 = 8;
        char[] cArray = new char[n3];
        int n4 = n3;
        char[] cArray2 = bl ? UPPER_CASE_DIGITS : DIGITS;
        do {
            cArray[--n4] = cArray2[n & 0xF];
        } while ((n >>>= 4) != 0 || n3 - n4 < n2);
        return new String(cArray, n4, n3 - n4);
    }

    public static String longToHexString(long l) {
        int n = (int)l;
        if (l >= 0L && (long)n == l) {
            return IntegralToString.intToHexString(n, false, 0);
        }
        int n2 = 16;
        char[] cArray = new char[n2];
        int n3 = n2;
        do {
            cArray[--n3] = DIGITS[(int)l & 0xF];
        } while ((l >>>= 4) != 0L);
        return new String(cArray, n3, n2 - n3);
    }

    public static String intToOctalString(int n) {
        int n2 = 11;
        char[] cArray = new char[n2];
        int n3 = n2;
        do {
            cArray[--n3] = DIGITS[n & 7];
        } while ((n >>>= 3) != 0);
        return new String(cArray, n3, n2 - n3);
    }

    public static String longToOctalString(long l) {
        int n = (int)l;
        if (l >= 0L && (long)n == l) {
            return IntegralToString.intToOctalString(n);
        }
        int n2 = 22;
        char[] cArray = new char[n2];
        int n3 = n2;
        do {
            cArray[--n3] = DIGITS[(int)l & 7];
        } while ((l >>>= 3) != 0L);
        return new String(cArray, n3, n2 - n3);
    }

    private static String stringOf(char ... cArray) {
        return new String(cArray, 0, cArray.length);
    }
}

