/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.layoutlib.java;

import java.nio.CharBuffer;
import java.nio.charset.Charset;

public class Charsets {
    public static final Charset ISO_8859_1 = Charset.forName("ISO-8859-1");
    public static final Charset US_ASCII = Charset.forName("US-ASCII");
    public static final Charset UTF_8 = Charset.forName("UTF-8");

    public static byte[] toAsciiBytes(char[] cArray, int n, int n2) {
        CharBuffer charBuffer = CharBuffer.allocate(n2);
        charBuffer.put(cArray, n, n2);
        return US_ASCII.encode(charBuffer).array();
    }

    public static byte[] toIsoLatin1Bytes(char[] cArray, int n, int n2) {
        CharBuffer charBuffer = CharBuffer.allocate(n2);
        charBuffer.put(cArray, n, n2);
        return ISO_8859_1.encode(charBuffer).array();
    }

    public static byte[] toUtf8Bytes(char[] cArray, int n, int n2) {
        CharBuffer charBuffer = CharBuffer.allocate(n2);
        charBuffer.put(cArray, n, n2);
        return UTF_8.encode(charBuffer).array();
    }

    public static byte[] toBigEndianUtf16Bytes(char[] cArray, int n, int n2) {
        byte[] byArray = new byte[n2 * 2];
        int n3 = n + n2;
        int n4 = 0;
        for (int i = n; i < n3; ++i) {
            char c = cArray[i];
            byArray[n4++] = (byte)(c >> 8);
            byArray[n4++] = (byte)c;
        }
        return byArray;
    }

    public static void asciiBytesToChars(byte[] byArray, int n, int n2, char[] cArray) {
        if (byArray == null || cArray == null) {
            return;
        }
        int n3 = n;
        for (int i = 0; i < n2; ++i) {
            int n4;
            cArray[i] = (n4 = (int)(byArray[n3++] & 0xFF)) <= 127 ? n4 : 4093;
        }
    }

    public static void isoLatin1BytesToChars(byte[] byArray, int n, int n2, char[] cArray) {
        if (byArray == null || cArray == null) {
            return;
        }
        int n3 = n;
        for (int i = 0; i < n2; ++i) {
            cArray[i] = (char)(byArray[n3++] & 0xFF);
        }
    }

    private Charsets() {
    }
}

