/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.util;

import com.android.internal.util.ArrayUtils;
import java.lang.ref.WeakReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparseWeakArray<E> {
    private static final Object DELETED_REF = new Object();
    private static final WeakReference<?> DELETED = new WeakReference<Object>(DELETED_REF);
    private boolean mGarbage = false;
    private long[] mKeys;
    private WeakReference<?>[] mValues;
    private int mSize;

    public SparseWeakArray() {
        this(10);
    }

    public SparseWeakArray(int n) {
        n = ArrayUtils.idealLongArraySize(n);
        this.mKeys = new long[n];
        this.mValues = new WeakReference[n];
        this.mSize = 0;
    }

    public E get(long l) {
        return this.get(l, null);
    }

    public E get(long l, E e) {
        int n = SparseWeakArray.binarySearch(this.mKeys, 0, this.mSize, l);
        if (n < 0 || this.mValues[n] == DELETED || this.mValues[n].get() == null) {
            return e;
        }
        return (E)this.mValues[n].get();
    }

    public void delete(long l) {
        int n = SparseWeakArray.binarySearch(this.mKeys, 0, this.mSize, l);
        if (n >= 0 && this.mValues[n] != DELETED) {
            this.mValues[n] = DELETED;
            this.mGarbage = true;
        }
    }

    public void remove(long l) {
        this.delete(l);
    }

    public void removeAt(int n) {
        if (this.mValues[n] != DELETED) {
            this.mValues[n] = DELETED;
            this.mGarbage = true;
        }
    }

    private void gc() {
        WeakReference<?> weakReference;
        int n;
        int n2 = this.mSize;
        int n3 = 0;
        long[] lArray = this.mKeys;
        WeakReference<?>[] weakReferenceArray = this.mValues;
        for (n = 0; n < n2; ++n) {
            weakReference = weakReferenceArray[n];
            if (weakReference == DELETED || weakReference.get() == null) continue;
            if (n != n3) {
                lArray[n3] = lArray[n];
                weakReferenceArray[n3] = weakReference;
            }
            ++n3;
        }
        this.mGarbage = false;
        this.mSize = n3;
        n = ArrayUtils.idealLongArraySize(this.mSize);
        if (n < this.mKeys.length) {
            weakReference = (WeakReference<?>)new long[n];
            WeakReference[] weakReferenceArray2 = new WeakReference[n];
            System.arraycopy(this.mKeys, 0, weakReference, 0, n);
            System.arraycopy(this.mValues, 0, weakReferenceArray2, 0, n);
            this.mKeys = (long[])weakReference;
            this.mValues = weakReferenceArray2;
        }
    }

    public void put(long l, E e) {
        int n = SparseWeakArray.binarySearch(this.mKeys, 0, this.mSize, l);
        if (n >= 0) {
            this.mValues[n] = new WeakReference<E>(e);
        } else {
            if ((n ^= 0xFFFFFFFF) < this.mSize && (this.mValues[n] == DELETED || this.mValues[n].get() == null)) {
                this.mKeys[n] = l;
                this.mValues[n] = new WeakReference<E>(e);
                return;
            }
            if (this.mSize >= this.mKeys.length && (this.mGarbage || this.hasReclaimedRefs())) {
                this.gc();
                n = ~SparseWeakArray.binarySearch(this.mKeys, 0, this.mSize, l);
            }
            if (this.mSize >= this.mKeys.length) {
                int n2 = ArrayUtils.idealLongArraySize(this.mSize + 1);
                long[] lArray = new long[n2];
                WeakReference[] weakReferenceArray = new WeakReference[n2];
                System.arraycopy(this.mKeys, 0, lArray, 0, this.mKeys.length);
                System.arraycopy(this.mValues, 0, weakReferenceArray, 0, this.mValues.length);
                this.mKeys = lArray;
                this.mValues = weakReferenceArray;
            }
            if (this.mSize - n != 0) {
                System.arraycopy(this.mKeys, n, this.mKeys, n + 1, this.mSize - n);
                System.arraycopy(this.mValues, n, this.mValues, n + 1, this.mSize - n);
            }
            this.mKeys[n] = l;
            this.mValues[n] = new WeakReference<E>(e);
            ++this.mSize;
        }
    }

    public int size() {
        if (this.mGarbage) {
            this.gc();
        }
        return this.mSize;
    }

    public long keyAt(int n) {
        if (this.mGarbage) {
            this.gc();
        }
        return this.mKeys[n];
    }

    public E valueAt(int n) {
        if (this.mGarbage) {
            this.gc();
        }
        return (E)this.mValues[n].get();
    }

    public void setValueAt(int n, E e) {
        if (this.mGarbage) {
            this.gc();
        }
        this.mValues[n] = new WeakReference<E>(e);
    }

    public int indexOfKey(long l) {
        if (this.mGarbage) {
            this.gc();
        }
        return SparseWeakArray.binarySearch(this.mKeys, 0, this.mSize, l);
    }

    public int indexOfValue(E e) {
        if (this.mGarbage) {
            this.gc();
        }
        for (int i = 0; i < this.mSize; ++i) {
            if (this.mValues[i].get() != e) continue;
            return i;
        }
        return -1;
    }

    public void clear() {
        int n = this.mSize;
        WeakReference<?>[] weakReferenceArray = this.mValues;
        for (int i = 0; i < n; ++i) {
            weakReferenceArray[i] = null;
        }
        this.mSize = 0;
        this.mGarbage = false;
    }

    public void append(long l, E e) {
        int n;
        if (this.mSize != 0 && l <= this.mKeys[this.mSize - 1]) {
            this.put(l, e);
            return;
        }
        if (this.mSize >= this.mKeys.length && (this.mGarbage || this.hasReclaimedRefs())) {
            this.gc();
        }
        if ((n = this.mSize) >= this.mKeys.length) {
            int n2 = ArrayUtils.idealLongArraySize(n + 1);
            long[] lArray = new long[n2];
            WeakReference[] weakReferenceArray = new WeakReference[n2];
            System.arraycopy(this.mKeys, 0, lArray, 0, this.mKeys.length);
            System.arraycopy(this.mValues, 0, weakReferenceArray, 0, this.mValues.length);
            this.mKeys = lArray;
            this.mValues = weakReferenceArray;
        }
        this.mKeys[n] = l;
        this.mValues[n] = new WeakReference<E>(e);
        this.mSize = n + 1;
    }

    private boolean hasReclaimedRefs() {
        for (int i = 0; i < this.mSize; ++i) {
            if (this.mValues[i].get() != null) continue;
            return true;
        }
        return false;
    }

    private static int binarySearch(long[] lArray, int n, int n2, long l) {
        int n3 = n + n2;
        int n4 = n - 1;
        while (n3 - n4 > 1) {
            int n5 = (n3 + n4) / 2;
            if (lArray[n5] < l) {
                n4 = n5;
                continue;
            }
            n3 = n5;
        }
        if (n3 == n + n2) {
            return ~(n + n2);
        }
        if (lArray[n3] == l) {
            return n3;
        }
        return ~n3;
    }
}

