/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.impl.binding;

import android.view.View;
import android.view.ViewGroup;
import android.widget.Checkable;
import android.widget.ImageView;
import android.widget.TextView;
import com.android.ide.common.rendering.api.DataBindingItem;
import com.android.ide.common.rendering.api.IProjectCallback;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.impl.RenderAction;
import com.android.layoutlib.bridge.impl.binding.AdapterItem;
import com.android.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdapterHelper {
    static Pair<View, Boolean> getView(AdapterItem adapterItem, AdapterItem adapterItem2, ViewGroup viewGroup, IProjectCallback iProjectCallback, ResourceReference resourceReference, boolean bl) {
        DataBindingItem dataBindingItem = adapterItem.getDataBindingItem();
        BridgeContext bridgeContext = RenderAction.getCurrentContext();
        Pair<View, Boolean> pair = bridgeContext.inflateView(dataBindingItem.getViewReference(), viewGroup, false, bl);
        View view = (View)pair.getFirst();
        bl |= ((Boolean)pair.getSecond()).booleanValue();
        if (view != null) {
            AdapterHelper.fillView(bridgeContext, view, adapterItem, adapterItem2, iProjectCallback, resourceReference);
        } else {
            TextView textView = new TextView(bridgeContext);
            textView.setText("Unable to find layout: " + dataBindingItem.getViewReference().getName());
            view = textView;
        }
        return Pair.of((Object)view, (Object)bl);
    }

    private static void fillView(BridgeContext bridgeContext, View view, AdapterItem adapterItem, AdapterItem adapterItem2, IProjectCallback iProjectCallback, ResourceReference resourceReference) {
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            int n = viewGroup.getChildCount();
            for (int i = 0; i < n; ++i) {
                AdapterHelper.fillView(bridgeContext, viewGroup.getChildAt(i), adapterItem, adapterItem2, iProjectCallback, resourceReference);
            }
        } else {
            ResourceReference resourceReference2;
            int n = view.getId();
            if (n != 0 && (resourceReference2 = bridgeContext.resolveId(n)) != null) {
                Object object;
                Object object2;
                int n2;
                int n3 = adapterItem.getFullPosition();
                int n4 = adapterItem.getPositionPerType();
                int n5 = adapterItem2 != null ? adapterItem2.getFullPosition() : 0;
                int n6 = n2 = adapterItem2 != null ? adapterItem2.getPositionPerType() : 0;
                if (view instanceof TextView) {
                    object2 = (TextView)view;
                    object = iProjectCallback.getAdapterItemValue(resourceReference, bridgeContext.getViewKey(view), adapterItem.getDataBindingItem().getViewReference(), n3, n4, n5, n2, resourceReference2, IProjectCallback.ViewAttribute.TEXT, (Object)((Object)((TextView)object2).getText()).toString());
                    if (object != null) {
                        if (object.getClass() != IProjectCallback.ViewAttribute.TEXT.getAttributeClass()) {
                            Bridge.getLog().error("broken", String.format("Wrong Adapter Item value class for TEXT. Expected String, got %s", object.getClass().getName()), null);
                        } else {
                            ((TextView)object2).setText((String)object);
                        }
                    }
                }
                if (view instanceof Checkable) {
                    object2 = (Checkable)((Object)view);
                    object = iProjectCallback.getAdapterItemValue(resourceReference, bridgeContext.getViewKey(view), adapterItem.getDataBindingItem().getViewReference(), n3, n4, n5, n2, resourceReference2, IProjectCallback.ViewAttribute.IS_CHECKED, (Object)object2.isChecked());
                    if (object != null) {
                        if (object.getClass() != IProjectCallback.ViewAttribute.IS_CHECKED.getAttributeClass()) {
                            Bridge.getLog().error("broken", String.format("Wrong Adapter Item value class for TEXT. Expected Boolean, got %s", object.getClass().getName()), null);
                        } else {
                            object2.setChecked((Boolean)object);
                        }
                    }
                }
                if (view instanceof ImageView) {
                    object2 = (ImageView)view;
                    object = iProjectCallback.getAdapterItemValue(resourceReference, bridgeContext.getViewKey(view), adapterItem.getDataBindingItem().getViewReference(), n3, n4, n5, n2, resourceReference2, IProjectCallback.ViewAttribute.SRC, (Object)((ImageView)object2).getDrawable());
                    if (object != null && object.getClass() != IProjectCallback.ViewAttribute.SRC.getAttributeClass()) {
                        Bridge.getLog().error("broken", String.format("Wrong Adapter Item value class for TEXT. Expected Boolean, got %s", object.getClass().getName()), null);
                    }
                }
            }
        }
    }
}

