/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.impl;

import android.animation.AnimationThread;
import android.animation.Animator;
import android.animation.AnimatorInflater;
import android.animation.LayoutTransition;
import android.app.Fragment_Delegate;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Bitmap_Delegate;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.AttachInfo_Accessor;
import android.view.BridgeInflater;
import android.view.IWindowManagerImpl;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.WindowManagerGlobal_Delegate;
import android.widget.AbsListView;
import android.widget.AbsSpinner;
import android.widget.AdapterView;
import android.widget.ExpandableListView;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.QuickContactBadge;
import android.widget.TabHost;
import android.widget.TabWidget;
import com.android.ide.common.rendering.api.AdapterBinding;
import com.android.ide.common.rendering.api.HardwareConfig;
import com.android.ide.common.rendering.api.IAnimationListener;
import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.ide.common.rendering.api.IProjectCallback;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.RenderSession;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.Result;
import com.android.ide.common.rendering.api.SessionParams;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.ide.common.rendering.api.ViewType;
import com.android.internal.util.XmlUtils;
import com.android.internal.view.menu.ActionMenuItemView;
import com.android.internal.view.menu.ActionMenuView;
import com.android.internal.view.menu.BridgeMenuItemImpl;
import com.android.internal.view.menu.IconMenuItemView;
import com.android.internal.view.menu.ListMenuItemView;
import com.android.internal.view.menu.MenuItemImpl;
import com.android.internal.view.menu.MenuView;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.android.BridgeLayoutParamsMapAttributes;
import com.android.layoutlib.bridge.android.BridgeXmlBlockParser;
import com.android.layoutlib.bridge.bars.ActionBarLayout;
import com.android.layoutlib.bridge.bars.NavigationBar;
import com.android.layoutlib.bridge.bars.StatusBar;
import com.android.layoutlib.bridge.bars.TitleBar;
import com.android.layoutlib.bridge.impl.PlayAnimationThread;
import com.android.layoutlib.bridge.impl.RenderAction;
import com.android.layoutlib.bridge.impl.ResourceHelper;
import com.android.layoutlib.bridge.impl.SystemViewInfo;
import com.android.layoutlib.bridge.impl.binding.FakeAdapter;
import com.android.layoutlib.bridge.impl.binding.FakeExpandableAdapter;
import com.android.resources.Density;
import com.android.resources.ResourceType;
import com.android.resources.ScreenOrientation;
import com.android.util.Pair;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderSessionImpl
extends RenderAction<SessionParams> {
    private static final int DEFAULT_TITLE_BAR_HEIGHT = 25;
    private static final int DEFAULT_STATUS_BAR_HEIGHT = 25;
    private RenderSession mScene;
    private BridgeXmlBlockParser mBlockParser;
    private BridgeInflater mInflater;
    private ResourceValue mWindowBackground;
    private ViewGroup mViewRoot;
    private FrameLayout mContentRoot;
    private Canvas mCanvas;
    private int mMeasuredScreenWidth = -1;
    private int mMeasuredScreenHeight = -1;
    private boolean mIsAlphaChannelImage;
    private boolean mWindowIsFloating;
    private int mStatusBarSize;
    private int mNavigationBarSize;
    private int mNavigationBarOrientation = 0;
    private int mTitleBarSize;
    private int mActionBarSize;
    private BufferedImage mImage;
    private List<ViewInfo> mViewInfoList;
    private List<ViewInfo> mSystemViewInfoList;

    public RenderSessionImpl(SessionParams sessionParams) {
        super(new SessionParams(sessionParams));
    }

    @Override
    public Result init(long l) {
        Result result = super.init(l);
        if (!result.isSuccess()) {
            return result;
        }
        SessionParams sessionParams = (SessionParams)this.getParams();
        BridgeContext bridgeContext = this.getContext();
        RenderResources renderResources = ((SessionParams)this.getParams()).getResources();
        DisplayMetrics displayMetrics = this.getContext().getMetrics();
        this.mIsAlphaChannelImage = this.getBooleanThemeValue(renderResources, "windowIsFloating", true);
        this.mWindowIsFloating = this.getBooleanThemeValue(renderResources, "windowIsFloating", true);
        this.findBackground(renderResources);
        this.findStatusBar(renderResources, displayMetrics);
        this.findActionBar(renderResources, displayMetrics);
        this.findNavigationBar(renderResources, displayMetrics);
        boolean bl = true;
        IWindowManagerImpl iWindowManagerImpl = new IWindowManagerImpl(this.getContext().getConfiguration(), displayMetrics, 0, bl);
        WindowManagerGlobal_Delegate.setWindowManagerService(iWindowManagerImpl);
        this.mInflater = new BridgeInflater(bridgeContext, sessionParams.getProjectCallback());
        bridgeContext.setBridgeInflater(this.mInflater);
        this.mBlockParser = new BridgeXmlBlockParser((XmlPullParser)sessionParams.getLayoutDescription(), bridgeContext, false);
        return Result.Status.SUCCESS.createResult();
    }

    public Result inflate() {
        this.checkLock();
        try {
            Object object;
            View view;
            ViewGroup viewGroup;
            int n;
            SessionParams sessionParams = (SessionParams)this.getParams();
            HardwareConfig hardwareConfig = sessionParams.getHardwareConfig();
            BridgeContext bridgeContext = this.getContext();
            boolean bl = Bridge.isLocaleRtl(sessionParams.getLocale());
            int n2 = n = bl ? 1 : 0;
            if (this.mWindowIsFloating || sessionParams.isForceNoDecor()) {
                this.mContentRoot = new FrameLayout(bridgeContext);
                this.mViewRoot = this.mContentRoot;
                viewGroup = this.mContentRoot;
                this.mViewRoot.setLayoutDirection(n);
            } else {
                LinearLayout linearLayout;
                LinearLayout.LayoutParams layoutParams;
                if (this.hasSoftwareButtons() && this.mNavigationBarOrientation == 1) {
                    view = new LinearLayout(bridgeContext);
                    view.setLayoutDirection(n);
                    this.mViewRoot = view;
                    ((LinearLayout)view).setOrientation(0);
                    try {
                        NavigationBar navigationBar = this.createNavigationBar(bridgeContext, hardwareConfig.getDensity(), bl, sessionParams.isRtlSupported());
                        ((ViewGroup)view).addView(navigationBar);
                    }
                    catch (XmlPullParserException xmlPullParserException) {
                        // empty catch block
                    }
                }
                view = new LinearLayout(bridgeContext);
                ((LinearLayout)view).setOrientation(1);
                view.setLayoutDirection(n);
                if (this.mViewRoot == null) {
                    this.mViewRoot = view;
                } else {
                    int n3 = sessionParams.getHardwareConfig().getScreenWidth() - this.mNavigationBarSize;
                    layoutParams = new LinearLayout.LayoutParams(n3, -1);
                    view.setLayoutParams(layoutParams);
                    if (bl && sessionParams.isRtlSupported()) {
                        this.mViewRoot.addView(view);
                    } else {
                        this.mViewRoot.addView(view, 0);
                    }
                }
                if (this.mStatusBarSize > 0) {
                    try {
                        StatusBar statusBar = this.createStatusBar(bridgeContext, hardwareConfig.getDensity(), n, sessionParams.isRtlSupported());
                        ((ViewGroup)view).addView(statusBar);
                    }
                    catch (XmlPullParserException xmlPullParserException) {
                        // empty catch block
                    }
                }
                object = new LinearLayout(bridgeContext);
                viewGroup = object;
                ((LinearLayout)object).setOrientation(1);
                layoutParams = new LinearLayout.LayoutParams(-1, 0);
                layoutParams.weight = 1.0f;
                ((View)object).setLayoutParams(layoutParams);
                ((ViewGroup)view).addView((View)object);
                if (this.mActionBarSize > 0) {
                    linearLayout = this.createActionBar(bridgeContext, sessionParams);
                    ((ViewGroup)object).addView(linearLayout);
                    linearLayout.createMenuPopup();
                    this.mContentRoot = linearLayout.getContentRoot();
                } else if (this.mTitleBarSize > 0) {
                    try {
                        linearLayout = this.createTitleBar(bridgeContext, hardwareConfig.getDensity(), sessionParams.getAppLabel());
                        ((ViewGroup)object).addView(linearLayout);
                    }
                    catch (XmlPullParserException xmlPullParserException) {
                        // empty catch block
                    }
                }
                if (this.mContentRoot == null) {
                    this.mContentRoot = new FrameLayout(bridgeContext);
                    layoutParams = new LinearLayout.LayoutParams(-1, 0);
                    layoutParams.weight = 1.0f;
                    this.mContentRoot.setLayoutParams(layoutParams);
                    ((ViewGroup)object).addView(this.mContentRoot);
                }
                if (this.mNavigationBarOrientation == 0 && this.mNavigationBarSize > 0) {
                    try {
                        linearLayout = this.createNavigationBar(bridgeContext, hardwareConfig.getDensity(), bl, sessionParams.isRtlSupported());
                        ((ViewGroup)view).addView(linearLayout);
                    }
                    catch (XmlPullParserException xmlPullParserException) {
                        // empty catch block
                    }
                }
            }
            Fragment_Delegate.setProjectCallback(sessionParams.getProjectCallback());
            view = this.mInflater.inflate(this.mBlockParser, (ViewGroup)this.mContentRoot);
            bridgeContext.popParser();
            Fragment_Delegate.setProjectCallback(null);
            AttachInfo_Accessor.setAttachInfo(this.mViewRoot);
            this.postInflateProcess(view, sessionParams.getProjectCallback());
            if (this.mWindowBackground != null) {
                object = ResourceHelper.getDrawable(this.mWindowBackground, bridgeContext);
                viewGroup.setBackground((Drawable)object);
            }
            return Result.Status.SUCCESS.createResult();
        }
        catch (PostInflateException postInflateException) {
            return Result.Status.ERROR_INFLATION.createResult(postInflateException.getMessage(), (Throwable)postInflateException);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            while (throwable2.getCause() != null) {
                throwable2 = throwable2.getCause();
            }
            return Result.Status.ERROR_INFLATION.createResult(throwable2.getMessage(), throwable2);
        }
    }

    public Result render(boolean bl) {
        this.checkLock();
        SessionParams sessionParams = (SessionParams)this.getParams();
        try {
            int n;
            if (this.mViewRoot == null) {
                return Result.Status.ERROR_NOT_INFLATED.createResult();
            }
            SessionParams.RenderingMode renderingMode = sessionParams.getRenderingMode();
            HardwareConfig hardwareConfig = sessionParams.getHardwareConfig();
            boolean bl2 = false;
            if (this.mMeasuredScreenWidth == -1) {
                bl2 = true;
                this.mMeasuredScreenWidth = hardwareConfig.getScreenWidth();
                this.mMeasuredScreenHeight = hardwareConfig.getScreenHeight();
                if (renderingMode != SessionParams.RenderingMode.NORMAL) {
                    int n2;
                    int n3;
                    n = renderingMode.isHorizExpand() ? 0 : 0x40000000;
                    int n4 = renderingMode.isVertExpand() ? 0 : 0x40000000;
                    Pair<Integer, Integer> pair = this.measureView(this.mViewRoot, this.mContentRoot.getChildAt(0), this.mMeasuredScreenWidth, 0x40000000, this.mMeasuredScreenHeight, 0x40000000);
                    Pair<Integer, Integer> pair2 = this.measureView(this.mContentRoot, this.mContentRoot.getChildAt(0), this.mMeasuredScreenWidth, n, this.mMeasuredScreenHeight, n4);
                    if (renderingMode.isHorizExpand()) {
                        n3 = (Integer)pair.getFirst();
                        n2 = (Integer)pair2.getFirst();
                        if (n2 > n3) {
                            this.mMeasuredScreenWidth += n2 - n3;
                        }
                    }
                    if (renderingMode.isVertExpand()) {
                        n3 = (Integer)pair.getSecond();
                        n2 = (Integer)pair2.getSecond();
                        if (n2 > n3) {
                            this.mMeasuredScreenHeight += n2 - n3;
                        }
                    }
                }
            }
            this.measureView(this.mViewRoot, null, this.mMeasuredScreenWidth, 0x40000000, this.mMeasuredScreenHeight, 0x40000000);
            this.mViewRoot.layout(0, 0, this.mMeasuredScreenWidth, this.mMeasuredScreenHeight);
            if (sessionParams.isLayoutOnly()) {
                this.mImage = null;
                this.mCanvas = null;
            } else {
                AttachInfo_Accessor.dispatchOnPreDraw(this.mViewRoot);
                n = 0;
                if (bl2 || this.mCanvas == null) {
                    if (sessionParams.getImageFactory() != null) {
                        this.mImage = sessionParams.getImageFactory().getImage(this.mMeasuredScreenWidth, this.mMeasuredScreenHeight);
                    } else {
                        this.mImage = new BufferedImage(this.mMeasuredScreenWidth, this.mMeasuredScreenHeight, 2);
                        n = 1;
                    }
                    if (sessionParams.isBgColorOverridden()) {
                        n = 1;
                        Graphics2D graphics2D = this.mImage.createGraphics();
                        graphics2D.setColor(new Color(sessionParams.getOverrideBgColor(), true));
                        graphics2D.setComposite(AlphaComposite.Src);
                        graphics2D.fillRect(0, 0, this.mMeasuredScreenWidth, this.mMeasuredScreenHeight);
                        graphics2D.dispose();
                    }
                    Bitmap bitmap = Bitmap_Delegate.createBitmap(this.mImage, true, hardwareConfig.getDensity());
                    this.mCanvas = new Canvas(bitmap);
                    this.mCanvas.setDensity(hardwareConfig.getDensity().getDpiValue());
                }
                if (bl && n == 0) {
                    Graphics2D graphics2D = this.mImage.createGraphics();
                    graphics2D.setComposite(AlphaComposite.Src);
                    graphics2D.setColor(new Color(0, true));
                    graphics2D.fillRect(0, 0, this.mMeasuredScreenWidth, this.mMeasuredScreenHeight);
                    graphics2D.dispose();
                }
                this.mViewRoot.draw(this.mCanvas);
            }
            this.mSystemViewInfoList = this.visitAllChildren(this.mViewRoot, 0, sessionParams.getExtendedViewInfoMode(), false);
            return Result.Status.SUCCESS.createResult();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            while (throwable2.getCause() != null) {
                throwable2 = throwable2.getCause();
            }
            return Result.Status.ERROR_UNKNOWN.createResult(throwable2.getMessage(), throwable2);
        }
    }

    private Pair<Integer, Integer> measureView(ViewGroup viewGroup, View view, int n, int n2, int n3, int n4) {
        int n5 = View.MeasureSpec.makeMeasureSpec(n, n2);
        int n6 = View.MeasureSpec.makeMeasureSpec(n3, n4);
        viewGroup.measure(n5, n6);
        if (view != null) {
            return Pair.of((Object)view.getMeasuredWidth(), (Object)view.getMeasuredHeight());
        }
        return null;
    }

    public Result animate(Object object, String string2, boolean bl, IAnimationListener iAnimationListener) {
        ResourceValue resourceValue;
        this.checkLock();
        BridgeContext bridgeContext = this.getContext();
        int n = 0;
        if (bl) {
            resourceValue = bridgeContext.getRenderResources().getFrameworkResource(ResourceType.ANIMATOR, string2);
            if (resourceValue != null) {
                n = Bridge.getResourceId(ResourceType.ANIMATOR, string2);
            }
        } else {
            resourceValue = bridgeContext.getRenderResources().getProjectResource(ResourceType.ANIMATOR, string2);
            if (resourceValue != null) {
                n = bridgeContext.getProjectCallback().getResourceId(ResourceType.ANIMATOR, string2);
            }
        }
        if (resourceValue != null) {
            try {
                Animator animator2 = AnimatorInflater.loadAnimator(bridgeContext, n);
                if (animator2 != null) {
                    animator2.setTarget(object);
                    new PlayAnimationThread(animator2, this, string2, iAnimationListener).start();
                    return Result.Status.SUCCESS.createResult();
                }
            }
            catch (Exception exception) {
                Throwable throwable = exception;
                while (throwable.getCause() != null) {
                    throwable = throwable.getCause();
                }
                return Result.Status.ERROR_UNKNOWN.createResult(throwable.getMessage(), throwable);
            }
        }
        return Result.Status.ERROR_ANIM_NOT_FOUND.createResult();
    }

    public Result insertChild(final ViewGroup viewGroup, ILayoutPullParser iLayoutPullParser, final int n, IAnimationListener iAnimationListener) {
        this.checkLock();
        BridgeContext bridgeContext = this.getContext();
        BridgeXmlBlockParser bridgeXmlBlockParser = new BridgeXmlBlockParser((XmlPullParser)iLayoutPullParser, bridgeContext, false);
        final View view = this.mInflater.inflate(bridgeXmlBlockParser, viewGroup, false);
        bridgeXmlBlockParser.ensurePopped();
        this.invalidateRenderingSize();
        if (iAnimationListener != null) {
            new AnimationThread(this, "insertChild", iAnimationListener){

                public Result preAnimation() {
                    viewGroup.setLayoutTransition(new LayoutTransition());
                    return RenderSessionImpl.this.addView(viewGroup, view, n);
                }

                public void postAnimation() {
                    viewGroup.setLayoutTransition(null);
                }
            }.start();
            return Result.Status.SUCCESS.createResult((Object)view);
        }
        Result result = this.addView(viewGroup, view, n);
        if (!result.isSuccess()) {
            return result;
        }
        result = this.render(false);
        if (result.isSuccess()) {
            result = result.getCopyWithData((Object)view);
        }
        return result;
    }

    private Result addView(ViewGroup viewGroup, View view, int n) {
        try {
            viewGroup.addView(view, n);
            return Result.Status.SUCCESS.createResult();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return Result.Status.ERROR_VIEWGROUP_NO_CHILDREN.createResult();
        }
    }

    public Result moveChild(final ViewGroup viewGroup, final View view, final int n, Map<String, String> map, final IAnimationListener iAnimationListener) {
        this.checkLock();
        this.invalidateRenderingSize();
        ViewGroup.LayoutParams layoutParams = null;
        if (map != null) {
            layoutParams = viewGroup.generateLayoutParams(new BridgeLayoutParamsMapAttributes(map));
        }
        final ViewGroup viewGroup2 = (ViewGroup)view.getParent();
        if (iAnimationListener != null) {
            final ViewGroup.LayoutParams layoutParams2 = layoutParams;
            if (viewGroup2 != viewGroup) {
                new Thread("not animated moveChild"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Result result = RenderSessionImpl.this.moveView(viewGroup2, viewGroup, view, n, layoutParams2);
                        if (!result.isSuccess()) {
                            iAnimationListener.done(result);
                        }
                        if (!(result = RenderSessionImpl.this.acquire(250L)).isSuccess()) {
                            iAnimationListener.done(result);
                            return;
                        }
                        try {
                            result = RenderSessionImpl.this.render(false);
                            if (result.isSuccess()) {
                                iAnimationListener.onNewFrame(RenderSessionImpl.this.getSession());
                            }
                        }
                        finally {
                            RenderSessionImpl.this.release();
                        }
                        iAnimationListener.done(result);
                    }
                }.start();
            } else {
                new AnimationThread(this, "moveChild", iAnimationListener){

                    public Result preAnimation() {
                        LayoutTransition layoutTransition = new LayoutTransition();
                        viewGroup2.setLayoutTransition(layoutTransition);
                        layoutTransition.setDuration(3, 100L);
                        layoutTransition.setStartDelay(1, 100L);
                        layoutTransition.setDuration(1, 100L);
                        layoutTransition.setDuration(0, 100L);
                        layoutTransition.setStartDelay(2, 100L);
                        layoutTransition.setDuration(2, 100L);
                        return RenderSessionImpl.this.moveView(viewGroup2, viewGroup, view, n, layoutParams2);
                    }

                    public void postAnimation() {
                        viewGroup2.setLayoutTransition(null);
                        viewGroup.setLayoutTransition(null);
                    }
                }.start();
            }
            return Result.Status.SUCCESS.createResult((Object)layoutParams);
        }
        Result result = this.moveView(viewGroup2, viewGroup, view, n, layoutParams);
        if (!result.isSuccess()) {
            return result;
        }
        result = this.render(false);
        if (layoutParams != null && result.isSuccess()) {
            result = result.getCopyWithData((Object)layoutParams);
        }
        return result;
    }

    private Result moveView(ViewGroup viewGroup, final ViewGroup viewGroup2, final View view, final int n, final ViewGroup.LayoutParams layoutParams) {
        try {
            LayoutTransition layoutTransition = viewGroup.getLayoutTransition();
            if (layoutTransition != null) {
                layoutTransition.addTransitionListener(new LayoutTransition.TransitionListener(){
                    private int mChangeDisappearingCount = 0;

                    public void startTransition(LayoutTransition layoutTransition, ViewGroup viewGroup, View view2, int n2) {
                        if (n2 == 1) {
                            ++this.mChangeDisappearingCount;
                        }
                    }

                    public void endTransition(LayoutTransition layoutTransition, ViewGroup viewGroup, View view2, int n2) {
                        if (n2 == 1) {
                            --this.mChangeDisappearingCount;
                        }
                        if (n2 == 1 && this.mChangeDisappearingCount == 0) {
                            if (layoutParams != null) {
                                viewGroup2.addView(view, n, layoutParams);
                            } else {
                                viewGroup2.addView(view, n);
                            }
                        }
                    }
                });
                viewGroup.removeView(view);
                return Result.Status.SUCCESS.createResult();
            }
            viewGroup.removeView(view);
            if (layoutParams != null) {
                viewGroup2.addView(view, n, layoutParams);
            } else {
                viewGroup2.addView(view, n);
            }
            return Result.Status.SUCCESS.createResult();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return Result.Status.ERROR_VIEWGROUP_NO_CHILDREN.createResult();
        }
    }

    public Result removeChild(final View view, IAnimationListener iAnimationListener) {
        this.checkLock();
        this.invalidateRenderingSize();
        final ViewGroup viewGroup = (ViewGroup)view.getParent();
        if (iAnimationListener != null) {
            new AnimationThread(this, "moveChild", iAnimationListener){

                public Result preAnimation() {
                    viewGroup.setLayoutTransition(new LayoutTransition());
                    return RenderSessionImpl.this.removeView(viewGroup, view);
                }

                public void postAnimation() {
                    viewGroup.setLayoutTransition(null);
                }
            }.start();
            return Result.Status.SUCCESS.createResult();
        }
        Result result = this.removeView(viewGroup, view);
        if (!result.isSuccess()) {
            return result;
        }
        return this.render(false);
    }

    private Result removeView(ViewGroup viewGroup, View view) {
        try {
            viewGroup.removeView(view);
            return Result.Status.SUCCESS.createResult();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return Result.Status.ERROR_VIEWGROUP_NO_CHILDREN.createResult();
        }
    }

    private void findBackground(RenderResources renderResources) {
        if (!((SessionParams)this.getParams()).isBgColorOverridden()) {
            this.mWindowBackground = renderResources.findItemInTheme("windowBackground", true);
            if (this.mWindowBackground != null) {
                this.mWindowBackground = renderResources.resolveResValue(this.mWindowBackground);
            }
        }
    }

    private boolean hasSoftwareButtons() {
        return ((SessionParams)this.getParams()).getHardwareConfig().hasSoftwareButtons();
    }

    private void findStatusBar(RenderResources renderResources, DisplayMetrics displayMetrics) {
        boolean bl = this.getBooleanThemeValue(renderResources, "windowFullscreen", false);
        if (!bl && !this.mWindowIsFloating) {
            TypedValue typedValue;
            this.mStatusBarSize = 25;
            ResourceValue resourceValue = renderResources.getFrameworkResource(ResourceType.DIMEN, "status_bar_height");
            if (resourceValue != null && (typedValue = ResourceHelper.getValue("status_bar_height", resourceValue.getValue(), true)) != null) {
                this.mStatusBarSize = (int)typedValue.getDimension(displayMetrics);
            }
        }
    }

    private void findActionBar(RenderResources renderResources, DisplayMetrics displayMetrics) {
        if (this.mWindowIsFloating) {
            return;
        }
        boolean bl = this.getBooleanThemeValue(renderResources, "windowActionBar", true);
        if (bl) {
            TypedValue typedValue;
            this.mActionBarSize = 25;
            ResourceValue resourceValue = renderResources.findItemInTheme("actionBarSize", true);
            if ((resourceValue = renderResources.resolveResValue(resourceValue)) != null && (typedValue = ResourceHelper.getValue("actionBarSize", resourceValue.getValue(), true)) != null) {
                this.mActionBarSize = (int)typedValue.getDimension(displayMetrics);
            }
        } else {
            boolean bl2 = this.getBooleanThemeValue(renderResources, "windowNoTitle", false);
            if (!bl2) {
                TypedValue typedValue;
                this.mTitleBarSize = 25;
                ResourceValue resourceValue = renderResources.findItemInTheme("windowTitleSize", true);
                if ((resourceValue = renderResources.resolveResValue(resourceValue)) != null && (typedValue = ResourceHelper.getValue("windowTitleSize", resourceValue.getValue(), true)) != null) {
                    this.mTitleBarSize = (int)typedValue.getDimension(displayMetrics);
                }
            }
        }
    }

    private void findNavigationBar(RenderResources renderResources, DisplayMetrics displayMetrics) {
        if (this.hasSoftwareButtons() && !this.mWindowIsFloating) {
            TypedValue typedValue;
            this.mNavigationBarSize = 48;
            HardwareConfig hardwareConfig = ((SessionParams)this.getParams()).getHardwareConfig();
            boolean bl = true;
            if (hardwareConfig.getOrientation() == ScreenOrientation.LANDSCAPE) {
                int n = hardwareConfig.getScreenHeight();
                int n2 = n * 160 / hardwareConfig.getDensity().getDpiValue();
                bl = n2 >= 600;
            }
            this.mNavigationBarOrientation = bl ? 0 : 1;
            ResourceValue resourceValue = renderResources.getFrameworkResource(ResourceType.DIMEN, bl ? "navigation_bar_height" : "navigation_bar_width");
            if (resourceValue != null && (typedValue = ResourceHelper.getValue("navigation_bar_height", resourceValue.getValue(), true)) != null) {
                this.mNavigationBarSize = (int)typedValue.getDimension(displayMetrics);
            }
        }
    }

    private boolean getBooleanThemeValue(RenderResources renderResources, String string2, boolean bl) {
        ResourceValue resourceValue = renderResources.findItemInTheme(string2, true);
        if ((resourceValue = renderResources.resolveResValue(resourceValue)) == null || resourceValue.getValue() == null) {
            return bl;
        }
        return XmlUtils.convertValueToBoolean(resourceValue.getValue(), bl);
    }

    private void postInflateProcess(View view, IProjectCallback iProjectCallback) throws PostInflateException {
        block11: {
            block13: {
                AdapterBinding adapterBinding;
                SessionParams sessionParams;
                ResourceReference resourceReference;
                block14: {
                    block12: {
                        block10: {
                            if (!(view instanceof TabHost)) break block10;
                            this.setupTabHost((TabHost)view, iProjectCallback);
                            break block11;
                        }
                        if (!(view instanceof QuickContactBadge)) break block12;
                        QuickContactBadge quickContactBadge = (QuickContactBadge)view;
                        quickContactBadge.setImageToDefault();
                        break block11;
                    }
                    if (!(view instanceof AdapterView)) break block13;
                    int n = view.getId();
                    BridgeContext bridgeContext = this.getContext();
                    resourceReference = bridgeContext.resolveId(n);
                    if (resourceReference == null) break block11;
                    sessionParams = (SessionParams)this.getParams();
                    adapterBinding = (AdapterBinding)sessionParams.getAdapterBindings().get(resourceReference);
                    if (adapterBinding == null) {
                        adapterBinding = sessionParams.getProjectCallback().getAdapterBinding(resourceReference, bridgeContext.getViewKey(view), (Object)view);
                    }
                    if (adapterBinding == null) break block11;
                    if (!(view instanceof AbsListView)) break block14;
                    if ((adapterBinding.getFooterCount() > 0 || adapterBinding.getHeaderCount() > 0) && view instanceof ListView) {
                        Pair<View, Boolean> pair;
                        int n2;
                        ListView listView = (ListView)view;
                        boolean bl = false;
                        int n3 = adapterBinding.getHeaderCount();
                        for (n2 = 0; n2 < n3; ++n2) {
                            pair = bridgeContext.inflateView(adapterBinding.getHeaderAt(n2), listView, false, bl);
                            if (pair.getFirst() != null) {
                                listView.addHeaderView((View)pair.getFirst());
                            }
                            bl |= ((Boolean)pair.getSecond()).booleanValue();
                        }
                        n3 = adapterBinding.getFooterCount();
                        for (n2 = 0; n2 < n3; ++n2) {
                            pair = bridgeContext.inflateView(adapterBinding.getFooterAt(n2), listView, false, bl);
                            if (pair.getFirst() != null) {
                                listView.addFooterView((View)pair.getFirst());
                            }
                            bl |= ((Boolean)pair.getSecond()).booleanValue();
                        }
                    }
                    if (view instanceof ExpandableListView) {
                        ((ExpandableListView)view).setAdapter(new FakeExpandableAdapter(resourceReference, adapterBinding, sessionParams.getProjectCallback()));
                    } else {
                        ((AbsListView)view).setAdapter(new FakeAdapter(resourceReference, adapterBinding, sessionParams.getProjectCallback()));
                    }
                    break block11;
                }
                if (!(view instanceof AbsSpinner)) break block11;
                ((AbsSpinner)view).setAdapter(new FakeAdapter(resourceReference, adapterBinding, sessionParams.getProjectCallback()));
                break block11;
            }
            if (view instanceof ViewGroup) {
                ViewGroup viewGroup = (ViewGroup)view;
                int n = viewGroup.getChildCount();
                for (int i = 0; i < n; ++i) {
                    View view2 = viewGroup.getChildAt(i);
                    this.postInflateProcess(view2, iProjectCallback);
                }
            }
        }
    }

    private void setupTabHost(TabHost tabHost, IProjectCallback iProjectCallback) throws PostInflateException {
        View view = tabHost.findViewById(16908307);
        if (view == null) {
            throw new PostInflateException("TabHost requires a TabWidget with id \"android:id/tabs\".\n");
        }
        if (!(view instanceof TabWidget)) {
            throw new PostInflateException(String.format("TabHost requires a TabWidget with id \"android:id/tabs\".\nView found with id 'tabs' is '%s'", view.getClass().getCanonicalName()));
        }
        view = tabHost.findViewById(0x1020011);
        if (view == null) {
            throw new PostInflateException("TabHost requires a FrameLayout with id \"android:id/tabcontent\".");
        }
        if (!(view instanceof FrameLayout)) {
            throw new PostInflateException(String.format("TabHost requires a FrameLayout with id \"android:id/tabcontent\".\nView found with id 'tabcontent' is '%s'", view.getClass().getCanonicalName()));
        }
        FrameLayout frameLayout = (FrameLayout)view;
        int n = frameLayout.getChildCount();
        tabHost.setup();
        if (n == 0) {
            TabHost.TabSpec tabSpec = tabHost.newTabSpec("tag").setIndicator("Tab Label", tabHost.getResources().getDrawable(17301569)).setContent(new TabHost.TabContentFactory(){

                public View createTabContent(String string2) {
                    return new LinearLayout(RenderSessionImpl.this.getContext());
                }
            });
            tabHost.addTab(tabSpec);
        } else {
            for (int i = 0; i < n; ++i) {
                View view2 = frameLayout.getChildAt(i);
                String string2 = String.format("tab_spec%d", i + 1);
                int n2 = view2.getId();
                Pair pair = iProjectCallback.resolveResourceId(n2);
                String string3 = pair != null ? (String)pair.getSecond() : String.format("Tab %d", i + 1);
                tabHost.addTab(tabHost.newTabSpec(string2).setIndicator(string3).setContent(n2));
            }
        }
    }

    private ViewInfo visit(View view, int n, boolean bl, boolean bl2) {
        ViewInfo viewInfo = this.createViewInfo(view, n, bl, bl2);
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            viewInfo.setChildren(this.visitAllChildren(viewGroup, bl2 ? 0 : n, bl, bl2));
        }
        return viewInfo;
    }

    private List<ViewInfo> visitAllChildren(ViewGroup viewGroup, int n, boolean bl, boolean bl2) {
        if (viewGroup == null) {
            return null;
        }
        if (!bl2) {
            n += viewGroup.getTop();
        }
        int n2 = viewGroup.getChildCount();
        if (viewGroup == this.mContentRoot) {
            ArrayList<ViewInfo> arrayList = new ArrayList<ViewInfo>(n2);
            ArrayList<ViewInfo> arrayList2 = new ArrayList<ViewInfo>(n2);
            for (int i = 0; i < n2; ++i) {
                ViewInfo[] viewInfoArray = this.visitContentRoot(viewGroup.getChildAt(i), n, bl);
                arrayList.add(viewInfoArray[0]);
                arrayList2.add(viewInfoArray[1]);
            }
            this.mViewInfoList = arrayList2;
            return arrayList;
        }
        ArrayList<ViewInfo> arrayList = new ArrayList<ViewInfo>(n2);
        for (int i = 0; i < n2; ++i) {
            arrayList.add(this.visit(viewGroup.getChildAt(i), n, bl, bl2));
        }
        return arrayList;
    }

    private ViewInfo[] visitContentRoot(View view, int n, boolean bl) {
        ViewInfo[] viewInfoArray = new ViewInfo[2];
        if (view == null) {
            return viewInfoArray;
        }
        viewInfoArray[0] = this.createViewInfo(view, 0, bl, true);
        viewInfoArray[1] = this.createViewInfo(view, n, bl, true);
        if (view instanceof ViewGroup) {
            List<ViewInfo> list = this.visitAllChildren((ViewGroup)view, 0, bl, true);
            viewInfoArray[0].setChildren(list);
            viewInfoArray[1].setChildren(list);
        }
        return viewInfoArray;
    }

    private ViewInfo createViewInfo(View view, int n, boolean bl, boolean bl2) {
        ViewGroup.LayoutParams layoutParams;
        Object object;
        SystemViewInfo systemViewInfo;
        if (view == null) {
            return null;
        }
        if (bl2) {
            systemViewInfo = new ViewInfo(view.getClass().getName(), this.getContext().getViewKey(view), view.getLeft(), view.getTop() + n, view.getRight(), view.getBottom() + n, (Object)view, (Object)view.getLayoutParams());
        } else {
            object = new SystemViewInfo(view.getClass().getName(), this.getViewKey(view), view.getLeft(), view.getTop(), view.getRight(), view.getBottom(), view, view.getLayoutParams());
            systemViewInfo = object;
            if (view instanceof ListMenuItemView) {
                ((SystemViewInfo)((Object)object)).setViewType(ViewType.ACTION_BAR_OVERFLOW_MENU);
            } else {
                layoutParams = view.getLayoutParams();
                if (layoutParams instanceof ActionMenuView.LayoutParams && ((ActionMenuView.LayoutParams)layoutParams).isOverflowButton) {
                    ((SystemViewInfo)((Object)object)).setViewType(ViewType.ACTION_BAR_OVERFLOW);
                } else {
                    for (ViewParent viewParent = view.getParent(); viewParent != this.mViewRoot && viewParent instanceof ViewGroup; viewParent = viewParent.getParent()) {
                        if (!(viewParent instanceof ActionMenuView)) continue;
                        ((SystemViewInfo)((Object)object)).setViewType(ViewType.ACTION_BAR_MENU);
                        break;
                    }
                }
            }
        }
        if (bl) {
            object = null;
            layoutParams = view.getLayoutParams();
            if (layoutParams instanceof ViewGroup.MarginLayoutParams) {
                object = (ViewGroup.MarginLayoutParams)layoutParams;
            }
            systemViewInfo.setExtendedInfo(view.getBaseline(), object != null ? ((ViewGroup.MarginLayoutParams)object).leftMargin : 0, object != null ? ((ViewGroup.MarginLayoutParams)object).topMargin : 0, object != null ? ((ViewGroup.MarginLayoutParams)object).rightMargin : 0, object != null ? ((ViewGroup.MarginLayoutParams)object).bottomMargin : 0);
        }
        return systemViewInfo;
    }

    private Object getViewKey(View view) {
        BridgeContext bridgeContext = this.getContext();
        if (!(view instanceof MenuView.ItemView)) {
            return bridgeContext.getViewKey(view);
        }
        MenuItemImpl menuItemImpl = view instanceof ActionMenuItemView ? ((ActionMenuItemView)view).getItemData() : (view instanceof ListMenuItemView ? ((ListMenuItemView)view).getItemData() : (view instanceof IconMenuItemView ? ((IconMenuItemView)view).getItemData() : null));
        if (menuItemImpl instanceof BridgeMenuItemImpl) {
            return ((BridgeMenuItemImpl)menuItemImpl).getViewCookie();
        }
        return null;
    }

    private void invalidateRenderingSize() {
        this.mMeasuredScreenHeight = -1;
        this.mMeasuredScreenWidth = -1;
    }

    private StatusBar createStatusBar(BridgeContext bridgeContext, Density density, int n, boolean bl) throws XmlPullParserException {
        StatusBar statusBar = new StatusBar(bridgeContext, density, n, bl);
        statusBar.setLayoutParams(new LinearLayout.LayoutParams(-1, this.mStatusBarSize));
        return statusBar;
    }

    private NavigationBar createNavigationBar(BridgeContext bridgeContext, Density density, boolean bl, boolean bl2) throws XmlPullParserException {
        NavigationBar navigationBar = new NavigationBar((Context)bridgeContext, density, this.mNavigationBarOrientation, bl, bl2);
        if (this.mNavigationBarOrientation == 1) {
            navigationBar.setLayoutParams(new LinearLayout.LayoutParams(this.mNavigationBarSize, -1));
        } else {
            navigationBar.setLayoutParams(new LinearLayout.LayoutParams(-1, this.mNavigationBarSize));
        }
        return navigationBar;
    }

    private TitleBar createTitleBar(BridgeContext bridgeContext, Density density, String string2) throws XmlPullParserException {
        TitleBar titleBar = new TitleBar((Context)bridgeContext, density, string2);
        titleBar.setLayoutParams(new LinearLayout.LayoutParams(-1, this.mTitleBarSize));
        return titleBar;
    }

    private ActionBarLayout createActionBar(BridgeContext bridgeContext, SessionParams sessionParams) {
        ActionBarLayout actionBarLayout = new ActionBarLayout(bridgeContext, sessionParams);
        actionBarLayout.setLayoutParams(new LinearLayout.LayoutParams(-1, -1));
        return actionBarLayout;
    }

    public BufferedImage getImage() {
        return this.mImage;
    }

    public boolean isAlphaChannelImage() {
        return this.mIsAlphaChannelImage;
    }

    public List<ViewInfo> getViewInfos() {
        return this.mViewInfoList;
    }

    public List<ViewInfo> getSystemViewInfos() {
        return this.mSystemViewInfoList;
    }

    public Map<String, String> getDefaultProperties(Object object) {
        return this.getContext().getDefaultPropMap(object);
    }

    public void setScene(RenderSession renderSession) {
        this.mScene = renderSession;
    }

    public RenderSession getSession() {
        return this.mScene;
    }

    private static final class PostInflateException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public PostInflateException(String string2) {
            super(string2);
        }
    }
}

