/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.impl;

import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FontLoader {
    private static final String FONTS_SYSTEM = "system_fonts.xml";
    private static final String FONTS_VENDOR = "vendor_fonts.xml";
    private static final String FONTS_FALLBACK = "fallback_fonts.xml";
    private static final String NODE_FAMILYSET = "familyset";
    private static final String NODE_FAMILY = "family";
    private static final String NODE_NAME = "name";
    private static final String NODE_FILE = "file";
    private static final String ATTRIBUTE_VARIANT = "variant";
    private static final String ATTRIBUTE_VALUE_ELEGANT = "elegant";
    private static final String FONT_SUFFIX_NONE = ".ttf";
    private static final String FONT_SUFFIX_REGULAR = "-Regular.ttf";
    private static final String FONT_SUFFIX_BOLD = "-Bold.ttf";
    private static final String FONT_SUFFIX_ITALIC = "Italic.ttf";
    private static final String FONT_SUFFIX_BOLDITALIC = "-BoldItalic.ttf";
    private static final int[] AWT_STYLES = new int[]{0, 1, 2, 3};
    private static int[] DERIVE_BOLD_ITALIC = new int[]{2, 1, 0};
    private static int[] DERIVE_ITALIC = new int[]{0};
    private static int[] DERIVE_BOLD = new int[]{0};
    private static final List<FontInfo> mMainFonts = new ArrayList<FontInfo>();
    private static final List<FontInfo> mFallbackFonts = new ArrayList<FontInfo>();
    private final String mOsFontsLocation;

    public static FontLoader create(String string2) {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            FontHandler fontHandler = FontLoader.parseFontFile(sAXParserFactory, string2, FONTS_SYSTEM);
            List<FontInfo> list = fontHandler.getFontList();
            fontHandler = FontLoader.parseFontFile(sAXParserFactory, string2, FONTS_FALLBACK);
            List<FontInfo> list2 = fontHandler.getFontList();
            return new FontLoader(string2, list, list2);
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXException sAXException) {
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private static FontHandler parseFontFile(SAXParserFactory sAXParserFactory, String string2, String string3) throws ParserConfigurationException, SAXException, IOException, FileNotFoundException {
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        File file = new File(string2, string3);
        FontHandler fontHandler = new FontHandler(string2 + File.separator);
        sAXParser.parse((InputStream)new FileInputStream(file), (DefaultHandler)fontHandler);
        return fontHandler;
    }

    private FontLoader(String string2, List<FontInfo> list, List<FontInfo> list2) {
        this.mOsFontsLocation = string2;
        mMainFonts.addAll(list);
        mFallbackFonts.addAll(list2);
    }

    public String getOsFontsLocation() {
        return this.mOsFontsLocation;
    }

    public synchronized List<Font> getFont(String string2, int n) {
        ArrayList<Font> arrayList = new ArrayList<Font>();
        if (string2 == null) {
            return arrayList;
        }
        for (FontInfo fontInfo : mMainFonts) {
            if (!fontInfo.families.contains(string2)) continue;
            arrayList.add(fontInfo.font[n]);
            break;
        }
        for (FontInfo fontInfo : mFallbackFonts) {
            arrayList.add(fontInfo.font[n]);
        }
        return arrayList;
    }

    public synchronized List<Font> getFallbackFonts(int n) {
        ArrayList<Font> arrayList = new ArrayList<Font>();
        for (FontInfo fontInfo : mFallbackFonts) {
            arrayList.add(fontInfo.font[n]);
        }
        return arrayList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FontHandler
    extends DefaultHandler {
        private final String mOsFontsLocation;
        private FontInfo mFontInfo = null;
        private final StringBuilder mBuilder = new StringBuilder();
        private List<FontInfo> mFontList = new ArrayList<FontInfo>();
        private boolean isCompactFont = true;

        private FontHandler(String string2) {
            this.mOsFontsLocation = string2;
        }

        public List<FontInfo> getFontList() {
            return this.mFontList;
        }

        @Override
        public void startElement(String string2, String string3, String string4, Attributes attributes) throws SAXException {
            if (FontLoader.NODE_FAMILYSET.equals(string3)) {
                this.mFontList = new ArrayList<FontInfo>();
            } else if (FontLoader.NODE_FAMILY.equals(string3)) {
                if (this.mFontList != null) {
                    this.mFontInfo = null;
                }
            } else if (FontLoader.NODE_NAME.equals(string3)) {
                if (this.mFontList != null && this.mFontInfo == null) {
                    this.mFontInfo = new FontInfo();
                }
            } else if (FontLoader.NODE_FILE.equals(string3)) {
                if (this.mFontList != null && this.mFontInfo == null) {
                    this.mFontInfo = new FontInfo();
                }
                this.isCompactFont = !FontLoader.ATTRIBUTE_VALUE_ELEGANT.equals(attributes.getValue(FontLoader.ATTRIBUTE_VARIANT));
            }
            this.mBuilder.setLength(0);
            super.startElement(string2, string3, string4, attributes);
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.isCompactFont) {
                this.mBuilder.append(cArray, n, n2);
            }
        }

        @Override
        public void endElement(String string2, String string3, String string4) throws SAXException {
            String string5;
            Font font;
            if (FontLoader.NODE_FAMILY.equals(string3)) {
                if (this.mFontInfo != null) {
                    if (this.mFontInfo.font[0] != null) {
                        this.mFontList.add(this.mFontInfo);
                        if (this.mFontInfo.font[3] == null) {
                            this.computeDerivedFont(3, DERIVE_BOLD_ITALIC);
                        }
                        if (this.mFontInfo.font[2] == null) {
                            this.computeDerivedFont(2, DERIVE_ITALIC);
                        }
                        if (this.mFontInfo.font[1] == null) {
                            this.computeDerivedFont(1, DERIVE_BOLD);
                        }
                    }
                    this.mFontInfo = null;
                }
            } else if (FontLoader.NODE_NAME.equals(string3)) {
                if (this.mFontInfo != null) {
                    String string6 = this.trimXmlWhitespaces(this.mBuilder.toString());
                    this.mFontInfo.families.add(string6);
                }
            } else if (FontLoader.NODE_FILE.equals(string3) && this.isCompactFont && this.mFontInfo != null && (font = this.getFont(string5 = this.trimXmlWhitespaces(this.mBuilder.toString()))) != null) {
                if (string5.endsWith(FontLoader.FONT_SUFFIX_REGULAR)) {
                    this.mFontInfo.font[0] = font;
                } else if (string5.endsWith(FontLoader.FONT_SUFFIX_BOLD)) {
                    this.mFontInfo.font[1] = font;
                } else if (string5.endsWith(FontLoader.FONT_SUFFIX_BOLDITALIC)) {
                    this.mFontInfo.font[3] = font;
                } else if (string5.endsWith(FontLoader.FONT_SUFFIX_ITALIC)) {
                    this.mFontInfo.font[2] = font;
                } else if (string5.endsWith(FontLoader.FONT_SUFFIX_NONE)) {
                    this.mFontInfo.font[0] = font;
                }
            }
        }

        private Font getFont(String string2) {
            try {
                File file = new File(this.mOsFontsLocation, string2);
                if (file.exists()) {
                    return Font.createFont(0, file);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        private void computeDerivedFont(int n, int[] nArray) {
            for (int n2 : nArray) {
                if (this.mFontInfo.font[n2] == null) continue;
                this.mFontInfo.font[n] = this.mFontInfo.font[n2].deriveFont(AWT_STYLES[n]);
                return;
            }
            assert (false);
        }

        private String trimXmlWhitespaces(String string2) {
            int n;
            int n2;
            int n3;
            if (string2 == null) {
                return null;
            }
            while ((n3 = string2.indexOf(10)) != -1) {
                int n4;
                for (n2 = n3 - 1; n2 >= 0 && Character.isWhitespace(string2.charAt(n2)); --n2) {
                }
                n = string2.length();
                for (n4 = n3 + 1; n4 < n && Character.isWhitespace(string2.charAt(n4)); ++n4) {
                }
                String string3 = null;
                if (n2 >= 0) {
                    string3 = string2.substring(0, n2 + 1);
                }
                String string4 = null;
                if (n4 < n) {
                    string4 = string2.substring(n4);
                }
                if (string3 != null) {
                    string2 = string3;
                    if (string4 == null) continue;
                    string2 = string2 + " " + string4;
                    continue;
                }
                string2 = string4 != null ? string4 : "";
            }
            n2 = string2.length();
            char[] cArray = string2.toCharArray();
            for (n = 0; n < n2; ++n) {
                if (cArray[n] != '\\') continue;
                if (cArray[n + 1] == 'n') {
                    cArray[n + 1] = 10;
                }
                System.arraycopy(cArray, n + 1, cArray, n, n2 - n - 1);
                --n2;
            }
            return new String(cArray, 0, n2);
        }
    }

    private static final class FontInfo {
        final Font[] font = new Font[4];
        final Set<String> families = new HashSet<String>();

        FontInfo() {
        }
    }
}

