/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.impl;

import com.android.layoutlib.bridge.util.SparseWeakArray;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DelegateManager<T> {
    private final Class<T> mClass;
    private final SparseWeakArray<T> mDelegates = new SparseWeakArray();
    private final List<T> mJavaReferences = new ArrayList<T>();
    private int mDelegateCounter = 0;

    public DelegateManager(Class<T> clazz) {
        this.mClass = clazz;
    }

    public T getDelegate(long l) {
        if (l > 0L) {
            T t = this.mDelegates.get(l);
            assert (t != null);
            return t;
        }
        return null;
    }

    public long addNewDelegate(T t) {
        long l = ++this.mDelegateCounter;
        this.mDelegates.put(l, t);
        assert (!this.mJavaReferences.contains(t));
        this.mJavaReferences.add(t);
        return l;
    }

    public void removeJavaReferenceFor(long l) {
        T t = this.getDelegate(l);
        this.mJavaReferences.remove(t);
    }
}

