/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.bars;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.view.menu.MenuBuilderAccessor;
import com.android.internal.view.menu.MenuItemImpl;
import com.android.internal.view.menu.MenuView;
import java.util.ArrayList;

public class OverflowMenuAdapter
extends BaseAdapter {
    private final MenuBuilder mMenu;
    private int mExpandedIndex = -1;
    private final Context context;

    public OverflowMenuAdapter(MenuBuilder menuBuilder, Context context) {
        this.mMenu = menuBuilder;
        this.findExpandedIndex();
        this.context = context;
    }

    public int getCount() {
        ArrayList<MenuItemImpl> arrayList = MenuBuilderAccessor.getNonActionItems(this.mMenu);
        if (this.mExpandedIndex < 0) {
            return arrayList.size();
        }
        return arrayList.size() - 1;
    }

    public MenuItemImpl getItem(int n) {
        ArrayList<MenuItemImpl> arrayList = MenuBuilderAccessor.getNonActionItems(this.mMenu);
        if (this.mExpandedIndex >= 0 && n >= this.mExpandedIndex) {
            ++n;
        }
        return arrayList.get(n);
    }

    public long getItemId(int n) {
        return n;
    }

    public View getView(int n, View view, ViewGroup viewGroup) {
        Object object;
        if (view == null) {
            object = LayoutInflater.from(this.context);
            view = ((LayoutInflater)object).inflate(17367154, viewGroup, false);
        }
        object = (MenuView.ItemView)((Object)view);
        object.initialize(this.getItem(n), 0);
        return view;
    }

    private void findExpandedIndex() {
        MenuItemImpl menuItemImpl = this.mMenu.getExpandedItem();
        if (menuItemImpl != null) {
            ArrayList<MenuItemImpl> arrayList = MenuBuilderAccessor.getNonActionItems(this.mMenu);
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                MenuItemImpl menuItemImpl2 = arrayList.get(i);
                if (menuItemImpl2 != menuItemImpl) continue;
                this.mExpandedIndex = i;
                return;
            }
        }
    }
}

