/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.bars;

import android.app.ActionBar;
import android.app.FragmentTransaction;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.MenuInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.RelativeLayout;
import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.rendering.api.ActionBarCallback;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.SessionParams;
import com.android.internal.R;
import com.android.internal.app.ActionBarImpl;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.view.menu.MenuBuilderAccessor;
import com.android.internal.view.menu.MenuItemImpl;
import com.android.internal.widget.ActionBarAccessor;
import com.android.internal.widget.ActionBarContainer;
import com.android.internal.widget.ActionBarView;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.bars.OverflowMenuAdapter;
import com.android.layoutlib.bridge.impl.ResourceHelper;
import com.android.resources.ResourceType;
import java.util.ArrayList;

public class ActionBarLayout
extends LinearLayout {
    @NonNull
    private final BridgeContext mBridgeContext;
    @NonNull
    private final Context mThemedContext;
    @NonNull
    private final ActionBar mActionBar;
    @Nullable
    private final String mIcon;
    @Nullable
    private final String mTitle;
    @Nullable
    private final String mSubTitle;
    private final boolean mSplit;
    private final boolean mShowHomeAsUp;
    private final int mNavMode;
    @NonNull
    private final MenuBuilder mMenuBuilder;
    private final int mPopupMaxWidth;
    @NonNull
    private final RenderResources res;
    @Nullable
    private final ActionBarView mActionBarView;
    @Nullable
    private FrameLayout mContentRoot;
    @NonNull
    private final ActionBarCallback mCallback;
    @Nullable
    private ViewGroup mMeasureParent;

    public ActionBarLayout(@NonNull BridgeContext bridgeContext, @NonNull SessionParams sessionParams) {
        super(bridgeContext);
        this.setOrientation(0);
        this.setGravity(16);
        LayoutInflater.from(bridgeContext).inflate(17367183, (ViewGroup)this, true);
        this.mActionBar = new ActionBarImpl(this);
        this.mBridgeContext = bridgeContext;
        this.mThemedContext = this.mActionBar.getThemedContext();
        this.mCallback = sessionParams.getProjectCallback().getActionBarCallback();
        this.mIcon = sessionParams.getAppIcon();
        this.mTitle = sessionParams.getAppLabel();
        this.mSplit = bridgeContext.getResources().getBoolean(0x1110006) && this.mCallback.getSplitActionBarWhenNarrow();
        this.mNavMode = this.mCallback.getNavigationMode();
        this.mShowHomeAsUp = this.mCallback.getHomeButtonStyle() == ActionBarCallback.HomeButtonStyle.SHOW_HOME_AS_UP;
        this.mSubTitle = this.mCallback.getSubTitle();
        this.mMenuBuilder = new MenuBuilder(this.mThemedContext);
        this.res = this.mBridgeContext.getRenderResources();
        this.mPopupMaxWidth = Math.max(this.mBridgeContext.getMetrics().widthPixels / 2, this.mThemedContext.getResources().getDimensionPixelSize(17104903));
        this.mActionBarView = (ActionBarView)this.findViewById(16909079);
        this.mContentRoot = (FrameLayout)this.findViewById(0x1020002);
        this.setupActionBar();
    }

    private void setupActionBar() {
        ResourceValue resourceValue = this.res.findResValue(this.mTitle, false);
        if (resourceValue != null && resourceValue.getValue() != null) {
            this.mActionBar.setTitle(resourceValue.getValue());
        } else {
            this.mActionBar.setTitle(this.mTitle);
        }
        if (this.mSubTitle != null) {
            this.mActionBar.setSubtitle(this.mSubTitle);
        }
        if (this.mShowHomeAsUp) {
            this.mActionBar.setDisplayOptions(255, 4);
        }
        this.mActionBar.setNavigationMode(this.mNavMode);
        if (this.mNavMode == 2) {
            this.setupTabs(3);
        }
        if (this.mActionBarView != null) {
            Object object;
            if (!this.mActionBarView.hasIcon() && this.mIcon != null && (object = this.getDrawable(this.mIcon, false)) != null) {
                this.mActionBar.setIcon((Drawable)object);
            }
            object = (ActionBarContainer)this.findViewById(16909081);
            this.mActionBarView.setSplitView((ActionBarContainer)object);
            this.mActionBarView.setSplitActionBar(this.mSplit);
            this.inflateMenus();
        }
    }

    private void inflateMenus() {
        if (this.mActionBarView == null) {
            return;
        }
        MenuInflater menuInflater = new MenuInflater(this.mThemedContext);
        for (String string2 : this.mCallback.getMenuIdNames()) {
            int n;
            if (this.mBridgeContext.getRenderResources().getProjectResource(ResourceType.MENU, string2) == null || (n = this.mBridgeContext.getProjectResourceValue(ResourceType.MENU, string2, -1)) <= -1) continue;
            menuInflater.inflate(n, this.mMenuBuilder);
        }
        this.mActionBarView.setMenu(this.mMenuBuilder, null);
    }

    private void setupTabs(int n) {
        for (int i = 1; i <= n; ++i) {
            ActionBar.Tab tab = this.mActionBar.newTab().setText("Tab" + i).setTabListener(new ActionBar.TabListener(){

                public void onTabUnselected(ActionBar.Tab tab, FragmentTransaction fragmentTransaction) {
                }

                public void onTabSelected(ActionBar.Tab tab, FragmentTransaction fragmentTransaction) {
                }

                public void onTabReselected(ActionBar.Tab tab, FragmentTransaction fragmentTransaction) {
                }
            });
            this.mActionBar.addTab(tab);
        }
    }

    @Nullable
    private Drawable getDrawable(@NonNull String string2, boolean bl) {
        ResourceValue resourceValue = this.res.findResValue(string2, bl);
        if ((resourceValue = this.res.resolveResValue(resourceValue)) != null) {
            return ResourceHelper.getDrawable(resourceValue, this.mBridgeContext);
        }
        return null;
    }

    public void createMenuPopup() {
        assert (this.mContentRoot != null && this.findViewById(0x1020002) == this.mContentRoot) : "Action Bar Menus have already been created.";
        if (!this.isOverflowPopupNeeded()) {
            return;
        }
        RelativeLayout relativeLayout = new RelativeLayout(this.mThemedContext);
        relativeLayout.setLayoutParams(new LinearLayout.LayoutParams(-1, -1));
        this.mContentRoot.addView(relativeLayout);
        FrameLayout frameLayout = new FrameLayout(this.mBridgeContext);
        frameLayout.setLayoutParams(new LinearLayout.LayoutParams(-1, -1));
        relativeLayout.addView(frameLayout);
        relativeLayout.addView(this.createMenuView());
        this.mContentRoot = frameLayout;
    }

    @NonNull
    private View createMenuView() {
        DisplayMetrics displayMetrics = this.mBridgeContext.getMetrics();
        OverflowMenuAdapter overflowMenuAdapter = new OverflowMenuAdapter(this.mMenuBuilder, this.mThemedContext);
        LinearLayout linearLayout = new LinearLayout(this.mThemedContext);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(this.measureContentWidth(overflowMenuAdapter), -2);
        layoutParams.addRule(21);
        if (this.mSplit) {
            layoutParams.addRule(12);
            layoutParams.bottomMargin = this.getPixelValue("-10dp", displayMetrics);
        } else {
            layoutParams.topMargin = this.getPixelValue("-10dp", displayMetrics);
        }
        linearLayout.setLayoutParams(layoutParams);
        TypedArray typedArray = this.mThemedContext.obtainStyledAttributes(null, R.styleable.PopupWindow, 0x1010300, 0);
        linearLayout.setBackground(typedArray.getDrawable(0));
        linearLayout.setDividerDrawable(typedArray.getDrawable(16843675));
        typedArray.recycle();
        linearLayout.setOrientation(1);
        linearLayout.setDividerPadding(this.getPixelValue("12dp", displayMetrics));
        linearLayout.setShowDividers(2);
        ListView listView = new ListView(this.mThemedContext, null, 16842861);
        listView.setAdapter(overflowMenuAdapter);
        linearLayout.addView(listView);
        return linearLayout;
    }

    private boolean isOverflowPopupNeeded() {
        boolean bl = this.mCallback.isOverflowPopupNeeded();
        if (!bl) {
            return false;
        }
        ArrayList<MenuItemImpl> arrayList = MenuBuilderAccessor.getNonActionItems(this.mMenuBuilder);
        if (ActionBarAccessor.getActionMenuPresenter(this.mActionBarView).isOverflowReserved() && arrayList != null) {
            int n = arrayList.size();
            bl = n == 1 ? !arrayList.get(0).isActionViewExpanded() : n > 0;
        }
        return bl;
    }

    @Nullable
    public FrameLayout getContentRoot() {
        return this.mContentRoot;
    }

    private int measureContentWidth(@NonNull ListAdapter listAdapter) {
        int n = 0;
        View view = null;
        int n2 = 0;
        int n3 = View.MeasureSpec.makeMeasureSpec(0, 0);
        int n4 = View.MeasureSpec.makeMeasureSpec(0, 0);
        int n5 = listAdapter.getCount();
        for (int i = 0; i < n5; ++i) {
            int n6 = listAdapter.getItemViewType(i);
            if (n6 != n2) {
                n2 = n6;
                view = null;
            }
            if (this.mMeasureParent == null) {
                this.mMeasureParent = new FrameLayout(this.mThemedContext);
            }
            view = listAdapter.getView(i, view, this.mMeasureParent);
            view.measure(n3, n4);
            int n7 = view.getMeasuredWidth();
            if (n7 >= this.mPopupMaxWidth) {
                return this.mPopupMaxWidth;
            }
            if (n7 <= n) continue;
            n = n7;
        }
        return n;
    }

    private int getPixelValue(@NonNull String string2, @NonNull DisplayMetrics displayMetrics) {
        TypedValue typedValue = ResourceHelper.getValue(null, string2, false);
        return (int)typedValue.getDimension(displayMetrics);
    }
}

