/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge;

import android.view.View;
import android.view.ViewGroup;
import com.android.ide.common.rendering.api.IAnimationListener;
import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.ide.common.rendering.api.RenderSession;
import com.android.ide.common.rendering.api.Result;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.impl.RenderSessionImpl;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BridgeRenderSession
extends RenderSession {
    private final RenderSessionImpl mSession;
    private Result mLastResult;

    public Result getResult() {
        return this.mLastResult;
    }

    public BufferedImage getImage() {
        return this.mSession.getImage();
    }

    public boolean isAlphaChannelImage() {
        return this.mSession.isAlphaChannelImage();
    }

    public List<ViewInfo> getRootViews() {
        return this.mSession.getViewInfos();
    }

    public List<ViewInfo> getSystemRootViews() {
        return this.mSession.getSystemViewInfos();
    }

    public Map<String, String> getDefaultProperties(Object object) {
        return this.mSession.getDefaultProperties(object);
    }

    public Result getProperty(Object object, String string2) {
        return super.getProperty(object, string2);
    }

    public Result setProperty(Object object, String string2, String string3) {
        return super.setProperty(object, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result render(long l) {
        try {
            Bridge.prepareThread();
            this.mLastResult = this.mSession.acquire(l);
            if (this.mLastResult.isSuccess()) {
                this.mLastResult = this.mSession.render(false);
            }
        }
        finally {
            this.mSession.release();
            Bridge.cleanupThread();
        }
        return this.mLastResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result animate(Object object, String string2, boolean bl, IAnimationListener iAnimationListener) {
        try {
            Bridge.prepareThread();
            this.mLastResult = this.mSession.acquire(250L);
            if (this.mLastResult.isSuccess()) {
                this.mLastResult = this.mSession.animate(object, string2, bl, iAnimationListener);
            }
        }
        finally {
            this.mSession.release();
            Bridge.cleanupThread();
        }
        return this.mLastResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result insertChild(Object object, ILayoutPullParser iLayoutPullParser, int n, IAnimationListener iAnimationListener) {
        if (!(object instanceof ViewGroup)) {
            throw new IllegalArgumentException("parentView is not a ViewGroup");
        }
        try {
            Bridge.prepareThread();
            this.mLastResult = this.mSession.acquire(250L);
            if (this.mLastResult.isSuccess()) {
                this.mLastResult = this.mSession.insertChild((ViewGroup)object, iLayoutPullParser, n, iAnimationListener);
            }
        }
        finally {
            this.mSession.release();
            Bridge.cleanupThread();
        }
        return this.mLastResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result moveChild(Object object, Object object2, int n, Map<String, String> map, IAnimationListener iAnimationListener) {
        if (!(object instanceof ViewGroup)) {
            throw new IllegalArgumentException("parentView is not a ViewGroup");
        }
        if (!(object2 instanceof View)) {
            throw new IllegalArgumentException("childView is not a View");
        }
        try {
            Bridge.prepareThread();
            this.mLastResult = this.mSession.acquire(250L);
            if (this.mLastResult.isSuccess()) {
                this.mLastResult = this.mSession.moveChild((ViewGroup)object, (View)object2, n, map, iAnimationListener);
            }
        }
        finally {
            this.mSession.release();
            Bridge.cleanupThread();
        }
        return this.mLastResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result removeChild(Object object, IAnimationListener iAnimationListener) {
        if (!(object instanceof View)) {
            throw new IllegalArgumentException("childView is not a View");
        }
        try {
            Bridge.prepareThread();
            this.mLastResult = this.mSession.acquire(250L);
            if (this.mLastResult.isSuccess()) {
                this.mLastResult = this.mSession.removeChild((View)object, iAnimationListener);
            }
        }
        finally {
            this.mSession.release();
            Bridge.cleanupThread();
        }
        return this.mLastResult;
    }

    public void dispose() {
    }

    BridgeRenderSession(RenderSessionImpl renderSessionImpl, Result result) {
        this.mSession = renderSessionImpl;
        if (renderSessionImpl != null) {
            this.mSession.setScene(this);
        }
        this.mLastResult = result;
    }
}

