/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.os.FileUtils;
import com.android.internal.util.Preconditions;
import com.android.tools.layoutlib.java.AutoCloseable;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import libcore.io.IoUtils;
import libcore.io.Streams;

public class FileRotator {
    private static final String TAG = "FileRotator";
    private static final boolean LOGD = false;
    private final File mBasePath;
    private final String mPrefix;
    private final long mRotateAgeMillis;
    private final long mDeleteAgeMillis;
    private static final String SUFFIX_BACKUP = ".backup";
    private static final String SUFFIX_NO_BACKUP = ".no_backup";

    public FileRotator(File basePath, String prefix, long rotateAgeMillis, long deleteAgeMillis) {
        this.mBasePath = Preconditions.checkNotNull(basePath);
        this.mPrefix = Preconditions.checkNotNull(prefix);
        this.mRotateAgeMillis = rotateAgeMillis;
        this.mDeleteAgeMillis = deleteAgeMillis;
        this.mBasePath.mkdirs();
        for (String name : this.mBasePath.list()) {
            File file;
            if (!name.startsWith(this.mPrefix)) continue;
            if (name.endsWith(SUFFIX_BACKUP)) {
                File backupFile = new File(this.mBasePath, name);
                file = new File(this.mBasePath, name.substring(0, name.length() - SUFFIX_BACKUP.length()));
                backupFile.renameTo(file);
                continue;
            }
            if (!name.endsWith(SUFFIX_NO_BACKUP)) continue;
            File noBackupFile = new File(this.mBasePath, name);
            file = new File(this.mBasePath, name.substring(0, name.length() - SUFFIX_NO_BACKUP.length()));
            noBackupFile.delete();
            file.delete();
        }
    }

    public void deleteAll() {
        FileInfo info = new FileInfo(this.mPrefix);
        for (String name : this.mBasePath.list()) {
            if (!info.parse(name)) continue;
            new File(this.mBasePath, name).delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpAll(OutputStream os) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(os);
        try {
            FileInfo info = new FileInfo(this.mPrefix);
            for (String name : this.mBasePath.list()) {
                if (!info.parse(name)) continue;
                ZipEntry entry = new ZipEntry(name);
                zos.putNextEntry(entry);
                File file = new File(this.mBasePath, name);
                FileInputStream is = new FileInputStream(file);
                try {
                    Streams.copy(is, zos);
                }
                finally {
                    IoUtils.closeQuietly((AutoCloseable)((Object)is));
                }
                zos.closeEntry();
            }
        }
        finally {
            IoUtils.closeQuietly((AutoCloseable)((Object)zos));
        }
    }

    public void rewriteActive(Rewriter rewriter, long currentTimeMillis) throws IOException {
        String activeName = this.getActiveName(currentTimeMillis);
        this.rewriteSingle(rewriter, activeName);
    }

    @Deprecated
    public void combineActive(final Reader reader, final Writer writer, long currentTimeMillis) throws IOException {
        this.rewriteActive(new Rewriter(){

            public void reset() {
            }

            public void read(InputStream in) throws IOException {
                reader.read(in);
            }

            public boolean shouldWrite() {
                return true;
            }

            public void write(OutputStream out) throws IOException {
                writer.write(out);
            }
        }, currentTimeMillis);
    }

    public void rewriteAll(Rewriter rewriter) throws IOException {
        FileInfo info = new FileInfo(this.mPrefix);
        for (String name : this.mBasePath.list()) {
            if (!info.parse(name)) continue;
            this.rewriteSingle(rewriter, name);
        }
    }

    private void rewriteSingle(Rewriter rewriter, String name) throws IOException {
        File file = new File(this.mBasePath, name);
        rewriter.reset();
        if (file.exists()) {
            FileRotator.readFile(file, rewriter);
            if (!rewriter.shouldWrite()) {
                return;
            }
            File backupFile = new File(this.mBasePath, name + SUFFIX_BACKUP);
            file.renameTo(backupFile);
            try {
                FileRotator.writeFile(file, rewriter);
                backupFile.delete();
            }
            catch (Throwable t) {
                file.delete();
                backupFile.renameTo(file);
                throw FileRotator.rethrowAsIoException(t);
            }
        }
        File backupFile = new File(this.mBasePath, name + SUFFIX_NO_BACKUP);
        backupFile.createNewFile();
        try {
            FileRotator.writeFile(file, rewriter);
            backupFile.delete();
        }
        catch (Throwable t) {
            file.delete();
            backupFile.delete();
            throw FileRotator.rethrowAsIoException(t);
        }
    }

    public void readMatching(Reader reader, long matchStartMillis, long matchEndMillis) throws IOException {
        FileInfo info = new FileInfo(this.mPrefix);
        for (String name : this.mBasePath.list()) {
            if (!info.parse(name) || info.startMillis > matchEndMillis || matchStartMillis > info.endMillis) continue;
            File file = new File(this.mBasePath, name);
            FileRotator.readFile(file, reader);
        }
    }

    private String getActiveName(long currentTimeMillis) {
        String oldestActiveName = null;
        long oldestActiveStart = Long.MAX_VALUE;
        FileInfo info = new FileInfo(this.mPrefix);
        for (String name : this.mBasePath.list()) {
            if (!info.parse(name) || !info.isActive() || info.startMillis >= currentTimeMillis || info.startMillis >= oldestActiveStart) continue;
            oldestActiveName = name;
            oldestActiveStart = info.startMillis;
        }
        if (oldestActiveName != null) {
            return oldestActiveName;
        }
        info.startMillis = currentTimeMillis;
        info.endMillis = Long.MAX_VALUE;
        return info.build();
    }

    public void maybeRotate(long currentTimeMillis) {
        long rotateBefore = currentTimeMillis - this.mRotateAgeMillis;
        long deleteBefore = currentTimeMillis - this.mDeleteAgeMillis;
        FileInfo info = new FileInfo(this.mPrefix);
        for (String name : this.mBasePath.list()) {
            File file;
            if (!info.parse(name)) continue;
            if (info.isActive()) {
                if (info.startMillis > rotateBefore) continue;
                info.endMillis = currentTimeMillis;
                file = new File(this.mBasePath, name);
                File destFile = new File(this.mBasePath, info.build());
                file.renameTo(destFile);
                continue;
            }
            if (info.endMillis > deleteBefore) continue;
            file = new File(this.mBasePath, name);
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readFile(File file, Reader reader) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        BufferedInputStream bis = new BufferedInputStream(fis);
        try {
            reader.read(bis);
        }
        finally {
            IoUtils.closeQuietly((AutoCloseable)((Object)bis));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeFile(File file, Writer writer) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        try {
            writer.write(bos);
            bos.flush();
        }
        finally {
            FileUtils.sync(fos);
            IoUtils.closeQuietly((AutoCloseable)((Object)bos));
        }
    }

    private static IOException rethrowAsIoException(Throwable t) throws IOException {
        if (t instanceof IOException) {
            throw (IOException)t;
        }
        throw new IOException(t.getMessage(), t);
    }

    private static class FileInfo {
        public final String prefix;
        public long startMillis;
        public long endMillis;

        public FileInfo(String prefix) {
            this.prefix = Preconditions.checkNotNull(prefix);
        }

        public boolean parse(String name) {
            this.endMillis = -1L;
            this.startMillis = -1L;
            int dotIndex = name.lastIndexOf(46);
            int dashIndex = name.lastIndexOf(45);
            if (dotIndex == -1 || dashIndex == -1) {
                return false;
            }
            if (!this.prefix.equals(name.substring(0, dotIndex))) {
                return false;
            }
            try {
                this.startMillis = Long.parseLong(name.substring(dotIndex + 1, dashIndex));
                this.endMillis = name.length() - dashIndex == 1 ? Long.MAX_VALUE : Long.parseLong(name.substring(dashIndex + 1));
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }

        public String build() {
            StringBuilder name = new StringBuilder();
            name.append(this.prefix).append('.').append(this.startMillis).append('-');
            if (this.endMillis != Long.MAX_VALUE) {
                name.append(this.endMillis);
            }
            return name.toString();
        }

        public boolean isActive() {
            return this.endMillis == Long.MAX_VALUE;
        }
    }

    public static interface Rewriter
    extends Reader,
    Writer {
        public void reset();

        public boolean shouldWrite();
    }

    public static interface Writer {
        public void write(OutputStream var1) throws IOException;
    }

    public static interface Reader {
        public void read(InputStream var1) throws IOException;
    }
}

