/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.SystemClock;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class TransferPipe
implements Runnable {
    static final String TAG = "TransferPipe";
    static final boolean DEBUG = false;
    static final long DEFAULT_TIMEOUT = 5000L;
    final Thread mThread = new Thread((Runnable)this, "TransferPipe");
    final ParcelFileDescriptor[] mFds = ParcelFileDescriptor.createPipe();
    FileDescriptor mOutFd;
    long mEndTime;
    String mFailure;
    boolean mComplete;
    String mBufferPrefix;

    ParcelFileDescriptor getReadFd() {
        return this.mFds[0];
    }

    public ParcelFileDescriptor getWriteFd() {
        return this.mFds[1];
    }

    public void setBufferPrefix(String prefix) {
        this.mBufferPrefix = prefix;
    }

    static void go(Caller caller, IInterface iface, FileDescriptor out, String prefix, String[] args) throws IOException, RemoteException {
        TransferPipe.go(caller, iface, out, prefix, args, 5000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void go(Caller caller, IInterface iface, FileDescriptor out, String prefix, String[] args, long timeout) throws IOException, RemoteException {
        if (iface.asBinder() instanceof Binder) {
            try {
                caller.go(iface, out, prefix, args);
            }
            catch (RemoteException e) {
                // empty catch block
            }
            return;
        }
        TransferPipe tp = new TransferPipe();
        try {
            caller.go(iface, tp.getWriteFd().getFileDescriptor(), prefix, args);
            tp.go(out, timeout);
        }
        finally {
            tp.kill();
        }
    }

    static void goDump(IBinder binder, FileDescriptor out, String[] args) throws IOException, RemoteException {
        TransferPipe.goDump(binder, out, args, 5000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void goDump(IBinder binder, FileDescriptor out, String[] args, long timeout) throws IOException, RemoteException {
        if (binder instanceof Binder) {
            try {
                binder.dump(out, args);
            }
            catch (RemoteException e) {
                // empty catch block
            }
            return;
        }
        TransferPipe tp = new TransferPipe();
        try {
            binder.dumpAsync(tp.getWriteFd().getFileDescriptor(), args);
            tp.go(out, timeout);
        }
        finally {
            tp.kill();
        }
    }

    public void go(FileDescriptor out) throws IOException {
        this.go(out, 5000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void go(FileDescriptor out, long timeout) throws IOException {
        try {
            TransferPipe transferPipe = this;
            synchronized (transferPipe) {
                this.mOutFd = out;
                this.mEndTime = SystemClock.uptimeMillis() + timeout;
                this.closeFd(1);
                this.mThread.start();
                while (this.mFailure == null && !this.mComplete) {
                    long waitTime = this.mEndTime - SystemClock.uptimeMillis();
                    if (waitTime <= 0L) {
                        this.mThread.interrupt();
                        throw new IOException("Timeout");
                    }
                    try {
                        this.wait(waitTime);
                    }
                    catch (InterruptedException e) {}
                }
                if (this.mFailure != null) {
                    throw new IOException(this.mFailure);
                }
            }
        }
        finally {
            this.kill();
        }
    }

    void closeFd(int num) {
        if (this.mFds[num] != null) {
            try {
                this.mFds[num].close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.mFds[num] = null;
        }
    }

    public void kill() {
        this.closeFd(0);
        this.closeFd(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        byte[] buffer = new byte[1024];
        FileInputStream fis = new FileInputStream(this.getReadFd().getFileDescriptor());
        FileOutputStream fos = new FileOutputStream(this.mOutFd);
        byte[] bufferPrefix = null;
        boolean needPrefix = true;
        if (this.mBufferPrefix != null) {
            bufferPrefix = this.mBufferPrefix.getBytes();
        }
        try {
            int size;
            while ((size = fis.read(buffer)) > 0) {
                if (bufferPrefix == null) {
                    fos.write(buffer, 0, size);
                    continue;
                }
                int start = 0;
                for (int i = 0; i < size; ++i) {
                    if (buffer[i] == 10) continue;
                    if (i > start) {
                        fos.write(buffer, start, i - start);
                    }
                    start = i;
                    if (needPrefix) {
                        fos.write(bufferPrefix);
                        needPrefix = false;
                    }
                    while (++i < size && buffer[i] != 10) {
                    }
                    if (i >= size) continue;
                    needPrefix = true;
                }
                if (size <= start) continue;
                fos.write(buffer, start, size - start);
            }
            if (!this.mThread.isInterrupted()) {
                // empty if block
            }
        }
        catch (IOException e) {
            TransferPipe transferPipe = this;
            synchronized (transferPipe) {
                this.mFailure = e.toString();
                this.notifyAll();
                return;
            }
        }
        TransferPipe transferPipe = this;
        synchronized (transferPipe) {
            this.mComplete = true;
            this.notifyAll();
            return;
        }
    }

    static interface Caller {
        public void go(IInterface var1, FileDescriptor var2, String var3, String[] var4) throws RemoteException;
    }
}

