/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.format.DateFormat;
import android.text.format.DateUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.NumberPicker;
import android.widget.TextView;
import com.android.internal.R;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Locale;

public class TimePicker
extends FrameLayout {
    private static final boolean DEFAULT_ENABLED_STATE = true;
    private static final int HOURS_IN_HALF_DAY = 12;
    private static final OnTimeChangedListener NO_OP_CHANGE_LISTENER = new OnTimeChangedListener(){

        public void onTimeChanged(TimePicker view, int hourOfDay, int minute) {
        }
    };
    private boolean mIs24HourView;
    private boolean mIsAm;
    private final NumberPicker mHourSpinner;
    private final NumberPicker mMinuteSpinner;
    private final NumberPicker mAmPmSpinner;
    private final EditText mHourSpinnerInput;
    private final EditText mMinuteSpinnerInput;
    private final EditText mAmPmSpinnerInput;
    private final TextView mDivider;
    private final Button mAmPmButton;
    private final String[] mAmPmStrings;
    private boolean mIsEnabled = true;
    private OnTimeChangedListener mOnTimeChangedListener;
    private Calendar mTempCalendar;
    private Locale mCurrentLocale;
    private boolean mHourWithTwoDigit;
    private char mHourFormat;

    public TimePicker(Context context) {
        this(context, null);
    }

    public TimePicker(Context context, AttributeSet attrs) {
        this(context, attrs, 16843782);
    }

    public TimePicker(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setCurrentLocale(Locale.getDefault());
        TypedArray attributesArray = context.obtainStyledAttributes(attrs, R.styleable.TimePicker, defStyle, 0);
        int layoutResourceId = attributesArray.getResourceId(0, 17367221);
        attributesArray.recycle();
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        inflater.inflate(layoutResourceId, (ViewGroup)this, true);
        this.mHourSpinner = (NumberPicker)this.findViewById(16909132);
        this.mHourSpinner.setOnValueChangedListener(new NumberPicker.OnValueChangeListener(){

            public void onValueChange(NumberPicker spinner, int oldVal, int newVal) {
                TimePicker.this.updateInputState();
                if (!TimePicker.this.is24HourView() && (oldVal == 11 && newVal == 12 || oldVal == 12 && newVal == 11)) {
                    TimePicker.this.mIsAm = !TimePicker.this.mIsAm;
                    TimePicker.this.updateAmPmControl();
                }
                TimePicker.this.onTimeChanged();
            }
        });
        this.mHourSpinnerInput = (EditText)this.mHourSpinner.findViewById(16909035);
        this.mHourSpinnerInput.setImeOptions(5);
        this.mDivider = (TextView)this.findViewById(16909136);
        if (this.mDivider != null) {
            this.setDividerText();
        }
        this.mMinuteSpinner = (NumberPicker)this.findViewById(16909133);
        this.mMinuteSpinner.setMinValue(0);
        this.mMinuteSpinner.setMaxValue(59);
        this.mMinuteSpinner.setOnLongPressUpdateInterval(100L);
        this.mMinuteSpinner.setFormatter(NumberPicker.getTwoDigitFormatter());
        this.mMinuteSpinner.setOnValueChangedListener(new NumberPicker.OnValueChangeListener(){

            public void onValueChange(NumberPicker spinner, int oldVal, int newVal) {
                TimePicker.this.updateInputState();
                int minValue = TimePicker.this.mMinuteSpinner.getMinValue();
                int maxValue = TimePicker.this.mMinuteSpinner.getMaxValue();
                if (oldVal == maxValue && newVal == minValue) {
                    int newHour = TimePicker.this.mHourSpinner.getValue() + 1;
                    if (!TimePicker.this.is24HourView() && newHour == 12) {
                        TimePicker.this.mIsAm = !TimePicker.this.mIsAm;
                        TimePicker.this.updateAmPmControl();
                    }
                    TimePicker.this.mHourSpinner.setValue(newHour);
                } else if (oldVal == minValue && newVal == maxValue) {
                    int newHour = TimePicker.this.mHourSpinner.getValue() - 1;
                    if (!TimePicker.this.is24HourView() && newHour == 11) {
                        TimePicker.this.mIsAm = !TimePicker.this.mIsAm;
                        TimePicker.this.updateAmPmControl();
                    }
                    TimePicker.this.mHourSpinner.setValue(newHour);
                }
                TimePicker.this.onTimeChanged();
            }
        });
        this.mMinuteSpinnerInput = (EditText)this.mMinuteSpinner.findViewById(16909035);
        this.mMinuteSpinnerInput.setImeOptions(5);
        this.mAmPmStrings = new DateFormatSymbols().getAmPmStrings();
        View amPmView = this.findViewById(16909134);
        if (amPmView instanceof Button) {
            this.mAmPmSpinner = null;
            this.mAmPmSpinnerInput = null;
            this.mAmPmButton = (Button)amPmView;
            this.mAmPmButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View button) {
                    button.requestFocus();
                    TimePicker.this.mIsAm = !TimePicker.this.mIsAm;
                    TimePicker.this.updateAmPmControl();
                    TimePicker.this.onTimeChanged();
                }
            });
        } else {
            this.mAmPmButton = null;
            this.mAmPmSpinner = (NumberPicker)amPmView;
            this.mAmPmSpinner.setMinValue(0);
            this.mAmPmSpinner.setMaxValue(1);
            this.mAmPmSpinner.setDisplayedValues(this.mAmPmStrings);
            this.mAmPmSpinner.setOnValueChangedListener(new NumberPicker.OnValueChangeListener(){

                public void onValueChange(NumberPicker picker, int oldVal, int newVal) {
                    TimePicker.this.updateInputState();
                    picker.requestFocus();
                    TimePicker.this.mIsAm = !TimePicker.this.mIsAm;
                    TimePicker.this.updateAmPmControl();
                    TimePicker.this.onTimeChanged();
                }
            });
            this.mAmPmSpinnerInput = (EditText)this.mAmPmSpinner.findViewById(16909035);
            this.mAmPmSpinnerInput.setImeOptions(6);
        }
        if (this.isAmPmAtStart()) {
            ViewGroup amPmParent = (ViewGroup)this.findViewById(16909131);
            amPmParent.removeView(amPmView);
            amPmParent.addView(amPmView, 0);
            ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)amPmView.getLayoutParams();
            int startMargin = lp.getMarginStart();
            int endMargin = lp.getMarginEnd();
            if (startMargin != endMargin) {
                lp.setMarginStart(endMargin);
                lp.setMarginEnd(startMargin);
            }
        }
        this.getHourFormatData();
        this.updateHourControl();
        this.updateMinuteControl();
        this.updateAmPmControl();
        this.setOnTimeChangedListener(NO_OP_CHANGE_LISTENER);
        this.setCurrentHour(this.mTempCalendar.get(11));
        this.setCurrentMinute(this.mTempCalendar.get(12));
        if (!this.isEnabled()) {
            this.setEnabled(false);
        }
        this.setContentDescriptions();
        if (this.getImportantForAccessibility() == 0) {
            this.setImportantForAccessibility(1);
        }
    }

    private void getHourFormatData() {
        Locale defaultLocale = Locale.getDefault();
        String bestDateTimePattern = DateFormat.getBestDateTimePattern(defaultLocale, this.mIs24HourView ? "Hm" : "hm");
        int lengthPattern = bestDateTimePattern.length();
        this.mHourWithTwoDigit = false;
        boolean hourFormat = false;
        for (int i = 0; i < lengthPattern; ++i) {
            char c = bestDateTimePattern.charAt(i);
            if (c != 'H' && c != 'h' && c != 'K' && c != 'k') continue;
            this.mHourFormat = c;
            if (i + 1 >= lengthPattern || c != bestDateTimePattern.charAt(i + 1)) break;
            this.mHourWithTwoDigit = true;
            break;
        }
    }

    private boolean isAmPmAtStart() {
        Locale defaultLocale = Locale.getDefault();
        String bestDateTimePattern = DateFormat.getBestDateTimePattern(defaultLocale, "hm");
        return bestDateTimePattern.startsWith("a");
    }

    public void setEnabled(boolean enabled) {
        if (this.mIsEnabled == enabled) {
            return;
        }
        super.setEnabled(enabled);
        this.mMinuteSpinner.setEnabled(enabled);
        if (this.mDivider != null) {
            this.mDivider.setEnabled(enabled);
        }
        this.mHourSpinner.setEnabled(enabled);
        if (this.mAmPmSpinner != null) {
            this.mAmPmSpinner.setEnabled(enabled);
        } else {
            this.mAmPmButton.setEnabled(enabled);
        }
        this.mIsEnabled = enabled;
    }

    public boolean isEnabled() {
        return this.mIsEnabled;
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.setCurrentLocale(newConfig.locale);
    }

    private void setCurrentLocale(Locale locale) {
        if (locale.equals(this.mCurrentLocale)) {
            return;
        }
        this.mCurrentLocale = locale;
        this.mTempCalendar = Calendar.getInstance(locale);
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        return new SavedState(superState, this.getCurrentHour(), this.getCurrentMinute());
    }

    protected void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.setCurrentHour(ss.getHour());
        this.setCurrentMinute(ss.getMinute());
    }

    public void setOnTimeChangedListener(OnTimeChangedListener onTimeChangedListener) {
        this.mOnTimeChangedListener = onTimeChangedListener;
    }

    public Integer getCurrentHour() {
        int currentHour = this.mHourSpinner.getValue();
        if (this.is24HourView()) {
            return currentHour;
        }
        if (this.mIsAm) {
            return currentHour % 12;
        }
        return currentHour % 12 + 12;
    }

    public void setCurrentHour(Integer currentHour) {
        this.setCurrentHour(currentHour, true);
    }

    private void setCurrentHour(Integer currentHour, boolean notifyTimeChanged) {
        if (currentHour == null || currentHour == this.getCurrentHour()) {
            return;
        }
        if (!this.is24HourView()) {
            if (currentHour >= 12) {
                this.mIsAm = false;
                if (currentHour > 12) {
                    currentHour = currentHour - 12;
                }
            } else {
                this.mIsAm = true;
                if (currentHour == 0) {
                    currentHour = 12;
                }
            }
            this.updateAmPmControl();
        }
        this.mHourSpinner.setValue(currentHour);
        if (notifyTimeChanged) {
            this.onTimeChanged();
        }
    }

    public void setIs24HourView(Boolean is24HourView) {
        if (this.mIs24HourView == is24HourView) {
            return;
        }
        int currentHour = this.getCurrentHour();
        this.mIs24HourView = is24HourView;
        this.getHourFormatData();
        this.updateHourControl();
        this.setCurrentHour(currentHour, false);
        this.updateMinuteControl();
        this.updateAmPmControl();
    }

    public boolean is24HourView() {
        return this.mIs24HourView;
    }

    public Integer getCurrentMinute() {
        return this.mMinuteSpinner.getValue();
    }

    public void setCurrentMinute(Integer currentMinute) {
        if (currentMinute == this.getCurrentMinute()) {
            return;
        }
        this.mMinuteSpinner.setValue(currentMinute);
        this.onTimeChanged();
    }

    private void setDividerText() {
        int minuteIndex;
        String skeleton;
        Locale defaultLocale = Locale.getDefault();
        String bestDateTimePattern = DateFormat.getBestDateTimePattern(defaultLocale, skeleton = this.mIs24HourView ? "Hm" : "hm");
        int hourIndex = bestDateTimePattern.lastIndexOf(72);
        if (hourIndex == -1) {
            hourIndex = bestDateTimePattern.lastIndexOf(104);
        }
        String separatorText = hourIndex == -1 ? ":" : ((minuteIndex = bestDateTimePattern.indexOf(109, hourIndex + 1)) == -1 ? Character.toString(bestDateTimePattern.charAt(hourIndex + 1)) : bestDateTimePattern.substring(hourIndex + 1, minuteIndex));
        this.mDivider.setText(separatorText);
    }

    public int getBaseline() {
        return this.mHourSpinner.getBaseline();
    }

    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
        this.onPopulateAccessibilityEvent(event);
        return true;
    }

    public void onPopulateAccessibilityEvent(AccessibilityEvent event) {
        super.onPopulateAccessibilityEvent(event);
        int flags = 1;
        flags = this.mIs24HourView ? (flags |= 0x80) : (flags |= 0x40);
        this.mTempCalendar.set(11, this.getCurrentHour());
        this.mTempCalendar.set(12, this.getCurrentMinute());
        String selectedDateUtterance = DateUtils.formatDateTime(this.mContext, this.mTempCalendar.getTimeInMillis(), flags);
        event.getText().add(selectedDateUtterance);
    }

    public void onInitializeAccessibilityEvent(AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        event.setClassName(TimePicker.class.getName());
    }

    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        info.setClassName(TimePicker.class.getName());
    }

    private void updateHourControl() {
        if (this.is24HourView()) {
            if (this.mHourFormat == 'k') {
                this.mHourSpinner.setMinValue(1);
                this.mHourSpinner.setMaxValue(24);
            } else {
                this.mHourSpinner.setMinValue(0);
                this.mHourSpinner.setMaxValue(23);
            }
        } else if (this.mHourFormat == 'K') {
            this.mHourSpinner.setMinValue(0);
            this.mHourSpinner.setMaxValue(11);
        } else {
            this.mHourSpinner.setMinValue(1);
            this.mHourSpinner.setMaxValue(12);
        }
        this.mHourSpinner.setFormatter(this.mHourWithTwoDigit ? NumberPicker.getTwoDigitFormatter() : null);
    }

    private void updateMinuteControl() {
        if (this.is24HourView()) {
            this.mMinuteSpinnerInput.setImeOptions(6);
        } else {
            this.mMinuteSpinnerInput.setImeOptions(5);
        }
    }

    private void updateAmPmControl() {
        if (this.is24HourView()) {
            if (this.mAmPmSpinner != null) {
                this.mAmPmSpinner.setVisibility(8);
            } else {
                this.mAmPmButton.setVisibility(8);
            }
        } else {
            int index;
            int n = index = this.mIsAm ? 0 : 1;
            if (this.mAmPmSpinner != null) {
                this.mAmPmSpinner.setValue(index);
                this.mAmPmSpinner.setVisibility(0);
            } else {
                this.mAmPmButton.setText(this.mAmPmStrings[index]);
                this.mAmPmButton.setVisibility(0);
            }
        }
        this.sendAccessibilityEvent(4);
    }

    private void onTimeChanged() {
        this.sendAccessibilityEvent(4);
        if (this.mOnTimeChangedListener != null) {
            this.mOnTimeChangedListener.onTimeChanged(this, this.getCurrentHour(), this.getCurrentMinute());
        }
    }

    private void setContentDescriptions() {
        this.trySetContentDescription(this.mMinuteSpinner, 16909034, 17040630);
        this.trySetContentDescription(this.mMinuteSpinner, 16909036, 17040631);
        this.trySetContentDescription(this.mHourSpinner, 16909034, 17040632);
        this.trySetContentDescription(this.mHourSpinner, 16909036, 17040633);
        if (this.mAmPmSpinner != null) {
            this.trySetContentDescription(this.mAmPmSpinner, 16909034, 17040634);
            this.trySetContentDescription(this.mAmPmSpinner, 16909036, 17040635);
        }
    }

    private void trySetContentDescription(View root, int viewId, int contDescResId) {
        View target = root.findViewById(viewId);
        if (target != null) {
            target.setContentDescription(this.mContext.getString(contDescResId));
        }
    }

    private void updateInputState() {
        InputMethodManager inputMethodManager = InputMethodManager.peekInstance();
        if (inputMethodManager != null) {
            if (inputMethodManager.isActive(this.mHourSpinnerInput)) {
                this.mHourSpinnerInput.clearFocus();
                inputMethodManager.hideSoftInputFromWindow(this.getWindowToken(), 0);
            } else if (inputMethodManager.isActive(this.mMinuteSpinnerInput)) {
                this.mMinuteSpinnerInput.clearFocus();
                inputMethodManager.hideSoftInputFromWindow(this.getWindowToken(), 0);
            } else if (inputMethodManager.isActive(this.mAmPmSpinnerInput)) {
                this.mAmPmSpinnerInput.clearFocus();
                inputMethodManager.hideSoftInputFromWindow(this.getWindowToken(), 0);
            }
        }
    }

    private static class SavedState
    extends View.BaseSavedState {
        private final int mHour;
        private final int mMinute;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        private SavedState(Parcelable superState, int hour, int minute) {
            super(superState);
            this.mHour = hour;
            this.mMinute = minute;
        }

        private SavedState(Parcel in) {
            super(in);
            this.mHour = in.readInt();
            this.mMinute = in.readInt();
        }

        public int getHour() {
            return this.mHour;
        }

        public int getMinute() {
            return this.mMinute;
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.mHour);
            dest.writeInt(this.mMinute);
        }
    }

    public static interface OnTimeChangedListener {
        public void onTimeChanged(TimePicker var1, int var2, int var3);
    }
}

