/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.graphics.Rect;
import android.text.Layout;
import android.text.Spannable;
import android.view.AccessibilityIterators;
import android.widget.TextView;

class AccessibilityIterators {
    AccessibilityIterators() {
    }

    static class PageTextSegmentIterator
    extends LineTextSegmentIterator {
        private static PageTextSegmentIterator sPageInstance;
        private TextView mView;
        private final Rect mTempRect = new Rect();

        PageTextSegmentIterator() {
        }

        public static PageTextSegmentIterator getInstance() {
            if (sPageInstance == null) {
                sPageInstance = new PageTextSegmentIterator();
            }
            return sPageInstance;
        }

        public void initialize(TextView view) {
            super.initialize((Spannable)view.getIterableTextForAccessibility(), view.getLayout());
            this.mView = view;
        }

        public int[] following(int offset) {
            int lastLineTop;
            int pageHeight;
            int textLegth = this.mText.length();
            if (textLegth <= 0) {
                return null;
            }
            if (offset >= this.mText.length()) {
                return null;
            }
            if (!this.mView.getGlobalVisibleRect(this.mTempRect)) {
                return null;
            }
            int start = Math.max(0, offset);
            int currentLine = this.mLayout.getLineForOffset(start);
            int currentLineTop = this.mLayout.getLineTop(currentLine);
            int nextPageStartY = currentLineTop + (pageHeight = this.mTempRect.height() - this.mView.getTotalPaddingTop() - this.mView.getTotalPaddingBottom());
            int currentPageEndLine = nextPageStartY < (lastLineTop = this.mLayout.getLineTop(this.mLayout.getLineCount() - 1)) ? this.mLayout.getLineForVertical(nextPageStartY) - 1 : this.mLayout.getLineCount() - 1;
            int end = this.getLineEdgeIndex(currentPageEndLine, 1) + 1;
            return this.getRange(start, end);
        }

        public int[] preceding(int offset) {
            int pageHeight;
            int textLegth = this.mText.length();
            if (textLegth <= 0) {
                return null;
            }
            if (offset <= 0) {
                return null;
            }
            if (!this.mView.getGlobalVisibleRect(this.mTempRect)) {
                return null;
            }
            int end = Math.min(this.mText.length(), offset);
            int currentLine = this.mLayout.getLineForOffset(end);
            int currentLineTop = this.mLayout.getLineTop(currentLine);
            int previousPageEndY = currentLineTop - (pageHeight = this.mTempRect.height() - this.mView.getTotalPaddingTop() - this.mView.getTotalPaddingBottom());
            int currentPageStartLine = previousPageEndY > 0 ? this.mLayout.getLineForVertical(previousPageEndY) + 1 : 0;
            int start = this.getLineEdgeIndex(currentPageStartLine, -1);
            return this.getRange(start, end);
        }
    }

    static class LineTextSegmentIterator
    extends AccessibilityIterators.AbstractTextSegmentIterator {
        private static LineTextSegmentIterator sLineInstance;
        protected static final int DIRECTION_START = -1;
        protected static final int DIRECTION_END = 1;
        protected Layout mLayout;

        LineTextSegmentIterator() {
        }

        public static LineTextSegmentIterator getInstance() {
            if (sLineInstance == null) {
                sLineInstance = new LineTextSegmentIterator();
            }
            return sLineInstance;
        }

        public void initialize(Spannable text, Layout layout2) {
            this.mText = text.toString();
            this.mLayout = layout2;
        }

        public int[] following(int offset) {
            int currentLine;
            int textLegth = this.mText.length();
            if (textLegth <= 0) {
                return null;
            }
            if (offset >= this.mText.length()) {
                return null;
            }
            int nextLine = offset < 0 ? this.mLayout.getLineForOffset(0) : (this.getLineEdgeIndex(currentLine = this.mLayout.getLineForOffset(offset), -1) == offset ? currentLine : currentLine + 1);
            if (nextLine >= this.mLayout.getLineCount()) {
                return null;
            }
            int start = this.getLineEdgeIndex(nextLine, -1);
            int end = this.getLineEdgeIndex(nextLine, 1) + 1;
            return this.getRange(start, end);
        }

        public int[] preceding(int offset) {
            int currentLine;
            int textLegth = this.mText.length();
            if (textLegth <= 0) {
                return null;
            }
            if (offset <= 0) {
                return null;
            }
            int previousLine = offset > this.mText.length() ? this.mLayout.getLineForOffset(this.mText.length()) : (this.getLineEdgeIndex(currentLine = this.mLayout.getLineForOffset(offset), 1) + 1 == offset ? currentLine : currentLine - 1);
            if (previousLine < 0) {
                return null;
            }
            int start = this.getLineEdgeIndex(previousLine, -1);
            int end = this.getLineEdgeIndex(previousLine, 1) + 1;
            return this.getRange(start, end);
        }

        protected int getLineEdgeIndex(int lineNumber, int direction) {
            int paragraphDirection = this.mLayout.getParagraphDirection(lineNumber);
            if (direction * paragraphDirection < 0) {
                return this.mLayout.getLineStart(lineNumber);
            }
            return this.mLayout.getLineEnd(lineNumber) - 1;
        }
    }
}

