/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.os.StrictMode;
import android.util.AndroidRuntimeException;
import android.util.Log;
import android.webkit.WebViewFactoryProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebViewFactory {
    private static final String CHROMIUM_WEBVIEW_FACTORY = "com.android.webview.chromium.WebViewChromiumFactoryProvider";
    private static final String NULL_WEBVIEW_FACTORY = "com.android.webview.nullwebview.NullWebViewFactoryProvider";
    private static final String LOGTAG = "WebViewFactory";
    private static final boolean DEBUG = false;
    private static WebViewFactoryProvider sProviderInstance;
    private static final Object sProviderLock;

    public static boolean isExperimentalWebViewAvailable() {
        return false;
    }

    public static void setUseExperimentalWebView(boolean enable) {
    }

    public static boolean useExperimentalWebView() {
        return true;
    }

    public static boolean isUseExperimentalWebViewSet() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static WebViewFactoryProvider getProvider() {
        Object object = sProviderLock;
        synchronized (object) {
            Class<WebViewFactoryProvider> providerClass;
            if (sProviderInstance != null) {
                return sProviderInstance;
            }
            try {
                providerClass = WebViewFactory.getFactoryClass();
            }
            catch (ClassNotFoundException e) {
                Log.e(LOGTAG, "error loading provider", e);
                throw new AndroidRuntimeException(e);
            }
            if (Preloader.sPreloadedProvider != null && Preloader.sPreloadedProvider.getClass() == providerClass) {
                sProviderInstance = Preloader.sPreloadedProvider;
                return sProviderInstance;
            }
            StrictMode.ThreadPolicy oldPolicy = StrictMode.allowThreadDiskReads();
            try {
                WebViewFactoryProvider webViewFactoryProvider = sProviderInstance = providerClass.newInstance();
                return webViewFactoryProvider;
            }
            catch (Exception e) {
                Log.e(LOGTAG, "error instantiating provider", e);
                throw new AndroidRuntimeException(e);
            }
            finally {
                StrictMode.setThreadPolicy(oldPolicy);
            }
        }
    }

    private static Class<WebViewFactoryProvider> getFactoryClass() throws ClassNotFoundException {
        try {
            return Class.forName(CHROMIUM_WEBVIEW_FACTORY);
        }
        catch (ClassNotFoundException e) {
            Log.e(LOGTAG, "Chromium WebView does not exist");
            return Class.forName(NULL_WEBVIEW_FACTORY);
        }
    }

    static {
        sProviderLock = new Object();
    }

    private static class Preloader {
        static WebViewFactoryProvider sPreloadedProvider;

        private Preloader() {
        }

        static {
            try {
                sPreloadedProvider = (WebViewFactoryProvider)WebViewFactory.getFactoryClass().newInstance();
            }
            catch (Exception e) {
                Log.w(WebViewFactory.LOGTAG, "error preloading provider", e);
            }
        }
    }
}

