/*
 * Decompiled with CFR 0.152.
 */
package android.view.inputmethod;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.os.SystemClock;
import android.text.Editable;
import android.text.Selection;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.method.MetaKeyKeyListener;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewRootImpl;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.ComposingText;
import android.view.inputmethod.CorrectionInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.ExtractedTextRequest;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodManager;

public class BaseInputConnection
implements InputConnection {
    private static final boolean DEBUG = false;
    private static final String TAG = "BaseInputConnection";
    static final Object COMPOSING = new ComposingText();
    protected final InputMethodManager mIMM;
    final View mTargetView;
    final boolean mDummyMode;
    private Object[] mDefaultComposingSpans;
    Editable mEditable;
    KeyCharacterMap mKeyCharacterMap;

    BaseInputConnection(InputMethodManager mgr, boolean fullEditor) {
        this.mIMM = mgr;
        this.mTargetView = null;
        this.mDummyMode = !fullEditor;
    }

    public BaseInputConnection(View targetView, boolean fullEditor) {
        this.mIMM = (InputMethodManager)targetView.getContext().getSystemService("input_method");
        this.mTargetView = targetView;
        this.mDummyMode = !fullEditor;
    }

    public static void removeComposingSpans(Spannable text) {
        text.removeSpan(COMPOSING);
        Object[] sps = text.getSpans(0, text.length(), Object.class);
        if (sps != null) {
            for (int i = sps.length - 1; i >= 0; --i) {
                Object o = sps[i];
                if ((text.getSpanFlags(o) & 0x100) == 0) continue;
                text.removeSpan(o);
            }
        }
    }

    public static void setComposingSpans(Spannable text) {
        BaseInputConnection.setComposingSpans(text, 0, text.length());
    }

    public static void setComposingSpans(Spannable text, int start, int end) {
        Object[] sps = text.getSpans(start, end, Object.class);
        if (sps != null) {
            for (int i = sps.length - 1; i >= 0; --i) {
                Object o = sps[i];
                if (o == COMPOSING) {
                    text.removeSpan(o);
                    continue;
                }
                int fl = text.getSpanFlags(o);
                if ((fl & 0x133) == 289) continue;
                text.setSpan(o, text.getSpanStart(o), text.getSpanEnd(o), fl & 0xFFFFFFCC | 0x100 | 0x21);
            }
        }
        text.setSpan(COMPOSING, start, end, 289);
    }

    public static int getComposingSpanStart(Spannable text) {
        return text.getSpanStart(COMPOSING);
    }

    public static int getComposingSpanEnd(Spannable text) {
        return text.getSpanEnd(COMPOSING);
    }

    public Editable getEditable() {
        if (this.mEditable == null) {
            this.mEditable = Editable.Factory.getInstance().newEditable("");
            Selection.setSelection(this.mEditable, 0);
        }
        return this.mEditable;
    }

    public boolean beginBatchEdit() {
        return false;
    }

    public boolean endBatchEdit() {
        return false;
    }

    protected void reportFinish() {
    }

    public boolean clearMetaKeyStates(int states) {
        Editable content = this.getEditable();
        if (content == null) {
            return false;
        }
        MetaKeyKeyListener.clearMetaKeyState(content, states);
        return true;
    }

    public boolean commitCompletion(CompletionInfo text) {
        return false;
    }

    public boolean commitCorrection(CorrectionInfo correctionInfo) {
        return false;
    }

    public boolean commitText(CharSequence text, int newCursorPosition) {
        this.replaceText(text, newCursorPosition, false);
        this.sendCurrentText();
        return true;
    }

    public boolean deleteSurroundingText(int beforeLength, int afterLength) {
        Editable content = this.getEditable();
        if (content == null) {
            return false;
        }
        this.beginBatchEdit();
        int a = Selection.getSelectionStart(content);
        int b = Selection.getSelectionEnd(content);
        if (a > b) {
            int tmp = a;
            a = b;
            b = tmp;
        }
        int ca = BaseInputConnection.getComposingSpanStart(content);
        int cb = BaseInputConnection.getComposingSpanEnd(content);
        if (cb < ca) {
            int tmp = ca;
            ca = cb;
            cb = tmp;
        }
        if (ca != -1 && cb != -1) {
            if (ca < a) {
                a = ca;
            }
            if (cb > b) {
                b = cb;
            }
        }
        int deleted = 0;
        if (beforeLength > 0) {
            int start = a - beforeLength;
            if (start < 0) {
                start = 0;
            }
            content.delete(start, a);
            deleted = a - start;
        }
        if (afterLength > 0) {
            int end = (b -= deleted) + afterLength;
            if (end > content.length()) {
                end = content.length();
            }
            content.delete(b, end);
        }
        this.endBatchEdit();
        return true;
    }

    public boolean finishComposingText() {
        Editable content = this.getEditable();
        if (content != null) {
            this.beginBatchEdit();
            BaseInputConnection.removeComposingSpans(content);
            this.sendCurrentText();
            this.endBatchEdit();
        }
        return true;
    }

    public int getCursorCapsMode(int reqModes) {
        int b;
        if (this.mDummyMode) {
            return 0;
        }
        Editable content = this.getEditable();
        if (content == null) {
            return 0;
        }
        int a = Selection.getSelectionStart(content);
        if (a > (b = Selection.getSelectionEnd(content))) {
            int tmp = a;
            a = b;
            b = tmp;
        }
        return TextUtils.getCapsMode(content, a, reqModes);
    }

    public ExtractedText getExtractedText(ExtractedTextRequest request, int flags) {
        return null;
    }

    public CharSequence getTextBeforeCursor(int length, int flags) {
        int b;
        Editable content = this.getEditable();
        if (content == null) {
            return null;
        }
        int a = Selection.getSelectionStart(content);
        if (a > (b = Selection.getSelectionEnd(content))) {
            int tmp = a;
            a = b;
            b = tmp;
        }
        if (a <= 0) {
            return "";
        }
        if (length > a) {
            length = a;
        }
        if ((flags & 1) != 0) {
            return content.subSequence(a - length, a);
        }
        return TextUtils.substring(content, a - length, a);
    }

    public CharSequence getSelectedText(int flags) {
        int b;
        Editable content = this.getEditable();
        if (content == null) {
            return null;
        }
        int a = Selection.getSelectionStart(content);
        if (a > (b = Selection.getSelectionEnd(content))) {
            int tmp = a;
            a = b;
            b = tmp;
        }
        if (a == b) {
            return null;
        }
        if ((flags & 1) != 0) {
            return content.subSequence(a, b);
        }
        return TextUtils.substring(content, a, b);
    }

    public CharSequence getTextAfterCursor(int length, int flags) {
        int b;
        Editable content = this.getEditable();
        if (content == null) {
            return null;
        }
        int a = Selection.getSelectionStart(content);
        if (a > (b = Selection.getSelectionEnd(content))) {
            int tmp = a;
            a = b;
            b = tmp;
        }
        if (b < 0) {
            b = 0;
        }
        if (b + length > content.length()) {
            length = content.length() - b;
        }
        if ((flags & 1) != 0) {
            return content.subSequence(b, b + length);
        }
        return TextUtils.substring(content, b, b + length);
    }

    public boolean performEditorAction(int actionCode) {
        long eventTime = SystemClock.uptimeMillis();
        this.sendKeyEvent(new KeyEvent(eventTime, eventTime, 0, 66, 0, 0, -1, 0, 22));
        this.sendKeyEvent(new KeyEvent(SystemClock.uptimeMillis(), eventTime, 1, 66, 0, 0, -1, 0, 22));
        return true;
    }

    public boolean performContextMenuAction(int id2) {
        return false;
    }

    public boolean performPrivateCommand(String action, Bundle data) {
        return false;
    }

    public boolean setComposingText(CharSequence text, int newCursorPosition) {
        this.replaceText(text, newCursorPosition, true);
        return true;
    }

    public boolean setComposingRegion(int start, int end) {
        Editable content = this.getEditable();
        if (content != null) {
            this.beginBatchEdit();
            BaseInputConnection.removeComposingSpans(content);
            int a = start;
            int b = end;
            if (a > b) {
                int tmp = a;
                a = b;
                b = tmp;
            }
            int length = content.length();
            if (a < 0) {
                a = 0;
            }
            if (b < 0) {
                b = 0;
            }
            if (a > length) {
                a = length;
            }
            if (b > length) {
                b = length;
            }
            this.ensureDefaultComposingSpans();
            if (this.mDefaultComposingSpans != null) {
                for (int i = 0; i < this.mDefaultComposingSpans.length; ++i) {
                    content.setSpan(this.mDefaultComposingSpans[i], a, b, 289);
                }
            }
            content.setSpan(COMPOSING, a, b, 289);
            this.sendCurrentText();
            this.endBatchEdit();
        }
        return true;
    }

    public boolean setSelection(int start, int end) {
        Editable content = this.getEditable();
        if (content == null) {
            return false;
        }
        int len = content.length();
        if (start > len || end > len) {
            return true;
        }
        if (start == end && MetaKeyKeyListener.getMetaState((CharSequence)content, 2048) != 0) {
            Selection.extendSelection(content, start);
        } else {
            Selection.setSelection(content, start, end);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendKeyEvent(KeyEvent event) {
        InputMethodManager.H h = this.mIMM.mH;
        synchronized (h) {
            ViewRootImpl viewRootImpl;
            ViewRootImpl viewRootImpl2 = viewRootImpl = this.mTargetView != null ? this.mTargetView.getViewRootImpl() : null;
            if (viewRootImpl == null && this.mIMM.mServedView != null) {
                viewRootImpl = this.mIMM.mServedView.getViewRootImpl();
            }
            if (viewRootImpl != null) {
                viewRootImpl.dispatchKeyFromIme(event);
            }
        }
        return false;
    }

    public boolean reportFullscreenMode(boolean enabled) {
        this.mIMM.setFullscreenMode(enabled);
        return true;
    }

    private void sendCurrentText() {
        if (!this.mDummyMode) {
            return;
        }
        Editable content = this.getEditable();
        if (content != null) {
            int N = content.length();
            if (N == 0) {
                return;
            }
            if (N == 1) {
                if (this.mKeyCharacterMap == null) {
                    this.mKeyCharacterMap = KeyCharacterMap.load(-1);
                }
                char[] chars = new char[1];
                content.getChars(0, 1, chars, 0);
                KeyEvent[] events = this.mKeyCharacterMap.getEvents(chars);
                if (events != null) {
                    for (int i = 0; i < events.length; ++i) {
                        this.sendKeyEvent(events[i]);
                    }
                    content.clear();
                    return;
                }
            }
            KeyEvent event = new KeyEvent(SystemClock.uptimeMillis(), content.toString(), -1, 0);
            this.sendKeyEvent(event);
            content.clear();
        }
    }

    private void ensureDefaultComposingSpans() {
        Context context;
        if (this.mDefaultComposingSpans == null && (context = this.mTargetView != null ? this.mTargetView.getContext() : (this.mIMM.mServedView != null ? this.mIMM.mServedView.getContext() : null)) != null) {
            TypedArray ta = context.getTheme().obtainStyledAttributes(new int[]{16843312});
            CharSequence style2 = ta.getText(0);
            ta.recycle();
            if (style2 != null && style2 instanceof Spanned) {
                this.mDefaultComposingSpans = ((Spanned)style2).getSpans(0, style2.length(), Object.class);
            }
        }
    }

    private void replaceText(CharSequence text, int newCursorPosition, boolean composing) {
        int tmp;
        Editable content = this.getEditable();
        if (content == null) {
            return;
        }
        this.beginBatchEdit();
        int a = BaseInputConnection.getComposingSpanStart(content);
        int b = BaseInputConnection.getComposingSpanEnd(content);
        if (b < a) {
            tmp = a;
            a = b;
            b = tmp;
        }
        if (a != -1 && b != -1) {
            BaseInputConnection.removeComposingSpans(content);
        } else {
            a = Selection.getSelectionStart(content);
            b = Selection.getSelectionEnd(content);
            if (a < 0) {
                a = 0;
            }
            if (b < 0) {
                b = 0;
            }
            if (b < a) {
                tmp = a;
                a = b;
                b = tmp;
            }
        }
        if (composing) {
            Spannable sp = null;
            if (!(text instanceof Spannable)) {
                sp = new SpannableStringBuilder(text);
                text = sp;
                this.ensureDefaultComposingSpans();
                if (this.mDefaultComposingSpans != null) {
                    for (int i = 0; i < this.mDefaultComposingSpans.length; ++i) {
                        sp.setSpan(this.mDefaultComposingSpans[i], 0, sp.length(), 289);
                    }
                }
            } else {
                sp = (Spannable)text;
            }
            BaseInputConnection.setComposingSpans(sp);
        }
        newCursorPosition = newCursorPosition > 0 ? (newCursorPosition += b - 1) : (newCursorPosition += a);
        if (newCursorPosition < 0) {
            newCursorPosition = 0;
        }
        if (newCursorPosition > content.length()) {
            newCursorPosition = content.length();
        }
        Selection.setSelection(content, newCursorPosition);
        content.replace(a, b, text);
        this.endBatchEdit();
    }
}

