/*
 * Decompiled with CFR 0.152.
 */
package android.view.animation;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.animation.Interpolator;
import com.android.internal.R;

public class DecelerateInterpolator
implements Interpolator {
    private float mFactor = 1.0f;

    public DecelerateInterpolator() {
    }

    public DecelerateInterpolator(float factor) {
        this.mFactor = factor;
    }

    public DecelerateInterpolator(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.DecelerateInterpolator);
        this.mFactor = a.getFloat(0, 1.0f);
        a.recycle();
    }

    public float getInterpolation(float input) {
        float result = this.mFactor == 1.0f ? 1.0f - (1.0f - input) * (1.0f - input) : (float)(1.0 - Math.pow(1.0f - input, 2.0f * this.mFactor));
        return result;
    }
}

