/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.view.WindowManagerGlobal;

public class WindowManagerImpl
implements WindowManager {
    private final WindowManagerGlobal mGlobal = WindowManagerGlobal.getInstance();
    private final Display mDisplay;
    private final Window mParentWindow;

    public WindowManagerImpl(Display display) {
        this(display, null);
    }

    private WindowManagerImpl(Display display, Window parentWindow) {
        this.mDisplay = display;
        this.mParentWindow = parentWindow;
    }

    public WindowManagerImpl createLocalWindowManager(Window parentWindow) {
        return new WindowManagerImpl(this.mDisplay, parentWindow);
    }

    public WindowManagerImpl createPresentationWindowManager(Display display) {
        return new WindowManagerImpl(display, this.mParentWindow);
    }

    public void addView(View view, ViewGroup.LayoutParams params) {
        this.mGlobal.addView(view, params, this.mDisplay, this.mParentWindow);
    }

    public void updateViewLayout(View view, ViewGroup.LayoutParams params) {
        this.mGlobal.updateViewLayout(view, params);
    }

    public void removeView(View view) {
        this.mGlobal.removeView(view, false);
    }

    public void removeViewImmediate(View view) {
        this.mGlobal.removeView(view, true);
    }

    public Display getDefaultDisplay() {
        return this.mDisplay;
    }
}

