/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Rect;

public class WindowInsets {
    private Rect mSystemWindowInsets;
    private Rect mWindowDecorInsets;
    private Rect mTempRect;
    private boolean mIsRound;
    private boolean mSystemWindowInsetsConsumed = false;
    private boolean mWindowDecorInsetsConsumed = false;
    private static final Rect EMPTY_RECT = new Rect(0, 0, 0, 0);
    public static final WindowInsets CONSUMED = new WindowInsets(EMPTY_RECT, EMPTY_RECT);

    public WindowInsets(Rect systemWindowInsets, Rect windowDecorInsets) {
        this(systemWindowInsets, windowDecorInsets, false);
    }

    public WindowInsets(Rect systemWindowInsets, boolean isRound) {
        this(systemWindowInsets, null, isRound);
    }

    public WindowInsets(Rect systemWindowInsets, Rect windowDecorInsets, boolean isRound) {
        this.mSystemWindowInsetsConsumed = systemWindowInsets == null;
        this.mSystemWindowInsets = this.mSystemWindowInsetsConsumed ? EMPTY_RECT : systemWindowInsets;
        this.mWindowDecorInsetsConsumed = windowDecorInsets == null;
        this.mWindowDecorInsets = this.mWindowDecorInsetsConsumed ? EMPTY_RECT : windowDecorInsets;
        this.mIsRound = isRound;
    }

    public WindowInsets(WindowInsets src) {
        this.mSystemWindowInsets = src.mSystemWindowInsets;
        this.mWindowDecorInsets = src.mWindowDecorInsets;
        this.mSystemWindowInsetsConsumed = src.mSystemWindowInsetsConsumed;
        this.mWindowDecorInsetsConsumed = src.mWindowDecorInsetsConsumed;
        this.mIsRound = src.mIsRound;
    }

    public WindowInsets(Rect systemWindowInsets) {
        this(systemWindowInsets, null);
    }

    public Rect getSystemWindowInsets() {
        if (this.mTempRect == null) {
            this.mTempRect = new Rect();
        }
        if (this.mSystemWindowInsets != null) {
            this.mTempRect.set(this.mSystemWindowInsets);
        } else {
            this.mTempRect.setEmpty();
        }
        return this.mTempRect;
    }

    public int getSystemWindowInsetLeft() {
        return this.mSystemWindowInsets.left;
    }

    public int getSystemWindowInsetTop() {
        return this.mSystemWindowInsets.top;
    }

    public int getSystemWindowInsetRight() {
        return this.mSystemWindowInsets.right;
    }

    public int getSystemWindowInsetBottom() {
        return this.mSystemWindowInsets.bottom;
    }

    public int getWindowDecorInsetLeft() {
        return this.mWindowDecorInsets.left;
    }

    public int getWindowDecorInsetTop() {
        return this.mWindowDecorInsets.top;
    }

    public int getWindowDecorInsetRight() {
        return this.mWindowDecorInsets.right;
    }

    public int getWindowDecorInsetBottom() {
        return this.mWindowDecorInsets.bottom;
    }

    public boolean hasSystemWindowInsets() {
        return this.mSystemWindowInsets.left != 0 || this.mSystemWindowInsets.top != 0 || this.mSystemWindowInsets.right != 0 || this.mSystemWindowInsets.bottom != 0;
    }

    public boolean hasWindowDecorInsets() {
        return this.mWindowDecorInsets.left != 0 || this.mWindowDecorInsets.top != 0 || this.mWindowDecorInsets.right != 0 || this.mWindowDecorInsets.bottom != 0;
    }

    public boolean hasInsets() {
        return this.hasSystemWindowInsets() || this.hasWindowDecorInsets();
    }

    public boolean isConsumed() {
        return this.mSystemWindowInsetsConsumed && this.mWindowDecorInsetsConsumed;
    }

    public boolean isRound() {
        return this.mIsRound;
    }

    public WindowInsets consumeSystemWindowInsets() {
        WindowInsets result = new WindowInsets(this);
        result.mSystemWindowInsets = EMPTY_RECT;
        result.mSystemWindowInsetsConsumed = true;
        return result;
    }

    public WindowInsets consumeSystemWindowInsets(boolean left, boolean top, boolean right, boolean bottom) {
        if (left || top || right || bottom) {
            WindowInsets result = new WindowInsets(this);
            result.mSystemWindowInsets = new Rect(left ? 0 : this.mSystemWindowInsets.left, top ? 0 : this.mSystemWindowInsets.top, right ? 0 : this.mSystemWindowInsets.right, bottom ? 0 : this.mSystemWindowInsets.bottom);
            result.mSystemWindowInsetsConsumed = !this.hasSystemWindowInsets();
            return result;
        }
        return this;
    }

    public WindowInsets replaceSystemWindowInsets(int left, int top, int right, int bottom) {
        WindowInsets result = new WindowInsets(this);
        result.mSystemWindowInsets = new Rect(left, top, right, bottom);
        result.mSystemWindowInsetsConsumed = !this.hasSystemWindowInsets();
        return result;
    }

    public WindowInsets consumeWindowDecorInsets() {
        WindowInsets result = new WindowInsets(this);
        result.mWindowDecorInsets.set(0, 0, 0, 0);
        result.mWindowDecorInsetsConsumed = true;
        return result;
    }

    public WindowInsets consumeWindowDecorInsets(boolean left, boolean top, boolean right, boolean bottom) {
        if (left || top || right || bottom) {
            WindowInsets result = new WindowInsets(this);
            result.mWindowDecorInsets = new Rect(left ? 0 : this.mWindowDecorInsets.left, top ? 0 : this.mWindowDecorInsets.top, right ? 0 : this.mWindowDecorInsets.right, bottom ? 0 : this.mWindowDecorInsets.bottom);
            result.mWindowDecorInsetsConsumed = !this.hasWindowDecorInsets();
            return result;
        }
        return this;
    }

    public WindowInsets replaceWindowDecorInsets(int left, int top, int right, int bottom) {
        WindowInsets result = new WindowInsets(this);
        result.mWindowDecorInsets = new Rect(left, top, right, bottom);
        result.mWindowDecorInsetsConsumed = !this.hasWindowDecorInsets();
        return result;
    }

    public String toString() {
        return "WindowInsets{systemWindowInsets=" + this.mSystemWindowInsets + " windowDecorInsets=" + this.mWindowDecorInsets + (this.isRound() ? "round}" : "}");
    }

    static {
        WindowInsets.CONSUMED.mSystemWindowInsetsConsumed = true;
        WindowInsets.CONSUMED.mWindowDecorInsetsConsumed = true;
    }
}

