/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.view.DisplayList;
import android.view.View;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

public class ViewPropertyAnimator {
    private final View mView;
    private long mDuration;
    private boolean mDurationSet = false;
    private long mStartDelay = 0L;
    private boolean mStartDelaySet = false;
    private TimeInterpolator mInterpolator;
    private boolean mInterpolatorSet = false;
    private Animator.AnimatorListener mListener = null;
    private ValueAnimator.AnimatorUpdateListener mUpdateListener = null;
    private ValueAnimator mTempValueAnimator;
    private AnimatorEventListener mAnimatorEventListener = new AnimatorEventListener();
    ArrayList<NameValuesHolder> mPendingAnimations = new ArrayList();
    private Runnable mPendingSetupAction;
    private Runnable mPendingCleanupAction;
    private Runnable mPendingOnStartAction;
    private Runnable mPendingOnEndAction;
    private static final int NONE = 0;
    private static final int TRANSLATION_X = 1;
    private static final int TRANSLATION_Y = 2;
    private static final int SCALE_X = 4;
    private static final int SCALE_Y = 8;
    private static final int ROTATION = 16;
    private static final int ROTATION_X = 32;
    private static final int ROTATION_Y = 64;
    private static final int X = 128;
    private static final int Y = 256;
    private static final int ALPHA = 512;
    private static final int TRANSFORM_MASK = 511;
    private Runnable mAnimationStarter = new Runnable(){

        public void run() {
            ViewPropertyAnimator.this.startAnimation();
        }
    };
    private HashMap<Animator, PropertyBundle> mAnimatorMap = new HashMap();
    private HashMap<Animator, Runnable> mAnimatorSetupMap;
    private HashMap<Animator, Runnable> mAnimatorCleanupMap;
    private HashMap<Animator, Runnable> mAnimatorOnStartMap;
    private HashMap<Animator, Runnable> mAnimatorOnEndMap;

    ViewPropertyAnimator(View view) {
        this.mView = view;
        view.ensureTransformationInfo();
    }

    public ViewPropertyAnimator setDuration(long duration) {
        if (duration < 0L) {
            throw new IllegalArgumentException("Animators cannot have negative duration: " + duration);
        }
        this.mDurationSet = true;
        this.mDuration = duration;
        return this;
    }

    public long getDuration() {
        if (this.mDurationSet) {
            return this.mDuration;
        }
        if (this.mTempValueAnimator == null) {
            this.mTempValueAnimator = new ValueAnimator();
        }
        return this.mTempValueAnimator.getDuration();
    }

    public long getStartDelay() {
        if (this.mStartDelaySet) {
            return this.mStartDelay;
        }
        return 0L;
    }

    public ViewPropertyAnimator setStartDelay(long startDelay) {
        if (startDelay < 0L) {
            throw new IllegalArgumentException("Animators cannot have negative duration: " + startDelay);
        }
        this.mStartDelaySet = true;
        this.mStartDelay = startDelay;
        return this;
    }

    public ViewPropertyAnimator setInterpolator(TimeInterpolator interpolator2) {
        this.mInterpolatorSet = true;
        this.mInterpolator = interpolator2;
        return this;
    }

    public TimeInterpolator getInterpolator() {
        if (this.mInterpolatorSet) {
            return this.mInterpolator;
        }
        if (this.mTempValueAnimator == null) {
            this.mTempValueAnimator = new ValueAnimator();
        }
        return this.mTempValueAnimator.getInterpolator();
    }

    public ViewPropertyAnimator setListener(Animator.AnimatorListener listener) {
        this.mListener = listener;
        return this;
    }

    public ViewPropertyAnimator setUpdateListener(ValueAnimator.AnimatorUpdateListener listener) {
        this.mUpdateListener = listener;
        return this;
    }

    public void start() {
        this.mView.removeCallbacks(this.mAnimationStarter);
        this.startAnimation();
    }

    public void cancel() {
        if (this.mAnimatorMap.size() > 0) {
            HashMap mAnimatorMapCopy = (HashMap)this.mAnimatorMap.clone();
            Set animatorSet = mAnimatorMapCopy.keySet();
            for (Animator runningAnim : animatorSet) {
                runningAnim.cancel();
            }
        }
        this.mPendingAnimations.clear();
        this.mView.removeCallbacks(this.mAnimationStarter);
    }

    public ViewPropertyAnimator x(float value) {
        this.animateProperty(128, value);
        return this;
    }

    public ViewPropertyAnimator xBy(float value) {
        this.animatePropertyBy(128, value);
        return this;
    }

    public ViewPropertyAnimator y(float value) {
        this.animateProperty(256, value);
        return this;
    }

    public ViewPropertyAnimator yBy(float value) {
        this.animatePropertyBy(256, value);
        return this;
    }

    public ViewPropertyAnimator rotation(float value) {
        this.animateProperty(16, value);
        return this;
    }

    public ViewPropertyAnimator rotationBy(float value) {
        this.animatePropertyBy(16, value);
        return this;
    }

    public ViewPropertyAnimator rotationX(float value) {
        this.animateProperty(32, value);
        return this;
    }

    public ViewPropertyAnimator rotationXBy(float value) {
        this.animatePropertyBy(32, value);
        return this;
    }

    public ViewPropertyAnimator rotationY(float value) {
        this.animateProperty(64, value);
        return this;
    }

    public ViewPropertyAnimator rotationYBy(float value) {
        this.animatePropertyBy(64, value);
        return this;
    }

    public ViewPropertyAnimator translationX(float value) {
        this.animateProperty(1, value);
        return this;
    }

    public ViewPropertyAnimator translationXBy(float value) {
        this.animatePropertyBy(1, value);
        return this;
    }

    public ViewPropertyAnimator translationY(float value) {
        this.animateProperty(2, value);
        return this;
    }

    public ViewPropertyAnimator translationYBy(float value) {
        this.animatePropertyBy(2, value);
        return this;
    }

    public ViewPropertyAnimator scaleX(float value) {
        this.animateProperty(4, value);
        return this;
    }

    public ViewPropertyAnimator scaleXBy(float value) {
        this.animatePropertyBy(4, value);
        return this;
    }

    public ViewPropertyAnimator scaleY(float value) {
        this.animateProperty(8, value);
        return this;
    }

    public ViewPropertyAnimator scaleYBy(float value) {
        this.animatePropertyBy(8, value);
        return this;
    }

    public ViewPropertyAnimator alpha(float value) {
        this.animateProperty(512, value);
        return this;
    }

    public ViewPropertyAnimator alphaBy(float value) {
        this.animatePropertyBy(512, value);
        return this;
    }

    public ViewPropertyAnimator withLayer() {
        this.mPendingSetupAction = new Runnable(){

            public void run() {
                ViewPropertyAnimator.this.mView.setLayerType(2, null);
                if (ViewPropertyAnimator.this.mView.isAttachedToWindow()) {
                    ViewPropertyAnimator.this.mView.buildLayer();
                }
            }
        };
        final int currentLayerType = this.mView.getLayerType();
        this.mPendingCleanupAction = new Runnable(){

            public void run() {
                ViewPropertyAnimator.this.mView.setLayerType(currentLayerType, null);
            }
        };
        if (this.mAnimatorSetupMap == null) {
            this.mAnimatorSetupMap = new HashMap();
        }
        if (this.mAnimatorCleanupMap == null) {
            this.mAnimatorCleanupMap = new HashMap();
        }
        return this;
    }

    public ViewPropertyAnimator withStartAction(Runnable runnable) {
        this.mPendingOnStartAction = runnable;
        if (runnable != null && this.mAnimatorOnStartMap == null) {
            this.mAnimatorOnStartMap = new HashMap();
        }
        return this;
    }

    public ViewPropertyAnimator withEndAction(Runnable runnable) {
        this.mPendingOnEndAction = runnable;
        if (runnable != null && this.mAnimatorOnEndMap == null) {
            this.mAnimatorOnEndMap = new HashMap();
        }
        return this;
    }

    private void startAnimation() {
        this.mView.setHasTransientState(true);
        ValueAnimator animator2 = ValueAnimator.ofFloat(1.0f);
        ArrayList nameValueList = (ArrayList)this.mPendingAnimations.clone();
        this.mPendingAnimations.clear();
        int propertyMask = 0;
        int propertyCount = nameValueList.size();
        for (int i = 0; i < propertyCount; ++i) {
            NameValuesHolder nameValuesHolder = (NameValuesHolder)nameValueList.get(i);
            propertyMask |= nameValuesHolder.mNameConstant;
        }
        this.mAnimatorMap.put(animator2, new PropertyBundle(propertyMask, nameValueList));
        if (this.mPendingSetupAction != null) {
            this.mAnimatorSetupMap.put(animator2, this.mPendingSetupAction);
            this.mPendingSetupAction = null;
        }
        if (this.mPendingCleanupAction != null) {
            this.mAnimatorCleanupMap.put(animator2, this.mPendingCleanupAction);
            this.mPendingCleanupAction = null;
        }
        if (this.mPendingOnStartAction != null) {
            this.mAnimatorOnStartMap.put(animator2, this.mPendingOnStartAction);
            this.mPendingOnStartAction = null;
        }
        if (this.mPendingOnEndAction != null) {
            this.mAnimatorOnEndMap.put(animator2, this.mPendingOnEndAction);
            this.mPendingOnEndAction = null;
        }
        animator2.addUpdateListener(this.mAnimatorEventListener);
        animator2.addListener(this.mAnimatorEventListener);
        if (this.mStartDelaySet) {
            animator2.setStartDelay(this.mStartDelay);
        }
        if (this.mDurationSet) {
            animator2.setDuration(this.mDuration);
        }
        if (this.mInterpolatorSet) {
            animator2.setInterpolator(this.mInterpolator);
        }
        animator2.start();
    }

    private void animateProperty(int constantName, float toValue) {
        float fromValue = this.getValue(constantName);
        float deltaValue = toValue - fromValue;
        this.animatePropertyBy(constantName, fromValue, deltaValue);
    }

    private void animatePropertyBy(int constantName, float byValue) {
        float fromValue = this.getValue(constantName);
        this.animatePropertyBy(constantName, fromValue, byValue);
    }

    private void animatePropertyBy(int constantName, float startValue, float byValue) {
        if (this.mAnimatorMap.size() > 0) {
            Animator animatorToCancel = null;
            Set<Animator> animatorSet = this.mAnimatorMap.keySet();
            for (Animator runningAnim : animatorSet) {
                PropertyBundle bundle = this.mAnimatorMap.get(runningAnim);
                if (!bundle.cancel(constantName) || bundle.mPropertyMask != 0) continue;
                animatorToCancel = runningAnim;
                break;
            }
            if (animatorToCancel != null) {
                animatorToCancel.cancel();
            }
        }
        NameValuesHolder nameValuePair = new NameValuesHolder(constantName, startValue, byValue);
        this.mPendingAnimations.add(nameValuePair);
        this.mView.removeCallbacks(this.mAnimationStarter);
        this.mView.postOnAnimation(this.mAnimationStarter);
    }

    private void setValue(int propertyConstant, float value) {
        View.TransformationInfo info = this.mView.mTransformationInfo;
        DisplayList displayList = this.mView.mDisplayList;
        switch (propertyConstant) {
            case 1: {
                info.mTranslationX = value;
                if (displayList == null) break;
                displayList.setTranslationX(value);
                break;
            }
            case 2: {
                info.mTranslationY = value;
                if (displayList == null) break;
                displayList.setTranslationY(value);
                break;
            }
            case 16: {
                info.mRotation = value;
                if (displayList == null) break;
                displayList.setRotation(value);
                break;
            }
            case 32: {
                info.mRotationX = value;
                if (displayList == null) break;
                displayList.setRotationX(value);
                break;
            }
            case 64: {
                info.mRotationY = value;
                if (displayList == null) break;
                displayList.setRotationY(value);
                break;
            }
            case 4: {
                info.mScaleX = value;
                if (displayList == null) break;
                displayList.setScaleX(value);
                break;
            }
            case 8: {
                info.mScaleY = value;
                if (displayList == null) break;
                displayList.setScaleY(value);
                break;
            }
            case 128: {
                info.mTranslationX = value - (float)this.mView.mLeft;
                if (displayList == null) break;
                displayList.setTranslationX(value - (float)this.mView.mLeft);
                break;
            }
            case 256: {
                info.mTranslationY = value - (float)this.mView.mTop;
                if (displayList == null) break;
                displayList.setTranslationY(value - (float)this.mView.mTop);
                break;
            }
            case 512: {
                info.mAlpha = value;
                if (displayList == null) break;
                displayList.setAlpha(value);
            }
        }
    }

    private float getValue(int propertyConstant) {
        View.TransformationInfo info = this.mView.mTransformationInfo;
        switch (propertyConstant) {
            case 1: {
                return info.mTranslationX;
            }
            case 2: {
                return info.mTranslationY;
            }
            case 16: {
                return info.mRotation;
            }
            case 32: {
                return info.mRotationX;
            }
            case 64: {
                return info.mRotationY;
            }
            case 4: {
                return info.mScaleX;
            }
            case 8: {
                return info.mScaleY;
            }
            case 128: {
                return (float)this.mView.mLeft + info.mTranslationX;
            }
            case 256: {
                return (float)this.mView.mTop + info.mTranslationY;
            }
            case 512: {
                return info.mAlpha;
            }
        }
        return 0.0f;
    }

    private class AnimatorEventListener
    implements Animator.AnimatorListener,
    ValueAnimator.AnimatorUpdateListener {
        private AnimatorEventListener() {
        }

        public void onAnimationStart(Animator animation) {
            Runnable r;
            if (ViewPropertyAnimator.this.mAnimatorSetupMap != null) {
                r = (Runnable)ViewPropertyAnimator.this.mAnimatorSetupMap.get(animation);
                if (r != null) {
                    r.run();
                }
                ViewPropertyAnimator.this.mAnimatorSetupMap.remove(animation);
            }
            if (ViewPropertyAnimator.this.mAnimatorOnStartMap != null) {
                r = (Runnable)ViewPropertyAnimator.this.mAnimatorOnStartMap.get(animation);
                if (r != null) {
                    r.run();
                }
                ViewPropertyAnimator.this.mAnimatorOnStartMap.remove(animation);
            }
            if (ViewPropertyAnimator.this.mListener != null) {
                ViewPropertyAnimator.this.mListener.onAnimationStart(animation);
            }
        }

        public void onAnimationCancel(Animator animation) {
            if (ViewPropertyAnimator.this.mListener != null) {
                ViewPropertyAnimator.this.mListener.onAnimationCancel(animation);
            }
            if (ViewPropertyAnimator.this.mAnimatorOnEndMap != null) {
                ViewPropertyAnimator.this.mAnimatorOnEndMap.remove(animation);
            }
        }

        public void onAnimationRepeat(Animator animation) {
            if (ViewPropertyAnimator.this.mListener != null) {
                ViewPropertyAnimator.this.mListener.onAnimationRepeat(animation);
            }
        }

        public void onAnimationEnd(Animator animation) {
            Runnable r;
            ViewPropertyAnimator.this.mView.setHasTransientState(false);
            if (ViewPropertyAnimator.this.mListener != null) {
                ViewPropertyAnimator.this.mListener.onAnimationEnd(animation);
            }
            if (ViewPropertyAnimator.this.mAnimatorOnEndMap != null) {
                r = (Runnable)ViewPropertyAnimator.this.mAnimatorOnEndMap.get(animation);
                if (r != null) {
                    r.run();
                }
                ViewPropertyAnimator.this.mAnimatorOnEndMap.remove(animation);
            }
            if (ViewPropertyAnimator.this.mAnimatorCleanupMap != null) {
                r = (Runnable)ViewPropertyAnimator.this.mAnimatorCleanupMap.get(animation);
                if (r != null) {
                    r.run();
                }
                ViewPropertyAnimator.this.mAnimatorCleanupMap.remove(animation);
            }
            ViewPropertyAnimator.this.mAnimatorMap.remove(animation);
        }

        public void onAnimationUpdate(ValueAnimator animation) {
            ArrayList<NameValuesHolder> valueList;
            PropertyBundle propertyBundle = (PropertyBundle)ViewPropertyAnimator.this.mAnimatorMap.get(animation);
            if (propertyBundle == null) {
                return;
            }
            boolean useDisplayListProperties = ((ViewPropertyAnimator)ViewPropertyAnimator.this).mView.mDisplayList != null;
            boolean alphaHandled = false;
            if (!useDisplayListProperties) {
                ViewPropertyAnimator.this.mView.invalidateParentCaches();
            }
            float fraction2 = animation.getAnimatedFraction();
            int propertyMask = propertyBundle.mPropertyMask;
            if ((propertyMask & 0x1FF) != 0) {
                ViewPropertyAnimator.this.mView.invalidateViewProperty(false, false);
            }
            if ((valueList = propertyBundle.mNameValuesHolder) != null) {
                int count = valueList.size();
                for (int i = 0; i < count; ++i) {
                    NameValuesHolder values = valueList.get(i);
                    float value = values.mFromValue + fraction2 * values.mDeltaValue;
                    if (values.mNameConstant == 512) {
                        alphaHandled = ViewPropertyAnimator.this.mView.setAlphaNoInvalidation(value);
                        continue;
                    }
                    ViewPropertyAnimator.this.setValue(values.mNameConstant, value);
                }
            }
            if ((propertyMask & 0x1FF) != 0) {
                ((ViewPropertyAnimator)ViewPropertyAnimator.this).mView.mTransformationInfo.mMatrixDirty = true;
                if (!useDisplayListProperties) {
                    ((ViewPropertyAnimator)ViewPropertyAnimator.this).mView.mPrivateFlags |= 0x20;
                }
            }
            if (alphaHandled) {
                ViewPropertyAnimator.this.mView.invalidate(true);
            } else {
                ViewPropertyAnimator.this.mView.invalidateViewProperty(false, false);
            }
            if (ViewPropertyAnimator.this.mUpdateListener != null) {
                ViewPropertyAnimator.this.mUpdateListener.onAnimationUpdate(animation);
            }
        }
    }

    private static class NameValuesHolder {
        int mNameConstant;
        float mFromValue;
        float mDeltaValue;

        NameValuesHolder(int nameConstant, float fromValue, float deltaValue) {
            this.mNameConstant = nameConstant;
            this.mFromValue = fromValue;
            this.mDeltaValue = deltaValue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PropertyBundle {
        int mPropertyMask;
        ArrayList<NameValuesHolder> mNameValuesHolder;

        PropertyBundle(int propertyMask, ArrayList<NameValuesHolder> nameValuesHolder) {
            this.mPropertyMask = propertyMask;
            this.mNameValuesHolder = nameValuesHolder;
        }

        boolean cancel(int propertyConstant) {
            if ((this.mPropertyMask & propertyConstant) != 0 && this.mNameValuesHolder != null) {
                int count = this.mNameValuesHolder.size();
                for (int i = 0; i < count; ++i) {
                    NameValuesHolder nameValuesHolder = this.mNameValuesHolder.get(i);
                    if (nameValuesHolder.mNameConstant != propertyConstant) continue;
                    this.mNameValuesHolder.remove(i);
                    this.mPropertyMask &= ~propertyConstant;
                    return true;
                }
            }
            return false;
        }
    }
}

