/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.os.Looper;
import android.util.AttributeSet;
import android.util.Log;
import android.view.HardwareLayer;
import android.view.View;
import com.android.tools.layoutlib.create.OverrideMethod;

public class TextureView
extends View {
    private static final String LOG_TAG = "TextureView";
    private HardwareLayer mLayer;
    private SurfaceTexture mSurface;
    private SurfaceTextureListener mListener;
    private boolean mHadSurface;
    private boolean mOpaque = true;
    private final Matrix mMatrix = new Matrix();
    private boolean mMatrixChanged;
    private final Object[] mLock = new Object[0];
    private boolean mUpdateLayer;
    private boolean mUpdateSurface;
    private SurfaceTexture.OnFrameAvailableListener mUpdateListener;
    private Canvas mCanvas;
    private int mSaveCount;
    private final Object[] mNativeWindowLock = new Object[0];
    private long mNativeWindow;

    public TextureView(Context context) {
        super(context);
        this.init();
    }

    public TextureView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public TextureView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    private void init() {
        this.mLayerPaint = new Paint();
    }

    public boolean isOpaque() {
        return this.mOpaque;
    }

    public void setOpaque(boolean opaque) {
        if (opaque != this.mOpaque) {
            this.mOpaque = opaque;
            if (this.mLayer != null) {
                this.updateLayerAndInvalidate();
            }
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isHardwareAccelerated()) {
            Log.w(LOG_TAG, "A TextureView or a subclass can only be used with hardware acceleration enabled.");
        }
        if (this.mHadSurface) {
            this.invalidate(true);
            this.mHadSurface = false;
        }
    }

    protected void onDetachedFromWindow() {
        boolean success;
        super.onDetachedFromWindow();
        if (this.mLayer != null && !(success = this.executeHardwareAction(new Runnable(){

            public void run() {
                TextureView.this.destroySurface();
            }
        }))) {
            Log.w(LOG_TAG, "TextureView was not able to destroy its surface: " + this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void destroySurface() {
        if (this.mLayer == null) return;
        this.mSurface.detachFromGLContext();
        this.mLayer.clearStorage();
        boolean shouldRelease = true;
        if (this.mListener != null) {
            shouldRelease = this.mListener.onSurfaceTextureDestroyed(this.mSurface);
        }
        Object[] objectArray = this.mNativeWindowLock;
        synchronized (this.mNativeWindowLock) {
            this.nDestroyNativeWindow();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.mLayer.destroy();
            if (shouldRelease) {
                this.mSurface.release();
            }
            this.mSurface = null;
            this.mLayer = null;
            this.mHadSurface = true;
            return;
        }
    }

    public void setLayerType(int layerType, Paint paint) {
        if (paint != this.mLayerPaint) {
            this.mLayerPaint = paint == null ? new Paint() : paint;
            this.invalidate();
        }
    }

    public int getLayerType() {
        return 2;
    }

    boolean hasStaticLayer() {
        return true;
    }

    public void buildLayer() {
    }

    public void draw(Canvas canvas) {
        this.mPrivateFlags = this.mPrivateFlags & 0xFF9FFFFF | 0x20;
        this.applyUpdate();
        this.applyTransformMatrix();
    }

    protected void onDraw(Canvas canvas) {
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.mSurface != null) {
            this.mSurface.setDefaultBufferSize(this.getWidth(), this.getHeight());
            this.updateLayer();
            if (this.mListener != null) {
                this.mListener.onSurfaceTextureSizeChanged(this.mSurface, this.getWidth(), this.getHeight());
            }
        }
    }

    boolean destroyLayer(boolean valid) {
        return false;
    }

    protected void destroyHardwareResources() {
        super.destroyHardwareResources();
        this.destroySurface();
        this.invalidateParentCaches();
        this.invalidate(true);
    }

    HardwareLayer getHardwareLayer() {
        this.mPrivateFlags |= 0x8020;
        this.mPrivateFlags &= 0xFF9FFFFF;
        if (this.mLayer == null) {
            if (this.mAttachInfo == null || this.mAttachInfo.mHardwareRenderer == null) {
                return null;
            }
            this.mLayer = this.mAttachInfo.mHardwareRenderer.createHardwareLayer(this.mOpaque);
            if (!this.mUpdateSurface) {
                this.mSurface = this.mAttachInfo.mHardwareRenderer.createSurfaceTexture(this.mLayer);
            }
            this.mSurface.setDefaultBufferSize(this.getWidth(), this.getHeight());
            this.nCreateNativeWindow(this.mSurface);
            this.mUpdateListener = new SurfaceTexture.OnFrameAvailableListener(){

                public void onFrameAvailable(SurfaceTexture surfaceTexture) {
                    TextureView.this.updateLayer();
                    if (Looper.myLooper() == Looper.getMainLooper()) {
                        TextureView.this.invalidate();
                    } else {
                        TextureView.this.postInvalidate();
                    }
                }
            };
            this.mSurface.setOnFrameAvailableListener(this.mUpdateListener);
            if (this.mListener != null && !this.mUpdateSurface) {
                this.mListener.onSurfaceTextureAvailable(this.mSurface, this.getWidth(), this.getHeight());
            }
            this.mLayer.setLayerPaint(this.mLayerPaint);
        }
        if (this.mUpdateSurface) {
            this.mUpdateSurface = false;
            this.updateLayer();
            this.mMatrixChanged = true;
            this.mAttachInfo.mHardwareRenderer.setSurfaceTexture(this.mLayer, this.mSurface);
            this.mSurface.setDefaultBufferSize(this.getWidth(), this.getHeight());
        }
        this.applyUpdate();
        this.applyTransformMatrix();
        return this.mLayer;
    }

    protected void onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (this.mSurface != null) {
            if (visibility == 0) {
                this.mSurface.setOnFrameAvailableListener(this.mUpdateListener);
                this.updateLayerAndInvalidate();
            } else {
                this.mSurface.setOnFrameAvailableListener(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLayer() {
        Object[] objectArray = this.mLock;
        synchronized (this.mLock) {
            this.mUpdateLayer = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLayerAndInvalidate() {
        Object[] objectArray = this.mLock;
        synchronized (this.mLock) {
            this.mUpdateLayer = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.invalidate();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyUpdate() {
        if (this.mLayer == null) {
            return;
        }
        Object[] objectArray = this.mLock;
        synchronized (this.mLock) {
            if (!this.mUpdateLayer) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.mUpdateLayer = false;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.mLayer.update(this.getWidth(), this.getHeight(), this.mOpaque);
            if (this.mListener != null) {
                this.mListener.onSurfaceTextureUpdated(this.mSurface);
            }
            return;
        }
    }

    public void setTransform(Matrix transform) {
        this.mMatrix.set(transform);
        this.mMatrixChanged = true;
        this.invalidateParentIfNeeded();
    }

    public Matrix getTransform(Matrix transform) {
        if (transform == null) {
            transform = new Matrix();
        }
        transform.set(this.mMatrix);
        return transform;
    }

    private void applyTransformMatrix() {
        if (this.mMatrixChanged && this.mLayer != null) {
            this.mLayer.setTransform(this.mMatrix);
            this.mMatrixChanged = false;
        }
    }

    public Bitmap getBitmap() {
        return this.getBitmap(this.getWidth(), this.getHeight());
    }

    public Bitmap getBitmap(int width, int height) {
        if (this.isAvailable() && width > 0 && height > 0) {
            return this.getBitmap(Bitmap.createBitmap(this.getResources().getDisplayMetrics(), width, height, Bitmap.Config.ARGB_8888));
        }
        return null;
    }

    public Bitmap getBitmap(Bitmap bitmap) {
        if (bitmap != null && this.isAvailable()) {
            View.AttachInfo info = this.mAttachInfo;
            if (info != null && info.mHardwareRenderer != null && info.mHardwareRenderer.isEnabled() && !info.mHardwareRenderer.validate()) {
                throw new IllegalStateException("Could not acquire hardware rendering context");
            }
            this.applyUpdate();
            this.applyTransformMatrix();
            if (this.mLayer == null && this.mUpdateSurface) {
                this.getHardwareLayer();
            }
            if (this.mLayer != null) {
                this.mLayer.copyInto(bitmap);
            }
        }
        return bitmap;
    }

    public boolean isAvailable() {
        return this.mSurface != null;
    }

    public Canvas lockCanvas() {
        return this.lockCanvas(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Canvas lockCanvas(Rect dirty) {
        if (!this.isAvailable()) {
            return null;
        }
        if (this.mCanvas == null) {
            this.mCanvas = new Canvas();
        }
        Object[] objectArray = this.mNativeWindowLock;
        synchronized (this.mNativeWindowLock) {
            if (!TextureView.nLockCanvas(this.mNativeWindow, this.mCanvas, dirty)) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.mSaveCount = this.mCanvas.save();
            return this.mCanvas;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void unlockCanvasAndPost(Canvas canvas) {
        if (this.mCanvas == null || canvas != this.mCanvas) return;
        canvas.restoreToCount(this.mSaveCount);
        this.mSaveCount = 0;
        Object[] objectArray = this.mNativeWindowLock;
        synchronized (this.mNativeWindowLock) {
            TextureView.nUnlockCanvasAndPost(this.mNativeWindow, this.mCanvas);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public SurfaceTexture getSurfaceTexture() {
        return this.mSurface;
    }

    public void setSurfaceTexture(SurfaceTexture surfaceTexture) {
        if (surfaceTexture == null) {
            throw new NullPointerException("surfaceTexture must not be null");
        }
        if (this.mSurface != null) {
            this.mSurface.release();
        }
        this.mSurface = surfaceTexture;
        this.mUpdateSurface = true;
        this.invalidateParentIfNeeded();
    }

    public SurfaceTextureListener getSurfaceTextureListener() {
        return this.mListener;
    }

    public void setSurfaceTextureListener(SurfaceTextureListener listener) {
        this.mListener = listener;
    }

    private void nCreateNativeWindow(SurfaceTexture surfaceTexture) {
        OverrideMethod.invokeV("android.view.TextureView#nCreateNativeWindow(Landroid/graphics/SurfaceTexture;)V", true, this);
    }

    private void nDestroyNativeWindow() {
        OverrideMethod.invokeV("android.view.TextureView#nDestroyNativeWindow()V", true, this);
    }

    private static boolean nLockCanvas(long l, Canvas canvas, Rect rect) {
        return OverrideMethod.invokeI("android.view.TextureView#nLockCanvas(JLandroid/graphics/Canvas;Landroid/graphics/Rect;)Z", true, null) != 0;
    }

    private static void nUnlockCanvasAndPost(long l, Canvas canvas) {
        OverrideMethod.invokeV("android.view.TextureView#nUnlockCanvasAndPost(JLandroid/graphics/Canvas;)V", true, null);
    }

    public static interface SurfaceTextureListener {
        public void onSurfaceTextureAvailable(SurfaceTexture var1, int var2, int var3);

        public void onSurfaceTextureSizeChanged(SurfaceTexture var1, int var2, int var3);

        public boolean onSurfaceTextureDestroyed(SurfaceTexture var1);

        public void onSurfaceTextureUpdated(SurfaceTexture var1);
    }
}

