/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.Region;
import android.os.IBinder;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceSession;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.system.CloseGuard;

public class SurfaceControl {
    private static final String TAG = "SurfaceControl";
    private final CloseGuard mCloseGuard = CloseGuard.get();
    private final String mName;
    long mNativeObject;
    public static final int HIDDEN = 4;
    public static final int SECURE = 128;
    public static final int NON_PREMULTIPLIED = 256;
    public static final int OPAQUE = 1024;
    public static final int PROTECTED_APP = 2048;
    public static final int FX_SURFACE_NORMAL = 0;
    public static final int FX_SURFACE_DIM = 131072;
    public static final int FX_SURFACE_MASK = 983040;
    public static final int SURFACE_HIDDEN = 1;
    public static final int SURFACE_OPAQUE = 2;
    public static final int BUILT_IN_DISPLAY_ID_MAIN = 0;
    public static final int BUILT_IN_DISPLAY_ID_HDMI = 1;

    private static long nativeCreate(SurfaceSession surfaceSession, String string2, int n, int n2, int n3, int n4) throws Surface.OutOfResourcesException {
        return OverrideMethod.invokeL("android.view.SurfaceControl#nativeCreate(Landroid/view/SurfaceSession;Ljava/lang/String;IIII)J", true, null);
    }

    private static void nativeRelease(long l) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeRelease(J)V", true, null);
    }

    private static void nativeDestroy(long l) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeDestroy(J)V", true, null);
    }

    private static Bitmap nativeScreenshot(IBinder iBinder, int n, int n2, int n3, int n4, boolean bl) {
        return (Bitmap)OverrideMethod.invokeA("android.view.SurfaceControl#nativeScreenshot(Landroid/os/IBinder;IIIIZ)Landroid/graphics/Bitmap;", true, null);
    }

    private static void nativeScreenshot(IBinder iBinder, Surface surface, int n, int n2, int n3, int n4, boolean bl) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeScreenshot(Landroid/os/IBinder;Landroid/view/Surface;IIIIZ)V", true, null);
    }

    private static void nativeOpenTransaction() {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeOpenTransaction()V", true, null);
    }

    private static void nativeCloseTransaction() {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeCloseTransaction()V", true, null);
    }

    private static void nativeSetAnimationTransaction() {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetAnimationTransaction()V", true, null);
    }

    private static void nativeSetLayer(long l, int n) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetLayer(JI)V", true, null);
    }

    private static void nativeSetPosition(long l, float f, float f2) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetPosition(JFF)V", true, null);
    }

    private static void nativeSetSize(long l, int n, int n2) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetSize(JII)V", true, null);
    }

    private static void nativeSetTransparentRegionHint(long l, Region region) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetTransparentRegionHint(JLandroid/graphics/Region;)V", true, null);
    }

    private static void nativeSetAlpha(long l, float f) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetAlpha(JF)V", true, null);
    }

    private static void nativeSetMatrix(long l, float f, float f2, float f3, float f4) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetMatrix(JFFFF)V", true, null);
    }

    private static void nativeSetFlags(long l, int n, int n2) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetFlags(JII)V", true, null);
    }

    private static void nativeSetWindowCrop(long l, int n, int n2, int n3, int n4) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetWindowCrop(JIIII)V", true, null);
    }

    private static void nativeSetLayerStack(long l, int n) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetLayerStack(JI)V", true, null);
    }

    private static IBinder nativeGetBuiltInDisplay(int n) {
        return (IBinder)OverrideMethod.invokeA("android.view.SurfaceControl#nativeGetBuiltInDisplay(I)Landroid/os/IBinder;", true, null);
    }

    private static IBinder nativeCreateDisplay(String string2, boolean bl) {
        return (IBinder)OverrideMethod.invokeA("android.view.SurfaceControl#nativeCreateDisplay(Ljava/lang/String;Z)Landroid/os/IBinder;", true, null);
    }

    private static void nativeDestroyDisplay(IBinder iBinder) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeDestroyDisplay(Landroid/os/IBinder;)V", true, null);
    }

    private static void nativeSetDisplaySurface(IBinder iBinder, long l) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetDisplaySurface(Landroid/os/IBinder;J)V", true, null);
    }

    private static void nativeSetDisplayLayerStack(IBinder iBinder, int n) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetDisplayLayerStack(Landroid/os/IBinder;I)V", true, null);
    }

    private static void nativeSetDisplayProjection(IBinder iBinder, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetDisplayProjection(Landroid/os/IBinder;IIIIIIIII)V", true, null);
    }

    private static boolean nativeGetDisplayInfo(IBinder iBinder, PhysicalDisplayInfo physicalDisplayInfo) {
        return OverrideMethod.invokeI("android.view.SurfaceControl#nativeGetDisplayInfo(Landroid/os/IBinder;Landroid/view/SurfaceControl$PhysicalDisplayInfo;)Z", true, null) != 0;
    }

    private static void nativeBlankDisplay(IBinder iBinder) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeBlankDisplay(Landroid/os/IBinder;)V", true, null);
    }

    private static void nativeUnblankDisplay(IBinder iBinder) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeUnblankDisplay(Landroid/os/IBinder;)V", true, null);
    }

    public SurfaceControl(SurfaceSession session, String name, int w, int h, int format, int flags) throws Surface.OutOfResourcesException {
        if (session == null) {
            throw new IllegalArgumentException("session must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        if ((flags & 4) == 0) {
            Log.w(TAG, "Surfaces should always be created with the HIDDEN flag set to ensure that they are not made visible prematurely before all of the surface's properties have been configured.  Set the other properties and make the surface visible within a transaction.  New surface name: " + name, new Throwable());
        }
        this.mName = name;
        this.mNativeObject = SurfaceControl.nativeCreate(session, name, w, h, format, flags);
        if (this.mNativeObject == 0L) {
            throw new Surface.OutOfResourcesException("Couldn't allocate SurfaceControl native object");
        }
        this.mCloseGuard.open("release");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            if (this.mNativeObject != 0L) {
                SurfaceControl.nativeRelease(this.mNativeObject);
            }
        }
        finally {
            super.finalize();
        }
    }

    public String toString() {
        return "Surface(name=" + this.mName + ")";
    }

    public void release() {
        if (this.mNativeObject != 0L) {
            SurfaceControl.nativeRelease(this.mNativeObject);
            this.mNativeObject = 0L;
        }
        this.mCloseGuard.close();
    }

    public void destroy() {
        if (this.mNativeObject != 0L) {
            SurfaceControl.nativeDestroy(this.mNativeObject);
            this.mNativeObject = 0L;
        }
        this.mCloseGuard.close();
    }

    private void checkNotReleased() {
        if (this.mNativeObject == 0L) {
            throw new NullPointerException("mNativeObject is null. Have you called release() already?");
        }
    }

    public static void openTransaction() {
        SurfaceControl.nativeOpenTransaction();
    }

    public static void closeTransaction() {
        SurfaceControl.nativeCloseTransaction();
    }

    public static void setAnimationTransaction() {
        SurfaceControl.nativeSetAnimationTransaction();
    }

    public void setLayer(int zorder) {
        this.checkNotReleased();
        SurfaceControl.nativeSetLayer(this.mNativeObject, zorder);
    }

    public void setPosition(float x, float y) {
        this.checkNotReleased();
        SurfaceControl.nativeSetPosition(this.mNativeObject, x, y);
    }

    public void setSize(int w, int h) {
        this.checkNotReleased();
        SurfaceControl.nativeSetSize(this.mNativeObject, w, h);
    }

    public void hide() {
        this.checkNotReleased();
        SurfaceControl.nativeSetFlags(this.mNativeObject, 1, 1);
    }

    public void show() {
        this.checkNotReleased();
        SurfaceControl.nativeSetFlags(this.mNativeObject, 0, 1);
    }

    public void setTransparentRegionHint(Region region) {
        this.checkNotReleased();
        SurfaceControl.nativeSetTransparentRegionHint(this.mNativeObject, region);
    }

    public void setAlpha(float alpha) {
        this.checkNotReleased();
        SurfaceControl.nativeSetAlpha(this.mNativeObject, alpha);
    }

    public void setMatrix(float dsdx, float dtdx, float dsdy, float dtdy) {
        this.checkNotReleased();
        SurfaceControl.nativeSetMatrix(this.mNativeObject, dsdx, dtdx, dsdy, dtdy);
    }

    public void setFlags(int flags, int mask) {
        this.checkNotReleased();
        SurfaceControl.nativeSetFlags(this.mNativeObject, flags, mask);
    }

    public void setWindowCrop(Rect crop) {
        this.checkNotReleased();
        if (crop != null) {
            SurfaceControl.nativeSetWindowCrop(this.mNativeObject, crop.left, crop.top, crop.right, crop.bottom);
        } else {
            SurfaceControl.nativeSetWindowCrop(this.mNativeObject, 0, 0, 0, 0);
        }
    }

    public void setLayerStack(int layerStack) {
        this.checkNotReleased();
        SurfaceControl.nativeSetLayerStack(this.mNativeObject, layerStack);
    }

    public void setOpaque(boolean isOpaque) {
        this.checkNotReleased();
        if (isOpaque) {
            SurfaceControl.nativeSetFlags(this.mNativeObject, 2, 2);
        } else {
            SurfaceControl.nativeSetFlags(this.mNativeObject, 0, 2);
        }
    }

    public static void unblankDisplay(IBinder displayToken) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        SurfaceControl.nativeUnblankDisplay(displayToken);
    }

    public static void blankDisplay(IBinder displayToken) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        SurfaceControl.nativeBlankDisplay(displayToken);
    }

    public static boolean getDisplayInfo(IBinder displayToken, PhysicalDisplayInfo outInfo) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        if (outInfo == null) {
            throw new IllegalArgumentException("outInfo must not be null");
        }
        return SurfaceControl.nativeGetDisplayInfo(displayToken, outInfo);
    }

    public static void setDisplayProjection(IBinder displayToken, int orientation, Rect layerStackRect, Rect displayRect) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        if (layerStackRect == null) {
            throw new IllegalArgumentException("layerStackRect must not be null");
        }
        if (displayRect == null) {
            throw new IllegalArgumentException("displayRect must not be null");
        }
        SurfaceControl.nativeSetDisplayProjection(displayToken, orientation, layerStackRect.left, layerStackRect.top, layerStackRect.right, layerStackRect.bottom, displayRect.left, displayRect.top, displayRect.right, displayRect.bottom);
    }

    public static void setDisplayLayerStack(IBinder displayToken, int layerStack) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        SurfaceControl.nativeSetDisplayLayerStack(displayToken, layerStack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDisplaySurface(IBinder displayToken, Surface surface) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        if (surface != null) {
            Object object = surface.mLock;
            synchronized (object) {
                SurfaceControl.nativeSetDisplaySurface(displayToken, surface.mNativeObject);
            }
        } else {
            SurfaceControl.nativeSetDisplaySurface(displayToken, 0L);
        }
    }

    public static IBinder createDisplay(String name, boolean secure) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        return SurfaceControl.nativeCreateDisplay(name, secure);
    }

    public static void destroyDisplay(IBinder displayToken) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        SurfaceControl.nativeDestroyDisplay(displayToken);
    }

    public static IBinder getBuiltInDisplay(int builtInDisplayId) {
        return SurfaceControl.nativeGetBuiltInDisplay(builtInDisplayId);
    }

    public static void screenshot(IBinder display, Surface consumer, int width, int height, int minLayer, int maxLayer) {
        SurfaceControl.screenshot(display, consumer, width, height, minLayer, maxLayer, false);
    }

    public static void screenshot(IBinder display, Surface consumer, int width, int height) {
        SurfaceControl.screenshot(display, consumer, width, height, 0, 0, true);
    }

    public static void screenshot(IBinder display, Surface consumer) {
        SurfaceControl.screenshot(display, consumer, 0, 0, 0, 0, true);
    }

    public static Bitmap screenshot(int width, int height, int minLayer, int maxLayer) {
        IBinder displayToken = SurfaceControl.getBuiltInDisplay(0);
        return SurfaceControl.nativeScreenshot(displayToken, width, height, minLayer, maxLayer, false);
    }

    public static Bitmap screenshot(int width, int height) {
        IBinder displayToken = SurfaceControl.getBuiltInDisplay(0);
        return SurfaceControl.nativeScreenshot(displayToken, width, height, 0, 0, true);
    }

    private static void screenshot(IBinder display, Surface consumer, int width, int height, int minLayer, int maxLayer, boolean allLayers) {
        if (display == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        if (consumer == null) {
            throw new IllegalArgumentException("consumer must not be null");
        }
        SurfaceControl.nativeScreenshot(display, consumer, width, height, minLayer, maxLayer, allLayers);
    }

    public static class PhysicalDisplayInfo {
        public int width;
        public int height;
        public float refreshRate;
        public float density;
        public float xDpi;
        public float yDpi;
        public boolean secure;

        public PhysicalDisplayInfo() {
        }

        public PhysicalDisplayInfo(PhysicalDisplayInfo other) {
            this.copyFrom(other);
        }

        public boolean equals(Object o) {
            return o instanceof PhysicalDisplayInfo && this.equals((PhysicalDisplayInfo)o);
        }

        public boolean equals(PhysicalDisplayInfo other) {
            return other != null && this.width == other.width && this.height == other.height && this.refreshRate == other.refreshRate && this.density == other.density && this.xDpi == other.xDpi && this.yDpi == other.yDpi && this.secure == other.secure;
        }

        public int hashCode() {
            return 0;
        }

        public void copyFrom(PhysicalDisplayInfo other) {
            this.width = other.width;
            this.height = other.height;
            this.refreshRate = other.refreshRate;
            this.density = other.density;
            this.xDpi = other.xDpi;
            this.yDpi = other.yDpi;
            this.secure = other.secure;
        }

        public String toString() {
            return "PhysicalDisplayInfo{" + this.width + " x " + this.height + ", " + this.refreshRate + " fps, " + "density " + this.density + ", " + this.xDpi + " x " + this.yDpi + " dpi, secure " + this.secure + "}";
        }
    }
}

