/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.view.DisplayList;
import android.view.GLES20Canvas;
import android.view.GLES20Layer;
import android.view.HardwareCanvas;

class GLES20TextureLayer
extends GLES20Layer {
    private int mTexture;
    private SurfaceTexture mSurface;

    GLES20TextureLayer(boolean isOpaque) {
        int[] layerInfo = new int[2];
        this.mLayer = GLES20Canvas.nCreateTextureLayer(isOpaque, layerInfo);
        if (this.mLayer != 0L) {
            this.mTexture = layerInfo[0];
            this.mFinalizer = new GLES20Layer.Finalizer(this.mLayer);
        } else {
            this.mFinalizer = null;
        }
    }

    boolean isValid() {
        return this.mLayer != 0L && this.mTexture != 0;
    }

    boolean resize(int width, int height) {
        return this.isValid();
    }

    HardwareCanvas getCanvas() {
        return null;
    }

    HardwareCanvas start(Canvas currentCanvas) {
        return null;
    }

    HardwareCanvas start(Canvas currentCanvas, Rect dirty) {
        return null;
    }

    void end(Canvas currentCanvas) {
    }

    SurfaceTexture getSurfaceTexture() {
        if (this.mSurface == null) {
            this.mSurface = new SurfaceTexture(this.mTexture);
        }
        return this.mSurface;
    }

    void setSurfaceTexture(SurfaceTexture surfaceTexture) {
        if (this.mSurface != null) {
            this.mSurface.release();
        }
        this.mSurface = surfaceTexture;
        this.mSurface.attachToGLContext(this.mTexture);
    }

    void update(int width, int height, boolean isOpaque) {
        super.update(width, height, isOpaque);
        GLES20Canvas.nUpdateTextureLayer(this.mLayer, width, height, isOpaque, this.mSurface);
    }

    void setOpaque(boolean isOpaque) {
        throw new UnsupportedOperationException("Use update(int, int, boolean) instead");
    }

    void setTransform(Matrix matrix) {
        GLES20Canvas.nSetTextureLayerTransform(this.mLayer, matrix.native_instance);
    }

    void redrawLater(DisplayList displayList, Rect dirtyRect) {
    }
}

