/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Bitmap;
import android.graphics.Paint;
import android.view.GLES20Canvas;
import android.view.HardwareLayer;

abstract class GLES20Layer
extends HardwareLayer {
    long mLayer;
    Finalizer mFinalizer;

    GLES20Layer() {
    }

    GLES20Layer(int width, int height, boolean opaque) {
        super(width, height, opaque);
    }

    public long getLayer() {
        return this.mLayer;
    }

    void setLayerPaint(Paint paint) {
        if (paint != null) {
            GLES20Canvas.nSetLayerPaint(this.mLayer, paint.mNativePaint);
            GLES20Canvas.nSetLayerColorFilter(this.mLayer, paint.getColorFilter() != null ? paint.getColorFilter().nativeColorFilter : 0L);
        }
    }

    public boolean copyInto(Bitmap bitmap) {
        return GLES20Canvas.nCopyLayer(this.mLayer, bitmap.mNativeBitmap);
    }

    public void destroy() {
        if (this.mDisplayList != null) {
            this.mDisplayList.reset();
        }
        if (this.mFinalizer != null) {
            this.mFinalizer.destroy();
            this.mFinalizer = null;
        }
        this.mLayer = 0L;
    }

    void clearStorage() {
        if (this.mLayer != 0L) {
            GLES20Canvas.nClearLayerTexture(this.mLayer);
        }
    }

    static class Finalizer {
        private long mLayerId;

        public Finalizer(long layerId) {
            this.mLayerId = layerId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                if (this.mLayerId != 0L) {
                    GLES20Canvas.nDestroyLayerDeferred(this.mLayerId);
                }
            }
            finally {
                super.finalize();
            }
        }

        void destroy() {
            GLES20Canvas.nDestroyLayer(this.mLayerId);
            this.mLayerId = 0L;
        }
    }
}

