/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Matrix;
import android.view.DisplayList;
import android.view.GLES20RecordingCanvas;
import android.view.HardwareCanvas;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GLES20DisplayList
extends DisplayList {
    private ArrayList<DisplayList> mChildDisplayLists;
    private GLES20RecordingCanvas mCanvas;
    private boolean mValid;
    private final String mName;
    private DisplayListFinalizer mFinalizer;

    GLES20DisplayList(String name) {
        this.mName = name;
    }

    boolean hasNativeDisplayList() {
        return this.mValid && this.mFinalizer != null;
    }

    long getNativeDisplayList() {
        if (!this.mValid || this.mFinalizer == null) {
            throw new IllegalStateException("The display list is not valid.");
        }
        return this.mFinalizer.mNativeDisplayList;
    }

    @Override
    public HardwareCanvas start(int width, int height) {
        if (this.mCanvas != null) {
            throw new IllegalStateException("Recording has already started");
        }
        this.mValid = false;
        this.mCanvas = GLES20RecordingCanvas.obtain(this);
        this.mCanvas.start();
        this.mCanvas.setViewport(width, height);
        this.mCanvas.onPreDraw(null);
        return this.mCanvas;
    }

    @Override
    public void clear() {
        this.clearDirty();
        if (this.mCanvas != null) {
            this.mCanvas.recycle();
            this.mCanvas = null;
        }
        this.mValid = false;
        this.clearReferences();
    }

    void clearReferences() {
        if (this.mChildDisplayLists != null) {
            this.mChildDisplayLists.clear();
        }
    }

    ArrayList<DisplayList> getChildDisplayLists() {
        if (this.mChildDisplayLists == null) {
            this.mChildDisplayLists = new ArrayList();
        }
        return this.mChildDisplayLists;
    }

    @Override
    public void reset() {
        if (this.hasNativeDisplayList()) {
            GLES20DisplayList.nReset(this.mFinalizer.mNativeDisplayList);
        }
        this.clear();
    }

    @Override
    public boolean isValid() {
        return this.mValid;
    }

    @Override
    public void end() {
        if (this.mCanvas != null) {
            this.mCanvas.onPostDraw();
            if (this.mFinalizer != null) {
                this.mCanvas.end(this.mFinalizer.mNativeDisplayList);
            } else {
                this.mFinalizer = new DisplayListFinalizer(this.mCanvas.end(0L));
                GLES20DisplayList.nSetDisplayListName(this.mFinalizer.mNativeDisplayList, this.mName);
            }
            this.mCanvas.recycle();
            this.mCanvas = null;
            this.mValid = true;
        }
    }

    @Override
    public int getSize() {
        if (this.mFinalizer == null) {
            return 0;
        }
        return GLES20DisplayList.nGetDisplayListSize(this.mFinalizer.mNativeDisplayList);
    }

    private static void nDestroyDisplayList(long l) {
        OverrideMethod.invokeV("android.view.GLES20DisplayList#nDestroyDisplayList(J)V", true, null);
    }

    private static int nGetDisplayListSize(long l) {
        return OverrideMethod.invokeI("android.view.GLES20DisplayList#nGetDisplayListSize(J)I", true, null);
    }

    private static void nSetDisplayListName(long l, String string2) {
        OverrideMethod.invokeV("android.view.GLES20DisplayList#nSetDisplayListName(JLjava/lang/String;)V", true, null);
    }

    @Override
    public void setCaching(boolean caching) {
        if (this.hasNativeDisplayList()) {
            GLES20DisplayList.nSetCaching(this.mFinalizer.mNativeDisplayList, caching);
        }
    }

    @Override
    public void setClipToBounds(boolean clipToBounds) {
        if (this.hasNativeDisplayList()) {
            GLES20DisplayList.nSetClipToBounds(this.mFinalizer.mNativeDisplayList, clipToBounds);
        }
    }

    @Override
    public void setMatrix(Matrix matrix) {
        if (this.hasNativeDisplayList()) {
            GLES20DisplayList.nSetStaticMatrix(this.mFinalizer.mNativeDisplayList, matrix.native_instance);
        }
    }

    @Override
    public Matrix getMatrix(Matrix matrix) {
        if (this.hasNativeDisplayList()) {
            GLES20DisplayList.nGetMatrix(this.mFinalizer.mNativeDisplayList, matrix.native_instance);
        }
        return matrix;
    }

    @Override
    public void setAnimationMatrix(Matrix matrix) {
        if (this.hasNativeDisplayList()) {
            GLES20DisplayList.nSetAnimationMatrix(this.mFinalizer.mNativeDisplayList, matrix != null ? matrix.native_instance : 0L);
        }
    }

    @Override
    public void setAlpha(float alpha) {
        if (this.hasNativeDisplayList()) {
            GLES20DisplayList.nSetAlpha(this.mFinalizer.mNativeDisplayList, alpha);
        }
    }

    @Override
    public float getAlpha() {
        if (this.hasNativeDisplayList()) {
            return GLES20DisplayList.nGetAlpha(this.mFinalizer.mNativeDisplayList);
        }
        return 1.0f;
    }

    @Override
    public void setHasOverlappingRendering(boolean hasOverlappingRendering) {
        if (this.hasNativeDisplayList()) {
            GLES20DisplayList.nSetHasOverlappingRendering(this.mFinalizer.mNativeDisplayList, hasOverlappingRendering);
        }
    }

    @Override
    public boolean hasOverlappingRendering() {
        if (this.hasNativeDisplayList()) {
            return GLES20DisplayList.nHasOverlappingRendering(this.mFinalizer.mNativeDisplayList);
        }
        return true;
    }

    @Override
    public void setTranslationX(float translationX) {
        if (this.hasNativeDisplayList()) {
            GLES20DisplayList.nSetTranslationX(this.mFinalizer.mNativeDisplayList, translationX);
        }
    }

    @Override
    public float getTranslationX() {
        if (this.hasNativeDisplayList()) {
            return GLES20DisplayList.nGetTranslationX(this.mFinalizer.mNativeDisplayList);
        }
        return 0.0f;
    }

    @Override
    public void setTranslationY(float translationY) {
        if (this.hasNativeDisplayList()) {
            GLES20DisplayList.nSetTranslationY(this.mFinalizer.mNativeDisplayList, translationY);
        }
    }

    @Override
    public float getTranslationY() {
        if (this.hasNativeDisplayList()) {
            return GLES20DisplayList.nGetTranslationY(this.mFinalizer.mNativeDisplayList);
        }
        return 0.0f;
    }

    @Override
    public void setRotation(float rotation) {
        if (this.hasNativeDisplayList()) {
            GLES20DisplayList.nSetRotation(this.mFinalizer.mNativeDisplayList, rotation);
        }
    }

    @Override
    public float getRotation() {
        if (this.hasNativeDisplayList()) {
            return GLES20DisplayList.nGetRotation(this.mFinalizer.mNativeDisplayList);
        }
        return 0.0f;
    }

    @Override
    public void setRotationX(float rotationX) {
        if (this.hasNativeDisplayList()) {
            GLES20DisplayList.nSetRotationX(this.mFinalizer.mNativeDisplayList, rotationX);
        }
    }

    @Override
    public float getRotationX() {
        if (this.hasNativeDisplayList()) {
            return GLES20DisplayList.nGetRotationX(this.mFinalizer.mNativeDisplayList);
        }
        return 0.0f;
    }

    @Override
    public void setRotationY(float rotationY) {
        if (this.hasNativeDisplayList()) {
            GLES20DisplayList.nSetRotationY(this.mFinalizer.mNativeDisplayList, rotationY);
        }
    }

    @Override
    public float getRotationY() {
        if (this.hasNativeDisplayList()) {
            return GLES20DisplayList.nGetRotationY(this.mFinalizer.mNativeDisplayList);
        }
        return 0.0f;
    }

    @Override
    public void setScaleX(float scaleX) {
        if (this.hasNativeDisplayList()) {
            GLES20DisplayList.nSetScaleX(this.mFinalizer.mNativeDisplayList, scaleX);
        }
    }

    @Override
    public float getScaleX() {
        if (this.hasNativeDisplayList()) {
            return GLES20DisplayList.nGetScaleX(this.mFinalizer.mNativeDisplayList);
        }
        return 1.0f;
    }

    @Override
    public void setScaleY(float scaleY) {
        if (this.hasNativeDisplayList()) {
            GLES20DisplayList.nSetScaleY(this.mFinalizer.mNativeDisplayList, scaleY);
        }
    }

    @Override
    public float getScaleY() {
        if (this.hasNativeDisplayList()) {
            return GLES20DisplayList.nGetScaleY(this.mFinalizer.mNativeDisplayList);
        }
        return 1.0f;
    }

    @Override
    public void setTransformationInfo(float alpha, float translationX, float translationY, float rotation, float rotationX, float rotationY, float scaleX, float scaleY) {
        if (this.hasNativeDisplayList()) {
            GLES20DisplayList.nSetTransformationInfo(this.mFinalizer.mNativeDisplayList, alpha, translationX, translationY, rotation, rotationX, rotationY, scaleX, scaleY);
        }
    }

    @Override
    public void setPivotX(float pivotX) {
        if (this.hasNativeDisplayList()) {
            GLES20DisplayList.nSetPivotX(this.mFinalizer.mNativeDisplayList, pivotX);
        }
    }

    @Override
    public float getPivotX() {
        if (this.hasNativeDisplayList()) {
            return GLES20DisplayList.nGetPivotX(this.mFinalizer.mNativeDisplayList);
        }
        return 0.0f;
    }

    @Override
    public void setPivotY(float pivotY) {
        if (this.hasNativeDisplayList()) {
            GLES20DisplayList.nSetPivotY(this.mFinalizer.mNativeDisplayList, pivotY);
        }
    }

    @Override
    public float getPivotY() {
        if (this.hasNativeDisplayList()) {
            return GLES20DisplayList.nGetPivotY(this.mFinalizer.mNativeDisplayList);
        }
        return 0.0f;
    }

    @Override
    public void setCameraDistance(float distance) {
        if (this.hasNativeDisplayList()) {
            GLES20DisplayList.nSetCameraDistance(this.mFinalizer.mNativeDisplayList, distance);
        }
    }

    @Override
    public float getCameraDistance() {
        if (this.hasNativeDisplayList()) {
            return GLES20DisplayList.nGetCameraDistance(this.mFinalizer.mNativeDisplayList);
        }
        return 0.0f;
    }

    @Override
    public void setLeft(int left) {
        if (this.hasNativeDisplayList()) {
            GLES20DisplayList.nSetLeft(this.mFinalizer.mNativeDisplayList, left);
        }
    }

    @Override
    public float getLeft() {
        if (this.hasNativeDisplayList()) {
            return GLES20DisplayList.nGetLeft(this.mFinalizer.mNativeDisplayList);
        }
        return 0.0f;
    }

    @Override
    public void setTop(int top) {
        if (this.hasNativeDisplayList()) {
            GLES20DisplayList.nSetTop(this.mFinalizer.mNativeDisplayList, top);
        }
    }

    @Override
    public float getTop() {
        if (this.hasNativeDisplayList()) {
            return GLES20DisplayList.nGetTop(this.mFinalizer.mNativeDisplayList);
        }
        return 0.0f;
    }

    @Override
    public void setRight(int right) {
        if (this.hasNativeDisplayList()) {
            GLES20DisplayList.nSetRight(this.mFinalizer.mNativeDisplayList, right);
        }
    }

    @Override
    public float getRight() {
        if (this.hasNativeDisplayList()) {
            return GLES20DisplayList.nGetRight(this.mFinalizer.mNativeDisplayList);
        }
        return 0.0f;
    }

    @Override
    public void setBottom(int bottom) {
        if (this.hasNativeDisplayList()) {
            GLES20DisplayList.nSetBottom(this.mFinalizer.mNativeDisplayList, bottom);
        }
    }

    @Override
    public float getBottom() {
        if (this.hasNativeDisplayList()) {
            return GLES20DisplayList.nGetBottom(this.mFinalizer.mNativeDisplayList);
        }
        return 0.0f;
    }

    @Override
    public void setLeftTopRightBottom(int left, int top, int right, int bottom) {
        if (this.hasNativeDisplayList()) {
            GLES20DisplayList.nSetLeftTopRightBottom(this.mFinalizer.mNativeDisplayList, left, top, right, bottom);
        }
    }

    @Override
    public void offsetLeftAndRight(float offset) {
        if (this.hasNativeDisplayList()) {
            GLES20DisplayList.nOffsetLeftAndRight(this.mFinalizer.mNativeDisplayList, offset);
        }
    }

    @Override
    public void offsetTopAndBottom(float offset) {
        if (this.hasNativeDisplayList()) {
            GLES20DisplayList.nOffsetTopAndBottom(this.mFinalizer.mNativeDisplayList, offset);
        }
    }

    private static void nReset(long l) {
        OverrideMethod.invokeV("android.view.GLES20DisplayList#nReset(J)V", true, null);
    }

    private static void nOffsetTopAndBottom(long l, float f) {
        OverrideMethod.invokeV("android.view.GLES20DisplayList#nOffsetTopAndBottom(JF)V", true, null);
    }

    private static void nOffsetLeftAndRight(long l, float f) {
        OverrideMethod.invokeV("android.view.GLES20DisplayList#nOffsetLeftAndRight(JF)V", true, null);
    }

    private static void nSetLeftTopRightBottom(long l, int n, int n2, int n3, int n4) {
        OverrideMethod.invokeV("android.view.GLES20DisplayList#nSetLeftTopRightBottom(JIIII)V", true, null);
    }

    private static void nSetBottom(long l, int n) {
        OverrideMethod.invokeV("android.view.GLES20DisplayList#nSetBottom(JI)V", true, null);
    }

    private static void nSetRight(long l, int n) {
        OverrideMethod.invokeV("android.view.GLES20DisplayList#nSetRight(JI)V", true, null);
    }

    private static void nSetTop(long l, int n) {
        OverrideMethod.invokeV("android.view.GLES20DisplayList#nSetTop(JI)V", true, null);
    }

    private static void nSetLeft(long l, int n) {
        OverrideMethod.invokeV("android.view.GLES20DisplayList#nSetLeft(JI)V", true, null);
    }

    private static void nSetCameraDistance(long l, float f) {
        OverrideMethod.invokeV("android.view.GLES20DisplayList#nSetCameraDistance(JF)V", true, null);
    }

    private static void nSetPivotY(long l, float f) {
        OverrideMethod.invokeV("android.view.GLES20DisplayList#nSetPivotY(JF)V", true, null);
    }

    private static void nSetPivotX(long l, float f) {
        OverrideMethod.invokeV("android.view.GLES20DisplayList#nSetPivotX(JF)V", true, null);
    }

    private static void nSetCaching(long l, boolean bl) {
        OverrideMethod.invokeV("android.view.GLES20DisplayList#nSetCaching(JZ)V", true, null);
    }

    private static void nSetClipToBounds(long l, boolean bl) {
        OverrideMethod.invokeV("android.view.GLES20DisplayList#nSetClipToBounds(JZ)V", true, null);
    }

    private static void nSetAlpha(long l, float f) {
        OverrideMethod.invokeV("android.view.GLES20DisplayList#nSetAlpha(JF)V", true, null);
    }

    private static void nSetHasOverlappingRendering(long l, boolean bl) {
        OverrideMethod.invokeV("android.view.GLES20DisplayList#nSetHasOverlappingRendering(JZ)V", true, null);
    }

    private static void nSetTranslationX(long l, float f) {
        OverrideMethod.invokeV("android.view.GLES20DisplayList#nSetTranslationX(JF)V", true, null);
    }

    private static void nSetTranslationY(long l, float f) {
        OverrideMethod.invokeV("android.view.GLES20DisplayList#nSetTranslationY(JF)V", true, null);
    }

    private static void nSetRotation(long l, float f) {
        OverrideMethod.invokeV("android.view.GLES20DisplayList#nSetRotation(JF)V", true, null);
    }

    private static void nSetRotationX(long l, float f) {
        OverrideMethod.invokeV("android.view.GLES20DisplayList#nSetRotationX(JF)V", true, null);
    }

    private static void nSetRotationY(long l, float f) {
        OverrideMethod.invokeV("android.view.GLES20DisplayList#nSetRotationY(JF)V", true, null);
    }

    private static void nSetScaleX(long l, float f) {
        OverrideMethod.invokeV("android.view.GLES20DisplayList#nSetScaleX(JF)V", true, null);
    }

    private static void nSetScaleY(long l, float f) {
        OverrideMethod.invokeV("android.view.GLES20DisplayList#nSetScaleY(JF)V", true, null);
    }

    private static void nSetTransformationInfo(long l, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        OverrideMethod.invokeV("android.view.GLES20DisplayList#nSetTransformationInfo(JFFFFFFFF)V", true, null);
    }

    private static void nSetStaticMatrix(long l, long l2) {
        OverrideMethod.invokeV("android.view.GLES20DisplayList#nSetStaticMatrix(JJ)V", true, null);
    }

    private static void nSetAnimationMatrix(long l, long l2) {
        OverrideMethod.invokeV("android.view.GLES20DisplayList#nSetAnimationMatrix(JJ)V", true, null);
    }

    private static boolean nHasOverlappingRendering(long l) {
        return OverrideMethod.invokeI("android.view.GLES20DisplayList#nHasOverlappingRendering(J)Z", true, null) != 0;
    }

    private static void nGetMatrix(long l, long l2) {
        OverrideMethod.invokeV("android.view.GLES20DisplayList#nGetMatrix(JJ)V", true, null);
    }

    private static float nGetAlpha(long l) {
        return OverrideMethod.invokeF("android.view.GLES20DisplayList#nGetAlpha(J)F", true, null);
    }

    private static float nGetLeft(long l) {
        return OverrideMethod.invokeF("android.view.GLES20DisplayList#nGetLeft(J)F", true, null);
    }

    private static float nGetTop(long l) {
        return OverrideMethod.invokeF("android.view.GLES20DisplayList#nGetTop(J)F", true, null);
    }

    private static float nGetRight(long l) {
        return OverrideMethod.invokeF("android.view.GLES20DisplayList#nGetRight(J)F", true, null);
    }

    private static float nGetBottom(long l) {
        return OverrideMethod.invokeF("android.view.GLES20DisplayList#nGetBottom(J)F", true, null);
    }

    private static float nGetCameraDistance(long l) {
        return OverrideMethod.invokeF("android.view.GLES20DisplayList#nGetCameraDistance(J)F", true, null);
    }

    private static float nGetScaleX(long l) {
        return OverrideMethod.invokeF("android.view.GLES20DisplayList#nGetScaleX(J)F", true, null);
    }

    private static float nGetScaleY(long l) {
        return OverrideMethod.invokeF("android.view.GLES20DisplayList#nGetScaleY(J)F", true, null);
    }

    private static float nGetTranslationX(long l) {
        return OverrideMethod.invokeF("android.view.GLES20DisplayList#nGetTranslationX(J)F", true, null);
    }

    private static float nGetTranslationY(long l) {
        return OverrideMethod.invokeF("android.view.GLES20DisplayList#nGetTranslationY(J)F", true, null);
    }

    private static float nGetRotation(long l) {
        return OverrideMethod.invokeF("android.view.GLES20DisplayList#nGetRotation(J)F", true, null);
    }

    private static float nGetRotationX(long l) {
        return OverrideMethod.invokeF("android.view.GLES20DisplayList#nGetRotationX(J)F", true, null);
    }

    private static float nGetRotationY(long l) {
        return OverrideMethod.invokeF("android.view.GLES20DisplayList#nGetRotationY(J)F", true, null);
    }

    private static float nGetPivotX(long l) {
        return OverrideMethod.invokeF("android.view.GLES20DisplayList#nGetPivotX(J)F", true, null);
    }

    private static float nGetPivotY(long l) {
        return OverrideMethod.invokeF("android.view.GLES20DisplayList#nGetPivotY(J)F", true, null);
    }

    private static class DisplayListFinalizer {
        final long mNativeDisplayList;

        public DisplayListFinalizer(long nativeDisplayList) {
            this.mNativeDisplayList = nativeDisplayList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                GLES20DisplayList.nDestroyDisplayList(this.mNativeDisplayList);
            }
            finally {
                super.finalize();
            }
        }
    }
}

