/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.DrawFilter;
import android.graphics.Matrix;
import android.graphics.NinePatch;
import android.graphics.Paint;
import android.graphics.PaintFlagsDrawFilter;
import android.graphics.Path;
import android.graphics.Picture;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.Shader;
import android.graphics.SurfaceTexture;
import android.graphics.TemporaryBuffer;
import android.text.GraphicsOperations;
import android.text.SpannableString;
import android.text.SpannedString;
import android.text.TextUtils;
import android.view.DisplayList;
import android.view.GLES20DisplayList;
import android.view.GLES20Layer;
import android.view.GLES20RenderLayer;
import android.view.GraphicBuffer;
import android.view.HardwareCanvas;
import android.view.HardwareLayer;
import com.android.tools.layoutlib.create.OverrideMethod;

class GLES20Canvas
extends HardwareCanvas {
    private static final int MODIFIER_NONE = 0;
    private static final int MODIFIER_SHADOW = 1;
    private static final int MODIFIER_SHADER = 2;
    private static final int MODIFIER_COLOR_FILTER = 4;
    private final boolean mOpaque;
    private long mRenderer;
    private CanvasFinalizer mFinalizer;
    private int mWidth;
    private int mHeight;
    private float[] mPoint;
    private float[] mLine;
    private Rect mClipBounds;
    private RectF mPathBounds;
    private DrawFilter mFilter;
    private static boolean sIsAvailable = GLES20Canvas.nIsAvailable();
    static final int FLUSH_CACHES_LAYERS = 0;
    static final int FLUSH_CACHES_MODERATE = 1;
    static final int FLUSH_CACHES_FULL = 2;

    private static boolean nIsAvailable() {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nIsAvailable()Z", true, null) != 0;
    }

    static boolean isAvailable() {
        return sIsAvailable;
    }

    GLES20Canvas(boolean translucent) {
        this(false, translucent);
    }

    GLES20Canvas(long layer, boolean translucent) {
        this.mOpaque = !translucent;
        this.mRenderer = GLES20Canvas.nCreateLayerRenderer(layer);
        this.setupFinalizer();
    }

    protected GLES20Canvas(boolean record, boolean translucent) {
        this.mOpaque = !translucent;
        this.mRenderer = record ? GLES20Canvas.nCreateDisplayListRenderer() : GLES20Canvas.nCreateRenderer();
        this.setupFinalizer();
    }

    private void setupFinalizer() {
        if (this.mRenderer == 0L) {
            throw new IllegalStateException("Could not create GLES20Canvas renderer");
        }
        this.mFinalizer = new CanvasFinalizer(this.mRenderer);
    }

    protected void resetDisplayListRenderer() {
        GLES20Canvas.nResetDisplayListRenderer(this.mRenderer);
    }

    private static long nCreateRenderer() {
        return OverrideMethod.invokeL("android.view.GLES20Canvas#nCreateRenderer()J", true, null);
    }

    private static long nCreateLayerRenderer(long l) {
        return OverrideMethod.invokeL("android.view.GLES20Canvas#nCreateLayerRenderer(J)J", true, null);
    }

    private static long nCreateDisplayListRenderer() {
        return OverrideMethod.invokeL("android.view.GLES20Canvas#nCreateDisplayListRenderer()J", true, null);
    }

    private static void nResetDisplayListRenderer(long l) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nResetDisplayListRenderer(J)V", true, null);
    }

    private static void nDestroyRenderer(long l) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDestroyRenderer(J)V", true, null);
    }

    public void setName(String name) {
        super.setName(name);
        GLES20Canvas.nSetName(this.mRenderer, name);
    }

    private static void nSetName(long l, String string2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nSetName(JLjava/lang/String;)V", true, null);
    }

    void pushLayerUpdate(HardwareLayer layer) {
        GLES20Canvas.nPushLayerUpdate(this.mRenderer, ((GLES20RenderLayer)layer).mLayer);
    }

    void cancelLayerUpdate(HardwareLayer layer) {
        GLES20Canvas.nCancelLayerUpdate(this.mRenderer, ((GLES20RenderLayer)layer).mLayer);
    }

    void flushLayerUpdates() {
        GLES20Canvas.nFlushLayerUpdates(this.mRenderer);
    }

    void clearLayerUpdates() {
        GLES20Canvas.nClearLayerUpdates(this.mRenderer);
    }

    static long nCreateTextureLayer(boolean bl, int[] nArray) {
        return OverrideMethod.invokeL("android.view.GLES20Canvas#nCreateTextureLayer(Z[I)J", true, null);
    }

    static long nCreateLayer(int n, int n2, boolean bl, int[] nArray) {
        return OverrideMethod.invokeL("android.view.GLES20Canvas#nCreateLayer(IIZ[I)J", true, null);
    }

    static boolean nResizeLayer(long l, int n, int n2, int[] nArray) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nResizeLayer(JII[I)Z", true, null) != 0;
    }

    static void nSetOpaqueLayer(long l, boolean bl) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nSetOpaqueLayer(JZ)V", true, null);
    }

    static void nSetLayerPaint(long l, long l2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nSetLayerPaint(JJ)V", true, null);
    }

    static void nSetLayerColorFilter(long l, long l2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nSetLayerColorFilter(JJ)V", true, null);
    }

    static void nUpdateTextureLayer(long l, int n, int n2, boolean bl, SurfaceTexture surfaceTexture) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nUpdateTextureLayer(JIIZLandroid/graphics/SurfaceTexture;)V", true, null);
    }

    static void nClearLayerTexture(long l) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nClearLayerTexture(J)V", true, null);
    }

    static void nSetTextureLayerTransform(long l, long l2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nSetTextureLayerTransform(JJ)V", true, null);
    }

    static void nDestroyLayer(long l) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDestroyLayer(J)V", true, null);
    }

    static void nDestroyLayerDeferred(long l) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDestroyLayerDeferred(J)V", true, null);
    }

    static void nUpdateRenderLayer(long l, long l2, long l3, int n, int n2, int n3, int n4) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nUpdateRenderLayer(JJJIIII)V", true, null);
    }

    static boolean nCopyLayer(long l, long l2) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nCopyLayer(JJ)Z", true, null) != 0;
    }

    private static void nClearLayerUpdates(long l) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nClearLayerUpdates(J)V", true, null);
    }

    private static void nFlushLayerUpdates(long l) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nFlushLayerUpdates(J)V", true, null);
    }

    private static void nPushLayerUpdate(long l, long l2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nPushLayerUpdate(JJ)V", true, null);
    }

    private static void nCancelLayerUpdate(long l, long l2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nCancelLayerUpdate(JJ)V", true, null);
    }

    public boolean isOpaque() {
        return this.mOpaque;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public int getMaximumBitmapWidth() {
        return GLES20Canvas.nGetMaximumTextureWidth();
    }

    public int getMaximumBitmapHeight() {
        return GLES20Canvas.nGetMaximumTextureHeight();
    }

    private static int nGetMaximumTextureWidth() {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nGetMaximumTextureWidth()I", true, null);
    }

    private static int nGetMaximumTextureHeight() {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nGetMaximumTextureHeight()I", true, null);
    }

    long getRenderer() {
        return this.mRenderer;
    }

    public void setViewport(int width, int height) {
        this.mWidth = width;
        this.mHeight = height;
        GLES20Canvas.nSetViewport(this.mRenderer, width, height);
    }

    private static void nSetViewport(long l, int n, int n2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nSetViewport(JII)V", true, null);
    }

    public int onPreDraw(Rect dirty) {
        if (dirty != null) {
            return GLES20Canvas.nPrepareDirty(this.mRenderer, dirty.left, dirty.top, dirty.right, dirty.bottom, this.mOpaque);
        }
        return GLES20Canvas.nPrepare(this.mRenderer, this.mOpaque);
    }

    private static int nPrepare(long l, boolean bl) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nPrepare(JZ)I", true, null);
    }

    private static int nPrepareDirty(long l, int n, int n2, int n3, int n4, boolean bl) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nPrepareDirty(JIIIIZ)I", true, null);
    }

    public void onPostDraw() {
        GLES20Canvas.nFinish(this.mRenderer);
    }

    private static void nFinish(long l) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nFinish(J)V", true, null);
    }

    public static int getStencilSize() {
        return GLES20Canvas.nGetStencilSize();
    }

    private static int nGetStencilSize() {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nGetStencilSize()I", true, null);
    }

    void setCountOverdrawEnabled(boolean enabled) {
        GLES20Canvas.nSetCountOverdrawEnabled(this.mRenderer, enabled);
    }

    static void nSetCountOverdrawEnabled(long l, boolean bl) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nSetCountOverdrawEnabled(JZ)V", true, null);
    }

    float getOverdraw() {
        return GLES20Canvas.nGetOverdraw(this.mRenderer);
    }

    static float nGetOverdraw(long l) {
        return OverrideMethod.invokeF("android.view.GLES20Canvas#nGetOverdraw(J)F", true, null);
    }

    public int callDrawGLFunction(long drawGLFunction) {
        return GLES20Canvas.nCallDrawGLFunction(this.mRenderer, drawGLFunction);
    }

    private static int nCallDrawGLFunction(long l, long l2) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nCallDrawGLFunction(JJ)I", true, null);
    }

    public int invokeFunctors(Rect dirty) {
        return GLES20Canvas.nInvokeFunctors(this.mRenderer, dirty);
    }

    private static int nInvokeFunctors(long l, Rect rect) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nInvokeFunctors(JLandroid/graphics/Rect;)I", true, null);
    }

    public void detachFunctor(long functor) {
        GLES20Canvas.nDetachFunctor(this.mRenderer, functor);
    }

    private static void nDetachFunctor(long l, long l2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDetachFunctor(JJ)V", true, null);
    }

    public void attachFunctor(long functor) {
        GLES20Canvas.nAttachFunctor(this.mRenderer, functor);
    }

    private static void nAttachFunctor(long l, long l2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nAttachFunctor(JJ)V", true, null);
    }

    static void flushCaches(int level) {
        GLES20Canvas.nFlushCaches(level);
    }

    private static void nFlushCaches(int n) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nFlushCaches(I)V", true, null);
    }

    static void terminateCaches() {
        GLES20Canvas.nTerminateCaches();
    }

    private static void nTerminateCaches() {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nTerminateCaches()V", true, null);
    }

    static boolean initCaches() {
        return GLES20Canvas.nInitCaches();
    }

    private static boolean nInitCaches() {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nInitCaches()Z", true, null) != 0;
    }

    static void initAtlas(GraphicBuffer buffer, int[] map) {
        GLES20Canvas.nInitAtlas(buffer, map, map.length);
    }

    private static void nInitAtlas(GraphicBuffer graphicBuffer, int[] nArray, int n) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nInitAtlas(Landroid/view/GraphicBuffer;[II)V", true, null);
    }

    long getDisplayList(long displayList) {
        return GLES20Canvas.nGetDisplayList(this.mRenderer, displayList);
    }

    private static long nGetDisplayList(long l, long l2) {
        return OverrideMethod.invokeL("android.view.GLES20Canvas#nGetDisplayList(JJ)J", true, null);
    }

    void outputDisplayList(DisplayList displayList) {
        GLES20Canvas.nOutputDisplayList(this.mRenderer, ((GLES20DisplayList)displayList).getNativeDisplayList());
    }

    private static void nOutputDisplayList(long l, long l2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nOutputDisplayList(JJ)V", true, null);
    }

    public int drawDisplayList(DisplayList displayList, Rect dirty, int flags) {
        return GLES20Canvas.nDrawDisplayList(this.mRenderer, ((GLES20DisplayList)displayList).getNativeDisplayList(), dirty, flags);
    }

    private static int nDrawDisplayList(long l, long l2, Rect rect, int n) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nDrawDisplayList(JJLandroid/graphics/Rect;I)I", true, null);
    }

    void drawHardwareLayer(HardwareLayer layer, float x, float y, Paint paint) {
        layer.setLayerPaint(paint);
        GLES20Layer glLayer = (GLES20Layer)layer;
        GLES20Canvas.nDrawLayer(this.mRenderer, glLayer.getLayer(), x, y);
    }

    private static void nDrawLayer(long l, long l2, float f, float f2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawLayer(JJFF)V", true, null);
    }

    void interrupt() {
        GLES20Canvas.nInterrupt(this.mRenderer);
    }

    void resume() {
        GLES20Canvas.nResume(this.mRenderer);
    }

    private static void nInterrupt(long l) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nInterrupt(J)V", true, null);
    }

    private static void nResume(long l) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nResume(J)V", true, null);
    }

    private Rect getInternalClipBounds() {
        if (this.mClipBounds == null) {
            this.mClipBounds = new Rect();
        }
        return this.mClipBounds;
    }

    private RectF getPathBounds() {
        if (this.mPathBounds == null) {
            this.mPathBounds = new RectF();
        }
        return this.mPathBounds;
    }

    private float[] getPointStorage() {
        if (this.mPoint == null) {
            this.mPoint = new float[2];
        }
        return this.mPoint;
    }

    private float[] getLineStorage() {
        if (this.mLine == null) {
            this.mLine = new float[4];
        }
        return this.mLine;
    }

    public boolean clipPath(Path path) {
        return GLES20Canvas.nClipPath(this.mRenderer, path.mNativePath, Region.Op.INTERSECT.nativeInt);
    }

    public boolean clipPath(Path path, Region.Op op) {
        return GLES20Canvas.nClipPath(this.mRenderer, path.mNativePath, op.nativeInt);
    }

    private static boolean nClipPath(long l, long l2, int n) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nClipPath(JJI)Z", true, null) != 0;
    }

    public boolean clipRect(float left, float top, float right, float bottom) {
        return GLES20Canvas.nClipRect(this.mRenderer, left, top, right, bottom, Region.Op.INTERSECT.nativeInt);
    }

    private static boolean nClipRect(long l, float f, float f2, float f3, float f4, int n) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nClipRect(JFFFFI)Z", true, null) != 0;
    }

    public boolean clipRect(float left, float top, float right, float bottom, Region.Op op) {
        return GLES20Canvas.nClipRect(this.mRenderer, left, top, right, bottom, op.nativeInt);
    }

    public boolean clipRect(int left, int top, int right, int bottom) {
        return GLES20Canvas.nClipRect(this.mRenderer, left, top, right, bottom, Region.Op.INTERSECT.nativeInt);
    }

    private static boolean nClipRect(long l, int n, int n2, int n3, int n4, int n5) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nClipRect(JIIIII)Z", true, null) != 0;
    }

    public boolean clipRect(Rect rect) {
        return GLES20Canvas.nClipRect(this.mRenderer, rect.left, rect.top, rect.right, rect.bottom, Region.Op.INTERSECT.nativeInt);
    }

    public boolean clipRect(Rect rect, Region.Op op) {
        return GLES20Canvas.nClipRect(this.mRenderer, rect.left, rect.top, rect.right, rect.bottom, op.nativeInt);
    }

    public boolean clipRect(RectF rect) {
        return GLES20Canvas.nClipRect(this.mRenderer, rect.left, rect.top, rect.right, rect.bottom, Region.Op.INTERSECT.nativeInt);
    }

    public boolean clipRect(RectF rect, Region.Op op) {
        return GLES20Canvas.nClipRect(this.mRenderer, rect.left, rect.top, rect.right, rect.bottom, op.nativeInt);
    }

    public boolean clipRegion(Region region) {
        return GLES20Canvas.nClipRegion(this.mRenderer, region.mNativeRegion, Region.Op.INTERSECT.nativeInt);
    }

    public boolean clipRegion(Region region, Region.Op op) {
        return GLES20Canvas.nClipRegion(this.mRenderer, region.mNativeRegion, op.nativeInt);
    }

    private static boolean nClipRegion(long l, long l2, int n) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nClipRegion(JJI)Z", true, null) != 0;
    }

    public boolean getClipBounds(Rect bounds) {
        return GLES20Canvas.nGetClipBounds(this.mRenderer, bounds);
    }

    private static boolean nGetClipBounds(long l, Rect rect) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nGetClipBounds(JLandroid/graphics/Rect;)Z", true, null) != 0;
    }

    public boolean quickReject(float left, float top, float right, float bottom, Canvas.EdgeType type) {
        return GLES20Canvas.nQuickReject(this.mRenderer, left, top, right, bottom);
    }

    private static boolean nQuickReject(long l, float f, float f2, float f3, float f4) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nQuickReject(JFFFF)Z", true, null) != 0;
    }

    public boolean quickReject(Path path, Canvas.EdgeType type) {
        RectF pathBounds = this.getPathBounds();
        path.computeBounds(pathBounds, true);
        return GLES20Canvas.nQuickReject(this.mRenderer, pathBounds.left, pathBounds.top, pathBounds.right, pathBounds.bottom);
    }

    public boolean quickReject(RectF rect, Canvas.EdgeType type) {
        return GLES20Canvas.nQuickReject(this.mRenderer, rect.left, rect.top, rect.right, rect.bottom);
    }

    public void translate(float dx, float dy) {
        if (dx != 0.0f || dy != 0.0f) {
            GLES20Canvas.nTranslate(this.mRenderer, dx, dy);
        }
    }

    private static void nTranslate(long l, float f, float f2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nTranslate(JFF)V", true, null);
    }

    public void skew(float sx, float sy) {
        GLES20Canvas.nSkew(this.mRenderer, sx, sy);
    }

    private static void nSkew(long l, float f, float f2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nSkew(JFF)V", true, null);
    }

    public void rotate(float degrees) {
        GLES20Canvas.nRotate(this.mRenderer, degrees);
    }

    private static void nRotate(long l, float f) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nRotate(JF)V", true, null);
    }

    public void scale(float sx, float sy) {
        GLES20Canvas.nScale(this.mRenderer, sx, sy);
    }

    private static void nScale(long l, float f, float f2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nScale(JFF)V", true, null);
    }

    public void setMatrix(Matrix matrix) {
        GLES20Canvas.nSetMatrix(this.mRenderer, matrix == null ? 0L : matrix.native_instance);
    }

    private static void nSetMatrix(long l, long l2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nSetMatrix(JJ)V", true, null);
    }

    public void getMatrix(Matrix matrix) {
        GLES20Canvas.nGetMatrix(this.mRenderer, matrix.native_instance);
    }

    private static void nGetMatrix(long l, long l2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nGetMatrix(JJ)V", true, null);
    }

    public void concat(Matrix matrix) {
        if (matrix != null) {
            GLES20Canvas.nConcatMatrix(this.mRenderer, matrix.native_instance);
        }
    }

    private static void nConcatMatrix(long l, long l2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nConcatMatrix(JJ)V", true, null);
    }

    public int save() {
        return GLES20Canvas.nSave(this.mRenderer, 3);
    }

    public int save(int saveFlags) {
        return GLES20Canvas.nSave(this.mRenderer, saveFlags);
    }

    private static int nSave(long l, int n) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nSave(JI)I", true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int saveLayer(RectF bounds, Paint paint, int saveFlags) {
        int count;
        if (bounds != null) {
            return this.saveLayer(bounds.left, bounds.top, bounds.right, bounds.bottom, paint, saveFlags);
        }
        int modifier = paint != null ? this.setupColorFilter(paint) : 0;
        try {
            long nativePaint = paint == null ? 0L : paint.mNativePaint;
            count = GLES20Canvas.nSaveLayer(this.mRenderer, nativePaint, saveFlags);
        }
        finally {
            if (modifier != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifier);
            }
        }
        return count;
    }

    private static int nSaveLayer(long l, long l2, int n) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nSaveLayer(JJI)I", true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int saveLayer(float left, float top, float right, float bottom, Paint paint, int saveFlags) {
        if (left < right && top < bottom) {
            int count;
            int modifier = paint != null ? this.setupColorFilter(paint) : 0;
            try {
                long nativePaint = paint == null ? 0L : paint.mNativePaint;
                count = GLES20Canvas.nSaveLayer(this.mRenderer, left, top, right, bottom, nativePaint, saveFlags);
            }
            finally {
                if (modifier != 0) {
                    GLES20Canvas.nResetModifiers(this.mRenderer, modifier);
                }
            }
            return count;
        }
        return this.save(saveFlags);
    }

    private static int nSaveLayer(long l, float f, float f2, float f3, float f4, long l2, int n) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nSaveLayer(JFFFFJI)I", true, null);
    }

    public int saveLayerAlpha(RectF bounds, int alpha, int saveFlags) {
        if (bounds != null) {
            return this.saveLayerAlpha(bounds.left, bounds.top, bounds.right, bounds.bottom, alpha, saveFlags);
        }
        return GLES20Canvas.nSaveLayerAlpha(this.mRenderer, alpha, saveFlags);
    }

    private static int nSaveLayerAlpha(long l, int n, int n2) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nSaveLayerAlpha(JII)I", true, null);
    }

    public int saveLayerAlpha(float left, float top, float right, float bottom, int alpha, int saveFlags) {
        if (left < right && top < bottom) {
            return GLES20Canvas.nSaveLayerAlpha(this.mRenderer, left, top, right, bottom, alpha, saveFlags);
        }
        return this.save(saveFlags);
    }

    private static int nSaveLayerAlpha(long l, float f, float f2, float f3, float f4, int n, int n2) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nSaveLayerAlpha(JFFFFII)I", true, null);
    }

    public void restore() {
        GLES20Canvas.nRestore(this.mRenderer);
    }

    private static void nRestore(long l) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nRestore(J)V", true, null);
    }

    public void restoreToCount(int saveCount) {
        GLES20Canvas.nRestoreToCount(this.mRenderer, saveCount);
    }

    private static void nRestoreToCount(long l, int n) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nRestoreToCount(JI)V", true, null);
    }

    public int getSaveCount() {
        return GLES20Canvas.nGetSaveCount(this.mRenderer);
    }

    private static int nGetSaveCount(long l) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nGetSaveCount(J)I", true, null);
    }

    public void setDrawFilter(DrawFilter filter) {
        this.mFilter = filter;
        if (filter == null) {
            GLES20Canvas.nResetPaintFilter(this.mRenderer);
        } else if (filter instanceof PaintFlagsDrawFilter) {
            PaintFlagsDrawFilter flagsFilter = (PaintFlagsDrawFilter)filter;
            GLES20Canvas.nSetupPaintFilter(this.mRenderer, flagsFilter.clearBits, flagsFilter.setBits);
        }
    }

    private static void nResetPaintFilter(long l) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nResetPaintFilter(J)V", true, null);
    }

    private static void nSetupPaintFilter(long l, int n, int n2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nSetupPaintFilter(JII)V", true, null);
    }

    public DrawFilter getDrawFilter() {
        return this.mFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawArc(RectF oval, float startAngle, float sweepAngle, boolean useCenter, Paint paint) {
        int modifiers = this.setupModifiers(paint, 6);
        try {
            GLES20Canvas.nDrawArc(this.mRenderer, oval.left, oval.top, oval.right, oval.bottom, startAngle, sweepAngle, useCenter, paint.mNativePaint);
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    private static void nDrawArc(long l, float f, float f2, float f3, float f4, float f5, float f6, boolean bl, long l2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawArc(JFFFFFFZJ)V", true, null);
    }

    public void drawARGB(int a, int r, int g, int b) {
        this.drawColor((a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawPatch(NinePatch patch, Rect dst, Paint paint) {
        Bitmap bitmap = patch.getBitmap();
        GLES20Canvas.throwIfCannotDraw(bitmap);
        int modifier = paint != null ? this.setupColorFilter(paint) : 0;
        try {
            long nativePaint = paint == null ? 0L : paint.mNativePaint;
            GLES20Canvas.nDrawPatch(this.mRenderer, bitmap.mNativeBitmap, bitmap.mBuffer, patch.mNativeChunk, dst.left, dst.top, dst.right, dst.bottom, nativePaint);
        }
        finally {
            if (modifier != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifier);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawPatch(NinePatch patch, RectF dst, Paint paint) {
        Bitmap bitmap = patch.getBitmap();
        GLES20Canvas.throwIfCannotDraw(bitmap);
        int modifier = paint != null ? this.setupColorFilter(paint) : 0;
        try {
            long nativePaint = paint == null ? 0L : paint.mNativePaint;
            GLES20Canvas.nDrawPatch(this.mRenderer, bitmap.mNativeBitmap, bitmap.mBuffer, patch.mNativeChunk, dst.left, dst.top, dst.right, dst.bottom, nativePaint);
        }
        finally {
            if (modifier != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifier);
            }
        }
    }

    private static void nDrawPatch(long l, long l2, byte[] byArray, long l3, float f, float f2, float f3, float f4, long l4) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawPatch(JJ[BJFFFFJ)V", true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawBitmap(Bitmap bitmap, float left, float top, Paint paint) {
        GLES20Canvas.throwIfCannotDraw(bitmap);
        int modifiers = paint != null ? this.setupModifiers(bitmap, paint) : 0;
        try {
            long nativePaint = paint == null ? 0L : paint.mNativePaint;
            GLES20Canvas.nDrawBitmap(this.mRenderer, bitmap.mNativeBitmap, bitmap.mBuffer, left, top, nativePaint);
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    private static void nDrawBitmap(long l, long l2, byte[] byArray, float f, float f2, long l3) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawBitmap(JJ[BFFJ)V", true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawBitmap(Bitmap bitmap, Matrix matrix, Paint paint) {
        GLES20Canvas.throwIfCannotDraw(bitmap);
        int modifiers = paint != null ? this.setupModifiers(bitmap, paint) : 0;
        try {
            long nativePaint = paint == null ? 0L : paint.mNativePaint;
            GLES20Canvas.nDrawBitmap(this.mRenderer, bitmap.mNativeBitmap, bitmap.mBuffer, matrix.native_instance, nativePaint);
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    private static void nDrawBitmap(long l, long l2, byte[] byArray, long l3, long l4) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawBitmap(JJ[BJJ)V", true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawBitmap(Bitmap bitmap, Rect src, Rect dst, Paint paint) {
        GLES20Canvas.throwIfCannotDraw(bitmap);
        int modifiers = paint != null ? this.setupModifiers(bitmap, paint) : 0;
        try {
            int bottom;
            int right;
            int left;
            int top;
            long nativePaint;
            long l = nativePaint = paint == null ? 0L : paint.mNativePaint;
            if (src == null) {
                top = 0;
                left = 0;
                right = bitmap.getWidth();
                bottom = bitmap.getHeight();
            } else {
                left = src.left;
                right = src.right;
                top = src.top;
                bottom = src.bottom;
            }
            GLES20Canvas.nDrawBitmap(this.mRenderer, bitmap.mNativeBitmap, bitmap.mBuffer, left, top, right, bottom, dst.left, dst.top, dst.right, dst.bottom, nativePaint);
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawBitmap(Bitmap bitmap, Rect src, RectF dst, Paint paint) {
        GLES20Canvas.throwIfCannotDraw(bitmap);
        int modifiers = paint != null ? this.setupModifiers(bitmap, paint) : 0;
        try {
            float bottom;
            float right;
            float left;
            float top;
            long nativePaint;
            long l = nativePaint = paint == null ? 0L : paint.mNativePaint;
            if (src == null) {
                top = 0.0f;
                left = 0.0f;
                right = bitmap.getWidth();
                bottom = bitmap.getHeight();
            } else {
                left = src.left;
                right = src.right;
                top = src.top;
                bottom = src.bottom;
            }
            GLES20Canvas.nDrawBitmap(this.mRenderer, bitmap.mNativeBitmap, bitmap.mBuffer, left, top, right, bottom, dst.left, dst.top, dst.right, dst.bottom, nativePaint);
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    private static void nDrawBitmap(long l, long l2, byte[] byArray, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, long l3) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawBitmap(JJ[BFFFFFFFFJ)V", true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawBitmap(int[] colors, int offset, int stride, float x, float y, int width, int height, boolean hasAlpha, Paint paint) {
        if (width < 0) {
            throw new IllegalArgumentException("width must be >= 0");
        }
        if (height < 0) {
            throw new IllegalArgumentException("height must be >= 0");
        }
        if (Math.abs(stride) < width) {
            throw new IllegalArgumentException("abs(stride) must be >= width");
        }
        int lastScanline = offset + (height - 1) * stride;
        int length = colors.length;
        if (offset < 0 || offset + width > length || lastScanline < 0 || lastScanline + width > length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int modifier = paint != null ? this.setupColorFilter(paint) : 0;
        try {
            long nativePaint = paint == null ? 0L : paint.mNativePaint;
            GLES20Canvas.nDrawBitmap(this.mRenderer, colors, offset, stride, x, y, width, height, hasAlpha, nativePaint);
        }
        finally {
            if (modifier != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifier);
            }
        }
    }

    private static void nDrawBitmap(long l, int[] nArray, int n, int n2, float f, float f2, int n3, int n4, boolean bl, long l2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawBitmap(J[IIIFFIIZJ)V", true, null);
    }

    public void drawBitmap(int[] colors, int offset, int stride, int x, int y, int width, int height, boolean hasAlpha, Paint paint) {
        this.drawBitmap(colors, offset, stride, (float)x, (float)y, width, height, hasAlpha, paint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawBitmapMesh(Bitmap bitmap, int meshWidth, int meshHeight, float[] verts, int vertOffset, int[] colors, int colorOffset, Paint paint) {
        GLES20Canvas.throwIfCannotDraw(bitmap);
        if (meshWidth < 0 || meshHeight < 0 || vertOffset < 0 || colorOffset < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (meshWidth == 0 || meshHeight == 0) {
            return;
        }
        int count = (meshWidth + 1) * (meshHeight + 1);
        GLES20Canvas.checkRange(verts.length, vertOffset, count * 2);
        if (colors != null) {
            GLES20Canvas.checkRange(colors.length, colorOffset, count);
        }
        int modifiers = paint != null ? this.setupModifiers(bitmap, paint) : 0;
        try {
            long nativePaint = paint == null ? 0L : paint.mNativePaint;
            GLES20Canvas.nDrawBitmapMesh(this.mRenderer, bitmap.mNativeBitmap, bitmap.mBuffer, meshWidth, meshHeight, verts, vertOffset, colors, colorOffset, nativePaint);
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    private static void nDrawBitmapMesh(long l, long l2, byte[] byArray, int n, int n2, float[] fArray, int n3, int[] nArray, int n4, long l3) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawBitmapMesh(JJ[BII[FI[IIJ)V", true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawCircle(float cx, float cy, float radius, Paint paint) {
        int modifiers = this.setupModifiers(paint, 6);
        try {
            GLES20Canvas.nDrawCircle(this.mRenderer, cx, cy, radius, paint.mNativePaint);
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    private static void nDrawCircle(long l, float f, float f2, float f3, long l2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawCircle(JFFFJ)V", true, null);
    }

    public void drawColor(int color2) {
        this.drawColor(color2, PorterDuff.Mode.SRC_OVER);
    }

    public void drawColor(int color2, PorterDuff.Mode mode) {
        GLES20Canvas.nDrawColor(this.mRenderer, color2, mode.nativeInt);
    }

    private static void nDrawColor(long l, int n, int n2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawColor(JII)V", true, null);
    }

    public void drawLine(float startX, float startY, float stopX, float stopY, Paint paint) {
        float[] line = this.getLineStorage();
        line[0] = startX;
        line[1] = startY;
        line[2] = stopX;
        line[3] = stopY;
        this.drawLines(line, 0, 4, paint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawLines(float[] pts, int offset, int count, Paint paint) {
        if (count < 4) {
            return;
        }
        if ((offset | count) < 0 || offset + count > pts.length) {
            throw new IllegalArgumentException("The lines array must contain 4 elements per line.");
        }
        int modifiers = this.setupModifiers(paint, 6);
        try {
            GLES20Canvas.nDrawLines(this.mRenderer, pts, offset, count, paint.mNativePaint);
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    private static void nDrawLines(long l, float[] fArray, int n, int n2, long l2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawLines(J[FIIJ)V", true, null);
    }

    public void drawLines(float[] pts, Paint paint) {
        this.drawLines(pts, 0, pts.length, paint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawOval(RectF oval, Paint paint) {
        int modifiers = this.setupModifiers(paint, 6);
        try {
            GLES20Canvas.nDrawOval(this.mRenderer, oval.left, oval.top, oval.right, oval.bottom, paint.mNativePaint);
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    private static void nDrawOval(long l, float f, float f2, float f3, float f4, long l2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawOval(JFFFFJ)V", true, null);
    }

    public void drawPaint(Paint paint) {
        Rect r = this.getInternalClipBounds();
        GLES20Canvas.nGetClipBounds(this.mRenderer, r);
        this.drawRect(r.left, r.top, r.right, r.bottom, paint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawPath(Path path, Paint paint) {
        int modifiers = this.setupModifiers(paint, 6);
        try {
            if (path.isSimplePath) {
                if (path.rects != null) {
                    GLES20Canvas.nDrawRects(this.mRenderer, path.rects.mNativeRegion, paint.mNativePaint);
                }
            } else {
                GLES20Canvas.nDrawPath(this.mRenderer, path.mNativePath, paint.mNativePaint);
            }
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    private static void nDrawPath(long l, long l2, long l3) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawPath(JJJ)V", true, null);
    }

    private static void nDrawRects(long l, long l2, long l3) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawRects(JJJ)V", true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void drawRects(float[] rects, int count, Paint paint) {
        int modifiers = this.setupModifiers(paint, 6);
        try {
            GLES20Canvas.nDrawRects(this.mRenderer, rects, count, paint.mNativePaint);
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    private static void nDrawRects(long l, float[] fArray, int n, long l2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawRects(J[FIJ)V", true, null);
    }

    public void drawPicture(Picture picture) {
        if (picture.createdFromStream) {
            return;
        }
        picture.endRecording();
    }

    public void drawPicture(Picture picture, Rect dst) {
        if (picture.createdFromStream) {
            return;
        }
        this.save();
        this.translate(dst.left, dst.top);
        if (picture.getWidth() > 0 && picture.getHeight() > 0) {
            this.scale(dst.width() / picture.getWidth(), dst.height() / picture.getHeight());
        }
        this.drawPicture(picture);
        this.restore();
    }

    public void drawPicture(Picture picture, RectF dst) {
        if (picture.createdFromStream) {
            return;
        }
        this.save();
        this.translate(dst.left, dst.top);
        if (picture.getWidth() > 0 && picture.getHeight() > 0) {
            this.scale(dst.width() / (float)picture.getWidth(), dst.height() / (float)picture.getHeight());
        }
        this.drawPicture(picture);
        this.restore();
    }

    public void drawPoint(float x, float y, Paint paint) {
        float[] point = this.getPointStorage();
        point[0] = x;
        point[1] = y;
        this.drawPoints(point, 0, 2, paint);
    }

    public void drawPoints(float[] pts, Paint paint) {
        this.drawPoints(pts, 0, pts.length, paint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawPoints(float[] pts, int offset, int count, Paint paint) {
        if (count < 2) {
            return;
        }
        int modifiers = this.setupModifiers(paint, 6);
        try {
            GLES20Canvas.nDrawPoints(this.mRenderer, pts, offset, count, paint.mNativePaint);
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    private static void nDrawPoints(long l, float[] fArray, int n, int n2, long l2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawPoints(J[FIIJ)V", true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawPosText(char[] text, int index, int count, float[] pos, Paint paint) {
        if (index < 0 || index + count > text.length || count * 2 > pos.length) {
            throw new IndexOutOfBoundsException();
        }
        int modifiers = this.setupModifiers(paint);
        try {
            GLES20Canvas.nDrawPosText(this.mRenderer, text, index, count, pos, paint.mNativePaint);
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    private static void nDrawPosText(long l, char[] cArray, int n, int n2, float[] fArray, long l2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawPosText(J[CII[FJ)V", true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawPosText(String text, float[] pos, Paint paint) {
        if (text.length() * 2 > pos.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int modifiers = this.setupModifiers(paint);
        try {
            GLES20Canvas.nDrawPosText(this.mRenderer, text, 0, text.length(), pos, paint.mNativePaint);
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    private static void nDrawPosText(long l, String string2, int n, int n2, float[] fArray, long l2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawPosText(JLjava/lang/String;II[FJ)V", true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawRect(float left, float top, float right, float bottom, Paint paint) {
        if (left == right || top == bottom) {
            return;
        }
        int modifiers = this.setupModifiers(paint, 6);
        try {
            GLES20Canvas.nDrawRect(this.mRenderer, left, top, right, bottom, paint.mNativePaint);
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    private static void nDrawRect(long l, float f, float f2, float f3, float f4, long l2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawRect(JFFFFJ)V", true, null);
    }

    public void drawRect(Rect r, Paint paint) {
        this.drawRect(r.left, r.top, r.right, r.bottom, paint);
    }

    public void drawRect(RectF r, Paint paint) {
        this.drawRect(r.left, r.top, r.right, r.bottom, paint);
    }

    public void drawRGB(int r, int g, int b) {
        this.drawColor(0xFF000000 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawRoundRect(RectF rect, float rx, float ry, Paint paint) {
        int modifiers = this.setupModifiers(paint, 6);
        try {
            GLES20Canvas.nDrawRoundRect(this.mRenderer, rect.left, rect.top, rect.right, rect.bottom, rx, ry, paint.mNativePaint);
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    private static void nDrawRoundRect(long l, float f, float f2, float f3, float f4, float f5, float f6, long l2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawRoundRect(JFFFFFFJ)V", true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawText(char[] text, int index, int count, float x, float y, Paint paint) {
        if ((index | count | index + count | text.length - index - count) < 0) {
            throw new IndexOutOfBoundsException();
        }
        int modifiers = this.setupModifiers(paint);
        try {
            GLES20Canvas.nDrawText(this.mRenderer, text, index, count, x, y, paint.mBidiFlags, paint.mNativePaint);
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    private static void nDrawText(long l, char[] cArray, int n, int n2, float f, float f2, int n3, long l2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawText(J[CIIFFIJ)V", true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawText(CharSequence text, int start, int end, float x, float y, Paint paint) {
        int modifiers = this.setupModifiers(paint);
        try {
            if (text instanceof String || text instanceof SpannedString || text instanceof SpannableString) {
                GLES20Canvas.nDrawText(this.mRenderer, ((Object)text).toString(), start, end, x, y, paint.mBidiFlags, paint.mNativePaint);
            } else if (text instanceof GraphicsOperations) {
                ((GraphicsOperations)text).drawText(this, start, end, x, y, paint);
            } else {
                char[] buf = TemporaryBuffer.obtain(end - start);
                TextUtils.getChars(text, start, end, buf, 0);
                GLES20Canvas.nDrawText(this.mRenderer, buf, 0, end - start, x, y, paint.mBidiFlags, paint.mNativePaint);
                TemporaryBuffer.recycle(buf);
            }
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawText(String text, int start, int end, float x, float y, Paint paint) {
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        int modifiers = this.setupModifiers(paint);
        try {
            GLES20Canvas.nDrawText(this.mRenderer, text, start, end, x, y, paint.mBidiFlags, paint.mNativePaint);
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    private static void nDrawText(long l, String string2, int n, int n2, float f, float f2, int n3, long l2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawText(JLjava/lang/String;IIFFIJ)V", true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawText(String text, float x, float y, Paint paint) {
        int modifiers = this.setupModifiers(paint);
        try {
            GLES20Canvas.nDrawText(this.mRenderer, text, 0, text.length(), x, y, paint.mBidiFlags, paint.mNativePaint);
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawTextOnPath(char[] text, int index, int count, Path path, float hOffset, float vOffset, Paint paint) {
        if (index < 0 || index + count > text.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int modifiers = this.setupModifiers(paint);
        try {
            GLES20Canvas.nDrawTextOnPath(this.mRenderer, text, index, count, path.mNativePath, hOffset, vOffset, paint.mBidiFlags, paint.mNativePaint);
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    private static void nDrawTextOnPath(long l, char[] cArray, int n, int n2, long l2, float f, float f2, int n3, long l3) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawTextOnPath(J[CIIJFFIJ)V", true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawTextOnPath(String text, Path path, float hOffset, float vOffset, Paint paint) {
        if (text.length() == 0) {
            return;
        }
        int modifiers = this.setupModifiers(paint);
        try {
            GLES20Canvas.nDrawTextOnPath(this.mRenderer, text, 0, text.length(), path.mNativePath, hOffset, vOffset, paint.mBidiFlags, paint.mNativePaint);
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    private static void nDrawTextOnPath(long l, String string2, int n, int n2, long l2, float f, float f2, int n3, long l3) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawTextOnPath(JLjava/lang/String;IIJFFIJ)V", true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawTextRun(char[] text, int index, int count, int contextIndex, int contextCount, float x, float y, int dir, Paint paint) {
        if ((index | count | text.length - index - count) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (dir != 0 && dir != 1) {
            throw new IllegalArgumentException("Unknown direction: " + dir);
        }
        int modifiers = this.setupModifiers(paint);
        try {
            GLES20Canvas.nDrawTextRun(this.mRenderer, text, index, count, contextIndex, contextCount, x, y, dir, paint.mNativePaint);
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    private static void nDrawTextRun(long l, char[] cArray, int n, int n2, int n3, int n4, float f, float f2, int n5, long l2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawTextRun(J[CIIIIFFIJ)V", true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawTextRun(CharSequence text, int start, int end, int contextStart, int contextEnd, float x, float y, int dir, Paint paint) {
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        int modifiers = this.setupModifiers(paint);
        try {
            int flags;
            int n = flags = dir == 0 ? 0 : 1;
            if (text instanceof String || text instanceof SpannedString || text instanceof SpannableString) {
                GLES20Canvas.nDrawTextRun(this.mRenderer, ((Object)text).toString(), start, end, contextStart, contextEnd, x, y, flags, paint.mNativePaint);
            } else if (text instanceof GraphicsOperations) {
                ((GraphicsOperations)text).drawTextRun(this, start, end, contextStart, contextEnd, x, y, flags, paint);
            } else {
                int contextLen = contextEnd - contextStart;
                int len = end - start;
                char[] buf = TemporaryBuffer.obtain(contextLen);
                TextUtils.getChars(text, contextStart, contextEnd, buf, 0);
                GLES20Canvas.nDrawTextRun(this.mRenderer, buf, start - contextStart, len, 0, contextLen, x, y, flags, paint.mNativePaint);
                TemporaryBuffer.recycle(buf);
            }
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    private static void nDrawTextRun(long l, String string2, int n, int n2, int n3, int n4, float f, float f2, int n5, long l2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawTextRun(JLjava/lang/String;IIIIFFIJ)V", true, null);
    }

    public void drawVertices(Canvas.VertexMode mode, int vertexCount, float[] verts, int vertOffset, float[] texs, int texOffset, int[] colors, int colorOffset, short[] indices, int indexOffset, int indexCount, Paint paint) {
    }

    private int setupModifiers(Bitmap b, Paint paint) {
        if (b.getConfig() != Bitmap.Config.ALPHA_8) {
            ColorFilter filter = paint.getColorFilter();
            if (filter != null) {
                GLES20Canvas.nSetupColorFilter(this.mRenderer, filter.nativeColorFilter);
                return 4;
            }
            return 0;
        }
        return this.setupModifiers(paint);
    }

    private int setupModifiers(Paint paint) {
        ColorFilter filter;
        Shader shader;
        int modifiers = 0;
        if (paint.hasShadow) {
            GLES20Canvas.nSetupShadow(this.mRenderer, paint.shadowRadius, paint.shadowDx, paint.shadowDy, paint.shadowColor);
            modifiers |= 1;
        }
        if ((shader = paint.getShader()) != null) {
            GLES20Canvas.nSetupShader(this.mRenderer, shader.native_shader);
            modifiers |= 2;
        }
        if ((filter = paint.getColorFilter()) != null) {
            GLES20Canvas.nSetupColorFilter(this.mRenderer, filter.nativeColorFilter);
            modifiers |= 4;
        }
        return modifiers;
    }

    private int setupModifiers(Paint paint, int flags) {
        ColorFilter filter;
        Shader shader;
        int modifiers = 0;
        if (paint.hasShadow && (flags & 1) != 0) {
            GLES20Canvas.nSetupShadow(this.mRenderer, paint.shadowRadius, paint.shadowDx, paint.shadowDy, paint.shadowColor);
            modifiers |= 1;
        }
        if ((shader = paint.getShader()) != null && (flags & 2) != 0) {
            GLES20Canvas.nSetupShader(this.mRenderer, shader.native_shader);
            modifiers |= 2;
        }
        if ((filter = paint.getColorFilter()) != null && (flags & 4) != 0) {
            GLES20Canvas.nSetupColorFilter(this.mRenderer, filter.nativeColorFilter);
            modifiers |= 4;
        }
        return modifiers;
    }

    private int setupColorFilter(Paint paint) {
        ColorFilter filter = paint.getColorFilter();
        if (filter != null) {
            GLES20Canvas.nSetupColorFilter(this.mRenderer, filter.nativeColorFilter);
            return 4;
        }
        return 0;
    }

    private static void nSetupShader(long l, long l2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nSetupShader(JJ)V", true, null);
    }

    private static void nSetupColorFilter(long l, long l2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nSetupColorFilter(JJ)V", true, null);
    }

    private static void nSetupShadow(long l, float f, float f2, float f3, int n) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nSetupShadow(JFFFI)V", true, null);
    }

    private static void nResetModifiers(long l, int n) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nResetModifiers(JI)V", true, null);
    }

    private static class CanvasFinalizer {
        private final long mRenderer;

        public CanvasFinalizer(long renderer) {
            this.mRenderer = renderer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                GLES20Canvas.nDestroyRenderer(this.mRenderer);
            }
            finally {
                super.finalize();
            }
        }
    }
}

