/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.os.SystemClock;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TimedRemoteCaller<T> {
    public static final long DEFAULT_CALL_TIMEOUT_MILLIS = 5000L;
    private static final int UNDEFINED_SEQUENCE = -1;
    private final Object mLock = new Object();
    private final long mCallTimeoutMillis;
    private int mSequenceCounter;
    private int mReceivedSequence = -1;
    private int mAwaitedSequence = -1;
    private T mResult;

    public TimedRemoteCaller(long callTimeoutMillis) {
        this.mCallTimeoutMillis = callTimeoutMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int onBeforeRemoteCall() {
        Object object = this.mLock;
        synchronized (object) {
            this.mAwaitedSequence = this.mSequenceCounter++;
            return this.mAwaitedSequence;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getResultTimed(int sequence) throws TimeoutException {
        Object object = this.mLock;
        synchronized (object) {
            boolean success = this.waitForResultTimedLocked(sequence);
            if (!success) {
                throw new TimeoutException("No reponse for sequence: " + sequence);
            }
            T result = this.mResult;
            this.mResult = null;
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRemoteMethodResult(T result, int sequence) {
        Object object = this.mLock;
        synchronized (object) {
            if (sequence == this.mAwaitedSequence) {
                this.mReceivedSequence = sequence;
                this.mResult = result;
                this.mLock.notifyAll();
            }
        }
    }

    private boolean waitForResultTimedLocked(int sequence) {
        long startMillis = SystemClock.uptimeMillis();
        while (true) {
            try {
                while (true) {
                    if (this.mReceivedSequence == sequence) {
                        return true;
                    }
                    long elapsedMillis = SystemClock.uptimeMillis() - startMillis;
                    long waitMillis = this.mCallTimeoutMillis - elapsedMillis;
                    if (waitMillis <= 0L) {
                        return false;
                    }
                    this.mLock.wait(waitMillis);
                }
            }
            catch (InterruptedException ie) {
                continue;
            }
            break;
        }
    }
}

