/*
 * Decompiled with CFR 0.152.
 */
package android.util;

public class StateSet {
    public static final int[] WILD_CARD = new int[0];
    public static final int[] NOTHING = new int[]{0};

    public static boolean isWildCard(int[] stateSetOrSpec) {
        return stateSetOrSpec.length == 0 || stateSetOrSpec[0] == 0;
    }

    public static boolean stateSetMatches(int[] stateSpec, int[] stateSet) {
        if (stateSet == null) {
            return stateSpec == null || StateSet.isWildCard(stateSpec);
        }
        int stateSpecSize = stateSpec.length;
        int stateSetSize = stateSet.length;
        for (int i = 0; i < stateSpecSize; ++i) {
            boolean mustMatch;
            int stateSpecState = stateSpec[i];
            if (stateSpecState == 0) {
                return true;
            }
            if (stateSpecState > 0) {
                mustMatch = true;
            } else {
                mustMatch = false;
                stateSpecState = -stateSpecState;
            }
            boolean found = false;
            for (int j = 0; j < stateSetSize; ++j) {
                int state = stateSet[j];
                if (state == 0) {
                    if (!mustMatch) break;
                    return false;
                }
                if (state != stateSpecState) continue;
                if (mustMatch) {
                    found = true;
                    break;
                }
                return false;
            }
            if (!mustMatch || found) continue;
            return false;
        }
        return true;
    }

    public static boolean stateSetMatches(int[] stateSpec, int state) {
        for (int stateSpecState : stateSpec) {
            if (stateSpecState == 0) {
                return true;
            }
            if (!(stateSpecState > 0 ? state != stateSpecState : state == -stateSpecState)) continue;
            return false;
        }
        return true;
    }

    public static int[] trimStateSet(int[] states, int newSize) {
        if (states.length == newSize) {
            return states;
        }
        int[] trimmedStates = new int[newSize];
        System.arraycopy(states, 0, trimmedStates, 0, newSize);
        return trimmedStates;
    }

    public static String dump(int[] states) {
        StringBuilder sb = new StringBuilder();
        int count = states.length;
        block7: for (int i = 0; i < count; ++i) {
            switch (states[i]) {
                case 16842909: {
                    sb.append("W ");
                    continue block7;
                }
                case 16842919: {
                    sb.append("P ");
                    continue block7;
                }
                case 0x10100A1: {
                    sb.append("S ");
                    continue block7;
                }
                case 16842908: {
                    sb.append("F ");
                    continue block7;
                }
                case 16842910: {
                    sb.append("E ");
                }
            }
        }
        return sb.toString();
    }
}

