/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Resources;
import android.net.SntpClient;
import android.os.SystemClock;
import android.provider.Settings;
import android.util.TrustedTime;

public class NtpTrustedTime
implements TrustedTime {
    private static final String TAG = "NtpTrustedTime";
    private static final boolean LOGD = false;
    private static NtpTrustedTime sSingleton;
    private final String mServer;
    private final long mTimeout;
    private boolean mHasCache;
    private long mCachedNtpTime;
    private long mCachedNtpElapsedRealtime;
    private long mCachedNtpCertainty;

    private NtpTrustedTime(String server, long timeout) {
        this.mServer = server;
        this.mTimeout = timeout;
    }

    public static synchronized NtpTrustedTime getInstance(Context context) {
        if (sSingleton == null) {
            Resources res = context.getResources();
            ContentResolver resolver = context.getContentResolver();
            String defaultServer = res.getString(17039408);
            long defaultTimeout = res.getInteger(17694787);
            String secureServer = Settings.Global.getString(resolver, "ntp_server");
            long timeout = Settings.Global.getLong(resolver, "ntp_timeout", defaultTimeout);
            String server = secureServer != null ? secureServer : defaultServer;
            sSingleton = new NtpTrustedTime(server, timeout);
        }
        return sSingleton;
    }

    public boolean forceRefresh() {
        if (this.mServer == null) {
            return false;
        }
        SntpClient client = new SntpClient();
        if (client.requestTime(this.mServer, (int)this.mTimeout)) {
            this.mHasCache = true;
            this.mCachedNtpTime = client.getNtpTime();
            this.mCachedNtpElapsedRealtime = client.getNtpTimeReference();
            this.mCachedNtpCertainty = client.getRoundTripTime() / 2L;
            return true;
        }
        return false;
    }

    public boolean hasCache() {
        return this.mHasCache;
    }

    public long getCacheAge() {
        if (this.mHasCache) {
            return SystemClock.elapsedRealtime() - this.mCachedNtpElapsedRealtime;
        }
        return Long.MAX_VALUE;
    }

    public long getCacheCertainty() {
        if (this.mHasCache) {
            return this.mCachedNtpCertainty;
        }
        return Long.MAX_VALUE;
    }

    public long currentTimeMillis() {
        if (!this.mHasCache) {
            throw new IllegalStateException("Missing authoritative time source");
        }
        return this.mCachedNtpTime + this.getCacheAge();
    }

    public long getCachedNtpTime() {
        return this.mCachedNtpTime;
    }

    public long getCachedNtpTimeReference() {
        return this.mCachedNtpElapsedRealtime;
    }
}

