/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LruCache<K, V> {
    private final LinkedHashMap<K, V> map;
    private int size;
    private int maxSize;
    private int putCount;
    private int createCount;
    private int evictionCount;
    private int hitCount;
    private int missCount;

    public LruCache(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("maxSize <= 0");
        }
        this.maxSize = n;
        this.map = new LinkedHashMap(0, 0.75f, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resize(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("maxSize <= 0");
        }
        LruCache lruCache = this;
        synchronized (lruCache) {
            this.maxSize = n;
        }
        this.trimToSize(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final V get(K k) {
        Object object;
        if (k == null) {
            throw new NullPointerException("key == null");
        }
        LruCache<K, V> lruCache = this;
        synchronized (lruCache) {
            object = this.map.get(k);
            if (object != null) {
                ++this.hitCount;
                return object;
            }
            ++this.missCount;
        }
        lruCache = this.create(k);
        if (lruCache == null) {
            return null;
        }
        LruCache lruCache2 = this;
        synchronized (lruCache2) {
            ++this.createCount;
            object = this.map.put(k, lruCache);
            if (object != null) {
                this.map.put(k, object);
            } else {
                this.size += this.safeSizeOf(k, lruCache);
            }
        }
        if (object != null) {
            this.entryRemoved(false, k, lruCache, object);
            return object;
        }
        this.trimToSize(this.maxSize);
        return (V)lruCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final V put(K k, V v) {
        V v2;
        if (k == null || v == null) {
            throw new NullPointerException("key == null || value == null");
        }
        LruCache lruCache = this;
        synchronized (lruCache) {
            ++this.putCount;
            this.size += this.safeSizeOf(k, v);
            v2 = this.map.put(k, v);
            if (v2 != null) {
                this.size -= this.safeSizeOf(k, v2);
            }
        }
        if (v2 != null) {
            this.entryRemoved(false, k, v2, v);
        }
        this.trimToSize(this.maxSize);
        return v2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trimToSize(int n) {
        while (true) {
            V v;
            Object k;
            LruCache lruCache = this;
            synchronized (lruCache) {
                if (this.size < 0 || this.map.isEmpty() && this.size != 0) {
                    throw new IllegalStateException(this.getClass().getName() + ".sizeOf() is reporting inconsistent results!");
                }
                if (this.size <= n) {
                    break;
                }
                Map.Entry<K, V> entry = null;
                Iterator<Map.Entry<K, V>> iterator = this.map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<K, V> entry2;
                    entry = entry2 = iterator.next();
                }
                if (entry == null) {
                    break;
                }
                k = entry.getKey();
                v = entry.getValue();
                this.map.remove(k);
                this.size -= this.safeSizeOf(k, v);
                ++this.evictionCount;
            }
            this.entryRemoved(true, k, v, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final V remove(K k) {
        Object v;
        if (k == null) {
            throw new NullPointerException("key == null");
        }
        LruCache lruCache = this;
        synchronized (lruCache) {
            v = this.map.remove(k);
            if (v != null) {
                this.size -= this.safeSizeOf(k, v);
            }
        }
        if (v != null) {
            this.entryRemoved(false, k, v, null);
        }
        return v;
    }

    protected void entryRemoved(boolean bl, K k, V v, V v2) {
    }

    protected V create(K k) {
        return null;
    }

    private int safeSizeOf(K k, V v) {
        int n = this.sizeOf(k, v);
        if (n < 0) {
            throw new IllegalStateException("Negative size: " + k + "=" + v);
        }
        return n;
    }

    protected int sizeOf(K k, V v) {
        return 1;
    }

    public final void evictAll() {
        this.trimToSize(-1);
    }

    public final synchronized int size() {
        return this.size;
    }

    public final synchronized int maxSize() {
        return this.maxSize;
    }

    public final synchronized int hitCount() {
        return this.hitCount;
    }

    public final synchronized int missCount() {
        return this.missCount;
    }

    public final synchronized int createCount() {
        return this.createCount;
    }

    public final synchronized int putCount() {
        return this.putCount;
    }

    public final synchronized int evictionCount() {
        return this.evictionCount;
    }

    public final synchronized Map<K, V> snapshot() {
        return new LinkedHashMap<K, V>(this.map);
    }

    public final synchronized String toString() {
        int n = this.hitCount + this.missCount;
        int n2 = n != 0 ? 100 * this.hitCount / n : 0;
        return String.format("LruCache[maxSize=%d,hits=%d,misses=%d,hitRate=%d%%]", this.maxSize, this.hitCount, this.missCount, n2);
    }
}

