/*
 * Decompiled with CFR 0.152.
 */
package android.transition;

import android.animation.TimeInterpolator;
import android.transition.Transition;
import android.transition.TransitionValues;
import android.transition.TransitionValuesMaps;
import android.util.AndroidRuntimeException;
import android.view.View;
import android.view.ViewGroup;
import java.util.ArrayList;

public class TransitionSet
extends Transition {
    ArrayList<Transition> mTransitions = new ArrayList();
    private boolean mPlayTogether = true;
    int mCurrentListeners;
    boolean mStarted = false;
    public static final int ORDERING_TOGETHER = 0;
    public static final int ORDERING_SEQUENTIAL = 1;

    public TransitionSet setOrdering(int ordering) {
        switch (ordering) {
            case 1: {
                this.mPlayTogether = false;
                break;
            }
            case 0: {
                this.mPlayTogether = true;
                break;
            }
            default: {
                throw new AndroidRuntimeException("Invalid parameter for TransitionSet ordering: " + ordering);
            }
        }
        return this;
    }

    public int getOrdering() {
        return this.mPlayTogether ? 0 : 1;
    }

    public TransitionSet addTransition(Transition transition) {
        if (transition != null) {
            this.mTransitions.add(transition);
            transition.mParent = this;
            if (this.mDuration >= 0L) {
                transition.setDuration(this.mDuration);
            }
        }
        return this;
    }

    public TransitionSet setDuration(long duration) {
        super.setDuration(duration);
        if (this.mDuration >= 0L) {
            int numTransitions = this.mTransitions.size();
            for (int i = 0; i < numTransitions; ++i) {
                this.mTransitions.get(i).setDuration(duration);
            }
        }
        return this;
    }

    public TransitionSet setStartDelay(long startDelay) {
        return (TransitionSet)super.setStartDelay(startDelay);
    }

    public TransitionSet setInterpolator(TimeInterpolator interpolator2) {
        return (TransitionSet)super.setInterpolator(interpolator2);
    }

    public TransitionSet addTarget(View target) {
        return (TransitionSet)super.addTarget(target);
    }

    public TransitionSet addTarget(int targetId) {
        return (TransitionSet)super.addTarget(targetId);
    }

    public TransitionSet addListener(Transition.TransitionListener listener) {
        return (TransitionSet)super.addListener(listener);
    }

    public TransitionSet removeTarget(int targetId) {
        return (TransitionSet)super.removeTarget(targetId);
    }

    public TransitionSet removeTarget(View target) {
        return (TransitionSet)super.removeTarget(target);
    }

    public TransitionSet removeListener(Transition.TransitionListener listener) {
        return (TransitionSet)super.removeListener(listener);
    }

    public TransitionSet removeTransition(Transition transition) {
        this.mTransitions.remove(transition);
        transition.mParent = null;
        return this;
    }

    private void setupStartEndListeners() {
        TransitionSetListener listener = new TransitionSetListener(this);
        for (Transition childTransition : this.mTransitions) {
            childTransition.addListener(listener);
        }
        this.mCurrentListeners = this.mTransitions.size();
    }

    protected void createAnimators(ViewGroup sceneRoot, TransitionValuesMaps startValues, TransitionValuesMaps endValues) {
        for (Transition childTransition : this.mTransitions) {
            childTransition.createAnimators(sceneRoot, startValues, endValues);
        }
    }

    protected void runAnimators() {
        this.setupStartEndListeners();
        if (!this.mPlayTogether) {
            for (int i = 1; i < this.mTransitions.size(); ++i) {
                Transition previousTransition = this.mTransitions.get(i - 1);
                final Transition nextTransition = this.mTransitions.get(i);
                previousTransition.addListener(new Transition.TransitionListenerAdapter(){

                    public void onTransitionEnd(Transition transition) {
                        nextTransition.runAnimators();
                        transition.removeListener(this);
                    }
                });
            }
            Transition firstTransition = this.mTransitions.get(0);
            if (firstTransition != null) {
                firstTransition.runAnimators();
            }
        } else {
            for (Transition childTransition : this.mTransitions) {
                childTransition.runAnimators();
            }
        }
    }

    public void captureStartValues(TransitionValues transitionValues) {
        int targetId = transitionValues.view.getId();
        if (this.isValidTarget(transitionValues.view, targetId)) {
            for (Transition childTransition : this.mTransitions) {
                if (!childTransition.isValidTarget(transitionValues.view, targetId)) continue;
                childTransition.captureStartValues(transitionValues);
            }
        }
    }

    public void captureEndValues(TransitionValues transitionValues) {
        int targetId = transitionValues.view.getId();
        if (this.isValidTarget(transitionValues.view, targetId)) {
            for (Transition childTransition : this.mTransitions) {
                if (!childTransition.isValidTarget(transitionValues.view, targetId)) continue;
                childTransition.captureEndValues(transitionValues);
            }
        }
    }

    public void pause() {
        super.pause();
        int numTransitions = this.mTransitions.size();
        for (int i = 0; i < numTransitions; ++i) {
            this.mTransitions.get(i).pause();
        }
    }

    public void resume() {
        super.resume();
        int numTransitions = this.mTransitions.size();
        for (int i = 0; i < numTransitions; ++i) {
            this.mTransitions.get(i).resume();
        }
    }

    protected void cancel() {
        super.cancel();
        int numTransitions = this.mTransitions.size();
        for (int i = 0; i < numTransitions; ++i) {
            this.mTransitions.get(i).cancel();
        }
    }

    TransitionSet setSceneRoot(ViewGroup sceneRoot) {
        super.setSceneRoot(sceneRoot);
        int numTransitions = this.mTransitions.size();
        for (int i = 0; i < numTransitions; ++i) {
            this.mTransitions.get(i).setSceneRoot(sceneRoot);
        }
        return this;
    }

    void setCanRemoveViews(boolean canRemoveViews) {
        super.setCanRemoveViews(canRemoveViews);
        int numTransitions = this.mTransitions.size();
        for (int i = 0; i < numTransitions; ++i) {
            this.mTransitions.get(i).setCanRemoveViews(canRemoveViews);
        }
    }

    String toString(String indent) {
        String result = super.toString(indent);
        for (int i = 0; i < this.mTransitions.size(); ++i) {
            result = result + "\n" + this.mTransitions.get(i).toString(indent + "  ");
        }
        return result;
    }

    public TransitionSet clone() {
        TransitionSet clone = (TransitionSet)super.clone();
        clone.mTransitions = new ArrayList();
        int numTransitions = this.mTransitions.size();
        for (int i = 0; i < numTransitions; ++i) {
            clone.addTransition(this.mTransitions.get(i).clone());
        }
        return clone;
    }

    static class TransitionSetListener
    extends Transition.TransitionListenerAdapter {
        TransitionSet mTransitionSet;

        TransitionSetListener(TransitionSet transitionSet) {
            this.mTransitionSet = transitionSet;
        }

        public void onTransitionStart(Transition transition) {
            if (!this.mTransitionSet.mStarted) {
                this.mTransitionSet.start();
                this.mTransitionSet.mStarted = true;
            }
        }

        public void onTransitionEnd(Transition transition) {
            --this.mTransitionSet.mCurrentListeners;
            if (this.mTransitionSet.mCurrentListeners == 0) {
                this.mTransitionSet.mStarted = false;
                this.mTransitionSet.end();
            }
            transition.removeListener(this);
        }
    }
}

