/*
 * Decompiled with CFR 0.152.
 */
package android.transition;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.RectEvaluator;
import android.animation.TypeEvaluator;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.transition.Transition;
import android.transition.TransitionValues;
import android.view.View;
import android.view.ViewGroup;
import java.util.Map;

public class ChangeBounds
extends Transition {
    private static final String PROPNAME_BOUNDS = "android:changeBounds:bounds";
    private static final String PROPNAME_PARENT = "android:changeBounds:parent";
    private static final String PROPNAME_WINDOW_X = "android:changeBounds:windowX";
    private static final String PROPNAME_WINDOW_Y = "android:changeBounds:windowY";
    private static final String[] sTransitionProperties = new String[]{"android:changeBounds:bounds", "android:changeBounds:parent", "android:changeBounds:windowX", "android:changeBounds:windowY"};
    int[] tempLocation = new int[2];
    boolean mResizeClip = false;
    boolean mReparent = false;
    private static final String LOG_TAG = "ChangeBounds";
    private static RectEvaluator sRectEvaluator = new RectEvaluator();

    public String[] getTransitionProperties() {
        return sTransitionProperties;
    }

    public void setResizeClip(boolean resizeClip) {
        this.mResizeClip = resizeClip;
    }

    public void setReparent(boolean reparent) {
        this.mReparent = reparent;
    }

    private void captureValues(TransitionValues values) {
        View view = values.view;
        values.values.put(PROPNAME_BOUNDS, new Rect(view.getLeft(), view.getTop(), view.getRight(), view.getBottom()));
        values.values.put(PROPNAME_PARENT, values.view.getParent());
        values.view.getLocationInWindow(this.tempLocation);
        values.values.put(PROPNAME_WINDOW_X, this.tempLocation[0]);
        values.values.put(PROPNAME_WINDOW_Y, this.tempLocation[1]);
    }

    public void captureStartValues(TransitionValues transitionValues) {
        this.captureValues(transitionValues);
    }

    public void captureEndValues(TransitionValues transitionValues) {
        this.captureValues(transitionValues);
    }

    public Animator createAnimator(final ViewGroup sceneRoot, TransitionValues startValues, TransitionValues endValues) {
        boolean parentsEqual;
        if (startValues == null || endValues == null) {
            return null;
        }
        Map<String, Object> startParentVals = startValues.values;
        Map<String, Object> endParentVals = endValues.values;
        ViewGroup startParent = (ViewGroup)startParentVals.get(PROPNAME_PARENT);
        ViewGroup endParent = (ViewGroup)endParentVals.get(PROPNAME_PARENT);
        if (startParent == null || endParent == null) {
            return null;
        }
        final View view = endValues.view;
        boolean bl = parentsEqual = startParent == endParent || startParent.getId() == endParent.getId();
        if (!this.mReparent || parentsEqual) {
            Rect startBounds = (Rect)startValues.values.get(PROPNAME_BOUNDS);
            Rect endBounds = (Rect)endValues.values.get(PROPNAME_BOUNDS);
            int startLeft = startBounds.left;
            int endLeft = endBounds.left;
            int startTop = startBounds.top;
            int endTop = endBounds.top;
            int startRight = startBounds.right;
            int endRight = endBounds.right;
            int startBottom = startBounds.bottom;
            int endBottom = endBounds.bottom;
            int startWidth = startRight - startLeft;
            int startHeight = startBottom - startTop;
            int endWidth = endRight - endLeft;
            int endHeight = endBottom - endTop;
            int numChanges = 0;
            if (startWidth != 0 && startHeight != 0 && endWidth != 0 && endHeight != 0) {
                if (startLeft != endLeft) {
                    ++numChanges;
                }
                if (startTop != endTop) {
                    ++numChanges;
                }
                if (startRight != endRight) {
                    ++numChanges;
                }
                if (startBottom != endBottom) {
                    ++numChanges;
                }
            }
            if (numChanges > 0) {
                if (!this.mResizeClip) {
                    PropertyValuesHolder[] pvh = new PropertyValuesHolder[numChanges];
                    int pvhIndex = 0;
                    if (startLeft != endLeft) {
                        view.setLeft(startLeft);
                    }
                    if (startTop != endTop) {
                        view.setTop(startTop);
                    }
                    if (startRight != endRight) {
                        view.setRight(startRight);
                    }
                    if (startBottom != endBottom) {
                        view.setBottom(startBottom);
                    }
                    if (startLeft != endLeft) {
                        pvh[pvhIndex++] = PropertyValuesHolder.ofInt("left", startLeft, endLeft);
                    }
                    if (startTop != endTop) {
                        pvh[pvhIndex++] = PropertyValuesHolder.ofInt("top", startTop, endTop);
                    }
                    if (startRight != endRight) {
                        pvh[pvhIndex++] = PropertyValuesHolder.ofInt("right", startRight, endRight);
                    }
                    if (startBottom != endBottom) {
                        pvh[pvhIndex++] = PropertyValuesHolder.ofInt("bottom", startBottom, endBottom);
                    }
                    ObjectAnimator anim2 = ObjectAnimator.ofPropertyValuesHolder(view, pvh);
                    if (view.getParent() instanceof ViewGroup) {
                        final ViewGroup parent = (ViewGroup)view.getParent();
                        parent.suppressLayout(true);
                        Transition.TransitionListenerAdapter transitionListener = new Transition.TransitionListenerAdapter(){
                            boolean mCanceled = false;

                            public void onTransitionCancel(Transition transition) {
                                parent.suppressLayout(false);
                                this.mCanceled = true;
                            }

                            public void onTransitionEnd(Transition transition) {
                                if (!this.mCanceled) {
                                    parent.suppressLayout(false);
                                }
                            }

                            public void onTransitionPause(Transition transition) {
                                parent.suppressLayout(false);
                            }

                            public void onTransitionResume(Transition transition) {
                                parent.suppressLayout(true);
                            }
                        };
                        this.addListener(transitionListener);
                    }
                    return anim2;
                }
                if (startWidth != endWidth) {
                    view.setRight(endLeft + Math.max(startWidth, endWidth));
                }
                if (startHeight != endHeight) {
                    view.setBottom(endTop + Math.max(startHeight, endHeight));
                }
                if (startLeft != endLeft) {
                    view.setTranslationX(startLeft - endLeft);
                }
                if (startTop != endTop) {
                    view.setTranslationY(startTop - endTop);
                }
                float transXDelta = endLeft - startLeft;
                float transYDelta = endTop - startTop;
                int widthDelta = endWidth - startWidth;
                int heightDelta = endHeight - startHeight;
                numChanges = 0;
                if (transXDelta != 0.0f) {
                    ++numChanges;
                }
                if (transYDelta != 0.0f) {
                    ++numChanges;
                }
                if (widthDelta != 0 || heightDelta != 0) {
                    ++numChanges;
                }
                PropertyValuesHolder[] pvh = new PropertyValuesHolder[numChanges];
                int pvhIndex = 0;
                if (transXDelta != 0.0f) {
                    pvh[pvhIndex++] = PropertyValuesHolder.ofFloat("translationX", view.getTranslationX(), 0.0f);
                }
                if (transYDelta != 0.0f) {
                    pvh[pvhIndex++] = PropertyValuesHolder.ofFloat("translationY", view.getTranslationY(), 0.0f);
                }
                if (widthDelta != 0 || heightDelta != 0) {
                    Rect tempStartBounds = new Rect(0, 0, startWidth, startHeight);
                    Rect tempEndBounds = new Rect(0, 0, endWidth, endHeight);
                    pvh[pvhIndex++] = PropertyValuesHolder.ofObject("clipBounds", (TypeEvaluator)sRectEvaluator, tempStartBounds, tempEndBounds);
                }
                ObjectAnimator anim3 = ObjectAnimator.ofPropertyValuesHolder(view, pvh);
                if (view.getParent() instanceof ViewGroup) {
                    final ViewGroup parent = (ViewGroup)view.getParent();
                    parent.suppressLayout(true);
                    Transition.TransitionListenerAdapter transitionListener = new Transition.TransitionListenerAdapter(){
                        boolean mCanceled = false;

                        public void onTransitionCancel(Transition transition) {
                            parent.suppressLayout(false);
                            this.mCanceled = true;
                        }

                        public void onTransitionEnd(Transition transition) {
                            if (!this.mCanceled) {
                                parent.suppressLayout(false);
                            }
                        }

                        public void onTransitionPause(Transition transition) {
                            parent.suppressLayout(false);
                        }

                        public void onTransitionResume(Transition transition) {
                            parent.suppressLayout(true);
                        }
                    };
                    this.addListener(transitionListener);
                }
                anim3.addListener(new AnimatorListenerAdapter(){

                    public void onAnimationEnd(Animator animation) {
                        view.setClipBounds(null);
                    }
                });
                return anim3;
            }
        } else {
            int startX = (Integer)startValues.values.get(PROPNAME_WINDOW_X);
            int startY = (Integer)startValues.values.get(PROPNAME_WINDOW_Y);
            int endX = (Integer)endValues.values.get(PROPNAME_WINDOW_X);
            int endY = (Integer)endValues.values.get(PROPNAME_WINDOW_Y);
            if (startX != endX || startY != endY) {
                sceneRoot.getLocationInWindow(this.tempLocation);
                Bitmap bitmap = Bitmap.createBitmap(view.getWidth(), view.getHeight(), Bitmap.Config.ARGB_8888);
                Canvas canvas = new Canvas(bitmap);
                view.draw(canvas);
                final BitmapDrawable drawable2 = new BitmapDrawable(bitmap);
                view.setVisibility(4);
                sceneRoot.getOverlay().add(drawable2);
                Rect startBounds1 = new Rect(startX - this.tempLocation[0], startY - this.tempLocation[1], startX - this.tempLocation[0] + view.getWidth(), startY - this.tempLocation[1] + view.getHeight());
                Rect endBounds1 = new Rect(endX - this.tempLocation[0], endY - this.tempLocation[1], endX - this.tempLocation[0] + view.getWidth(), endY - this.tempLocation[1] + view.getHeight());
                ObjectAnimator anim4 = ObjectAnimator.ofObject(drawable2, "bounds", (TypeEvaluator)sRectEvaluator, startBounds1, endBounds1);
                anim4.addListener(new AnimatorListenerAdapter(){

                    public void onAnimationEnd(Animator animation) {
                        sceneRoot.getOverlay().remove(drawable2);
                        view.setVisibility(0);
                    }
                });
                return anim4;
            }
        }
        return null;
    }
}

