/*
 * Decompiled with CFR 0.152.
 */
package android.text.style;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.os.Parcel;
import android.text.ParcelableSpan;
import android.text.TextPaint;
import android.text.style.MetricAffectingSpan;
import com.android.internal.R;

public class TextAppearanceSpan
extends MetricAffectingSpan
implements ParcelableSpan {
    private final String mTypeface;
    private final int mStyle;
    private final int mTextSize;
    private final ColorStateList mTextColor;
    private final ColorStateList mTextColorLink;

    public TextAppearanceSpan(Context context, int appearance) {
        this(context, appearance, -1);
    }

    public TextAppearanceSpan(Context context, int appearance, int colorList) {
        TypedArray a = context.obtainStyledAttributes(appearance, R.styleable.TextAppearance);
        ColorStateList textColor = a.getColorStateList(3);
        this.mTextColorLink = a.getColorStateList(6);
        this.mTextSize = a.getDimensionPixelSize(0, -1);
        this.mStyle = a.getInt(2, 0);
        String family = a.getString(12);
        if (family != null) {
            this.mTypeface = family;
        } else {
            int tf = a.getInt(1, 0);
            switch (tf) {
                case 1: {
                    this.mTypeface = "sans";
                    break;
                }
                case 2: {
                    this.mTypeface = "serif";
                    break;
                }
                case 3: {
                    this.mTypeface = "monospace";
                    break;
                }
                default: {
                    this.mTypeface = null;
                }
            }
        }
        a.recycle();
        if (colorList >= 0) {
            a = context.obtainStyledAttributes(16973829, R.styleable.Theme);
            textColor = a.getColorStateList(colorList);
            a.recycle();
        }
        this.mTextColor = textColor;
    }

    public TextAppearanceSpan(String family, int style2, int size, ColorStateList color2, ColorStateList linkColor) {
        this.mTypeface = family;
        this.mStyle = style2;
        this.mTextSize = size;
        this.mTextColor = color2;
        this.mTextColorLink = linkColor;
    }

    public TextAppearanceSpan(Parcel src) {
        this.mTypeface = src.readString();
        this.mStyle = src.readInt();
        this.mTextSize = src.readInt();
        this.mTextColor = src.readInt() != 0 ? ColorStateList.CREATOR.createFromParcel(src) : null;
        this.mTextColorLink = src.readInt() != 0 ? ColorStateList.CREATOR.createFromParcel(src) : null;
    }

    public int getSpanTypeId() {
        return 17;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mTypeface);
        dest.writeInt(this.mStyle);
        dest.writeInt(this.mTextSize);
        if (this.mTextColor != null) {
            dest.writeInt(1);
            this.mTextColor.writeToParcel(dest, flags);
        } else {
            dest.writeInt(0);
        }
        if (this.mTextColorLink != null) {
            dest.writeInt(1);
            this.mTextColorLink.writeToParcel(dest, flags);
        } else {
            dest.writeInt(0);
        }
    }

    public String getFamily() {
        return this.mTypeface;
    }

    public ColorStateList getTextColor() {
        return this.mTextColor;
    }

    public ColorStateList getLinkTextColor() {
        return this.mTextColorLink;
    }

    public int getTextSize() {
        return this.mTextSize;
    }

    public int getTextStyle() {
        return this.mStyle;
    }

    public void updateDrawState(TextPaint ds) {
        this.updateMeasureState(ds);
        if (this.mTextColor != null) {
            ds.setColor(this.mTextColor.getColorForState(ds.drawableState, 0));
        }
        if (this.mTextColorLink != null) {
            ds.linkColor = this.mTextColorLink.getColorForState(ds.drawableState, 0);
        }
    }

    public void updateMeasureState(TextPaint ds) {
        if (this.mTypeface != null || this.mStyle != 0) {
            int fake;
            Typeface tf = ds.getTypeface();
            int style2 = 0;
            if (tf != null) {
                style2 = tf.getStyle();
            }
            if (((fake = style2 & ~(tf = this.mTypeface != null ? Typeface.create(this.mTypeface, style2) : (tf == null ? Typeface.defaultFromStyle(style2) : Typeface.create(tf, style2 |= this.mStyle))).getStyle()) & 1) != 0) {
                ds.setFakeBoldText(true);
            }
            if ((fake & 2) != 0) {
                ds.setTextSkewX(-0.25f);
            }
            ds.setTypeface(tf);
        }
        if (this.mTextSize > 0) {
            ds.setTextSize(this.mTextSize);
        }
    }
}

