/*
 * Decompiled with CFR 0.152.
 */
package android.text.format;

import android.text.format.Time;
import com.android.layoutlib.bridge.Bridge;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.UnknownFormatConversionException;
import java.util.regex.Pattern;

public class Time_Delegate {
    private static final Pattern p = Pattern.compile("(?<!%)(%%)*%(?!%)");
    private static final String FORMAT = "%1$tY%1$tm%1$tdT%1$tH%1$tM%1$tS<%1$tZ>";

    @LayoutlibDelegate
    static long normalize(Time time, boolean bl) {
        long l = Time_Delegate.toMillis(time, bl);
        Time_Delegate.set(time, l);
        return l;
    }

    @LayoutlibDelegate
    static void switchTimezone(Time time, String string2) {
        Calendar calendar = Time_Delegate.timeToCalendar(time);
        calendar.setTimeZone(TimeZone.getTimeZone(string2));
        Time_Delegate.calendarToTime(calendar, time);
    }

    @LayoutlibDelegate
    static int nativeCompare(Time time, Time time2) {
        return Time_Delegate.timeToCalendar(time).compareTo(Time_Delegate.timeToCalendar(time2));
    }

    @LayoutlibDelegate
    static String format1(Time time, String string2) {
        try {
            return String.format(p.matcher(string2).replaceAll("$0\\1\\$t"), Time_Delegate.timeToCalendar(time));
        }
        catch (UnknownFormatConversionException unknownFormatConversionException) {
            Bridge.getLog().fidelityWarning("strftime", "Unrecognized format", (Throwable)unknownFormatConversionException, (Object)string2);
            return string2;
        }
    }

    @LayoutlibDelegate
    static String toString(Time time) {
        Calendar calendar = Time_Delegate.timeToCalendar(time);
        return String.format(FORMAT, calendar);
    }

    @LayoutlibDelegate
    static boolean nativeParse(Time time, String string2) {
        Bridge.getLog().error("unsupported", "android.text.format.Time.parse() not supported.", null);
        return false;
    }

    @LayoutlibDelegate
    static boolean nativeParse3339(Time time, String string2) {
        Bridge.getLog().error("unsupported", "android.text.format.Time.parse3339() not supported.", null);
        return false;
    }

    @LayoutlibDelegate
    static void setToNow(Time time) {
        Time_Delegate.calendarToTime(Time_Delegate.getCalendarInstance(time), time);
    }

    @LayoutlibDelegate
    static long toMillis(Time time, boolean bl) {
        return Time_Delegate.timeToCalendar(time).getTimeInMillis();
    }

    @LayoutlibDelegate
    static void set(Time time, long l) {
        Calendar calendar = Time_Delegate.getCalendarInstance(time);
        calendar.setTimeInMillis(l);
        Time_Delegate.calendarToTime(calendar, time);
    }

    @LayoutlibDelegate
    static String format2445(Time time) {
        Bridge.getLog().error("unsupported", "android.text.format.Time.format2445() not supported.", null);
        return "";
    }

    private static Calendar timeToCalendar(Time time) {
        Calendar calendar = Time_Delegate.getCalendarInstance(time);
        calendar.set(time.year, time.month, time.monthDay, time.hour, time.minute, time.second);
        return calendar;
    }

    private static void calendarToTime(Calendar calendar, Time time) {
        time.timezone = calendar.getTimeZone().getID();
        time.set(calendar.get(13), calendar.get(12), calendar.get(11), calendar.get(5), calendar.get(2), calendar.get(1));
        time.weekDay = calendar.get(7);
        time.yearDay = calendar.get(6);
        time.isDst = calendar.getTimeZone().inDaylightTime(calendar.getTime()) ? 1 : 0;
        time.gmtoff = (long)calendar.getTimeZone().getOffset(calendar.getTimeInMillis()) / 1000L;
    }

    private static Calendar getCalendarInstance(Time time) {
        if (time == null || time.timezone == null) {
            return Calendar.getInstance();
        }
        return Calendar.getInstance(TimeZone.getTimeZone(time.timezone));
    }
}

