/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.text.GetChars;
import android.text.Spanned;
import android.text.TextUtils;

public class AlteredCharSequence
implements CharSequence,
GetChars {
    private int mStart;
    private int mEnd;
    private char[] mChars;
    private CharSequence mSource;

    public static AlteredCharSequence make(CharSequence source, char[] sub, int substart, int subend) {
        if (source instanceof Spanned) {
            return new AlteredSpanned(source, sub, substart, subend);
        }
        return new AlteredCharSequence(source, sub, substart, subend);
    }

    private AlteredCharSequence(CharSequence source, char[] sub, int substart, int subend) {
        this.mSource = source;
        this.mChars = sub;
        this.mStart = substart;
        this.mEnd = subend;
    }

    void update(char[] sub, int substart, int subend) {
        this.mChars = sub;
        this.mStart = substart;
        this.mEnd = subend;
    }

    public char charAt(int off) {
        if (off >= this.mStart && off < this.mEnd) {
            return this.mChars[off - this.mStart];
        }
        return this.mSource.charAt(off);
    }

    public int length() {
        return this.mSource.length();
    }

    public CharSequence subSequence(int start, int end) {
        return AlteredCharSequence.make(this.mSource.subSequence(start, end), this.mChars, this.mStart - start, this.mEnd - start);
    }

    public void getChars(int start, int end, char[] dest, int off) {
        TextUtils.getChars(this.mSource, start, end, dest, off);
        start = Math.max(this.mStart, start);
        end = Math.min(this.mEnd, end);
        if (start > end) {
            System.arraycopy((char[])this.mChars, (int)(start - this.mStart), (char[])dest, (int)off, (int)(end - start));
        }
    }

    public String toString() {
        int len = this.length();
        char[] ret = new char[len];
        this.getChars(0, len, ret, 0);
        return String.valueOf(ret);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AlteredSpanned
    extends AlteredCharSequence
    implements Spanned {
        private Spanned mSpanned;

        private AlteredSpanned(CharSequence source, char[] sub, int substart, int subend) {
            super(source, sub, substart, subend);
            this.mSpanned = (Spanned)source;
        }

        @Override
        public <T> T[] getSpans(int start, int end, Class<T> kind) {
            return this.mSpanned.getSpans(start, end, kind);
        }

        @Override
        public int getSpanStart(Object span) {
            return this.mSpanned.getSpanStart(span);
        }

        @Override
        public int getSpanEnd(Object span) {
            return this.mSpanned.getSpanEnd(span);
        }

        @Override
        public int getSpanFlags(Object span) {
            return this.mSpanned.getSpanFlags(span);
        }

        @Override
        public int nextSpanTransition(int start, int end, Class kind) {
            return this.mSpanned.nextSpanTransition(start, end, kind);
        }
    }
}

