/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.SurfaceTexture;
import android.os.SystemProperties;
import android.renderscript.Allocation;
import android.renderscript.BaseObj;
import android.renderscript.Element;
import android.renderscript.ProgramRaster;
import android.renderscript.ProgramStore;
import android.renderscript.RSDriverException;
import android.renderscript.RSInvalidStateException;
import android.renderscript.RSRuntimeException;
import android.renderscript.Sampler;
import android.util.Log;
import android.view.Surface;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.File;
import java.lang.reflect.Method;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class RenderScript {
    static final long TRACE_TAG = 32768L;
    static final String LOG_TAG = "RenderScript_jni";
    static final boolean DEBUG = false;
    static final boolean LOG_ENABLED = false;
    private Context mApplicationContext;
    static boolean sInitialized = false;
    static Object sRuntime;
    static Method registerNativeAllocation;
    static Method registerNativeFree;
    static File mCacheDir;
    static final long sMinorID = 1L;
    ContextType mContextType = ContextType.NORMAL;
    ReentrantReadWriteLock mRWLock;
    int mDev;
    int mContext;
    MessageThread mMessageThread;
    Element mElement_U8;
    Element mElement_I8;
    Element mElement_U16;
    Element mElement_I16;
    Element mElement_U32;
    Element mElement_I32;
    Element mElement_U64;
    Element mElement_I64;
    Element mElement_F32;
    Element mElement_F64;
    Element mElement_BOOLEAN;
    Element mElement_ELEMENT;
    Element mElement_TYPE;
    Element mElement_ALLOCATION;
    Element mElement_SAMPLER;
    Element mElement_SCRIPT;
    Element mElement_MESH;
    Element mElement_PROGRAM_FRAGMENT;
    Element mElement_PROGRAM_VERTEX;
    Element mElement_PROGRAM_RASTER;
    Element mElement_PROGRAM_STORE;
    Element mElement_FONT;
    Element mElement_A_8;
    Element mElement_RGB_565;
    Element mElement_RGB_888;
    Element mElement_RGBA_5551;
    Element mElement_RGBA_4444;
    Element mElement_RGBA_8888;
    Element mElement_FLOAT_2;
    Element mElement_FLOAT_3;
    Element mElement_FLOAT_4;
    Element mElement_DOUBLE_2;
    Element mElement_DOUBLE_3;
    Element mElement_DOUBLE_4;
    Element mElement_UCHAR_2;
    Element mElement_UCHAR_3;
    Element mElement_UCHAR_4;
    Element mElement_CHAR_2;
    Element mElement_CHAR_3;
    Element mElement_CHAR_4;
    Element mElement_USHORT_2;
    Element mElement_USHORT_3;
    Element mElement_USHORT_4;
    Element mElement_SHORT_2;
    Element mElement_SHORT_3;
    Element mElement_SHORT_4;
    Element mElement_UINT_2;
    Element mElement_UINT_3;
    Element mElement_UINT_4;
    Element mElement_INT_2;
    Element mElement_INT_3;
    Element mElement_INT_4;
    Element mElement_ULONG_2;
    Element mElement_ULONG_3;
    Element mElement_ULONG_4;
    Element mElement_LONG_2;
    Element mElement_LONG_3;
    Element mElement_LONG_4;
    Element mElement_YUV;
    Element mElement_MATRIX_4X4;
    Element mElement_MATRIX_3X3;
    Element mElement_MATRIX_2X2;
    Sampler mSampler_CLAMP_NEAREST;
    Sampler mSampler_CLAMP_LINEAR;
    Sampler mSampler_CLAMP_LINEAR_MIP_LINEAR;
    Sampler mSampler_WRAP_NEAREST;
    Sampler mSampler_WRAP_LINEAR;
    Sampler mSampler_WRAP_LINEAR_MIP_LINEAR;
    Sampler mSampler_MIRRORED_REPEAT_NEAREST;
    Sampler mSampler_MIRRORED_REPEAT_LINEAR;
    Sampler mSampler_MIRRORED_REPEAT_LINEAR_MIP_LINEAR;
    ProgramStore mProgramStore_BLEND_NONE_DEPTH_TEST;
    ProgramStore mProgramStore_BLEND_NONE_DEPTH_NO_DEPTH;
    ProgramStore mProgramStore_BLEND_ALPHA_DEPTH_TEST;
    ProgramStore mProgramStore_BLEND_ALPHA_DEPTH_NO_DEPTH;
    ProgramRaster mProgramRaster_CULL_BACK;
    ProgramRaster mProgramRaster_CULL_FRONT;
    ProgramRaster mProgramRaster_CULL_NONE;
    RSMessageHandler mMessageCallback = null;
    RSErrorHandler mErrorCallback = null;

    static void _nInit() {
        OverrideMethod.invokeV("android.renderscript.RenderScript#_nInit()V", true, null);
    }

    int nDeviceCreate() {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#nDeviceCreate()I", true, this);
    }

    void nDeviceDestroy(int n) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nDeviceDestroy(I)V", true, this);
    }

    void nDeviceSetConfig(int n, int n2, int n3) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nDeviceSetConfig(III)V", true, this);
    }

    int nContextGetUserMessage(int n, int[] nArray) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#nContextGetUserMessage(I[I)I", true, this);
    }

    String nContextGetErrorMessage(int n) {
        return (String)OverrideMethod.invokeA("android.renderscript.RenderScript#nContextGetErrorMessage(I)Ljava/lang/String;", true, this);
    }

    int nContextPeekMessage(int n, int[] nArray) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#nContextPeekMessage(I[I)I", true, this);
    }

    void nContextInitToClient(int n) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nContextInitToClient(I)V", true, this);
    }

    void nContextDeinitToClient(int n) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nContextDeinitToClient(I)V", true, this);
    }

    public static long getMinorID() {
        return 1L;
    }

    public static void setupDiskCache(File cacheDir) {
        if (!sInitialized) {
            Log.e(LOG_TAG, "RenderScript.setupDiskCache() called when disabled");
            return;
        }
        mCacheDir = cacheDir;
    }

    int rsnContextCreateGL(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, float f, int n14) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnContextCreateGL(IIIIIIIIIIIIIFI)I", true, this);
    }

    synchronized int nContextCreateGL(int dev, int ver, int sdkVer, int colorMin, int colorPref, int alphaMin, int alphaPref, int depthMin, int depthPref, int stencilMin, int stencilPref, int samplesMin, int samplesPref, float samplesQ, int dpi) {
        return this.rsnContextCreateGL(dev, ver, sdkVer, colorMin, colorPref, alphaMin, alphaPref, depthMin, depthPref, stencilMin, stencilPref, samplesMin, samplesPref, samplesQ, dpi);
    }

    int rsnContextCreate(int n, int n2, int n3, int n4) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnContextCreate(IIII)I", true, this);
    }

    synchronized int nContextCreate(int dev, int ver, int sdkVer, int contextType) {
        return this.rsnContextCreate(dev, ver, sdkVer, contextType);
    }

    void rsnContextDestroy(int n) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnContextDestroy(I)V", true, this);
    }

    synchronized void nContextDestroy() {
        this.validate();
        ReentrantReadWriteLock.WriteLock wlock = this.mRWLock.writeLock();
        wlock.lock();
        int curCon = this.mContext;
        this.mContext = 0;
        wlock.unlock();
        this.rsnContextDestroy(curCon);
    }

    void rsnContextSetSurface(int n, int n2, int n3, Surface surface) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnContextSetSurface(IIILandroid/view/Surface;)V", true, this);
    }

    synchronized void nContextSetSurface(int w, int h, Surface sur) {
        this.validate();
        this.rsnContextSetSurface(this.mContext, w, h, sur);
    }

    void rsnContextSetSurfaceTexture(int n, int n2, int n3, SurfaceTexture surfaceTexture) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnContextSetSurfaceTexture(IIILandroid/graphics/SurfaceTexture;)V", true, this);
    }

    synchronized void nContextSetSurfaceTexture(int w, int h, SurfaceTexture sur) {
        this.validate();
        this.rsnContextSetSurfaceTexture(this.mContext, w, h, sur);
    }

    void rsnContextSetPriority(int n, int n2) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnContextSetPriority(II)V", true, this);
    }

    synchronized void nContextSetPriority(int p) {
        this.validate();
        this.rsnContextSetPriority(this.mContext, p);
    }

    void rsnContextDump(int n, int n2) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnContextDump(II)V", true, this);
    }

    synchronized void nContextDump(int bits) {
        this.validate();
        this.rsnContextDump(this.mContext, bits);
    }

    void rsnContextFinish(int n) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnContextFinish(I)V", true, this);
    }

    synchronized void nContextFinish() {
        this.validate();
        this.rsnContextFinish(this.mContext);
    }

    void rsnContextSendMessage(int n, int n2, int[] nArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnContextSendMessage(II[I)V", true, this);
    }

    synchronized void nContextSendMessage(int id2, int[] data) {
        this.validate();
        this.rsnContextSendMessage(this.mContext, id2, data);
    }

    void rsnContextBindRootScript(int n, int n2) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnContextBindRootScript(II)V", true, this);
    }

    synchronized void nContextBindRootScript(int script) {
        this.validate();
        this.rsnContextBindRootScript(this.mContext, script);
    }

    void rsnContextBindSampler(int n, int n2, int n3) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnContextBindSampler(III)V", true, this);
    }

    synchronized void nContextBindSampler(int sampler, int slot) {
        this.validate();
        this.rsnContextBindSampler(this.mContext, sampler, slot);
    }

    void rsnContextBindProgramStore(int n, int n2) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnContextBindProgramStore(II)V", true, this);
    }

    synchronized void nContextBindProgramStore(int pfs) {
        this.validate();
        this.rsnContextBindProgramStore(this.mContext, pfs);
    }

    void rsnContextBindProgramFragment(int n, int n2) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnContextBindProgramFragment(II)V", true, this);
    }

    synchronized void nContextBindProgramFragment(int pf) {
        this.validate();
        this.rsnContextBindProgramFragment(this.mContext, pf);
    }

    void rsnContextBindProgramVertex(int n, int n2) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnContextBindProgramVertex(II)V", true, this);
    }

    synchronized void nContextBindProgramVertex(int pv) {
        this.validate();
        this.rsnContextBindProgramVertex(this.mContext, pv);
    }

    void rsnContextBindProgramRaster(int n, int n2) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnContextBindProgramRaster(II)V", true, this);
    }

    synchronized void nContextBindProgramRaster(int pr) {
        this.validate();
        this.rsnContextBindProgramRaster(this.mContext, pr);
    }

    void rsnContextPause(int n) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnContextPause(I)V", true, this);
    }

    synchronized void nContextPause() {
        this.validate();
        this.rsnContextPause(this.mContext);
    }

    void rsnContextResume(int n) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnContextResume(I)V", true, this);
    }

    synchronized void nContextResume() {
        this.validate();
        this.rsnContextResume(this.mContext);
    }

    void rsnAssignName(int n, int n2, byte[] byArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAssignName(II[B)V", true, this);
    }

    synchronized void nAssignName(int obj, byte[] name) {
        this.validate();
        this.rsnAssignName(this.mContext, obj, name);
    }

    String rsnGetName(int n, int n2) {
        return (String)OverrideMethod.invokeA("android.renderscript.RenderScript#rsnGetName(II)Ljava/lang/String;", true, this);
    }

    synchronized String nGetName(int obj) {
        this.validate();
        return this.rsnGetName(this.mContext, obj);
    }

    void rsnObjDestroy(int n, int n2) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnObjDestroy(II)V", true, this);
    }

    void nObjDestroy(int id2) {
        if (this.mContext != 0) {
            this.rsnObjDestroy(this.mContext, id2);
        }
    }

    int rsnElementCreate(int n, int n2, int n3, boolean bl, int n4) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnElementCreate(IIIZI)I", true, this);
    }

    synchronized int nElementCreate(int type, int kind, boolean norm, int vecSize) {
        this.validate();
        return this.rsnElementCreate(this.mContext, type, kind, norm, vecSize);
    }

    int rsnElementCreate2(int n, int[] nArray, String[] stringArray, int[] nArray2) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnElementCreate2(I[I[Ljava/lang/String;[I)I", true, this);
    }

    synchronized int nElementCreate2(int[] elements, String[] names, int[] arraySizes) {
        this.validate();
        return this.rsnElementCreate2(this.mContext, elements, names, arraySizes);
    }

    void rsnElementGetNativeData(int n, int n2, int[] nArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnElementGetNativeData(II[I)V", true, this);
    }

    synchronized void nElementGetNativeData(int id2, int[] elementData) {
        this.validate();
        this.rsnElementGetNativeData(this.mContext, id2, elementData);
    }

    void rsnElementGetSubElements(int n, int n2, int[] nArray, String[] stringArray, int[] nArray2) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnElementGetSubElements(II[I[Ljava/lang/String;[I)V", true, this);
    }

    synchronized void nElementGetSubElements(int id2, int[] IDs, String[] names, int[] arraySizes) {
        this.validate();
        this.rsnElementGetSubElements(this.mContext, id2, IDs, names, arraySizes);
    }

    int rsnTypeCreate(int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2, int n6) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnTypeCreate(IIIIIZZI)I", true, this);
    }

    synchronized int nTypeCreate(int eid, int x, int y, int z, boolean mips, boolean faces, int yuv) {
        this.validate();
        return this.rsnTypeCreate(this.mContext, eid, x, y, z, mips, faces, yuv);
    }

    void rsnTypeGetNativeData(int n, int n2, int[] nArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnTypeGetNativeData(II[I)V", true, this);
    }

    synchronized void nTypeGetNativeData(int id2, int[] typeData) {
        this.validate();
        this.rsnTypeGetNativeData(this.mContext, id2, typeData);
    }

    int rsnAllocationCreateTyped(int n, int n2, int n3, int n4, int n5) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnAllocationCreateTyped(IIIII)I", true, this);
    }

    synchronized int nAllocationCreateTyped(int type, int mip, int usage, int pointer) {
        this.validate();
        return this.rsnAllocationCreateTyped(this.mContext, type, mip, usage, pointer);
    }

    int rsnAllocationCreateFromBitmap(int n, int n2, int n3, Bitmap bitmap, int n4) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnAllocationCreateFromBitmap(IIILandroid/graphics/Bitmap;I)I", true, this);
    }

    synchronized int nAllocationCreateFromBitmap(int type, int mip, Bitmap bmp, int usage) {
        this.validate();
        return this.rsnAllocationCreateFromBitmap(this.mContext, type, mip, bmp, usage);
    }

    int rsnAllocationCreateBitmapBackedAllocation(int n, int n2, int n3, Bitmap bitmap, int n4) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnAllocationCreateBitmapBackedAllocation(IIILandroid/graphics/Bitmap;I)I", true, this);
    }

    synchronized int nAllocationCreateBitmapBackedAllocation(int type, int mip, Bitmap bmp, int usage) {
        this.validate();
        return this.rsnAllocationCreateBitmapBackedAllocation(this.mContext, type, mip, bmp, usage);
    }

    int rsnAllocationCubeCreateFromBitmap(int n, int n2, int n3, Bitmap bitmap, int n4) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnAllocationCubeCreateFromBitmap(IIILandroid/graphics/Bitmap;I)I", true, this);
    }

    synchronized int nAllocationCubeCreateFromBitmap(int type, int mip, Bitmap bmp, int usage) {
        this.validate();
        return this.rsnAllocationCubeCreateFromBitmap(this.mContext, type, mip, bmp, usage);
    }

    int rsnAllocationCreateBitmapRef(int n, int n2, Bitmap bitmap) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnAllocationCreateBitmapRef(IILandroid/graphics/Bitmap;)I", true, this);
    }

    synchronized int nAllocationCreateBitmapRef(int type, Bitmap bmp) {
        this.validate();
        return this.rsnAllocationCreateBitmapRef(this.mContext, type, bmp);
    }

    int rsnAllocationCreateFromAssetStream(int n, int n2, int n3, int n4) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnAllocationCreateFromAssetStream(IIII)I", true, this);
    }

    synchronized int nAllocationCreateFromAssetStream(int mips, int assetStream, int usage) {
        this.validate();
        return this.rsnAllocationCreateFromAssetStream(this.mContext, mips, assetStream, usage);
    }

    void rsnAllocationCopyToBitmap(int n, int n2, Bitmap bitmap) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationCopyToBitmap(IILandroid/graphics/Bitmap;)V", true, this);
    }

    synchronized void nAllocationCopyToBitmap(int alloc, Bitmap bmp) {
        this.validate();
        this.rsnAllocationCopyToBitmap(this.mContext, alloc, bmp);
    }

    void rsnAllocationSyncAll(int n, int n2, int n3) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationSyncAll(III)V", true, this);
    }

    synchronized void nAllocationSyncAll(int alloc, int src) {
        this.validate();
        this.rsnAllocationSyncAll(this.mContext, alloc, src);
    }

    Surface rsnAllocationGetSurface(int n, int n2) {
        return (Surface)OverrideMethod.invokeA("android.renderscript.RenderScript#rsnAllocationGetSurface(II)Landroid/view/Surface;", true, this);
    }

    synchronized Surface nAllocationGetSurface(int alloc) {
        this.validate();
        return this.rsnAllocationGetSurface(this.mContext, alloc);
    }

    void rsnAllocationSetSurface(int n, int n2, Surface surface) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationSetSurface(IILandroid/view/Surface;)V", true, this);
    }

    synchronized void nAllocationSetSurface(int alloc, Surface sur) {
        this.validate();
        this.rsnAllocationSetSurface(this.mContext, alloc, sur);
    }

    void rsnAllocationIoSend(int n, int n2) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationIoSend(II)V", true, this);
    }

    synchronized void nAllocationIoSend(int alloc) {
        this.validate();
        this.rsnAllocationIoSend(this.mContext, alloc);
    }

    void rsnAllocationIoReceive(int n, int n2) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationIoReceive(II)V", true, this);
    }

    synchronized void nAllocationIoReceive(int alloc) {
        this.validate();
        this.rsnAllocationIoReceive(this.mContext, alloc);
    }

    void rsnAllocationGenerateMipmaps(int n, int n2) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationGenerateMipmaps(II)V", true, this);
    }

    synchronized void nAllocationGenerateMipmaps(int alloc) {
        this.validate();
        this.rsnAllocationGenerateMipmaps(this.mContext, alloc);
    }

    void rsnAllocationCopyFromBitmap(int n, int n2, Bitmap bitmap) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationCopyFromBitmap(IILandroid/graphics/Bitmap;)V", true, this);
    }

    synchronized void nAllocationCopyFromBitmap(int alloc, Bitmap bmp) {
        this.validate();
        this.rsnAllocationCopyFromBitmap(this.mContext, alloc, bmp);
    }

    void rsnAllocationData1D(int n, int n2, int n3, int n4, int n5, int[] nArray, int n6) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationData1D(IIIII[II)V", true, this);
    }

    synchronized void nAllocationData1D(int id2, int off, int mip, int count, int[] d, int sizeBytes) {
        this.validate();
        this.rsnAllocationData1D(this.mContext, id2, off, mip, count, d, sizeBytes);
    }

    void rsnAllocationData1D(int n, int n2, int n3, int n4, int n5, short[] sArray, int n6) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationData1D(IIIII[SI)V", true, this);
    }

    synchronized void nAllocationData1D(int id2, int off, int mip, int count, short[] d, int sizeBytes) {
        this.validate();
        this.rsnAllocationData1D(this.mContext, id2, off, mip, count, d, sizeBytes);
    }

    void rsnAllocationData1D(int n, int n2, int n3, int n4, int n5, byte[] byArray, int n6) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationData1D(IIIII[BI)V", true, this);
    }

    synchronized void nAllocationData1D(int id2, int off, int mip, int count, byte[] d, int sizeBytes) {
        this.validate();
        this.rsnAllocationData1D(this.mContext, id2, off, mip, count, d, sizeBytes);
    }

    void rsnAllocationData1D(int n, int n2, int n3, int n4, int n5, float[] fArray, int n6) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationData1D(IIIII[FI)V", true, this);
    }

    synchronized void nAllocationData1D(int id2, int off, int mip, int count, float[] d, int sizeBytes) {
        this.validate();
        this.rsnAllocationData1D(this.mContext, id2, off, mip, count, d, sizeBytes);
    }

    void rsnAllocationElementData1D(int n, int n2, int n3, int n4, int n5, byte[] byArray, int n6) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationElementData1D(IIIII[BI)V", true, this);
    }

    synchronized void nAllocationElementData1D(int id2, int xoff, int mip, int compIdx, byte[] d, int sizeBytes) {
        this.validate();
        this.rsnAllocationElementData1D(this.mContext, id2, xoff, mip, compIdx, d, sizeBytes);
    }

    void rsnAllocationData2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationData2D(IIIIIIIIIIIII)V", true, this);
    }

    synchronized void nAllocationData2D(int dstAlloc, int dstXoff, int dstYoff, int dstMip, int dstFace, int width, int height, int srcAlloc, int srcXoff, int srcYoff, int srcMip, int srcFace) {
        this.validate();
        this.rsnAllocationData2D(this.mContext, dstAlloc, dstXoff, dstYoff, dstMip, dstFace, width, height, srcAlloc, srcXoff, srcYoff, srcMip, srcFace);
    }

    void rsnAllocationData2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, byte[] byArray, int n9) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationData2D(IIIIIIII[BI)V", true, this);
    }

    synchronized void nAllocationData2D(int id2, int xoff, int yoff, int mip, int face, int w, int h, byte[] d, int sizeBytes) {
        this.validate();
        this.rsnAllocationData2D(this.mContext, id2, xoff, yoff, mip, face, w, h, d, sizeBytes);
    }

    void rsnAllocationData2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, short[] sArray, int n9) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationData2D(IIIIIIII[SI)V", true, this);
    }

    synchronized void nAllocationData2D(int id2, int xoff, int yoff, int mip, int face, int w, int h, short[] d, int sizeBytes) {
        this.validate();
        this.rsnAllocationData2D(this.mContext, id2, xoff, yoff, mip, face, w, h, d, sizeBytes);
    }

    void rsnAllocationData2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int[] nArray, int n9) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationData2D(IIIIIIII[II)V", true, this);
    }

    synchronized void nAllocationData2D(int id2, int xoff, int yoff, int mip, int face, int w, int h, int[] d, int sizeBytes) {
        this.validate();
        this.rsnAllocationData2D(this.mContext, id2, xoff, yoff, mip, face, w, h, d, sizeBytes);
    }

    void rsnAllocationData2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, float[] fArray, int n9) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationData2D(IIIIIIII[FI)V", true, this);
    }

    synchronized void nAllocationData2D(int id2, int xoff, int yoff, int mip, int face, int w, int h, float[] d, int sizeBytes) {
        this.validate();
        this.rsnAllocationData2D(this.mContext, id2, xoff, yoff, mip, face, w, h, d, sizeBytes);
    }

    void rsnAllocationData2D(int n, int n2, int n3, int n4, int n5, int n6, Bitmap bitmap) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationData2D(IIIIIILandroid/graphics/Bitmap;)V", true, this);
    }

    synchronized void nAllocationData2D(int id2, int xoff, int yoff, int mip, int face, Bitmap b) {
        this.validate();
        this.rsnAllocationData2D(this.mContext, id2, xoff, yoff, mip, face, b);
    }

    void rsnAllocationData3D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationData3D(IIIIIIIIIIIIII)V", true, this);
    }

    synchronized void nAllocationData3D(int dstAlloc, int dstXoff, int dstYoff, int dstZoff, int dstMip, int width, int height, int depth, int srcAlloc, int srcXoff, int srcYoff, int srcZoff, int srcMip) {
        this.validate();
        this.rsnAllocationData3D(this.mContext, dstAlloc, dstXoff, dstYoff, dstZoff, dstMip, width, height, depth, srcAlloc, srcXoff, srcYoff, srcZoff, srcMip);
    }

    void rsnAllocationData3D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, byte[] byArray, int n10) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationData3D(IIIIIIIII[BI)V", true, this);
    }

    synchronized void nAllocationData3D(int id2, int xoff, int yoff, int zoff, int mip, int w, int h, int depth, byte[] d, int sizeBytes) {
        this.validate();
        this.rsnAllocationData3D(this.mContext, id2, xoff, yoff, zoff, mip, w, h, depth, d, sizeBytes);
    }

    void rsnAllocationData3D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, short[] sArray, int n10) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationData3D(IIIIIIIII[SI)V", true, this);
    }

    synchronized void nAllocationData3D(int id2, int xoff, int yoff, int zoff, int mip, int w, int h, int depth, short[] d, int sizeBytes) {
        this.validate();
        this.rsnAllocationData3D(this.mContext, id2, xoff, yoff, zoff, mip, w, h, depth, d, sizeBytes);
    }

    void rsnAllocationData3D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int[] nArray, int n10) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationData3D(IIIIIIIII[II)V", true, this);
    }

    synchronized void nAllocationData3D(int id2, int xoff, int yoff, int zoff, int mip, int w, int h, int depth, int[] d, int sizeBytes) {
        this.validate();
        this.rsnAllocationData3D(this.mContext, id2, xoff, yoff, zoff, mip, w, h, depth, d, sizeBytes);
    }

    void rsnAllocationData3D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, float[] fArray, int n10) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationData3D(IIIIIIIII[FI)V", true, this);
    }

    synchronized void nAllocationData3D(int id2, int xoff, int yoff, int zoff, int mip, int w, int h, int depth, float[] d, int sizeBytes) {
        this.validate();
        this.rsnAllocationData3D(this.mContext, id2, xoff, yoff, zoff, mip, w, h, depth, d, sizeBytes);
    }

    void rsnAllocationRead(int n, int n2, byte[] byArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationRead(II[B)V", true, this);
    }

    synchronized void nAllocationRead(int id2, byte[] d) {
        this.validate();
        this.rsnAllocationRead(this.mContext, id2, d);
    }

    void rsnAllocationRead(int n, int n2, short[] sArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationRead(II[S)V", true, this);
    }

    synchronized void nAllocationRead(int id2, short[] d) {
        this.validate();
        this.rsnAllocationRead(this.mContext, id2, d);
    }

    void rsnAllocationRead(int n, int n2, int[] nArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationRead(II[I)V", true, this);
    }

    synchronized void nAllocationRead(int id2, int[] d) {
        this.validate();
        this.rsnAllocationRead(this.mContext, id2, d);
    }

    void rsnAllocationRead(int n, int n2, float[] fArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationRead(II[F)V", true, this);
    }

    synchronized void nAllocationRead(int id2, float[] d) {
        this.validate();
        this.rsnAllocationRead(this.mContext, id2, d);
    }

    int rsnAllocationGetType(int n, int n2) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnAllocationGetType(II)I", true, this);
    }

    synchronized int nAllocationGetType(int id2) {
        this.validate();
        return this.rsnAllocationGetType(this.mContext, id2);
    }

    void rsnAllocationResize1D(int n, int n2, int n3) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationResize1D(III)V", true, this);
    }

    synchronized void nAllocationResize1D(int id2, int dimX) {
        this.validate();
        this.rsnAllocationResize1D(this.mContext, id2, dimX);
    }

    int rsnFileA3DCreateFromAssetStream(int n, int n2) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnFileA3DCreateFromAssetStream(II)I", true, this);
    }

    synchronized int nFileA3DCreateFromAssetStream(int assetStream) {
        this.validate();
        return this.rsnFileA3DCreateFromAssetStream(this.mContext, assetStream);
    }

    int rsnFileA3DCreateFromFile(int n, String string2) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnFileA3DCreateFromFile(ILjava/lang/String;)I", true, this);
    }

    synchronized int nFileA3DCreateFromFile(String path) {
        this.validate();
        return this.rsnFileA3DCreateFromFile(this.mContext, path);
    }

    int rsnFileA3DCreateFromAsset(int n, AssetManager assetManager, String string2) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnFileA3DCreateFromAsset(ILandroid/content/res/AssetManager;Ljava/lang/String;)I", true, this);
    }

    synchronized int nFileA3DCreateFromAsset(AssetManager mgr, String path) {
        this.validate();
        return this.rsnFileA3DCreateFromAsset(this.mContext, mgr, path);
    }

    int rsnFileA3DGetNumIndexEntries(int n, int n2) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnFileA3DGetNumIndexEntries(II)I", true, this);
    }

    synchronized int nFileA3DGetNumIndexEntries(int fileA3D) {
        this.validate();
        return this.rsnFileA3DGetNumIndexEntries(this.mContext, fileA3D);
    }

    void rsnFileA3DGetIndexEntries(int n, int n2, int n3, int[] nArray, String[] stringArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnFileA3DGetIndexEntries(III[I[Ljava/lang/String;)V", true, this);
    }

    synchronized void nFileA3DGetIndexEntries(int fileA3D, int numEntries, int[] IDs, String[] names) {
        this.validate();
        this.rsnFileA3DGetIndexEntries(this.mContext, fileA3D, numEntries, IDs, names);
    }

    int rsnFileA3DGetEntryByIndex(int n, int n2, int n3) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnFileA3DGetEntryByIndex(III)I", true, this);
    }

    synchronized int nFileA3DGetEntryByIndex(int fileA3D, int index) {
        this.validate();
        return this.rsnFileA3DGetEntryByIndex(this.mContext, fileA3D, index);
    }

    int rsnFontCreateFromFile(int n, String string2, float f, int n2) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnFontCreateFromFile(ILjava/lang/String;FI)I", true, this);
    }

    synchronized int nFontCreateFromFile(String fileName, float size, int dpi) {
        this.validate();
        return this.rsnFontCreateFromFile(this.mContext, fileName, size, dpi);
    }

    int rsnFontCreateFromAssetStream(int n, String string2, float f, int n2, int n3) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnFontCreateFromAssetStream(ILjava/lang/String;FII)I", true, this);
    }

    synchronized int nFontCreateFromAssetStream(String name, float size, int dpi, int assetStream) {
        this.validate();
        return this.rsnFontCreateFromAssetStream(this.mContext, name, size, dpi, assetStream);
    }

    int rsnFontCreateFromAsset(int n, AssetManager assetManager, String string2, float f, int n2) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnFontCreateFromAsset(ILandroid/content/res/AssetManager;Ljava/lang/String;FI)I", true, this);
    }

    synchronized int nFontCreateFromAsset(AssetManager mgr, String path, float size, int dpi) {
        this.validate();
        return this.rsnFontCreateFromAsset(this.mContext, mgr, path, size, dpi);
    }

    void rsnScriptBindAllocation(int n, int n2, int n3, int n4) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnScriptBindAllocation(IIII)V", true, this);
    }

    synchronized void nScriptBindAllocation(int script, int alloc, int slot) {
        this.validate();
        this.rsnScriptBindAllocation(this.mContext, script, alloc, slot);
    }

    void rsnScriptSetTimeZone(int n, int n2, byte[] byArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnScriptSetTimeZone(II[B)V", true, this);
    }

    synchronized void nScriptSetTimeZone(int script, byte[] timeZone) {
        this.validate();
        this.rsnScriptSetTimeZone(this.mContext, script, timeZone);
    }

    void rsnScriptInvoke(int n, int n2, int n3) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnScriptInvoke(III)V", true, this);
    }

    synchronized void nScriptInvoke(int id2, int slot) {
        this.validate();
        this.rsnScriptInvoke(this.mContext, id2, slot);
    }

    void rsnScriptForEach(int n, int n2, int n3, int n4, int n5, byte[] byArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnScriptForEach(IIIII[B)V", true, this);
    }

    void rsnScriptForEach(int n, int n2, int n3, int n4, int n5) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnScriptForEach(IIIII)V", true, this);
    }

    void rsnScriptForEachClipped(int n, int n2, int n3, int n4, int n5, byte[] byArray, int n6, int n7, int n8, int n9, int n10, int n11) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnScriptForEachClipped(IIIII[BIIIIII)V", true, this);
    }

    void rsnScriptForEachClipped(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnScriptForEachClipped(IIIIIIIIIII)V", true, this);
    }

    synchronized void nScriptForEach(int id2, int slot, int ain, int aout, byte[] params) {
        this.validate();
        if (params == null) {
            this.rsnScriptForEach(this.mContext, id2, slot, ain, aout);
        } else {
            this.rsnScriptForEach(this.mContext, id2, slot, ain, aout, params);
        }
    }

    synchronized void nScriptForEachClipped(int id2, int slot, int ain, int aout, byte[] params, int xstart, int xend, int ystart, int yend, int zstart, int zend) {
        this.validate();
        if (params == null) {
            this.rsnScriptForEachClipped(this.mContext, id2, slot, ain, aout, xstart, xend, ystart, yend, zstart, zend);
        } else {
            this.rsnScriptForEachClipped(this.mContext, id2, slot, ain, aout, params, xstart, xend, ystart, yend, zstart, zend);
        }
    }

    void rsnScriptInvokeV(int n, int n2, int n3, byte[] byArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnScriptInvokeV(III[B)V", true, this);
    }

    synchronized void nScriptInvokeV(int id2, int slot, byte[] params) {
        this.validate();
        this.rsnScriptInvokeV(this.mContext, id2, slot, params);
    }

    void rsnScriptSetVarI(int n, int n2, int n3, int n4) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnScriptSetVarI(IIII)V", true, this);
    }

    synchronized void nScriptSetVarI(int id2, int slot, int val) {
        this.validate();
        this.rsnScriptSetVarI(this.mContext, id2, slot, val);
    }

    int rsnScriptGetVarI(int n, int n2, int n3) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnScriptGetVarI(III)I", true, this);
    }

    synchronized int nScriptGetVarI(int id2, int slot) {
        this.validate();
        return this.rsnScriptGetVarI(this.mContext, id2, slot);
    }

    void rsnScriptSetVarJ(int n, int n2, int n3, long l) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnScriptSetVarJ(IIIJ)V", true, this);
    }

    synchronized void nScriptSetVarJ(int id2, int slot, long val) {
        this.validate();
        this.rsnScriptSetVarJ(this.mContext, id2, slot, val);
    }

    long rsnScriptGetVarJ(int n, int n2, int n3) {
        return OverrideMethod.invokeL("android.renderscript.RenderScript#rsnScriptGetVarJ(III)J", true, this);
    }

    synchronized long nScriptGetVarJ(int id2, int slot) {
        this.validate();
        return this.rsnScriptGetVarJ(this.mContext, id2, slot);
    }

    void rsnScriptSetVarF(int n, int n2, int n3, float f) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnScriptSetVarF(IIIF)V", true, this);
    }

    synchronized void nScriptSetVarF(int id2, int slot, float val) {
        this.validate();
        this.rsnScriptSetVarF(this.mContext, id2, slot, val);
    }

    float rsnScriptGetVarF(int n, int n2, int n3) {
        return OverrideMethod.invokeF("android.renderscript.RenderScript#rsnScriptGetVarF(III)F", true, this);
    }

    synchronized float nScriptGetVarF(int id2, int slot) {
        this.validate();
        return this.rsnScriptGetVarF(this.mContext, id2, slot);
    }

    void rsnScriptSetVarD(int n, int n2, int n3, double d) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnScriptSetVarD(IIID)V", true, this);
    }

    synchronized void nScriptSetVarD(int id2, int slot, double val) {
        this.validate();
        this.rsnScriptSetVarD(this.mContext, id2, slot, val);
    }

    double rsnScriptGetVarD(int n, int n2, int n3) {
        return OverrideMethod.invokeD("android.renderscript.RenderScript#rsnScriptGetVarD(III)D", true, this);
    }

    synchronized double nScriptGetVarD(int id2, int slot) {
        this.validate();
        return this.rsnScriptGetVarD(this.mContext, id2, slot);
    }

    void rsnScriptSetVarV(int n, int n2, int n3, byte[] byArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnScriptSetVarV(III[B)V", true, this);
    }

    synchronized void nScriptSetVarV(int id2, int slot, byte[] val) {
        this.validate();
        this.rsnScriptSetVarV(this.mContext, id2, slot, val);
    }

    void rsnScriptGetVarV(int n, int n2, int n3, byte[] byArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnScriptGetVarV(III[B)V", true, this);
    }

    synchronized void nScriptGetVarV(int id2, int slot, byte[] val) {
        this.validate();
        this.rsnScriptGetVarV(this.mContext, id2, slot, val);
    }

    void rsnScriptSetVarVE(int n, int n2, int n3, byte[] byArray, int n4, int[] nArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnScriptSetVarVE(III[BI[I)V", true, this);
    }

    synchronized void nScriptSetVarVE(int id2, int slot, byte[] val, int e, int[] dims) {
        this.validate();
        this.rsnScriptSetVarVE(this.mContext, id2, slot, val, e, dims);
    }

    void rsnScriptSetVarObj(int n, int n2, int n3, int n4) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnScriptSetVarObj(IIII)V", true, this);
    }

    synchronized void nScriptSetVarObj(int id2, int slot, int val) {
        this.validate();
        this.rsnScriptSetVarObj(this.mContext, id2, slot, val);
    }

    int rsnScriptCCreate(int n, String string2, String string3, byte[] byArray, int n2) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnScriptCCreate(ILjava/lang/String;Ljava/lang/String;[BI)I", true, this);
    }

    synchronized int nScriptCCreate(String resName, String cacheDir, byte[] script, int length) {
        this.validate();
        return this.rsnScriptCCreate(this.mContext, resName, cacheDir, script, length);
    }

    int rsnScriptIntrinsicCreate(int n, int n2, int n3) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnScriptIntrinsicCreate(III)I", true, this);
    }

    synchronized int nScriptIntrinsicCreate(int id2, int eid) {
        this.validate();
        return this.rsnScriptIntrinsicCreate(this.mContext, id2, eid);
    }

    int rsnScriptKernelIDCreate(int n, int n2, int n3, int n4) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnScriptKernelIDCreate(IIII)I", true, this);
    }

    synchronized int nScriptKernelIDCreate(int sid, int slot, int sig) {
        this.validate();
        return this.rsnScriptKernelIDCreate(this.mContext, sid, slot, sig);
    }

    int rsnScriptFieldIDCreate(int n, int n2, int n3) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnScriptFieldIDCreate(III)I", true, this);
    }

    synchronized int nScriptFieldIDCreate(int sid, int slot) {
        this.validate();
        return this.rsnScriptFieldIDCreate(this.mContext, sid, slot);
    }

    int rsnScriptGroupCreate(int n, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnScriptGroupCreate(I[I[I[I[I[I)I", true, this);
    }

    synchronized int nScriptGroupCreate(int[] kernels, int[] src, int[] dstk, int[] dstf, int[] types) {
        this.validate();
        return this.rsnScriptGroupCreate(this.mContext, kernels, src, dstk, dstf, types);
    }

    void rsnScriptGroupSetInput(int n, int n2, int n3, int n4) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnScriptGroupSetInput(IIII)V", true, this);
    }

    synchronized void nScriptGroupSetInput(int group, int kernel, int alloc) {
        this.validate();
        this.rsnScriptGroupSetInput(this.mContext, group, kernel, alloc);
    }

    void rsnScriptGroupSetOutput(int n, int n2, int n3, int n4) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnScriptGroupSetOutput(IIII)V", true, this);
    }

    synchronized void nScriptGroupSetOutput(int group, int kernel, int alloc) {
        this.validate();
        this.rsnScriptGroupSetOutput(this.mContext, group, kernel, alloc);
    }

    void rsnScriptGroupExecute(int n, int n2) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnScriptGroupExecute(II)V", true, this);
    }

    synchronized void nScriptGroupExecute(int group) {
        this.validate();
        this.rsnScriptGroupExecute(this.mContext, group);
    }

    int rsnSamplerCreate(int n, int n2, int n3, int n4, int n5, int n6, float f) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnSamplerCreate(IIIIIIF)I", true, this);
    }

    synchronized int nSamplerCreate(int magFilter, int minFilter, int wrapS, int wrapT, int wrapR, float aniso) {
        this.validate();
        return this.rsnSamplerCreate(this.mContext, magFilter, minFilter, wrapS, wrapT, wrapR, aniso);
    }

    int rsnProgramStoreCreate(int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n2, int n3, int n4) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnProgramStoreCreate(IZZZZZZIII)I", true, this);
    }

    synchronized int nProgramStoreCreate(boolean r, boolean g, boolean b, boolean a, boolean depthMask, boolean dither, int srcMode, int dstMode, int depthFunc) {
        this.validate();
        return this.rsnProgramStoreCreate(this.mContext, r, g, b, a, depthMask, dither, srcMode, dstMode, depthFunc);
    }

    int rsnProgramRasterCreate(int n, boolean bl, int n2) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnProgramRasterCreate(IZI)I", true, this);
    }

    synchronized int nProgramRasterCreate(boolean pointSprite, int cullMode) {
        this.validate();
        return this.rsnProgramRasterCreate(this.mContext, pointSprite, cullMode);
    }

    void rsnProgramBindConstants(int n, int n2, int n3, int n4) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnProgramBindConstants(IIII)V", true, this);
    }

    synchronized void nProgramBindConstants(int pv, int slot, int mID) {
        this.validate();
        this.rsnProgramBindConstants(this.mContext, pv, slot, mID);
    }

    void rsnProgramBindTexture(int n, int n2, int n3, int n4) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnProgramBindTexture(IIII)V", true, this);
    }

    synchronized void nProgramBindTexture(int vpf, int slot, int a) {
        this.validate();
        this.rsnProgramBindTexture(this.mContext, vpf, slot, a);
    }

    void rsnProgramBindSampler(int n, int n2, int n3, int n4) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnProgramBindSampler(IIII)V", true, this);
    }

    synchronized void nProgramBindSampler(int vpf, int slot, int s) {
        this.validate();
        this.rsnProgramBindSampler(this.mContext, vpf, slot, s);
    }

    int rsnProgramFragmentCreate(int n, String string2, String[] stringArray, int[] nArray) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnProgramFragmentCreate(ILjava/lang/String;[Ljava/lang/String;[I)I", true, this);
    }

    synchronized int nProgramFragmentCreate(String shader, String[] texNames, int[] params) {
        this.validate();
        return this.rsnProgramFragmentCreate(this.mContext, shader, texNames, params);
    }

    int rsnProgramVertexCreate(int n, String string2, String[] stringArray, int[] nArray) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnProgramVertexCreate(ILjava/lang/String;[Ljava/lang/String;[I)I", true, this);
    }

    synchronized int nProgramVertexCreate(String shader, String[] texNames, int[] params) {
        this.validate();
        return this.rsnProgramVertexCreate(this.mContext, shader, texNames, params);
    }

    int rsnMeshCreate(int n, int[] nArray, int[] nArray2, int[] nArray3) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnMeshCreate(I[I[I[I)I", true, this);
    }

    synchronized int nMeshCreate(int[] vtx, int[] idx, int[] prim) {
        this.validate();
        return this.rsnMeshCreate(this.mContext, vtx, idx, prim);
    }

    int rsnMeshGetVertexBufferCount(int n, int n2) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnMeshGetVertexBufferCount(II)I", true, this);
    }

    synchronized int nMeshGetVertexBufferCount(int id2) {
        this.validate();
        return this.rsnMeshGetVertexBufferCount(this.mContext, id2);
    }

    int rsnMeshGetIndexCount(int n, int n2) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnMeshGetIndexCount(II)I", true, this);
    }

    synchronized int nMeshGetIndexCount(int id2) {
        this.validate();
        return this.rsnMeshGetIndexCount(this.mContext, id2);
    }

    void rsnMeshGetVertices(int n, int n2, int[] nArray, int n3) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnMeshGetVertices(II[II)V", true, this);
    }

    synchronized void nMeshGetVertices(int id2, int[] vtxIds, int vtxIdCount) {
        this.validate();
        this.rsnMeshGetVertices(this.mContext, id2, vtxIds, vtxIdCount);
    }

    void rsnMeshGetIndices(int n, int n2, int[] nArray, int[] nArray2, int n3) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnMeshGetIndices(II[I[II)V", true, this);
    }

    synchronized void nMeshGetIndices(int id2, int[] idxIds, int[] primitives, int vtxIdCount) {
        this.validate();
        this.rsnMeshGetIndices(this.mContext, id2, idxIds, primitives, vtxIdCount);
    }

    int rsnPathCreate(int n, int n2, boolean bl, int n3, int n4, float f) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnPathCreate(IIZIIF)I", true, this);
    }

    synchronized int nPathCreate(int prim, boolean isStatic, int vtx, int loop, float q) {
        this.validate();
        return this.rsnPathCreate(this.mContext, prim, isStatic, vtx, loop, q);
    }

    public void setMessageHandler(RSMessageHandler msg) {
        this.mMessageCallback = msg;
    }

    public RSMessageHandler getMessageHandler() {
        return this.mMessageCallback;
    }

    public void sendMessage(int id2, int[] data) {
        this.nContextSendMessage(id2, data);
    }

    public void setErrorHandler(RSErrorHandler msg) {
        this.mErrorCallback = msg;
    }

    public RSErrorHandler getErrorHandler() {
        return this.mErrorCallback;
    }

    void validate() {
        if (this.mContext == 0) {
            throw new RSInvalidStateException("Calling RS with no Context active.");
        }
    }

    public void setPriority(Priority p) {
        this.validate();
        this.nContextSetPriority(p.mID);
    }

    RenderScript(Context ctx) {
        if (ctx != null) {
            this.mApplicationContext = ctx.getApplicationContext();
        }
        this.mRWLock = new ReentrantReadWriteLock();
    }

    public Context getApplicationContext() {
        return this.mApplicationContext;
    }

    public static RenderScript create(Context ctx, int sdkVersion) {
        return RenderScript.create(ctx, sdkVersion, ContextType.NORMAL);
    }

    public static RenderScript create(Context ctx, int sdkVersion, ContextType ct) {
        if (!sInitialized) {
            Log.e(LOG_TAG, "RenderScript.create() called when disabled; someone is likely to crash");
            return null;
        }
        RenderScript rs = new RenderScript(ctx);
        rs.mDev = rs.nDeviceCreate();
        rs.mContext = rs.nContextCreate(rs.mDev, 0, sdkVersion, ct.mID);
        rs.mContextType = ct;
        if (rs.mContext == 0) {
            throw new RSDriverException("Failed to create RS context.");
        }
        rs.mMessageThread = new MessageThread(rs);
        rs.mMessageThread.start();
        return rs;
    }

    public static RenderScript create(Context ctx) {
        return RenderScript.create(ctx, ContextType.NORMAL);
    }

    public static RenderScript create(Context ctx, ContextType ct) {
        int v = ctx.getApplicationInfo().targetSdkVersion;
        return RenderScript.create(ctx, v, ct);
    }

    public void contextDump() {
        this.validate();
        this.nContextDump(0);
    }

    public void finish() {
        this.nContextFinish();
    }

    public void destroy() {
        this.validate();
        this.nContextFinish();
        this.nContextDeinitToClient(this.mContext);
        this.mMessageThread.mRun = false;
        try {
            this.mMessageThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.nContextDestroy();
        this.nDeviceDestroy(this.mDev);
        this.mDev = 0;
    }

    boolean isAlive() {
        return this.mContext != 0;
    }

    int safeID(BaseObj o) {
        if (o != null) {
            return o.getID(this);
        }
        return 0;
    }

    static {
        if (!SystemProperties.getBoolean("config.disable_renderscript", false)) {
            try {
                Class<?> vm_runtime = Class.forName("dalvik.system.VMRuntime");
                Method get_runtime = vm_runtime.getDeclaredMethod("getRuntime", new Class[0]);
                sRuntime = get_runtime.invoke(null, new Object[0]);
                registerNativeAllocation = vm_runtime.getDeclaredMethod("registerNativeAllocation", Integer.TYPE);
                registerNativeFree = vm_runtime.getDeclaredMethod("registerNativeFree", Integer.TYPE);
            }
            catch (Exception e) {
                Log.e(LOG_TAG, "Error loading GC methods: " + e);
                throw new RSRuntimeException("Error loading GC methods: " + e);
            }
            try {
                System.loadLibrary("rs_jni");
                RenderScript._nInit();
                sInitialized = true;
            }
            catch (UnsatisfiedLinkError e) {
                Log.e(LOG_TAG, "Error loading RS jni library: " + e);
                throw new RSRuntimeException("Error loading RS jni library: " + e);
            }
        }
    }

    static class MessageThread
    extends Thread {
        RenderScript mRS;
        boolean mRun = true;
        int[] mAuxData = new int[2];
        static final int RS_MESSAGE_TO_CLIENT_NONE = 0;
        static final int RS_MESSAGE_TO_CLIENT_EXCEPTION = 1;
        static final int RS_MESSAGE_TO_CLIENT_RESIZE = 2;
        static final int RS_MESSAGE_TO_CLIENT_ERROR = 3;
        static final int RS_MESSAGE_TO_CLIENT_USER = 4;
        static final int RS_MESSAGE_TO_CLIENT_NEW_BUFFER = 5;
        static final int RS_ERROR_FATAL_DEBUG = 2048;
        static final int RS_ERROR_FATAL_UNKNOWN = 4096;

        MessageThread(RenderScript rs) {
            super("RSMessageThread");
            this.mRS = rs;
        }

        public void run() {
            int[] rbuf = new int[16];
            this.mRS.nContextInitToClient(this.mRS.mContext);
            while (this.mRun) {
                rbuf[0] = 0;
                int msg = this.mRS.nContextPeekMessage(this.mRS.mContext, this.mAuxData);
                int size = this.mAuxData[1];
                int subID = this.mAuxData[0];
                if (msg == 4) {
                    if (size >> 2 >= rbuf.length) {
                        rbuf = new int[size + 3 >> 2];
                    }
                    if (this.mRS.nContextGetUserMessage(this.mRS.mContext, rbuf) != 4) {
                        throw new RSDriverException("Error processing message from RenderScript.");
                    }
                    if (this.mRS.mMessageCallback != null) {
                        this.mRS.mMessageCallback.mData = rbuf;
                        this.mRS.mMessageCallback.mID = subID;
                        this.mRS.mMessageCallback.mLength = size;
                        this.mRS.mMessageCallback.run();
                        continue;
                    }
                    throw new RSInvalidStateException("Received a message from the script with no message handler installed.");
                }
                if (msg == 3) {
                    String e = this.mRS.nContextGetErrorMessage(this.mRS.mContext);
                    if (subID >= 4096 || subID >= 2048 && (this.mRS.mContextType != ContextType.DEBUG || this.mRS.mErrorCallback == null)) {
                        throw new RSRuntimeException("Fatal error " + subID + ", details: " + e);
                    }
                    if (this.mRS.mErrorCallback != null) {
                        this.mRS.mErrorCallback.mErrorMessage = e;
                        this.mRS.mErrorCallback.mErrorNum = subID;
                        this.mRS.mErrorCallback.run();
                        continue;
                    }
                    Log.e(RenderScript.LOG_TAG, "non fatal RS error, " + e);
                    continue;
                }
                if (msg == 5) {
                    Allocation.sendBufferNotification(subID);
                    continue;
                }
                try {
                    MessageThread.sleep(1L, 0);
                }
                catch (InterruptedException e) {}
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Priority {
        LOW(15),
        NORMAL(-4);

        int mID;

        private Priority(int id2) {
            this.mID = id2;
        }
    }

    public static class RSErrorHandler
    implements Runnable {
        protected String mErrorMessage;
        protected int mErrorNum;

        public void run() {
        }
    }

    public static class RSMessageHandler
    implements Runnable {
        protected int[] mData;
        protected int mID;
        protected int mLength;

        public void run() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ContextType {
        NORMAL(0),
        DEBUG(1),
        PROFILE(2);

        int mID;

        private ContextType(int id2) {
            this.mID = id2;
        }
    }
}

