/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.BaseObj;
import android.renderscript.Byte2;
import android.renderscript.Byte3;
import android.renderscript.Byte4;
import android.renderscript.Double2;
import android.renderscript.Double3;
import android.renderscript.Double4;
import android.renderscript.Float2;
import android.renderscript.Float3;
import android.renderscript.Float4;
import android.renderscript.Int2;
import android.renderscript.Int3;
import android.renderscript.Int4;
import android.renderscript.Long2;
import android.renderscript.Long3;
import android.renderscript.Long4;
import android.renderscript.Matrix2f;
import android.renderscript.Matrix3f;
import android.renderscript.Matrix4f;
import android.renderscript.RSIllegalArgumentException;
import android.renderscript.Short2;
import android.renderscript.Short3;
import android.renderscript.Short4;
import android.util.Log;
import java.util.BitSet;

public class FieldPacker {
    private final byte[] mData;
    private int mPos = 0;
    private int mLen;
    private BitSet mAlignment;

    public FieldPacker(int len) {
        this.mLen = len;
        this.mData = new byte[len];
        this.mAlignment = new BitSet();
    }

    public FieldPacker(byte[] data) {
        this.mLen = data.length;
        this.mData = data;
        this.mAlignment = new BitSet();
    }

    public void align(int v) {
        if (v <= 0 || (v & v - 1) != 0) {
            throw new RSIllegalArgumentException("argument must be a non-negative non-zero power of 2: " + v);
        }
        while ((this.mPos & v - 1) != 0) {
            this.mAlignment.flip(this.mPos);
            this.mData[this.mPos++] = 0;
        }
    }

    public void subalign(int v) {
        if ((v & v - 1) != 0) {
            throw new RSIllegalArgumentException("argument must be a non-negative non-zero power of 2: " + v);
        }
        while ((this.mPos & v - 1) != 0) {
            --this.mPos;
        }
        if (this.mPos > 0) {
            while (this.mAlignment.get(this.mPos - 1)) {
                --this.mPos;
                this.mAlignment.flip(this.mPos);
            }
        }
    }

    public void reset() {
        this.mPos = 0;
    }

    public void reset(int i) {
        if (i < 0 || i >= this.mLen) {
            throw new RSIllegalArgumentException("out of range argument: " + i);
        }
        this.mPos = i;
    }

    public void skip(int i) {
        int res = this.mPos + i;
        if (res < 0 || res > this.mLen) {
            throw new RSIllegalArgumentException("out of range argument: " + i);
        }
        this.mPos = res;
    }

    public void addI8(byte v) {
        this.mData[this.mPos++] = v;
    }

    public byte subI8() {
        this.subalign(1);
        return this.mData[--this.mPos];
    }

    public void addI16(short v) {
        this.align(2);
        this.mData[this.mPos++] = (byte)(v & 0xFF);
        this.mData[this.mPos++] = (byte)(v >> 8);
    }

    public short subI16() {
        this.subalign(2);
        short v = 0;
        v = (short)((this.mData[--this.mPos] & 0xFF) << 8);
        v = (short)(v | (short)(this.mData[--this.mPos] & 0xFF));
        return v;
    }

    public void addI32(int v) {
        this.align(4);
        this.mData[this.mPos++] = (byte)(v & 0xFF);
        this.mData[this.mPos++] = (byte)(v >> 8 & 0xFF);
        this.mData[this.mPos++] = (byte)(v >> 16 & 0xFF);
        this.mData[this.mPos++] = (byte)(v >> 24 & 0xFF);
    }

    public int subI32() {
        this.subalign(4);
        int v = 0;
        v = (this.mData[--this.mPos] & 0xFF) << 24;
        v |= (this.mData[--this.mPos] & 0xFF) << 16;
        v |= (this.mData[--this.mPos] & 0xFF) << 8;
        return v |= this.mData[--this.mPos] & 0xFF;
    }

    public void addI64(long v) {
        this.align(8);
        this.mData[this.mPos++] = (byte)(v & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 8 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 16 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 24 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 32 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 40 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 48 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 56 & 0xFFL);
    }

    public long subI64() {
        this.subalign(8);
        long v = 0L;
        byte x = 0;
        x = this.mData[--this.mPos];
        v |= ((long)x & 0xFFL) << 56;
        x = this.mData[--this.mPos];
        v |= ((long)x & 0xFFL) << 48;
        x = this.mData[--this.mPos];
        v |= ((long)x & 0xFFL) << 40;
        x = this.mData[--this.mPos];
        v |= ((long)x & 0xFFL) << 32;
        x = this.mData[--this.mPos];
        v |= ((long)x & 0xFFL) << 24;
        x = this.mData[--this.mPos];
        v |= ((long)x & 0xFFL) << 16;
        x = this.mData[--this.mPos];
        v |= ((long)x & 0xFFL) << 8;
        x = this.mData[--this.mPos];
        return v |= (long)x & 0xFFL;
    }

    public void addU8(short v) {
        if (v < 0 || v > 255) {
            Log.e("rs", "FieldPacker.addU8( " + v + " )");
            throw new IllegalArgumentException("Saving value out of range for type");
        }
        this.mData[this.mPos++] = (byte)v;
    }

    public void addU16(int v) {
        if (v < 0 || v > 65535) {
            Log.e("rs", "FieldPacker.addU16( " + v + " )");
            throw new IllegalArgumentException("Saving value out of range for type");
        }
        this.align(2);
        this.mData[this.mPos++] = (byte)(v & 0xFF);
        this.mData[this.mPos++] = (byte)(v >> 8);
    }

    public void addU32(long v) {
        if (v < 0L || v > 0xFFFFFFFFL) {
            Log.e("rs", "FieldPacker.addU32( " + v + " )");
            throw new IllegalArgumentException("Saving value out of range for type");
        }
        this.align(4);
        this.mData[this.mPos++] = (byte)(v & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 8 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 16 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 24 & 0xFFL);
    }

    public void addU64(long v) {
        if (v < 0L) {
            Log.e("rs", "FieldPacker.addU64( " + v + " )");
            throw new IllegalArgumentException("Saving value out of range for type");
        }
        this.align(8);
        this.mData[this.mPos++] = (byte)(v & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 8 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 16 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 24 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 32 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 40 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 48 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 56 & 0xFFL);
    }

    public void addF32(float v) {
        this.addI32(Float.floatToRawIntBits(v));
    }

    public float subF32() {
        return Float.intBitsToFloat(this.subI32());
    }

    public void addF64(double v) {
        this.addI64(Double.doubleToRawLongBits(v));
    }

    public double subF64() {
        return Double.longBitsToDouble(this.subI64());
    }

    public void addObj(BaseObj obj) {
        if (obj != null) {
            this.addI32(obj.getID(null));
        } else {
            this.addI32(0);
        }
    }

    public void addF32(Float2 v) {
        this.addF32(v.x);
        this.addF32(v.y);
    }

    public void addF32(Float3 v) {
        this.addF32(v.x);
        this.addF32(v.y);
        this.addF32(v.z);
    }

    public void addF32(Float4 v) {
        this.addF32(v.x);
        this.addF32(v.y);
        this.addF32(v.z);
        this.addF32(v.w);
    }

    public void addF64(Double2 v) {
        this.addF64(v.x);
        this.addF64(v.y);
    }

    public void addF64(Double3 v) {
        this.addF64(v.x);
        this.addF64(v.y);
        this.addF64(v.z);
    }

    public void addF64(Double4 v) {
        this.addF64(v.x);
        this.addF64(v.y);
        this.addF64(v.z);
        this.addF64(v.w);
    }

    public void addI8(Byte2 v) {
        this.addI8(v.x);
        this.addI8(v.y);
    }

    public void addI8(Byte3 v) {
        this.addI8(v.x);
        this.addI8(v.y);
        this.addI8(v.z);
    }

    public void addI8(Byte4 v) {
        this.addI8(v.x);
        this.addI8(v.y);
        this.addI8(v.z);
        this.addI8(v.w);
    }

    public void addU8(Short2 v) {
        this.addU8(v.x);
        this.addU8(v.y);
    }

    public void addU8(Short3 v) {
        this.addU8(v.x);
        this.addU8(v.y);
        this.addU8(v.z);
    }

    public void addU8(Short4 v) {
        this.addU8(v.x);
        this.addU8(v.y);
        this.addU8(v.z);
        this.addU8(v.w);
    }

    public void addI16(Short2 v) {
        this.addI16(v.x);
        this.addI16(v.y);
    }

    public void addI16(Short3 v) {
        this.addI16(v.x);
        this.addI16(v.y);
        this.addI16(v.z);
    }

    public void addI16(Short4 v) {
        this.addI16(v.x);
        this.addI16(v.y);
        this.addI16(v.z);
        this.addI16(v.w);
    }

    public void addU16(Int2 v) {
        this.addU16(v.x);
        this.addU16(v.y);
    }

    public void addU16(Int3 v) {
        this.addU16(v.x);
        this.addU16(v.y);
        this.addU16(v.z);
    }

    public void addU16(Int4 v) {
        this.addU16(v.x);
        this.addU16(v.y);
        this.addU16(v.z);
        this.addU16(v.w);
    }

    public void addI32(Int2 v) {
        this.addI32(v.x);
        this.addI32(v.y);
    }

    public void addI32(Int3 v) {
        this.addI32(v.x);
        this.addI32(v.y);
        this.addI32(v.z);
    }

    public void addI32(Int4 v) {
        this.addI32(v.x);
        this.addI32(v.y);
        this.addI32(v.z);
        this.addI32(v.w);
    }

    public void addU32(Long2 v) {
        this.addU32(v.x);
        this.addU32(v.y);
    }

    public void addU32(Long3 v) {
        this.addU32(v.x);
        this.addU32(v.y);
        this.addU32(v.z);
    }

    public void addU32(Long4 v) {
        this.addU32(v.x);
        this.addU32(v.y);
        this.addU32(v.z);
        this.addU32(v.w);
    }

    public void addI64(Long2 v) {
        this.addI64(v.x);
        this.addI64(v.y);
    }

    public void addI64(Long3 v) {
        this.addI64(v.x);
        this.addI64(v.y);
        this.addI64(v.z);
    }

    public void addI64(Long4 v) {
        this.addI64(v.x);
        this.addI64(v.y);
        this.addI64(v.z);
        this.addI64(v.w);
    }

    public void addU64(Long2 v) {
        this.addU64(v.x);
        this.addU64(v.y);
    }

    public void addU64(Long3 v) {
        this.addU64(v.x);
        this.addU64(v.y);
        this.addU64(v.z);
    }

    public void addU64(Long4 v) {
        this.addU64(v.x);
        this.addU64(v.y);
        this.addU64(v.z);
        this.addU64(v.w);
    }

    public Float2 subFloat2() {
        Float2 v = new Float2();
        v.y = this.subF32();
        v.x = this.subF32();
        return v;
    }

    public Float3 subFloat3() {
        Float3 v = new Float3();
        v.z = this.subF32();
        v.y = this.subF32();
        v.x = this.subF32();
        return v;
    }

    public Float4 subFloat4() {
        Float4 v = new Float4();
        v.w = this.subF32();
        v.z = this.subF32();
        v.y = this.subF32();
        v.x = this.subF32();
        return v;
    }

    public Double2 subDouble2() {
        Double2 v = new Double2();
        v.y = this.subF64();
        v.x = this.subF64();
        return v;
    }

    public Double3 subDouble3() {
        Double3 v = new Double3();
        v.z = this.subF64();
        v.y = this.subF64();
        v.x = this.subF64();
        return v;
    }

    public Double4 subDouble4() {
        Double4 v = new Double4();
        v.w = this.subF64();
        v.z = this.subF64();
        v.y = this.subF64();
        v.x = this.subF64();
        return v;
    }

    public Byte2 subByte2() {
        Byte2 v = new Byte2();
        v.y = this.subI8();
        v.x = this.subI8();
        return v;
    }

    public Byte3 subByte3() {
        Byte3 v = new Byte3();
        v.z = this.subI8();
        v.y = this.subI8();
        v.x = this.subI8();
        return v;
    }

    public Byte4 subByte4() {
        Byte4 v = new Byte4();
        v.w = this.subI8();
        v.z = this.subI8();
        v.y = this.subI8();
        v.x = this.subI8();
        return v;
    }

    public Short2 subShort2() {
        Short2 v = new Short2();
        v.y = this.subI16();
        v.x = this.subI16();
        return v;
    }

    public Short3 subShort3() {
        Short3 v = new Short3();
        v.z = this.subI16();
        v.y = this.subI16();
        v.x = this.subI16();
        return v;
    }

    public Short4 subShort4() {
        Short4 v = new Short4();
        v.w = this.subI16();
        v.z = this.subI16();
        v.y = this.subI16();
        v.x = this.subI16();
        return v;
    }

    public Int2 subInt2() {
        Int2 v = new Int2();
        v.y = this.subI32();
        v.x = this.subI32();
        return v;
    }

    public Int3 subInt3() {
        Int3 v = new Int3();
        v.z = this.subI32();
        v.y = this.subI32();
        v.x = this.subI32();
        return v;
    }

    public Int4 subInt4() {
        Int4 v = new Int4();
        v.w = this.subI32();
        v.z = this.subI32();
        v.y = this.subI32();
        v.x = this.subI32();
        return v;
    }

    public Long2 subLong2() {
        Long2 v = new Long2();
        v.y = this.subI64();
        v.x = this.subI64();
        return v;
    }

    public Long3 subLong3() {
        Long3 v = new Long3();
        v.z = this.subI64();
        v.y = this.subI64();
        v.x = this.subI64();
        return v;
    }

    public Long4 subLong4() {
        Long4 v = new Long4();
        v.w = this.subI64();
        v.z = this.subI64();
        v.y = this.subI64();
        v.x = this.subI64();
        return v;
    }

    public void addMatrix(Matrix4f v) {
        for (int i = 0; i < v.mMat.length; ++i) {
            this.addF32(v.mMat[i]);
        }
    }

    public Matrix4f subMatrix4f() {
        Matrix4f v = new Matrix4f();
        for (int i = v.mMat.length - 1; i >= 0; --i) {
            v.mMat[i] = this.subF32();
        }
        return v;
    }

    public void addMatrix(Matrix3f v) {
        for (int i = 0; i < v.mMat.length; ++i) {
            this.addF32(v.mMat[i]);
        }
    }

    public Matrix3f subMatrix3f() {
        Matrix3f v = new Matrix3f();
        for (int i = v.mMat.length - 1; i >= 0; --i) {
            v.mMat[i] = this.subF32();
        }
        return v;
    }

    public void addMatrix(Matrix2f v) {
        for (int i = 0; i < v.mMat.length; ++i) {
            this.addF32(v.mMat[i]);
        }
    }

    public Matrix2f subMatrix2f() {
        Matrix2f v = new Matrix2f();
        for (int i = v.mMat.length - 1; i >= 0; --i) {
            v.mMat[i] = this.subF32();
        }
        return v;
    }

    public void addBoolean(boolean v) {
        this.addI8((byte)(v ? 1 : 0));
    }

    public boolean subBoolean() {
        byte v = this.subI8();
        return v == 1;
    }

    public byte[] getData() {
        return this.mData;
    }
}

