/*
 * Decompiled with CFR 0.152.
 */
package android.print;

import android.print.PrintJobId;
import android.print.PrintJobInfo;
import android.print.PrintManager;

public class PrintJob {
    private final PrintManager mPrintManager;
    private PrintJobInfo mCachedInfo;

    PrintJob(PrintJobInfo info, PrintManager printManager) {
        this.mCachedInfo = info;
        this.mPrintManager = printManager;
    }

    public PrintJobId getId() {
        return this.mCachedInfo.getId();
    }

    public PrintJobInfo getInfo() {
        if (this.isInImmutableState()) {
            return this.mCachedInfo;
        }
        PrintJobInfo info = this.mPrintManager.getPrintJobInfo(this.mCachedInfo.getId());
        if (info != null) {
            this.mCachedInfo = info;
        }
        return this.mCachedInfo;
    }

    public void cancel() {
        int state = this.getInfo().getState();
        if (state == 2 || state == 3 || state == 4 || state == 6) {
            this.mPrintManager.cancelPrintJob(this.mCachedInfo.getId());
        }
    }

    public void restart() {
        if (this.isFailed()) {
            this.mPrintManager.restartPrintJob(this.mCachedInfo.getId());
        }
    }

    public boolean isQueued() {
        return this.getInfo().getState() == 2;
    }

    public boolean isStarted() {
        return this.getInfo().getState() == 3;
    }

    public boolean isBlocked() {
        return this.getInfo().getState() == 4;
    }

    public boolean isCompleted() {
        return this.getInfo().getState() == 5;
    }

    public boolean isFailed() {
        return this.getInfo().getState() == 6;
    }

    public boolean isCancelled() {
        return this.getInfo().getState() == 7;
    }

    private boolean isInImmutableState() {
        int state = this.mCachedInfo.getState();
        return state == 5 || state == 7;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PrintJob other = (PrintJob)obj;
        return this.mCachedInfo.getId().equals(other.mCachedInfo.getId());
    }

    public int hashCode() {
        return this.mCachedInfo.getId().hashCode();
    }
}

