/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.app.ActivityThread;
import android.content.Context;
import android.os.Binder;
import android.os.IVibratorService;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.Vibrator;
import android.util.Log;

public class SystemVibrator
extends Vibrator {
    private static final String TAG = "Vibrator";
    private final String mPackageName;
    private final IVibratorService mService;
    private final Binder mToken = new Binder();

    public SystemVibrator() {
        this.mPackageName = ActivityThread.currentPackageName();
        this.mService = IVibratorService.Stub.asInterface(ServiceManager.getService("vibrator"));
    }

    public SystemVibrator(Context context) {
        this.mPackageName = context.getOpPackageName();
        this.mService = IVibratorService.Stub.asInterface(ServiceManager.getService("vibrator"));
    }

    public boolean hasVibrator() {
        if (this.mService == null) {
            Log.w(TAG, "Failed to vibrate; no vibrator service.");
            return false;
        }
        try {
            return this.mService.hasVibrator();
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public void vibrate(long milliseconds) {
        this.vibrate(Process.myUid(), this.mPackageName, milliseconds);
    }

    public void vibrate(long[] pattern, int repeat) {
        this.vibrate(Process.myUid(), this.mPackageName, pattern, repeat);
    }

    public void vibrate(int owningUid, String owningPackage, long milliseconds) {
        if (this.mService == null) {
            Log.w(TAG, "Failed to vibrate; no vibrator service.");
            return;
        }
        try {
            this.mService.vibrate(owningUid, owningPackage, milliseconds, this.mToken);
        }
        catch (RemoteException e) {
            Log.w(TAG, "Failed to vibrate.", e);
        }
    }

    public void vibrate(int owningUid, String owningPackage, long[] pattern, int repeat) {
        if (this.mService == null) {
            Log.w(TAG, "Failed to vibrate; no vibrator service.");
            return;
        }
        if (repeat < pattern.length) {
            try {
                this.mService.vibratePattern(owningUid, owningPackage, pattern, repeat, this.mToken);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed to vibrate.", e);
            }
        } else {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public void cancel() {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.cancelVibrate(this.mToken);
        }
        catch (RemoteException e) {
            Log.w(TAG, "Failed to cancel vibration.", e);
        }
    }
}

